/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.domainModelsDatasheet.formatting2;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.service.domainModelsDatasheet.DomainModelsDatasheet;
import org.eclipse.smartmdsd.xtext.base.genericDatasheet.formatting2.GenericDatasheetFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class DomainModelsDatasheetFormatter extends GenericDatasheetFormatter {
  protected void _format(final DomainModelsDatasheet domainModelsDatasheet, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(domainModelsDatasheet).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(domainModelsDatasheet).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(rclose, _function_3);
  }
  
  public void format(final Object domainModelsDatasheet, final IFormattableDocument document) {
    if (domainModelsDatasheet instanceof XtextResource) {
      _format((XtextResource)domainModelsDatasheet, document);
      return;
    } else if (domainModelsDatasheet instanceof DatasheetProperty) {
      _format((DatasheetProperty)domainModelsDatasheet, document);
      return;
    } else if (domainModelsDatasheet instanceof DomainModelsDatasheet) {
      _format((DomainModelsDatasheet)domainModelsDatasheet, document);
      return;
    } else if (domainModelsDatasheet instanceof EObject) {
      _format((EObject)domainModelsDatasheet, document);
      return;
    } else if (domainModelsDatasheet == null) {
      _format((Void)null, document);
      return;
    } else if (domainModelsDatasheet != null) {
      _format(domainModelsDatasheet, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(domainModelsDatasheet, document).toString());
    }
  }
}
