/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.parameterDefinition.scoping;

import com.google.inject.Inject;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ParameterDefinitionDefaultLib;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;

@SuppressWarnings("all")
public class ParameterDefinitionGlobalScopeProvider extends ImportUriGlobalScopeProvider {
  @Inject
  private ParameterDefinitionDefaultLib lib;
  
  @Override
  protected LinkedHashSet<URI> getImportedUris(final Resource resource) {
    final LinkedHashSet<URI> importedUris = super.getImportedUris(resource);
    importedUris.add(this.lib.getPluginURI());
    return importedUris;
  }
}
