/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.parameterDefinition.scoping;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinitionPackage;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ParameterDefinitionDefaultLib;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.scoping.AbstractParameterDefinitionScopeProvider;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.scoping.ParameterDefinitionGlobalScopeProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class ParameterDefinitionScopeProvider extends AbstractParameterDefinitionScopeProvider {
  @Inject
  private ParameterDefinitionGlobalScopeProvider gsp;
  
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    EReference _parameterSetDefinition_Extends = ParameterDefinitionPackage.eINSTANCE.getParameterSetDefinition_Extends();
    boolean _equals = Objects.equal(reference, _parameterSetDefinition_Extends);
    if (_equals) {
      final IScope result = this.gsp.getScope(context.eResource(), reference);
      final Iterable<IEObjectDescription> elements = result.getElements(ParameterDefinitionDefaultLib.DEFAULT_PARAMETR_SET_QNAME);
      final IScope globalScope = super.getScope(context, reference);
      final Function1<IEObjectDescription, EObject> _function = (IEObjectDescription it) -> {
        return it.getEObjectOrProxy();
      };
      return Scopes.scopeFor(IterableExtensions.<IEObjectDescription, EObject>map(elements, _function), globalScope);
    }
    return super.getScope(context, reference);
  }
}
