/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.parameterDefinition.ui.contentassist;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinitionPackage;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ui.contentassist.AbstractParameterDefinitionProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class ParameterDefinitionProposalProvider extends AbstractParameterDefinitionProposalProvider {
  @Inject
  private XtextResourceIndex index;
  
  @Override
  public void completeParameterSetRepository_Name(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    final URI uri = model.eResource().getURI();
    boolean _isPlatform = uri.isPlatform();
    if (_isPlatform) {
      final String projectName = uri.segment(1);
      acceptor.accept(this.createCompletionProposal(projectName, (projectName + " - ProjectName"), this.getImage(model), context));
    }
  }
  
  @Override
  public void completeParamDefRepoImport_ImportedNamespace(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    final Iterable<IEObjectDescription> repos = this.index.getVisibleEObjectDescriptions(model, ParameterDefinitionPackage.eINSTANCE.getParameterSetRepository());
    final Consumer<IEObjectDescription> _function = (IEObjectDescription repo) -> {
      final String name = repo.getName().toString();
      final String text = (name + ".*;");
      acceptor.accept(this.createCompletionProposal(text, (name + " - CommRepositoryImport"), this.getImage(repo), context));
    };
    repos.forEach(_function);
  }
}
