/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.serviceDefinition.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smartmdsd.xtext.service.serviceDefinition.ServiceDefinitionRuntimeModule;
import org.eclipse.smartmdsd.xtext.service.serviceDefinition.ServiceDefinitionStandaloneSetup;
import org.eclipse.smartmdsd.xtext.service.serviceDefinition.ide.ServiceDefinitionIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class ServiceDefinitionIdeSetup extends ServiceDefinitionStandaloneSetup {
  @Override
  public Injector createInjector() {
    ServiceDefinitionRuntimeModule _serviceDefinitionRuntimeModule = new ServiceDefinitionRuntimeModule();
    ServiceDefinitionIdeModule _serviceDefinitionIdeModule = new ServiceDefinitionIdeModule();
    return Guice.createInjector(Modules2.mixin(_serviceDefinitionRuntimeModule, _serviceDefinitionIdeModule));
  }
}
