/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.serviceDefinition.scoping;

import com.google.inject.Inject;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.xtext.base.stateMachine.StateMachineDefaultLifecycleLib;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ParameterDefinitionDefaultLib;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;

@SuppressWarnings("all")
public class ServiceDefinitionGlobalScopeProvider extends ImportUriGlobalScopeProvider {
  @Inject
  private StateMachineDefaultLifecycleLib stateLib;
  
  @Inject
  private ParameterDefinitionDefaultLib paramLib;
  
  @Override
  protected LinkedHashSet<URI> getImportedUris(final Resource resource) {
    final LinkedHashSet<URI> importedUris = super.getImportedUris(resource);
    importedUris.add(this.stateLib.getPluginURI());
    importedUris.add(this.paramLib.getPluginURI());
    return importedUris;
  }
}
