/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.serviceDefinition.ui.contentassist;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ParameterDefinitionDefaultLib;
import org.eclipse.smartmdsd.xtext.service.serviceDefinition.ui.contentassist.AbstractServiceDefinitionProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class ServiceDefinitionProposalProvider extends AbstractServiceDefinitionProposalProvider {
  @Override
  public void completeServiceDefRepository_Name(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    final URI uri = model.eResource().getURI();
    boolean _isPlatform = uri.isPlatform();
    if (_isPlatform) {
      final String projectName = uri.segment(1);
      acceptor.accept(this.createCompletionProposal(projectName, (projectName + " - ProjectName"), this.getImage(model), context));
    }
  }
  
  @Override
  public void completeServiceRepoVersion_Major(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    acceptor.accept(this.createCompletionProposal("1.0", "1.0 - Version", this.getImage(model), context));
  }
  
  @Override
  public void completeCommRepoImport_ImportedNamespace(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeCommRepoImport_ImportedNamespace(model, assignment, context, acceptor);
    final URI uri = model.eResource().getURI();
    boolean _isPlatform = uri.isPlatform();
    if (_isPlatform) {
      final String projectName = uri.segment(1);
      final String name = projectName;
      final String text = (name + ".*;");
      acceptor.accept(this.createCompletionProposal(text, (name + " - CommRepositoryImport"), this.getImage(model), context));
    }
  }
  
  @Override
  public void complete_ParameterPattern(final EObject model, final RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.complete_ParameterPattern(model, ruleCall, context, acceptor);
    String _name = ruleCall.getRule().getName();
    String _plus = (_name + " < ");
    String _plus_1 = (_plus + ParameterDefinitionDefaultLib.DEFAULT_PARAMETR_SET_SIMPLE);
    final String proposalText = (_plus_1 + " >");
    String _name_1 = ruleCall.getRule().getName();
    String _plus_2 = ("add default " + _name_1);
    acceptor.accept(this.createCompletionProposal(proposalText, _plus_2, this.getImage(model), context));
  }
}
