/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.serviceDefinition.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.AbstractServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionStyledLabelProvider;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * Provides labels for EObjects.
 * 
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#label-provider
 */
@SuppressWarnings("all")
public class ServiceDefinitionLabelProvider extends DefaultEObjectLabelProvider {
  @Inject
  public ServiceDefinitionLabelProvider(final AdapterFactoryLabelProvider delegate) {
    super(delegate);
  }
  
  @Inject
  @Extension
  private ServiceDefinitionStyledLabelProvider _serviceDefinitionStyledLabelProvider;
  
  public StyledString text(final AbstractServiceDefinition service) {
    return this._serviceDefinitionStyledLabelProvider.getStyledServiceString(service);
  }
}
