/********************************************************************************
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.service.skillDefinition.parser.antlr;

import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtext.service.skillDefinition.parser.antlr.internal.InternalSkillDefinitionParser;
import org.eclipse.smartmdsd.xtext.service.skillDefinition.services.SkillDefinitionGrammarAccess;
import org.eclipse.xtext.parser.antlr.AbstractAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;

public class SkillDefinitionParser extends AbstractAntlrParser {

	@Inject
	private SkillDefinitionGrammarAccess grammarAccess;

	@Override
	protected void setInitialHiddenTokens(XtextTokenStream tokenStream) {
		tokenStream.setInitialHiddenTokens("RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT");
	}
	

	@Override
	protected InternalSkillDefinitionParser createParser(XtextTokenStream stream) {
		return new InternalSkillDefinitionParser(stream, getGrammarAccess());
	}

	@Override 
	protected String getDefaultRuleName() {
		return "SkillDefinitionModel";
	}

	public SkillDefinitionGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(SkillDefinitionGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
}
