/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.activityArchitecture;

import com.google.inject.Injector;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitecturePackage;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.ActivityArchitectureStandaloneSetupGenerated;

/**
 * Initialization support for running Xtext languages without Equinox extension registry.
 */
@SuppressWarnings("all")
public class ActivityArchitectureStandaloneSetup extends ActivityArchitectureStandaloneSetupGenerated {
  public static void doSetup() {
    new ActivityArchitectureStandaloneSetup().createInjectorAndDoEMFRegistration();
  }
  
  @Override
  public void register(final Injector injector) {
    boolean _containsKey = EPackage.Registry.INSTANCE.containsKey(ActivityArchitecturePackage.eNS_URI);
    boolean _not = (!_containsKey);
    if (_not) {
      EPackage.Registry.INSTANCE.put(ActivityArchitecturePackage.eNS_URI, 
        ActivityArchitecturePackage.eINSTANCE);
    }
    super.register(injector);
  }
}
