/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.activityArchitecture.scoping;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitecturePackage;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityNode;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.TriggerInputNode;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.scoping.AbstractActivityArchitectureScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class ActivityArchitectureScopeProvider extends AbstractActivityArchitectureScopeProvider {
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    EReference _dataTriggered_TriggerRef = ActivityArchitecturePackage.eINSTANCE.getDataTriggered_TriggerRef();
    boolean _equals = Objects.equal(reference, _dataTriggered_TriggerRef);
    if (_equals) {
      final EObject parent = context.eContainer();
      if ((parent instanceof ActivityNode)) {
        return Scopes.scopeFor(Iterables.<TriggerInputNode>filter(((ActivityNode)parent).getInputs(), TriggerInputNode.class));
      }
    }
    return super.getScope(context, reference);
  }
}
