/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.activityArchitecture.validation;

import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitecturePackage;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ExecutionTime;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.TimeUnit;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.TimeValue;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.validation.AbstractActivityArchitectureValidator;
import org.eclipse.xtext.validation.Check;

/**
 * This class contains custom validation rules.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
@SuppressWarnings("all")
public class ActivityArchitectureValidator extends AbstractActivityArchitectureValidator {
  public static final String ACT_ARCH_PACKAGE = "org.xtext.system.activityArchitecture.";
  
  public static final String MAX_EXEC_TIME = (ActivityArchitectureValidator.ACT_ARCH_PACKAGE + "MaxMaxExecTime");
  
  public static final String MIN_EXEC_TIME = (ActivityArchitectureValidator.ACT_ARCH_PACKAGE + "MinMaxExecTime");
  
  @Check
  public void checkExecutionTimeValues(final ExecutionTime exec) {
    if (((exec.getMinTime() != null) && (exec.getMaxTime() != null))) {
      double _time = this.getTime(exec.getMinTime());
      double _time_1 = this.getTime(exec.getMaxTime());
      boolean _greaterThan = (_time > _time_1);
      if (_greaterThan) {
        this.error("MIN execution time is higher than the MAX execution time", 
          ActivityArchitecturePackage.Literals.EXECUTION_TIME__MIN_TIME, 
          ActivityArchitectureValidator.MIN_EXEC_TIME);
        this.error("MAX execution time is lower than the MIN execution time", 
          ActivityArchitecturePackage.Literals.EXECUTION_TIME__MAX_TIME, 
          ActivityArchitectureValidator.MAX_EXEC_TIME);
      }
    }
  }
  
  private double getTime(final TimeValue tv) {
    double result = 0.0;
    TimeUnit _unit = tv.getUnit();
    if (_unit != null) {
      switch (_unit) {
        case SEC:
          result = tv.getValue();
          break;
        case MSEC:
          int _value = tv.getValue();
          double _divide = (_value / 1000.0);
          result = _divide;
          break;
        case USEC:
          int _value_1 = tv.getValue();
          double _divide_1 = (_value_1 / 1000.0);
          double _divide_2 = (_divide_1 / 1000.0);
          result = _divide_2;
          break;
        default:
          break;
      }
    }
    return result;
  }
}
