/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.activityArchitecture.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.DataTriggered;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ExecutionTime;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.TimeValue;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

/**
 * Provides labels for EObjects.
 * 
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#label-provider
 */
@SuppressWarnings("all")
public class ActivityArchitectureLabelProvider extends DefaultEObjectLabelProvider {
  @Inject
  public ActivityArchitectureLabelProvider(final AdapterFactoryLabelProvider delegate) {
    super(delegate);
  }
  
  public String text(final DataTriggered element) {
    String _name = element.getTriggerRef().getName();
    String _plus = ("DataTriggered: " + _name);
    String _plus_1 = (_plus + " / ");
    int _prescale = element.getPrescale();
    return (_plus_1 + Integer.valueOf(_prescale));
  }
  
  public String text(final TimeValue tv) {
    int _value = tv.getValue();
    String _plus = ("TimeValue: " + Integer.valueOf(_value));
    String _plus_1 = (_plus + " ");
    String _literal = tv.getUnit().getLiteral();
    return (_plus_1 + _literal);
  }
  
  public String text(final ExecutionTime exec) {
    int _value = exec.getMinTime().getValue();
    String _plus = ("ExecutionTime: " + Integer.valueOf(_value));
    String _plus_1 = (_plus + " ");
    String _literal = exec.getMinTime().getUnit().getLiteral();
    String _plus_2 = (_plus_1 + _literal);
    String _plus_3 = (_plus_2 + " -- ");
    int _value_1 = exec.getMaxTime().getValue();
    String _plus_4 = (_plus_3 + Integer.valueOf(_value_1));
    String _plus_5 = (_plus_4 + " ");
    String _literal_1 = exec.getMaxTime().getUnit().getLiteral();
    return (_plus_5 + _literal_1);
  }
}
