/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.activityArchitecture.ui.quickfix;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ExecutionTime;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.TimeValue;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.validation.ActivityArchitectureValidator;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

/**
 * Custom quickfixes.
 * 
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#quick-fixes
 */
@SuppressWarnings("all")
public class ActivityArchitectureQuickfixProvider extends DefaultQuickfixProvider {
  @Fix(ActivityArchitectureValidator.MAX_EXEC_TIME)
  public void fixMaxExecTime(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final String from = "MINIMAL";
    final String to = "MAXIMAL";
    final String label = (((("Assign " + from) + " execution time to ") + to) + " execution time");
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final ExecutionTime execTime = ((ExecutionTime) element);
      TimeValue _maxTime = execTime.getMaxTime();
      _maxTime.setValue(execTime.getMinTime().getValue());
      TimeValue _maxTime_1 = execTime.getMaxTime();
      _maxTime_1.setUnit(execTime.getMinTime().getUnit());
    };
    acceptor.accept(issue, label, label, "", _function);
  }
  
  @Fix(ActivityArchitectureValidator.MIN_EXEC_TIME)
  public void fixMinExecTime(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final String from = "MAXIMAL";
    final String to = "MINIMAL";
    final String label = (((("Assign " + from) + " execution time to ") + to) + " execution time");
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final ExecutionTime execTime = ((ExecutionTime) element);
      TimeValue _minTime = execTime.getMinTime();
      _minTime.setValue(execTime.getMaxTime().getValue());
      TimeValue _minTime_1 = execTime.getMinTime();
      _minTime_1.setUnit(execTime.getMaxTime().getUnit());
    };
    acceptor.accept(issue, label, label, "", _function);
  }
}
