/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.causeEffectChain.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.AbstractChainLink;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.ActivityChain;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.CuaseEffectChainModel;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.MaxResponseTime;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.MinResponseTime;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class CauseEffectChainFormatter extends AbstractFormatter2 {
  protected void _format(final CuaseEffectChainModel cuaseEffectChainModel, @Extension final IFormattableDocument document) {
    EList<ActivityChain> _chains = cuaseEffectChainModel.getChains();
    for (final ActivityChain activityChain : _chains) {
      document.<ActivityChain>format(activityChain);
    }
  }
  
  protected void _format(final ActivityChain activityChain, @Extension final IFormattableDocument document) {
    EList<AbstractChainLink> _chainLinks = activityChain.getChainLinks();
    for (final AbstractChainLink abstractChainLink : _chainLinks) {
      document.<AbstractChainLink>format(abstractChainLink);
    }
    document.<MinResponseTime>format(activityChain.getDesiredMinResponse());
    document.<MaxResponseTime>format(activityChain.getDesiredMaxResponse());
  }
  
  public void format(final Object activityChain, final IFormattableDocument document) {
    if (activityChain instanceof XtextResource) {
      _format((XtextResource)activityChain, document);
      return;
    } else if (activityChain instanceof ActivityChain) {
      _format((ActivityChain)activityChain, document);
      return;
    } else if (activityChain instanceof CuaseEffectChainModel) {
      _format((CuaseEffectChainModel)activityChain, document);
      return;
    } else if (activityChain instanceof EObject) {
      _format((EObject)activityChain, document);
      return;
    } else if (activityChain == null) {
      _format((Void)null, document);
      return;
    } else if (activityChain != null) {
      _format(activityChain, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(activityChain, document).toString());
    }
  }
}
