/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.componentArchitecture;

import java.util.List;
import org.eclipse.smartmdsd.ecore.system.compArchSeronetExtension.CompArchSeronetExtensionPackage;
import org.eclipse.smartmdsd.ecore.system.compArchSeronetExtension.OpcUaDeviceClientInstance;
import org.eclipse.smartmdsd.ecore.system.compArchSeronetExtension.OpcUaReadServerInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ActivityConfigurationMapping;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitecturePackage;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.Connection;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.InputHandlerConfigurationMapping;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ServiceInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ParameterStructInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterPackage;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@SuppressWarnings("all")
public class ComponentArchitectureQNameProvider extends DefaultDeclarativeQualifiedNameProvider {
  public QualifiedName qualifiedName(final ServiceInstance service) {
    final QualifiedName parent = super.getFullyQualifiedName(service.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(service, ComponentArchitecturePackage.Literals.SERVICE_INSTANCE__PORT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = service.eIsSet(ComponentArchitecturePackage.Literals.SERVICE_INSTANCE__PORT);
      if (_eIsSet) {
        return parent.append(service.getPort().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final ParameterStructInstance param) {
    final QualifiedName parent = super.getFullyQualifiedName(param.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(param, SystemParameterPackage.Literals.PARAMETER_STRUCT_INSTANCE__PARAMETER);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = param.eIsSet(SystemParameterPackage.Literals.PARAMETER_STRUCT_INSTANCE__PARAMETER);
      if (_eIsSet) {
        return parent.append(param.getParameter().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final OpcUaDeviceClientInstance client) {
    final QualifiedName parent = super.getFullyQualifiedName(client.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(client, CompArchSeronetExtensionPackage.Literals.OPC_UA_DEVICE_CLIENT_INSTANCE__DEVICE_CLIENT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = client.eIsSet(CompArchSeronetExtensionPackage.Literals.OPC_UA_DEVICE_CLIENT_INSTANCE__DEVICE_CLIENT);
      if (_eIsSet) {
        return parent.append(client.getDeviceClient().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final OpcUaReadServerInstance server) {
    final QualifiedName parent = super.getFullyQualifiedName(server.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(server, CompArchSeronetExtensionPackage.Literals.OPC_UA_READ_SERVER_INSTANCE__READ_SERVER);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = server.eIsSet(CompArchSeronetExtensionPackage.Literals.OPC_UA_READ_SERVER_INSTANCE__READ_SERVER);
      if (_eIsSet) {
        return parent.append(server.getReadServer().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final Connection connection) {
    final QualifiedName parent = super.getFullyQualifiedName(connection.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(connection, ComponentArchitecturePackage.Literals.CONNECTION__FROM);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = connection.eIsSet(ComponentArchitecturePackage.Literals.CONNECTION__FROM);
      if (_eIsSet) {
        return parent.append(connection.getFrom().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final ActivityConfigurationMapping activity) {
    final QualifiedName parent = super.getFullyQualifiedName(activity.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(activity, ComponentArchitecturePackage.Literals.ACTIVITY_CONFIGURATION_MAPPING__ACTIVITY);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = activity.eIsSet(ComponentArchitecturePackage.Literals.ACTIVITY_CONFIGURATION_MAPPING__ACTIVITY);
      if (_eIsSet) {
        return parent.append(activity.getActivity().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final InputHandlerConfigurationMapping handler) {
    final QualifiedName parent = super.getFullyQualifiedName(handler.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(handler, ComponentArchitecturePackage.Literals.INPUT_HANDLER_CONFIGURATION_MAPPING__HANDLER);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = handler.eIsSet(ComponentArchitecturePackage.Literals.INPUT_HANDLER_CONFIGURATION_MAPPING__HANDLER);
      if (_eIsSet) {
        return parent.append(handler.getHandler().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
}
