/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.componentArchitecture.scoping;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.CoordinationModuleRealization;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputHandler;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.SkillRealizationsRef;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaDeviceClient;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaReadServer;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.skillDefinition.CoordinationModuleDefinition;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitectureModel;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityNode;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.InputHandlerNode;
import org.eclipse.smartmdsd.ecore.system.compArchBehaviorExtension.CompArchBehaviorExtensionPackage;
import org.eclipse.smartmdsd.ecore.system.compArchBehaviorExtension.CoordinationInterfaceComponentInstanceMapping;
import org.eclipse.smartmdsd.ecore.system.compArchBehaviorExtension.CoordinationModuleMapping;
import org.eclipse.smartmdsd.ecore.system.compArchSeronetExtension.CompArchSeronetExtensionPackage;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitectureModelUtility;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitecturePackage;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ProvidedService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.RequiredService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.xtext.system.componentArchitecture.scoping.AbstractComponentArchitectureScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class ComponentArchitectureScopeProvider extends AbstractComponentArchitectureScopeProvider {
  public static Iterable<ComponentInstance> getAllMatchingComponentInstances(final SystemComponentArchitecture sysArch, final CoordinationServiceDefinition coordInterDef) {
    List<ComponentInstance> result = CollectionLiterals.<ComponentInstance>newArrayList();
    EList<ComponentInstance> _components = sysArch.getComponents();
    for (final ComponentInstance compInst : _components) {
      {
        Iterable<CoordinationSlavePort> compCoordinationSlavePorts = Iterables.<CoordinationSlavePort>filter(compInst.getComponent().getElements(), CoordinationSlavePort.class);
        if ((compCoordinationSlavePorts != null)) {
          for (final CoordinationSlavePort compCoordinationSlavePort : compCoordinationSlavePorts) {
            {
              CoordinationServiceDefinition coordInterDef2 = compCoordinationSlavePort.getService();
              boolean _equals = Objects.equal(coordInterDef, coordInterDef2);
              if (_equals) {
                result.add(compInst);
              }
            }
          }
        }
      }
    }
    return result;
  }
  
  public static Iterable<CoordinationModuleRealization> getAllMatchingCoordinationModuleRealizations(final SystemComponentArchitecture sysArch, final CoordinationModuleDefinition coordModDef) {
    List<CoordinationModuleRealization> result = CollectionLiterals.<CoordinationModuleRealization>newArrayList();
    EList<ComponentInstance> _components = sysArch.getComponents();
    for (final ComponentInstance compInst : _components) {
      {
        Iterable<CoordinationSlavePort> compCoordinationSlavePorts = Iterables.<CoordinationSlavePort>filter(compInst.getComponent().getElements(), CoordinationSlavePort.class);
        if ((compCoordinationSlavePorts != null)) {
          for (final CoordinationSlavePort compCoordinationSlavePort : compCoordinationSlavePorts) {
            {
              Iterable<SkillRealizationsRef> skillRealizationsRefs = Iterables.<SkillRealizationsRef>filter(compCoordinationSlavePort.getElements(), SkillRealizationsRef.class);
              for (final SkillRealizationsRef skillRealizationsRef : skillRealizationsRefs) {
                {
                  CoordinationModuleRealization coordinatioModuleRealization = skillRealizationsRef.getSkillRealizationCoordModuleRef();
                  CoordinationModuleDefinition coordModuleDef2 = skillRealizationsRef.getSkillRealizationCoordModuleRef().getCoordinationModuleDef();
                  boolean _equals = Objects.equal(coordModDef, coordModuleDef2);
                  if (_equals) {
                    result.add(coordinatioModuleRealization);
                  }
                }
              }
            }
          }
        }
      }
    }
    return result;
  }
  
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    EReference _serviceInstance_Port = ComponentArchitecturePackage.eINSTANCE.getServiceInstance_Port();
    boolean _equals = Objects.equal(reference, _serviceInstance_Port);
    if (_equals) {
      if ((context instanceof RequiredService)) {
        EObject _eContainer = ((RequiredService)context).eContainer();
        return Scopes.scopeFor(ComponentArchitectureModelUtility.getAllClientPorts(((ComponentInstance) _eContainer)));
      } else {
        if ((context instanceof ProvidedService)) {
          EObject _eContainer_1 = ((ProvidedService)context).eContainer();
          return Scopes.scopeFor(ComponentArchitectureModelUtility.getAllServerPorts(((ComponentInstance) _eContainer_1)));
        }
      }
    } else {
      EReference _opcUaDeviceClientInstance_DeviceClient = CompArchSeronetExtensionPackage.eINSTANCE.getOpcUaDeviceClientInstance_DeviceClient();
      boolean _equals_1 = Objects.equal(reference, _opcUaDeviceClientInstance_DeviceClient);
      if (_equals_1) {
        final EObject parent = context.eContainer();
        if ((parent instanceof ComponentInstance)) {
          return Scopes.scopeFor(Iterables.<OpcUaDeviceClient>filter(((ComponentInstance)parent).getComponent().getElements(), OpcUaDeviceClient.class));
        }
      } else {
        EReference _opcUaReadServerInstance_ReadServer = CompArchSeronetExtensionPackage.eINSTANCE.getOpcUaReadServerInstance_ReadServer();
        boolean _equals_2 = Objects.equal(reference, _opcUaReadServerInstance_ReadServer);
        if (_equals_2) {
          final EObject parent_1 = context.eContainer();
          if ((parent_1 instanceof ComponentInstance)) {
            return Scopes.scopeFor(Iterables.<OpcUaReadServer>filter(((ComponentInstance)parent_1).getComponent().getElements(), OpcUaReadServer.class));
          }
        } else {
          EReference _activityConfigurationMapping_Activity = ComponentArchitecturePackage.eINSTANCE.getActivityConfigurationMapping_Activity();
          boolean _equals_3 = Objects.equal(reference, _activityConfigurationMapping_Activity);
          if (_equals_3) {
            final EObject parent_2 = context.eContainer();
            if ((parent_2 instanceof ComponentInstance)) {
              return Scopes.scopeFor(Iterables.<Activity>filter(((ComponentInstance)parent_2).getComponent().getElements(), Activity.class));
            }
          } else {
            EReference _activityConfigurationMapping_Config = ComponentArchitecturePackage.eINSTANCE.getActivityConfigurationMapping_Config();
            boolean _equals_4 = Objects.equal(reference, _activityConfigurationMapping_Config);
            if (_equals_4) {
              final EObject parent_3 = context.eContainer().eContainer();
              if ((parent_3 instanceof SystemComponentArchitecture)) {
                ActivityArchitectureModel _activityArch = ((SystemComponentArchitecture)parent_3).getActivityArch();
                boolean _tripleNotEquals = (_activityArch != null);
                if (_tripleNotEquals) {
                  return Scopes.scopeFor(Iterables.<ActivityNode>filter(((SystemComponentArchitecture)parent_3).getActivityArch().getElements(), ActivityNode.class));
                }
              }
            } else {
              EReference _inputHandlerConfigurationMapping_Handler = ComponentArchitecturePackage.eINSTANCE.getInputHandlerConfigurationMapping_Handler();
              boolean _equals_5 = Objects.equal(reference, _inputHandlerConfigurationMapping_Handler);
              if (_equals_5) {
                final EObject parent_4 = context.eContainer();
                if ((parent_4 instanceof ComponentInstance)) {
                  return Scopes.scopeFor(Iterables.<InputHandler>filter(((ComponentInstance)parent_4).getComponent().getElements(), InputHandler.class));
                }
              } else {
                EReference _inputHandlerConfigurationMapping_Config = ComponentArchitecturePackage.eINSTANCE.getInputHandlerConfigurationMapping_Config();
                boolean _equals_6 = Objects.equal(reference, _inputHandlerConfigurationMapping_Config);
                if (_equals_6) {
                  final EObject parent_5 = context.eContainer().eContainer();
                  if ((parent_5 instanceof SystemComponentArchitecture)) {
                    ActivityArchitectureModel _activityArch_1 = ((SystemComponentArchitecture)parent_5).getActivityArch();
                    boolean _tripleNotEquals_1 = (_activityArch_1 != null);
                    if (_tripleNotEquals_1) {
                      return Scopes.scopeFor(Iterables.<InputHandlerNode>filter(((SystemComponentArchitecture)parent_5).getActivityArch().getElements(), InputHandlerNode.class));
                    }
                  }
                } else {
                  EReference _coordinationModuleMapping_CoordModReal = CompArchBehaviorExtensionPackage.eINSTANCE.getCoordinationModuleMapping_CoordModReal();
                  boolean _equals_7 = Objects.equal(reference, _coordinationModuleMapping_CoordModReal);
                  if (_equals_7) {
                    if ((context instanceof CoordinationModuleMapping)) {
                      CoordinationModuleDefinition coordModuleDef1 = ((CoordinationModuleMapping)context).getCoordModuleInst().getCoordModuleDef();
                      final EObject parent_6 = ((CoordinationModuleMapping)context).eContainer();
                      if ((parent_6 instanceof SystemComponentArchitecture)) {
                        return Scopes.scopeFor(ComponentArchitectureScopeProvider.getAllMatchingCoordinationModuleRealizations(((SystemComponentArchitecture)parent_6), coordModuleDef1));
                      }
                    }
                  } else {
                    EReference _coordinationInterfaceComponentInstanceMapping_CoordInterInst = CompArchBehaviorExtensionPackage.eINSTANCE.getCoordinationInterfaceComponentInstanceMapping_CoordInterInst();
                    boolean _equals_8 = Objects.equal(reference, _coordinationInterfaceComponentInstanceMapping_CoordInterInst);
                    if (_equals_8) {
                      final EObject parent_7 = context.eContainer();
                      if ((parent_7 instanceof CoordinationModuleMapping)) {
                        return Scopes.scopeFor(((CoordinationModuleMapping)parent_7).getCoordModReal().getCoordInterfaceInsts());
                      }
                    } else {
                      EReference _coordinationInterfaceComponentInstanceMapping_CompInst = CompArchBehaviorExtensionPackage.eINSTANCE.getCoordinationInterfaceComponentInstanceMapping_CompInst();
                      boolean _equals_9 = Objects.equal(reference, _coordinationInterfaceComponentInstanceMapping_CompInst);
                      if (_equals_9) {
                        if ((context instanceof CoordinationInterfaceComponentInstanceMapping)) {
                          CoordinationServiceDefinition coordInterfaceDef1 = ((CoordinationInterfaceComponentInstanceMapping)context).getCoordInterInst().getCoordinationInterfaceDef();
                          final EObject parent_8 = ((CoordinationInterfaceComponentInstanceMapping)context).eContainer().eContainer();
                          if ((parent_8 instanceof SystemComponentArchitecture)) {
                            return Scopes.scopeFor(ComponentArchitectureScopeProvider.getAllMatchingComponentInstances(((SystemComponentArchitecture)parent_8), coordInterfaceDef1));
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    return super.getScope(context, reference);
  }
}
