/********************************************************************************
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.system.componentArchitecture.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.smartmdsd.xtext.base.docuterminals.services.DocuTerminalsGrammarAccess;
import org.eclipse.smartmdsd.xtext.service.roboticMiddleware.services.RoboticMiddlewareGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.services.TerminalsGrammarAccess;
import org.eclipse.xtext.service.AbstractElementFinder.AbstractGrammarElementFinder;
import org.eclipse.xtext.service.GrammarProvider;

@Singleton
public class ComponentArchitectureGrammarAccess extends AbstractGrammarElementFinder {
	
	public class SystemComponentArchitectureElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.SystemComponentArchitecture");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSystemComponentArchitectureAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cSystemComponentArchitectureKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cUsingActivityArchitectureKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cActivityArchAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final CrossReference cActivityArchActivityArchitectureModelCrossReference_3_1_0 = (CrossReference)cActivityArchAssignment_3_1.eContents().get(0);
		private final RuleCall cActivityArchActivityArchitectureModelFQNParserRuleCall_3_1_0_1 = (RuleCall)cActivityArchActivityArchitectureModelCrossReference_3_1_0.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cComponentsAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cComponentsComponentInstanceParserRuleCall_5_0 = (RuleCall)cComponentsAssignment_5.eContents().get(0);
		private final Assignment cConnectionsAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cConnectionsConnectionParserRuleCall_6_0 = (RuleCall)cConnectionsAssignment_6.eContents().get(0);
		private final Assignment cExtensionsAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cExtensionsSystemExtensionParserRuleCall_7_0 = (RuleCall)cExtensionsAssignment_7.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_8 = (Keyword)cGroup.eContents().get(8);
		
		//SystemComponentArchitecture:
		//	{SystemComponentArchitecture}
		//	'SystemComponentArchitecture' name=ID ('usingActivityArchitecture'
		//	activityArch=[activityArchitecture::ActivityArchitectureModel|FQN])?
		//	'{'
		//	components+=ComponentInstance*
		//	connections+=Connection*
		//	extensions+=SystemExtension*
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//{SystemComponentArchitecture} 'SystemComponentArchitecture' name=ID ('usingActivityArchitecture'
		//activityArch=[activityArchitecture::ActivityArchitectureModel|FQN])? '{' components+=ComponentInstance*
		//connections+=Connection* extensions+=SystemExtension* '}'
		public Group getGroup() { return cGroup; }
		
		//{SystemComponentArchitecture}
		public Action getSystemComponentArchitectureAction_0() { return cSystemComponentArchitectureAction_0; }
		
		//'SystemComponentArchitecture'
		public Keyword getSystemComponentArchitectureKeyword_1() { return cSystemComponentArchitectureKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
		
		//('usingActivityArchitecture' activityArch=[activityArchitecture::ActivityArchitectureModel|FQN])?
		public Group getGroup_3() { return cGroup_3; }
		
		//'usingActivityArchitecture'
		public Keyword getUsingActivityArchitectureKeyword_3_0() { return cUsingActivityArchitectureKeyword_3_0; }
		
		//activityArch=[activityArchitecture::ActivityArchitectureModel|FQN]
		public Assignment getActivityArchAssignment_3_1() { return cActivityArchAssignment_3_1; }
		
		//[activityArchitecture::ActivityArchitectureModel|FQN]
		public CrossReference getActivityArchActivityArchitectureModelCrossReference_3_1_0() { return cActivityArchActivityArchitectureModelCrossReference_3_1_0; }
		
		//FQN
		public RuleCall getActivityArchActivityArchitectureModelFQNParserRuleCall_3_1_0_1() { return cActivityArchActivityArchitectureModelFQNParserRuleCall_3_1_0_1; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_4() { return cLeftCurlyBracketKeyword_4; }
		
		//components+=ComponentInstance*
		public Assignment getComponentsAssignment_5() { return cComponentsAssignment_5; }
		
		//ComponentInstance
		public RuleCall getComponentsComponentInstanceParserRuleCall_5_0() { return cComponentsComponentInstanceParserRuleCall_5_0; }
		
		//connections+=Connection*
		public Assignment getConnectionsAssignment_6() { return cConnectionsAssignment_6; }
		
		//Connection
		public RuleCall getConnectionsConnectionParserRuleCall_6_0() { return cConnectionsConnectionParserRuleCall_6_0; }
		
		//extensions+=SystemExtension*
		public Assignment getExtensionsAssignment_7() { return cExtensionsAssignment_7; }
		
		//SystemExtension
		public RuleCall getExtensionsSystemExtensionParserRuleCall_7_0() { return cExtensionsSystemExtensionParserRuleCall_7_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_8() { return cRightCurlyBracketKeyword_8; }
	}
	public class SystemExtensionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.SystemExtension");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cCoordinationModuleMappingParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cTaskRealizationModelRefParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//SystemExtension:
		//	CoordinationModuleMapping | TaskRealizationModelRef;
		@Override public ParserRule getRule() { return rule; }
		
		//CoordinationModuleMapping | TaskRealizationModelRef
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//CoordinationModuleMapping
		public RuleCall getCoordinationModuleMappingParserRuleCall_0() { return cCoordinationModuleMappingParserRuleCall_0; }
		
		//TaskRealizationModelRef
		public RuleCall getTaskRealizationModelRefParserRuleCall_1() { return cTaskRealizationModelRefParserRuleCall_1; }
	}
	public class ConnectionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.Connection");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cConnectionKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cFromAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cFromRequiredServiceCrossReference_1_0 = (CrossReference)cFromAssignment_1.eContents().get(0);
		private final RuleCall cFromRequiredServiceFQNParserRuleCall_1_0_1 = (RuleCall)cFromRequiredServiceCrossReference_1_0.eContents().get(1);
		private final Keyword cHyphenMinusGreaterThanSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cToAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cToProvidedServiceCrossReference_3_0 = (CrossReference)cToAssignment_3.eContents().get(0);
		private final RuleCall cToProvidedServiceFQNParserRuleCall_3_0_1 = (RuleCall)cToProvidedServiceCrossReference_3_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cUseMiddlewareKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cMiddlewareSelectionAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cMiddlewareSelectionRoboticMiddlewareParserRuleCall_4_1_0 = (RuleCall)cMiddlewareSelectionAssignment_4_1.eContents().get(0);
		private final Keyword cSemicolonKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//Connection:
		//	'Connection' from=[RequiredService|FQN] '->' to=[ProvidedService|FQN] ('useMiddleware'
		//	middlewareSelection=RoboticMiddleware)? ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'Connection' from=[RequiredService|FQN] '->' to=[ProvidedService|FQN] ('useMiddleware'
		//middlewareSelection=RoboticMiddleware)? ';'?
		public Group getGroup() { return cGroup; }
		
		//'Connection'
		public Keyword getConnectionKeyword_0() { return cConnectionKeyword_0; }
		
		//from=[RequiredService|FQN]
		public Assignment getFromAssignment_1() { return cFromAssignment_1; }
		
		//[RequiredService|FQN]
		public CrossReference getFromRequiredServiceCrossReference_1_0() { return cFromRequiredServiceCrossReference_1_0; }
		
		//FQN
		public RuleCall getFromRequiredServiceFQNParserRuleCall_1_0_1() { return cFromRequiredServiceFQNParserRuleCall_1_0_1; }
		
		//'->'
		public Keyword getHyphenMinusGreaterThanSignKeyword_2() { return cHyphenMinusGreaterThanSignKeyword_2; }
		
		//to=[ProvidedService|FQN]
		public Assignment getToAssignment_3() { return cToAssignment_3; }
		
		//[ProvidedService|FQN]
		public CrossReference getToProvidedServiceCrossReference_3_0() { return cToProvidedServiceCrossReference_3_0; }
		
		//FQN
		public RuleCall getToProvidedServiceFQNParserRuleCall_3_0_1() { return cToProvidedServiceFQNParserRuleCall_3_0_1; }
		
		//('useMiddleware' middlewareSelection=RoboticMiddleware)?
		public Group getGroup_4() { return cGroup_4; }
		
		//'useMiddleware'
		public Keyword getUseMiddlewareKeyword_4_0() { return cUseMiddlewareKeyword_4_0; }
		
		//middlewareSelection=RoboticMiddleware
		public Assignment getMiddlewareSelectionAssignment_4_1() { return cMiddlewareSelectionAssignment_4_1; }
		
		//RoboticMiddleware
		public RuleCall getMiddlewareSelectionRoboticMiddlewareParserRuleCall_4_1_0() { return cMiddlewareSelectionRoboticMiddlewareParserRuleCall_4_1_0; }
		
		//';'?
		public Keyword getSemicolonKeyword_5() { return cSemicolonKeyword_5; }
	}
	public class ComponentInstanceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.ComponentInstance");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cComponentInstanceKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cInstantiatesKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cComponentAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cComponentComponentDefinitionCrossReference_3_0 = (CrossReference)cComponentAssignment_3.eContents().get(0);
		private final RuleCall cComponentComponentDefinitionFQNParserRuleCall_3_0_1 = (RuleCall)cComponentComponentDefinitionCrossReference_3_0.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cPortsAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cPortsServiceInstanceParserRuleCall_5_0 = (RuleCall)cPortsAssignment_5.eContents().get(0);
		private final Assignment cExtensionsAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cExtensionsComponentInstanceExtensionParserRuleCall_6_0 = (RuleCall)cExtensionsAssignment_6.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_7 = (Keyword)cGroup.eContents().get(7);
		
		//ComponentInstance:
		//	'ComponentInstance' name=ID 'instantiates' component=[componentDefinition::ComponentDefinition|FQN]
		//	'{'
		//	ports+=ServiceInstance*
		//	extensions+=ComponentInstanceExtension*
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//'ComponentInstance' name=ID 'instantiates' component=[componentDefinition::ComponentDefinition|FQN] '{'
		//ports+=ServiceInstance* extensions+=ComponentInstanceExtension* '}'
		public Group getGroup() { return cGroup; }
		
		//'ComponentInstance'
		public Keyword getComponentInstanceKeyword_0() { return cComponentInstanceKeyword_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//'instantiates'
		public Keyword getInstantiatesKeyword_2() { return cInstantiatesKeyword_2; }
		
		//component=[componentDefinition::ComponentDefinition|FQN]
		public Assignment getComponentAssignment_3() { return cComponentAssignment_3; }
		
		//[componentDefinition::ComponentDefinition|FQN]
		public CrossReference getComponentComponentDefinitionCrossReference_3_0() { return cComponentComponentDefinitionCrossReference_3_0; }
		
		//FQN
		public RuleCall getComponentComponentDefinitionFQNParserRuleCall_3_0_1() { return cComponentComponentDefinitionFQNParserRuleCall_3_0_1; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_4() { return cLeftCurlyBracketKeyword_4; }
		
		//ports+=ServiceInstance*
		public Assignment getPortsAssignment_5() { return cPortsAssignment_5; }
		
		//ServiceInstance
		public RuleCall getPortsServiceInstanceParserRuleCall_5_0() { return cPortsServiceInstanceParserRuleCall_5_0; }
		
		//extensions+=ComponentInstanceExtension*
		public Assignment getExtensionsAssignment_6() { return cExtensionsAssignment_6; }
		
		//ComponentInstanceExtension
		public RuleCall getExtensionsComponentInstanceExtensionParserRuleCall_6_0() { return cExtensionsComponentInstanceExtensionParserRuleCall_6_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_7() { return cRightCurlyBracketKeyword_7; }
	}
	public class ComponentInstanceExtensionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.ComponentInstanceExtension");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cParameterStructInstanceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cActivityConfigurationMappingParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cInputHandlerConfigurationMappingParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cOpcUaDeviceClientInstanceParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cOpcUaReadServerInstanceParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		
		//ComponentInstanceExtension:
		//	ParameterStructInstance | ActivityConfigurationMapping | InputHandlerConfigurationMapping | OpcUaDeviceClientInstance
		//	| OpcUaReadServerInstance;
		@Override public ParserRule getRule() { return rule; }
		
		//ParameterStructInstance | ActivityConfigurationMapping | InputHandlerConfigurationMapping | OpcUaDeviceClientInstance |
		//OpcUaReadServerInstance
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ParameterStructInstance
		public RuleCall getParameterStructInstanceParserRuleCall_0() { return cParameterStructInstanceParserRuleCall_0; }
		
		//ActivityConfigurationMapping
		public RuleCall getActivityConfigurationMappingParserRuleCall_1() { return cActivityConfigurationMappingParserRuleCall_1; }
		
		//InputHandlerConfigurationMapping
		public RuleCall getInputHandlerConfigurationMappingParserRuleCall_2() { return cInputHandlerConfigurationMappingParserRuleCall_2; }
		
		//OpcUaDeviceClientInstance
		public RuleCall getOpcUaDeviceClientInstanceParserRuleCall_3() { return cOpcUaDeviceClientInstanceParserRuleCall_3; }
		
		//OpcUaReadServerInstance
		public RuleCall getOpcUaReadServerInstanceParserRuleCall_4() { return cOpcUaReadServerInstanceParserRuleCall_4; }
	}
	public class ParameterStructInstanceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.ParameterStructInstance");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cParameterStructInstanceKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cParameterAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cParameterComponentParameterInstanceCrossReference_1_0 = (CrossReference)cParameterAssignment_1.eContents().get(0);
		private final RuleCall cParameterComponentParameterInstanceFQNParserRuleCall_1_0_1 = (RuleCall)cParameterComponentParameterInstanceCrossReference_1_0.eContents().get(1);
		private final Keyword cSemicolonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		
		//ParameterStructInstance systemParameter::ParameterStructInstance:
		//	'ParameterStructInstance' parameter=[systemParameter::ComponentParameterInstance|FQN] ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'ParameterStructInstance' parameter=[systemParameter::ComponentParameterInstance|FQN] ';'?
		public Group getGroup() { return cGroup; }
		
		//'ParameterStructInstance'
		public Keyword getParameterStructInstanceKeyword_0() { return cParameterStructInstanceKeyword_0; }
		
		//parameter=[systemParameter::ComponentParameterInstance|FQN]
		public Assignment getParameterAssignment_1() { return cParameterAssignment_1; }
		
		//[systemParameter::ComponentParameterInstance|FQN]
		public CrossReference getParameterComponentParameterInstanceCrossReference_1_0() { return cParameterComponentParameterInstanceCrossReference_1_0; }
		
		//FQN
		public RuleCall getParameterComponentParameterInstanceFQNParserRuleCall_1_0_1() { return cParameterComponentParameterInstanceFQNParserRuleCall_1_0_1; }
		
		//';'?
		public Keyword getSemicolonKeyword_2() { return cSemicolonKeyword_2; }
	}
	public class ActivityConfigurationMappingElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.ActivityConfigurationMapping");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cActivityKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cActivityAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cActivityActivityCrossReference_1_0 = (CrossReference)cActivityAssignment_1.eContents().get(0);
		private final RuleCall cActivityActivityFQNParserRuleCall_1_0_1 = (RuleCall)cActivityActivityCrossReference_1_0.eContents().get(1);
		private final Keyword cConfigurationKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cConfigAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cConfigActivityNodeCrossReference_3_0 = (CrossReference)cConfigAssignment_3.eContents().get(0);
		private final RuleCall cConfigActivityNodeFQNParserRuleCall_3_0_1 = (RuleCall)cConfigActivityNodeCrossReference_3_0.eContents().get(1);
		private final Keyword cSemicolonKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//ActivityConfigurationMapping:
		//	'Activity' activity=[componentDefinition::Activity|FQN] 'configuration'
		//	config=[activityArchitecture::ActivityNode|FQN] ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'Activity' activity=[componentDefinition::Activity|FQN] 'configuration' config=[activityArchitecture::ActivityNode|FQN]
		//';'?
		public Group getGroup() { return cGroup; }
		
		//'Activity'
		public Keyword getActivityKeyword_0() { return cActivityKeyword_0; }
		
		//activity=[componentDefinition::Activity|FQN]
		public Assignment getActivityAssignment_1() { return cActivityAssignment_1; }
		
		//[componentDefinition::Activity|FQN]
		public CrossReference getActivityActivityCrossReference_1_0() { return cActivityActivityCrossReference_1_0; }
		
		//FQN
		public RuleCall getActivityActivityFQNParserRuleCall_1_0_1() { return cActivityActivityFQNParserRuleCall_1_0_1; }
		
		//'configuration'
		public Keyword getConfigurationKeyword_2() { return cConfigurationKeyword_2; }
		
		//config=[activityArchitecture::ActivityNode|FQN]
		public Assignment getConfigAssignment_3() { return cConfigAssignment_3; }
		
		//[activityArchitecture::ActivityNode|FQN]
		public CrossReference getConfigActivityNodeCrossReference_3_0() { return cConfigActivityNodeCrossReference_3_0; }
		
		//FQN
		public RuleCall getConfigActivityNodeFQNParserRuleCall_3_0_1() { return cConfigActivityNodeFQNParserRuleCall_3_0_1; }
		
		//';'?
		public Keyword getSemicolonKeyword_4() { return cSemicolonKeyword_4; }
	}
	public class InputHandlerConfigurationMappingElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.InputHandlerConfigurationMapping");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cInputHandlerKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cHandlerAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cHandlerInputHandlerCrossReference_1_0 = (CrossReference)cHandlerAssignment_1.eContents().get(0);
		private final RuleCall cHandlerInputHandlerFQNParserRuleCall_1_0_1 = (RuleCall)cHandlerInputHandlerCrossReference_1_0.eContents().get(1);
		private final Keyword cConfigurationKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cConfigAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cConfigInputHandlerNodeCrossReference_3_0 = (CrossReference)cConfigAssignment_3.eContents().get(0);
		private final RuleCall cConfigInputHandlerNodeFQNParserRuleCall_3_0_1 = (RuleCall)cConfigInputHandlerNodeCrossReference_3_0.eContents().get(1);
		private final Keyword cSemicolonKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//InputHandlerConfigurationMapping:
		//	'InputHandler' handler=[componentDefinition::InputHandler|FQN] 'configuration'
		//	config=[activityArchitecture::InputHandlerNode|FQN] ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'InputHandler' handler=[componentDefinition::InputHandler|FQN] 'configuration'
		//config=[activityArchitecture::InputHandlerNode|FQN] ';'?
		public Group getGroup() { return cGroup; }
		
		//'InputHandler'
		public Keyword getInputHandlerKeyword_0() { return cInputHandlerKeyword_0; }
		
		//handler=[componentDefinition::InputHandler|FQN]
		public Assignment getHandlerAssignment_1() { return cHandlerAssignment_1; }
		
		//[componentDefinition::InputHandler|FQN]
		public CrossReference getHandlerInputHandlerCrossReference_1_0() { return cHandlerInputHandlerCrossReference_1_0; }
		
		//FQN
		public RuleCall getHandlerInputHandlerFQNParserRuleCall_1_0_1() { return cHandlerInputHandlerFQNParserRuleCall_1_0_1; }
		
		//'configuration'
		public Keyword getConfigurationKeyword_2() { return cConfigurationKeyword_2; }
		
		//config=[activityArchitecture::InputHandlerNode|FQN]
		public Assignment getConfigAssignment_3() { return cConfigAssignment_3; }
		
		//[activityArchitecture::InputHandlerNode|FQN]
		public CrossReference getConfigInputHandlerNodeCrossReference_3_0() { return cConfigInputHandlerNodeCrossReference_3_0; }
		
		//FQN
		public RuleCall getConfigInputHandlerNodeFQNParserRuleCall_3_0_1() { return cConfigInputHandlerNodeFQNParserRuleCall_3_0_1; }
		
		//';'?
		public Keyword getSemicolonKeyword_4() { return cSemicolonKeyword_4; }
	}
	public class OpcUaDeviceClientInstanceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.OpcUaDeviceClientInstance");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cOpcUaDeviceClientInstanceKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cDeviceClientAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cDeviceClientOpcUaDeviceClientCrossReference_1_0 = (CrossReference)cDeviceClientAssignment_1.eContents().get(0);
		private final RuleCall cDeviceClientOpcUaDeviceClientFQNParserRuleCall_1_0_1 = (RuleCall)cDeviceClientOpcUaDeviceClientCrossReference_1_0.eContents().get(1);
		private final Keyword cDeviceURIKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cDeviceURIAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cDeviceURIEStringParserRuleCall_3_0 = (RuleCall)cDeviceURIAssignment_3.eContents().get(0);
		private final Keyword cSemicolonKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//OpcUaDeviceClientInstance compArchSeronetExtension::OpcUaDeviceClientInstance:
		//	'OpcUaDeviceClientInstance' deviceClient=[seronetExtension::OpcUaDeviceClient|FQN] 'deviceURI' deviceURI=EString ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'OpcUaDeviceClientInstance' deviceClient=[seronetExtension::OpcUaDeviceClient|FQN] 'deviceURI' deviceURI=EString ';'?
		public Group getGroup() { return cGroup; }
		
		//'OpcUaDeviceClientInstance'
		public Keyword getOpcUaDeviceClientInstanceKeyword_0() { return cOpcUaDeviceClientInstanceKeyword_0; }
		
		//deviceClient=[seronetExtension::OpcUaDeviceClient|FQN]
		public Assignment getDeviceClientAssignment_1() { return cDeviceClientAssignment_1; }
		
		//[seronetExtension::OpcUaDeviceClient|FQN]
		public CrossReference getDeviceClientOpcUaDeviceClientCrossReference_1_0() { return cDeviceClientOpcUaDeviceClientCrossReference_1_0; }
		
		//FQN
		public RuleCall getDeviceClientOpcUaDeviceClientFQNParserRuleCall_1_0_1() { return cDeviceClientOpcUaDeviceClientFQNParserRuleCall_1_0_1; }
		
		//'deviceURI'
		public Keyword getDeviceURIKeyword_2() { return cDeviceURIKeyword_2; }
		
		//deviceURI=EString
		public Assignment getDeviceURIAssignment_3() { return cDeviceURIAssignment_3; }
		
		//EString
		public RuleCall getDeviceURIEStringParserRuleCall_3_0() { return cDeviceURIEStringParserRuleCall_3_0; }
		
		//';'?
		public Keyword getSemicolonKeyword_4() { return cSemicolonKeyword_4; }
	}
	public class OpcUaReadServerInstanceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.OpcUaReadServerInstance");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cOpcUaReadServerInstanceKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cReadServerAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cReadServerOpcUaReadServerCrossReference_1_0 = (CrossReference)cReadServerAssignment_1.eContents().get(0);
		private final RuleCall cReadServerOpcUaReadServerFQNParserRuleCall_1_0_1 = (RuleCall)cReadServerOpcUaReadServerCrossReference_1_0.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cPortNumberKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cPortNumberAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cPortNumberEIntParserRuleCall_2_1_0 = (RuleCall)cPortNumberAssignment_2_1.eContents().get(0);
		private final Keyword cSemicolonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//OpcUaReadServerInstance compArchSeronetExtension::OpcUaReadServerInstance:
		//	'OpcUaReadServerInstance' readServer=[seronetExtension::OpcUaReadServer|FQN] ('portNumber' portNumber=EInt)? ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'OpcUaReadServerInstance' readServer=[seronetExtension::OpcUaReadServer|FQN] ('portNumber' portNumber=EInt)? ';'?
		public Group getGroup() { return cGroup; }
		
		//'OpcUaReadServerInstance'
		public Keyword getOpcUaReadServerInstanceKeyword_0() { return cOpcUaReadServerInstanceKeyword_0; }
		
		//readServer=[seronetExtension::OpcUaReadServer|FQN]
		public Assignment getReadServerAssignment_1() { return cReadServerAssignment_1; }
		
		//[seronetExtension::OpcUaReadServer|FQN]
		public CrossReference getReadServerOpcUaReadServerCrossReference_1_0() { return cReadServerOpcUaReadServerCrossReference_1_0; }
		
		//FQN
		public RuleCall getReadServerOpcUaReadServerFQNParserRuleCall_1_0_1() { return cReadServerOpcUaReadServerFQNParserRuleCall_1_0_1; }
		
		//('portNumber' portNumber=EInt)?
		public Group getGroup_2() { return cGroup_2; }
		
		//'portNumber'
		public Keyword getPortNumberKeyword_2_0() { return cPortNumberKeyword_2_0; }
		
		//portNumber=EInt
		public Assignment getPortNumberAssignment_2_1() { return cPortNumberAssignment_2_1; }
		
		//EInt
		public RuleCall getPortNumberEIntParserRuleCall_2_1_0() { return cPortNumberEIntParserRuleCall_2_1_0; }
		
		//';'?
		public Keyword getSemicolonKeyword_3() { return cSemicolonKeyword_3; }
	}
	public class ServiceInstanceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.ServiceInstance");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cRequiredServiceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cProvidedServiceParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//ServiceInstance:
		//	RequiredService | ProvidedService;
		@Override public ParserRule getRule() { return rule; }
		
		//RequiredService | ProvidedService
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//RequiredService
		public RuleCall getRequiredServiceParserRuleCall_0() { return cRequiredServiceParserRuleCall_0; }
		
		//ProvidedService
		public RuleCall getProvidedServiceParserRuleCall_1() { return cProvidedServiceParserRuleCall_1; }
	}
	public class RequiredServiceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.RequiredService");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cRequiredServiceKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cPortAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cPortComponentPortCrossReference_1_0 = (CrossReference)cPortAssignment_1.eContents().get(0);
		private final RuleCall cPortComponentPortIDTerminalRuleCall_1_0_1 = (RuleCall)cPortComponentPortCrossReference_1_0.eContents().get(1);
		private final Keyword cSemicolonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		
		//RequiredService:
		//	'RequiredService' port=[componentDefinition::ComponentPort] ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'RequiredService' port=[componentDefinition::ComponentPort] ';'?
		public Group getGroup() { return cGroup; }
		
		//'RequiredService'
		public Keyword getRequiredServiceKeyword_0() { return cRequiredServiceKeyword_0; }
		
		//port=[componentDefinition::ComponentPort]
		public Assignment getPortAssignment_1() { return cPortAssignment_1; }
		
		//[componentDefinition::ComponentPort]
		public CrossReference getPortComponentPortCrossReference_1_0() { return cPortComponentPortCrossReference_1_0; }
		
		//ID
		public RuleCall getPortComponentPortIDTerminalRuleCall_1_0_1() { return cPortComponentPortIDTerminalRuleCall_1_0_1; }
		
		//';'?
		public Keyword getSemicolonKeyword_2() { return cSemicolonKeyword_2; }
	}
	public class ProvidedServiceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.ProvidedService");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cProvidedServiceKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cPortAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cPortComponentPortCrossReference_1_0 = (CrossReference)cPortAssignment_1.eContents().get(0);
		private final RuleCall cPortComponentPortIDTerminalRuleCall_1_0_1 = (RuleCall)cPortComponentPortCrossReference_1_0.eContents().get(1);
		private final Keyword cSemicolonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		
		//ProvidedService:
		//	'ProvidedService' port=[componentDefinition::ComponentPort] ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'ProvidedService' port=[componentDefinition::ComponentPort] ';'?
		public Group getGroup() { return cGroup; }
		
		//'ProvidedService'
		public Keyword getProvidedServiceKeyword_0() { return cProvidedServiceKeyword_0; }
		
		//port=[componentDefinition::ComponentPort]
		public Assignment getPortAssignment_1() { return cPortAssignment_1; }
		
		//[componentDefinition::ComponentPort]
		public CrossReference getPortComponentPortCrossReference_1_0() { return cPortComponentPortCrossReference_1_0; }
		
		//ID
		public RuleCall getPortComponentPortIDTerminalRuleCall_1_0_1() { return cPortComponentPortIDTerminalRuleCall_1_0_1; }
		
		//';'?
		public Keyword getSemicolonKeyword_2() { return cSemicolonKeyword_2; }
	}
	public class CoordinationModuleMappingElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.CoordinationModuleMapping");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cCoordinationModuleMappingKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cModuleInstanceKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cCoordModuleInstAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cCoordModuleInstAbstractCoordinationModuleInstanceCrossReference_3_0 = (CrossReference)cCoordModuleInstAssignment_3.eContents().get(0);
		private final RuleCall cCoordModuleInstAbstractCoordinationModuleInstanceFQNParserRuleCall_3_0_1 = (RuleCall)cCoordModuleInstAbstractCoordinationModuleInstanceCrossReference_3_0.eContents().get(1);
		private final Keyword cRealizedbyKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cCoordModRealAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final CrossReference cCoordModRealCoordinationModuleRealizationCrossReference_5_0 = (CrossReference)cCoordModRealAssignment_5.eContents().get(0);
		private final RuleCall cCoordModRealCoordinationModuleRealizationIDTerminalRuleCall_5_0_1 = (RuleCall)cCoordModRealCoordinationModuleRealizationCrossReference_5_0.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Assignment cCoordInterCompInstMappingAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cCoordInterCompInstMappingCoordinationInterfaceComponentInstanceMappingParserRuleCall_7_0 = (RuleCall)cCoordInterCompInstMappingAssignment_7.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_8 = (Keyword)cGroup.eContents().get(8);
		private final Keyword cRightCurlyBracketKeyword_9 = (Keyword)cGroup.eContents().get(9);
		
		//CoordinationModuleMapping compArchBehaviorExtension::CoordinationModuleMapping:
		//	'CoordinationModuleMapping' '{'
		//	'moduleInstance' coordModuleInst=[taskRealization::AbstractCoordinationModuleInstance|FQN] 'realizedby'
		//	coordModReal=[skillRealization::CoordinationModuleRealization]
		//	'{'
		//	coordInterCompInstMapping+=CoordinationInterfaceComponentInstanceMapping+
		//	'}'
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//'CoordinationModuleMapping' '{' 'moduleInstance'
		//coordModuleInst=[taskRealization::AbstractCoordinationModuleInstance|FQN] 'realizedby'
		//coordModReal=[skillRealization::CoordinationModuleRealization] '{'
		//coordInterCompInstMapping+=CoordinationInterfaceComponentInstanceMapping+ '}' '}'
		public Group getGroup() { return cGroup; }
		
		//'CoordinationModuleMapping'
		public Keyword getCoordinationModuleMappingKeyword_0() { return cCoordinationModuleMappingKeyword_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_1() { return cLeftCurlyBracketKeyword_1; }
		
		//'moduleInstance'
		public Keyword getModuleInstanceKeyword_2() { return cModuleInstanceKeyword_2; }
		
		//coordModuleInst=[taskRealization::AbstractCoordinationModuleInstance|FQN]
		public Assignment getCoordModuleInstAssignment_3() { return cCoordModuleInstAssignment_3; }
		
		//[taskRealization::AbstractCoordinationModuleInstance|FQN]
		public CrossReference getCoordModuleInstAbstractCoordinationModuleInstanceCrossReference_3_0() { return cCoordModuleInstAbstractCoordinationModuleInstanceCrossReference_3_0; }
		
		//FQN
		public RuleCall getCoordModuleInstAbstractCoordinationModuleInstanceFQNParserRuleCall_3_0_1() { return cCoordModuleInstAbstractCoordinationModuleInstanceFQNParserRuleCall_3_0_1; }
		
		//'realizedby'
		public Keyword getRealizedbyKeyword_4() { return cRealizedbyKeyword_4; }
		
		//coordModReal=[skillRealization::CoordinationModuleRealization]
		public Assignment getCoordModRealAssignment_5() { return cCoordModRealAssignment_5; }
		
		//[skillRealization::CoordinationModuleRealization]
		public CrossReference getCoordModRealCoordinationModuleRealizationCrossReference_5_0() { return cCoordModRealCoordinationModuleRealizationCrossReference_5_0; }
		
		//ID
		public RuleCall getCoordModRealCoordinationModuleRealizationIDTerminalRuleCall_5_0_1() { return cCoordModRealCoordinationModuleRealizationIDTerminalRuleCall_5_0_1; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_6() { return cLeftCurlyBracketKeyword_6; }
		
		//coordInterCompInstMapping+=CoordinationInterfaceComponentInstanceMapping+
		public Assignment getCoordInterCompInstMappingAssignment_7() { return cCoordInterCompInstMappingAssignment_7; }
		
		//CoordinationInterfaceComponentInstanceMapping
		public RuleCall getCoordInterCompInstMappingCoordinationInterfaceComponentInstanceMappingParserRuleCall_7_0() { return cCoordInterCompInstMappingCoordinationInterfaceComponentInstanceMappingParserRuleCall_7_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_8() { return cRightCurlyBracketKeyword_8; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_9() { return cRightCurlyBracketKeyword_9; }
	}
	public class CoordinationInterfaceComponentInstanceMappingElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.CoordinationInterfaceComponentInstanceMapping");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cInterfaceInstanceKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cCoordInterInstAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cCoordInterInstCoordinationInterfaceInstanceCrossReference_1_0 = (CrossReference)cCoordInterInstAssignment_1.eContents().get(0);
		private final RuleCall cCoordInterInstCoordinationInterfaceInstanceIDTerminalRuleCall_1_0_1 = (RuleCall)cCoordInterInstCoordinationInterfaceInstanceCrossReference_1_0.eContents().get(1);
		private final Keyword cRealizedbyKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cCompInstAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cCompInstComponentInstanceCrossReference_3_0 = (CrossReference)cCompInstAssignment_3.eContents().get(0);
		private final RuleCall cCompInstComponentInstanceIDTerminalRuleCall_3_0_1 = (RuleCall)cCompInstComponentInstanceCrossReference_3_0.eContents().get(1);
		
		//CoordinationInterfaceComponentInstanceMapping compArchBehaviorExtension::CoordinationInterfaceComponentInstanceMapping:
		//	'interfaceInstance' coordInterInst=[skillRealization::CoordinationInterfaceInstance] 'realizedby'
		//	compInst=[ComponentInstance];
		@Override public ParserRule getRule() { return rule; }
		
		//'interfaceInstance' coordInterInst=[skillRealization::CoordinationInterfaceInstance] 'realizedby'
		//compInst=[ComponentInstance]
		public Group getGroup() { return cGroup; }
		
		//'interfaceInstance'
		public Keyword getInterfaceInstanceKeyword_0() { return cInterfaceInstanceKeyword_0; }
		
		//coordInterInst=[skillRealization::CoordinationInterfaceInstance]
		public Assignment getCoordInterInstAssignment_1() { return cCoordInterInstAssignment_1; }
		
		//[skillRealization::CoordinationInterfaceInstance]
		public CrossReference getCoordInterInstCoordinationInterfaceInstanceCrossReference_1_0() { return cCoordInterInstCoordinationInterfaceInstanceCrossReference_1_0; }
		
		//ID
		public RuleCall getCoordInterInstCoordinationInterfaceInstanceIDTerminalRuleCall_1_0_1() { return cCoordInterInstCoordinationInterfaceInstanceIDTerminalRuleCall_1_0_1; }
		
		//'realizedby'
		public Keyword getRealizedbyKeyword_2() { return cRealizedbyKeyword_2; }
		
		//compInst=[ComponentInstance]
		public Assignment getCompInstAssignment_3() { return cCompInstAssignment_3; }
		
		//[ComponentInstance]
		public CrossReference getCompInstComponentInstanceCrossReference_3_0() { return cCompInstComponentInstanceCrossReference_3_0; }
		
		//ID
		public RuleCall getCompInstComponentInstanceIDTerminalRuleCall_3_0_1() { return cCompInstComponentInstanceIDTerminalRuleCall_3_0_1; }
	}
	public class TaskRealizationModelRefElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture.TaskRealizationModelRef");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cBehaviorTaskRefKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cTaskModelRefAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cTaskModelRefTaskRealizationModelCrossReference_1_0 = (CrossReference)cTaskModelRefAssignment_1.eContents().get(0);
		private final RuleCall cTaskModelRefTaskRealizationModelFQNParserRuleCall_1_0_1 = (RuleCall)cTaskModelRefTaskRealizationModelCrossReference_1_0.eContents().get(1);
		
		//TaskRealizationModelRef compArchBehaviorExtension::TaskRealizationModelRef:
		//	'BehaviorTaskRef' taskModelRef=[taskRealization::TaskRealizationModel|FQN];
		@Override public ParserRule getRule() { return rule; }
		
		//'BehaviorTaskRef' taskModelRef=[taskRealization::TaskRealizationModel|FQN]
		public Group getGroup() { return cGroup; }
		
		//'BehaviorTaskRef'
		public Keyword getBehaviorTaskRefKeyword_0() { return cBehaviorTaskRefKeyword_0; }
		
		//taskModelRef=[taskRealization::TaskRealizationModel|FQN]
		public Assignment getTaskModelRefAssignment_1() { return cTaskModelRefAssignment_1; }
		
		//[taskRealization::TaskRealizationModel|FQN]
		public CrossReference getTaskModelRefTaskRealizationModelCrossReference_1_0() { return cTaskModelRefTaskRealizationModelCrossReference_1_0; }
		
		//FQN
		public RuleCall getTaskModelRefTaskRealizationModelFQNParserRuleCall_1_0_1() { return cTaskModelRefTaskRealizationModelFQNParserRuleCall_1_0_1; }
	}
	
	
	private final SystemComponentArchitectureElements pSystemComponentArchitecture;
	private final SystemExtensionElements pSystemExtension;
	private final ConnectionElements pConnection;
	private final ComponentInstanceElements pComponentInstance;
	private final ComponentInstanceExtensionElements pComponentInstanceExtension;
	private final ParameterStructInstanceElements pParameterStructInstance;
	private final ActivityConfigurationMappingElements pActivityConfigurationMapping;
	private final InputHandlerConfigurationMappingElements pInputHandlerConfigurationMapping;
	private final OpcUaDeviceClientInstanceElements pOpcUaDeviceClientInstance;
	private final OpcUaReadServerInstanceElements pOpcUaReadServerInstance;
	private final ServiceInstanceElements pServiceInstance;
	private final RequiredServiceElements pRequiredService;
	private final ProvidedServiceElements pProvidedService;
	private final CoordinationModuleMappingElements pCoordinationModuleMapping;
	private final CoordinationInterfaceComponentInstanceMappingElements pCoordinationInterfaceComponentInstanceMapping;
	private final TaskRealizationModelRefElements pTaskRealizationModelRef;
	
	private final Grammar grammar;
	
	private final RoboticMiddlewareGrammarAccess gaRoboticMiddleware;
	
	private final DocuTerminalsGrammarAccess gaDocuTerminals;
	
	private final TerminalsGrammarAccess gaTerminals;

	@Inject
	public ComponentArchitectureGrammarAccess(GrammarProvider grammarProvider,
			RoboticMiddlewareGrammarAccess gaRoboticMiddleware,
			DocuTerminalsGrammarAccess gaDocuTerminals,
			TerminalsGrammarAccess gaTerminals) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaRoboticMiddleware = gaRoboticMiddleware;
		this.gaDocuTerminals = gaDocuTerminals;
		this.gaTerminals = gaTerminals;
		this.pSystemComponentArchitecture = new SystemComponentArchitectureElements();
		this.pSystemExtension = new SystemExtensionElements();
		this.pConnection = new ConnectionElements();
		this.pComponentInstance = new ComponentInstanceElements();
		this.pComponentInstanceExtension = new ComponentInstanceExtensionElements();
		this.pParameterStructInstance = new ParameterStructInstanceElements();
		this.pActivityConfigurationMapping = new ActivityConfigurationMappingElements();
		this.pInputHandlerConfigurationMapping = new InputHandlerConfigurationMappingElements();
		this.pOpcUaDeviceClientInstance = new OpcUaDeviceClientInstanceElements();
		this.pOpcUaReadServerInstance = new OpcUaReadServerInstanceElements();
		this.pServiceInstance = new ServiceInstanceElements();
		this.pRequiredService = new RequiredServiceElements();
		this.pProvidedService = new ProvidedServiceElements();
		this.pCoordinationModuleMapping = new CoordinationModuleMappingElements();
		this.pCoordinationInterfaceComponentInstanceMapping = new CoordinationInterfaceComponentInstanceMappingElements();
		this.pTaskRealizationModelRef = new TaskRealizationModelRefElements();
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	
	
	public RoboticMiddlewareGrammarAccess getRoboticMiddlewareGrammarAccess() {
		return gaRoboticMiddleware;
	}
	
	public DocuTerminalsGrammarAccess getDocuTerminalsGrammarAccess() {
		return gaDocuTerminals;
	}
	
	public TerminalsGrammarAccess getTerminalsGrammarAccess() {
		return gaTerminals;
	}

	
	//SystemComponentArchitecture:
	//	{SystemComponentArchitecture}
	//	'SystemComponentArchitecture' name=ID ('usingActivityArchitecture'
	//	activityArch=[activityArchitecture::ActivityArchitectureModel|FQN])?
	//	'{'
	//	components+=ComponentInstance*
	//	connections+=Connection*
	//	extensions+=SystemExtension*
	//	'}';
	public SystemComponentArchitectureElements getSystemComponentArchitectureAccess() {
		return pSystemComponentArchitecture;
	}
	
	public ParserRule getSystemComponentArchitectureRule() {
		return getSystemComponentArchitectureAccess().getRule();
	}
	
	//SystemExtension:
	//	CoordinationModuleMapping | TaskRealizationModelRef;
	public SystemExtensionElements getSystemExtensionAccess() {
		return pSystemExtension;
	}
	
	public ParserRule getSystemExtensionRule() {
		return getSystemExtensionAccess().getRule();
	}
	
	//Connection:
	//	'Connection' from=[RequiredService|FQN] '->' to=[ProvidedService|FQN] ('useMiddleware'
	//	middlewareSelection=RoboticMiddleware)? ';'?;
	public ConnectionElements getConnectionAccess() {
		return pConnection;
	}
	
	public ParserRule getConnectionRule() {
		return getConnectionAccess().getRule();
	}
	
	//ComponentInstance:
	//	'ComponentInstance' name=ID 'instantiates' component=[componentDefinition::ComponentDefinition|FQN]
	//	'{'
	//	ports+=ServiceInstance*
	//	extensions+=ComponentInstanceExtension*
	//	'}';
	public ComponentInstanceElements getComponentInstanceAccess() {
		return pComponentInstance;
	}
	
	public ParserRule getComponentInstanceRule() {
		return getComponentInstanceAccess().getRule();
	}
	
	//ComponentInstanceExtension:
	//	ParameterStructInstance | ActivityConfigurationMapping | InputHandlerConfigurationMapping | OpcUaDeviceClientInstance
	//	| OpcUaReadServerInstance;
	public ComponentInstanceExtensionElements getComponentInstanceExtensionAccess() {
		return pComponentInstanceExtension;
	}
	
	public ParserRule getComponentInstanceExtensionRule() {
		return getComponentInstanceExtensionAccess().getRule();
	}
	
	//ParameterStructInstance systemParameter::ParameterStructInstance:
	//	'ParameterStructInstance' parameter=[systemParameter::ComponentParameterInstance|FQN] ';'?;
	public ParameterStructInstanceElements getParameterStructInstanceAccess() {
		return pParameterStructInstance;
	}
	
	public ParserRule getParameterStructInstanceRule() {
		return getParameterStructInstanceAccess().getRule();
	}
	
	//ActivityConfigurationMapping:
	//	'Activity' activity=[componentDefinition::Activity|FQN] 'configuration'
	//	config=[activityArchitecture::ActivityNode|FQN] ';'?;
	public ActivityConfigurationMappingElements getActivityConfigurationMappingAccess() {
		return pActivityConfigurationMapping;
	}
	
	public ParserRule getActivityConfigurationMappingRule() {
		return getActivityConfigurationMappingAccess().getRule();
	}
	
	//InputHandlerConfigurationMapping:
	//	'InputHandler' handler=[componentDefinition::InputHandler|FQN] 'configuration'
	//	config=[activityArchitecture::InputHandlerNode|FQN] ';'?;
	public InputHandlerConfigurationMappingElements getInputHandlerConfigurationMappingAccess() {
		return pInputHandlerConfigurationMapping;
	}
	
	public ParserRule getInputHandlerConfigurationMappingRule() {
		return getInputHandlerConfigurationMappingAccess().getRule();
	}
	
	//OpcUaDeviceClientInstance compArchSeronetExtension::OpcUaDeviceClientInstance:
	//	'OpcUaDeviceClientInstance' deviceClient=[seronetExtension::OpcUaDeviceClient|FQN] 'deviceURI' deviceURI=EString ';'?;
	public OpcUaDeviceClientInstanceElements getOpcUaDeviceClientInstanceAccess() {
		return pOpcUaDeviceClientInstance;
	}
	
	public ParserRule getOpcUaDeviceClientInstanceRule() {
		return getOpcUaDeviceClientInstanceAccess().getRule();
	}
	
	//OpcUaReadServerInstance compArchSeronetExtension::OpcUaReadServerInstance:
	//	'OpcUaReadServerInstance' readServer=[seronetExtension::OpcUaReadServer|FQN] ('portNumber' portNumber=EInt)? ';'?;
	public OpcUaReadServerInstanceElements getOpcUaReadServerInstanceAccess() {
		return pOpcUaReadServerInstance;
	}
	
	public ParserRule getOpcUaReadServerInstanceRule() {
		return getOpcUaReadServerInstanceAccess().getRule();
	}
	
	//ServiceInstance:
	//	RequiredService | ProvidedService;
	public ServiceInstanceElements getServiceInstanceAccess() {
		return pServiceInstance;
	}
	
	public ParserRule getServiceInstanceRule() {
		return getServiceInstanceAccess().getRule();
	}
	
	//RequiredService:
	//	'RequiredService' port=[componentDefinition::ComponentPort] ';'?;
	public RequiredServiceElements getRequiredServiceAccess() {
		return pRequiredService;
	}
	
	public ParserRule getRequiredServiceRule() {
		return getRequiredServiceAccess().getRule();
	}
	
	//ProvidedService:
	//	'ProvidedService' port=[componentDefinition::ComponentPort] ';'?;
	public ProvidedServiceElements getProvidedServiceAccess() {
		return pProvidedService;
	}
	
	public ParserRule getProvidedServiceRule() {
		return getProvidedServiceAccess().getRule();
	}
	
	//CoordinationModuleMapping compArchBehaviorExtension::CoordinationModuleMapping:
	//	'CoordinationModuleMapping' '{'
	//	'moduleInstance' coordModuleInst=[taskRealization::AbstractCoordinationModuleInstance|FQN] 'realizedby'
	//	coordModReal=[skillRealization::CoordinationModuleRealization]
	//	'{'
	//	coordInterCompInstMapping+=CoordinationInterfaceComponentInstanceMapping+
	//	'}'
	//	'}';
	public CoordinationModuleMappingElements getCoordinationModuleMappingAccess() {
		return pCoordinationModuleMapping;
	}
	
	public ParserRule getCoordinationModuleMappingRule() {
		return getCoordinationModuleMappingAccess().getRule();
	}
	
	//CoordinationInterfaceComponentInstanceMapping compArchBehaviorExtension::CoordinationInterfaceComponentInstanceMapping:
	//	'interfaceInstance' coordInterInst=[skillRealization::CoordinationInterfaceInstance] 'realizedby'
	//	compInst=[ComponentInstance];
	public CoordinationInterfaceComponentInstanceMappingElements getCoordinationInterfaceComponentInstanceMappingAccess() {
		return pCoordinationInterfaceComponentInstanceMapping;
	}
	
	public ParserRule getCoordinationInterfaceComponentInstanceMappingRule() {
		return getCoordinationInterfaceComponentInstanceMappingAccess().getRule();
	}
	
	//TaskRealizationModelRef compArchBehaviorExtension::TaskRealizationModelRef:
	//	'BehaviorTaskRef' taskModelRef=[taskRealization::TaskRealizationModel|FQN];
	public TaskRealizationModelRefElements getTaskRealizationModelRefAccess() {
		return pTaskRealizationModelRef;
	}
	
	public ParserRule getTaskRealizationModelRefRule() {
		return getTaskRealizationModelRefAccess().getRule();
	}
	
	//RoboticMiddleware:
	//	ACE_SmartSoft | OpcUa_SeRoNet | CORBA_SmartSoft | DDS_SmartSoft;
	public RoboticMiddlewareGrammarAccess.RoboticMiddlewareElements getRoboticMiddlewareAccess() {
		return gaRoboticMiddleware.getRoboticMiddlewareAccess();
	}
	
	public ParserRule getRoboticMiddlewareRule() {
		return getRoboticMiddlewareAccess().getRule();
	}
	
	//FQN:
	//	ID ('.' ID)*;
	public RoboticMiddlewareGrammarAccess.FQNElements getFQNAccess() {
		return gaRoboticMiddleware.getFQNAccess();
	}
	
	public ParserRule getFQNRule() {
		return getFQNAccess().getRule();
	}
	
	//FQNW:
	//	FQN '.*'?;
	public RoboticMiddlewareGrammarAccess.FQNWElements getFQNWAccess() {
		return gaRoboticMiddleware.getFQNWAccess();
	}
	
	public ParserRule getFQNWRule() {
		return getFQNWAccess().getRule();
	}
	
	//EString:
	//	STRING;
	public RoboticMiddlewareGrammarAccess.EStringElements getEStringAccess() {
		return gaRoboticMiddleware.getEStringAccess();
	}
	
	public ParserRule getEStringRule() {
		return getEStringAccess().getRule();
	}
	
	//EInt ecore::EInt:
	//	'-'? INT;
	public RoboticMiddlewareGrammarAccess.EIntElements getEIntAccess() {
		return gaRoboticMiddleware.getEIntAccess();
	}
	
	public ParserRule getEIntRule() {
		return getEIntAccess().getRule();
	}
	
	//EDouble ecore::EDouble:
	//	'-'? INT? '.' INT (('E' | 'e') '-'? INT)?;
	public RoboticMiddlewareGrammarAccess.EDoubleElements getEDoubleAccess() {
		return gaRoboticMiddleware.getEDoubleAccess();
	}
	
	public ParserRule getEDoubleRule() {
		return getEDoubleAccess().getRule();
	}
	
	//EBoolean ecore::EBoolean:
	//	'true' | 'false';
	public RoboticMiddlewareGrammarAccess.EBooleanElements getEBooleanAccess() {
		return gaRoboticMiddleware.getEBooleanAccess();
	}
	
	public ParserRule getEBooleanRule() {
		return getEBooleanAccess().getRule();
	}
	
	//ACE_SmartSoft:
	//	{ACE_SmartSoft}
	//	'ACE_SmartSoft' ('description' description=EString)?;
	public RoboticMiddlewareGrammarAccess.ACE_SmartSoftElements getACE_SmartSoftAccess() {
		return gaRoboticMiddleware.getACE_SmartSoftAccess();
	}
	
	public ParserRule getACE_SmartSoftRule() {
		return getACE_SmartSoftAccess().getRule();
	}
	
	//OpcUa_SeRoNet:
	//	{OpcUa_SeRoNet}
	//	'OpcUa_SeRoNet' ('description' description=EString)?;
	public RoboticMiddlewareGrammarAccess.OpcUa_SeRoNetElements getOpcUa_SeRoNetAccess() {
		return gaRoboticMiddleware.getOpcUa_SeRoNetAccess();
	}
	
	public ParserRule getOpcUa_SeRoNetRule() {
		return getOpcUa_SeRoNetAccess().getRule();
	}
	
	//CORBA_SmartSoft:
	//	{CORBA_SmartSoft}
	//	'CORBA_SmartSoft' ('description' description=EString)?;
	public RoboticMiddlewareGrammarAccess.CORBA_SmartSoftElements getCORBA_SmartSoftAccess() {
		return gaRoboticMiddleware.getCORBA_SmartSoftAccess();
	}
	
	public ParserRule getCORBA_SmartSoftRule() {
		return getCORBA_SmartSoftAccess().getRule();
	}
	
	//DDS_SmartSoft:
	//	{DDS_SmartSoft}
	//	'DDS_SmartSoft' ('description' description=EString)?;
	public RoboticMiddlewareGrammarAccess.DDS_SmartSoftElements getDDS_SmartSoftAccess() {
		return gaRoboticMiddleware.getDDS_SmartSoftAccess();
	}
	
	public ParserRule getDDS_SmartSoftRule() {
		return getDDS_SmartSoftAccess().getRule();
	}
	
	//AbstractDocumentationElement:
	//	{AbstractDocumentationElement} documentation=DOCU_COMMENT?;
	public DocuTerminalsGrammarAccess.AbstractDocumentationElementElements getAbstractDocumentationElementAccess() {
		return gaDocuTerminals.getAbstractDocumentationElementAccess();
	}
	
	public ParserRule getAbstractDocumentationElementRule() {
		return getAbstractDocumentationElementAccess().getRule();
	}
	
	//@Override
	//terminal ML_COMMENT:
	//	'/*' !'*'->'*/';
	public TerminalRule getML_COMMENTRule() {
		return gaDocuTerminals.getML_COMMENTRule();
	}
	
	//terminal fragment ML_DOCUMENTATION:
	//	'/**'->'*/';
	public TerminalRule getML_DOCUMENTATIONRule() {
		return gaDocuTerminals.getML_DOCUMENTATIONRule();
	}
	
	//@Override
	//terminal SL_COMMENT:
	//	'//' !'/' !('\n' | '\r')* ('\r'? '\n')?;
	public TerminalRule getSL_COMMENTRule() {
		return gaDocuTerminals.getSL_COMMENTRule();
	}
	
	//terminal fragment SL_DOCUMENTATION:
	//	'///' !('\n' | '\r')* ('\r'? '\n')?;
	public TerminalRule getSL_DOCUMENTATIONRule() {
		return gaDocuTerminals.getSL_DOCUMENTATIONRule();
	}
	
	//terminal DOCU_COMMENT:
	//	ML_DOCUMENTATION | SL_DOCUMENTATION;
	public TerminalRule getDOCU_COMMENTRule() {
		return gaDocuTerminals.getDOCU_COMMENTRule();
	}
	
	//terminal ID:
	//	'^'? ('a'..'z' | 'A'..'Z' | '_') ('a'..'z' | 'A'..'Z' | '_' | '0'..'9')*;
	public TerminalRule getIDRule() {
		return gaTerminals.getIDRule();
	}
	
	//terminal INT returns ecore::EInt:
	//	'0'..'9'+;
	public TerminalRule getINTRule() {
		return gaTerminals.getINTRule();
	}
	
	//terminal STRING:
	//	'"' ('\\' . | !('\\' | '"'))* '"' |
	//	"'" ('\\' . | !('\\' | "'"))* "'";
	public TerminalRule getSTRINGRule() {
		return gaTerminals.getSTRINGRule();
	}
	
	//terminal WS:
	//	' ' | '\t' | '\r' | '\n'+;
	public TerminalRule getWSRule() {
		return gaTerminals.getWSRule();
	}
	
	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return gaTerminals.getANY_OTHERRule();
	}
}
