/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.SystemDatasheetPropertyChecksRuntimeModule;
import org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.SystemDatasheetPropertyChecksStandaloneSetup;
import org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.ide.SystemDatasheetPropertyChecksIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class SystemDatasheetPropertyChecksIdeSetup extends SystemDatasheetPropertyChecksStandaloneSetup {
  @Override
  public Injector createInjector() {
    SystemDatasheetPropertyChecksRuntimeModule _systemDatasheetPropertyChecksRuntimeModule = new SystemDatasheetPropertyChecksRuntimeModule();
    SystemDatasheetPropertyChecksIdeModule _systemDatasheetPropertyChecksIdeModule = new SystemDatasheetPropertyChecksIdeModule();
    return Guice.createInjector(Modules2.mixin(_systemDatasheetPropertyChecksRuntimeModule, _systemDatasheetPropertyChecksIdeModule));
  }
}
