/********************************************************************************
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.DatasheetPropertyCheck;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.DatasheetPropertyChecksPackage;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.SystemDatasheetPropertyChecksModel;
import org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.services.SystemDatasheetPropertyChecksGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;

@SuppressWarnings("all")
public class SystemDatasheetPropertyChecksSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private SystemDatasheetPropertyChecksGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == DatasheetPropertyChecksPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case DatasheetPropertyChecksPackage.DATASHEET_PROPERTY_CHECK:
				sequence_DatasheetPropertyCheck(context, (DatasheetPropertyCheck) semanticObject); 
				return; 
			case DatasheetPropertyChecksPackage.SYSTEM_DATASHEET_PROPERTY_CHECKS_MODEL:
				sequence_SystemDatasheetPropertyChecksModel(context, (SystemDatasheetPropertyChecksModel) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     DatasheetPropertyCheck returns DatasheetPropertyCheck
	 *
	 * Constraint:
	 *     (function=EvaluationFunction propertyName=ID operator=EvaluationOperator propertyValue=STRING propertyUnit=STRING?)
	 */
	protected void sequence_DatasheetPropertyCheck(ISerializationContext context, DatasheetPropertyCheck semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     SystemDatasheetPropertyChecksModel returns SystemDatasheetPropertyChecksModel
	 *
	 * Constraint:
	 *     (system=[SystemComponentArchitecture|ID] checks+=DatasheetPropertyCheck*)
	 */
	protected void sequence_SystemDatasheetPropertyChecksModel(ISerializationContext context, SystemDatasheetPropertyChecksModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
