/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.datasheetPropertyChecks.validation;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.datasheet.indexer.DatasheetProjectSettings;
import org.eclipse.smartmdsd.datasheet.indexer.WorkspaceDatasheetIndexer;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DefaultDatasheetProperties;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.DatasheetPropertyCheck;
import org.eclipse.smartmdsd.ecore.system.datasheetPropertyChecks.EvaluationOperator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.osgi.service.prefs.Preferences;

@SuppressWarnings("all")
public class DatasheetPropertyCheckEvaluator {
  public Collection<String> getMainPropertyValues(final String componentName, final String propertyName) {
    final WorkspaceDatasheetIndexer indexer = WorkspaceDatasheetIndexer.getInstance();
    final DatasheetProjectSettings component_datasheet = indexer.getDatasheetProjectSettings(componentName);
    final Preferences property_node = component_datasheet.getMainPropertyNode(propertyName);
    return component_datasheet.getPropertyValues(property_node);
  }
  
  public Collection<String> getIncompatiblePropertyValues(final ComponentInstance instance, final DatasheetPropertyCheck check) {
    final ArrayList<String> result = CollectionLiterals.<String>newArrayList();
    boolean _equals = check.getPropertyName().equals(DefaultDatasheetProperties.TECHNOLOGY_READINESS_LEVEL.getLiteral());
    if (_equals) {
      final int right_value = this.getTRLIndex(check.getPropertyValue());
      Collection<String> _mainPropertyValues = this.getMainPropertyValues(instance.getComponent().getName(), check.getPropertyName());
      for (final String value : _mainPropertyValues) {
        {
          final int left_value = this.getTRLIndex(value);
          boolean _intCompare = this.intCompare(left_value, check.getOperator(), right_value);
          boolean _not = (!_intCompare);
          if (_not) {
            result.add(value);
          }
        }
      }
    } else {
      Collection<String> _mainPropertyValues_1 = this.getMainPropertyValues(instance.getComponent().getName(), check.getPropertyName());
      for (final String value_1 : _mainPropertyValues_1) {
        boolean _stringCompare = this.stringCompare(value_1, check.getOperator(), check.getPropertyValue());
        boolean _not = (!_stringCompare);
        if (_not) {
          result.add(value_1);
        }
      }
    }
    return result;
  }
  
  public boolean exists(final SystemComponentArchitecture system, final DatasheetPropertyCheck check) {
    boolean _equals = check.getPropertyName().equals(DefaultDatasheetProperties.TECHNOLOGY_READINESS_LEVEL.getLiteral());
    if (_equals) {
      final int right_value = this.getTRLIndex(check.getPropertyValue());
      EList<ComponentInstance> _components = system.getComponents();
      for (final ComponentInstance instance : _components) {
        Collection<String> _mainPropertyValues = this.getMainPropertyValues(instance.getComponent().getName(), check.getPropertyName());
        for (final String value : _mainPropertyValues) {
          {
            final int left_value = this.getTRLIndex(value);
            boolean _intCompare = this.intCompare(left_value, check.getOperator(), right_value);
            if (_intCompare) {
              return true;
            }
          }
        }
      }
    } else {
      EList<ComponentInstance> _components_1 = system.getComponents();
      for (final ComponentInstance instance_1 : _components_1) {
        Collection<String> _mainPropertyValues_1 = this.getMainPropertyValues(instance_1.getComponent().getName(), check.getPropertyName());
        for (final String value_1 : _mainPropertyValues_1) {
          boolean _stringCompare = this.stringCompare(value_1, check.getOperator(), check.getPropertyValue());
          if (_stringCompare) {
            return true;
          }
        }
      }
    }
    return false;
  }
  
  public int getTRLIndex(final String value) {
    try {
      int _length = value.length();
      int _minus = (_length - 1);
      return (Integer.valueOf(value.substring(_minus))).intValue();
    } catch (final Throwable _t) {
      if (_t instanceof NumberFormatException) {
        return 0;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public double calculateSum(final SystemComponentArchitecture system, final String propertyName) throws NumberFormatException {
    double sum = 0.0;
    final WorkspaceDatasheetIndexer indexer = WorkspaceDatasheetIndexer.getInstance();
    EList<ComponentInstance> _components = system.getComponents();
    for (final ComponentInstance instance : _components) {
      {
        final DatasheetProjectSettings component_datasheet = indexer.getDatasheetProjectSettings(instance.getComponent().getName());
        if ((component_datasheet != null)) {
          final Preferences property_node = component_datasheet.getMainPropertyNode(propertyName);
          Collection<String> _propertyValues = component_datasheet.getPropertyValues(property_node);
          for (final String value : _propertyValues) {
            double _sum = sum;
            Double _valueOf = Double.valueOf(value);
            sum = (_sum + (_valueOf).doubleValue());
          }
        }
      }
    }
    return sum;
  }
  
  public boolean stringCompare(final String left, final EvaluationOperator op, final String right) {
    boolean _switchResult = false;
    if (op != null) {
      switch (op) {
        case EQ:
          _switchResult = Objects.equal(left, right);
          break;
        case NEQ:
          _switchResult = (!Objects.equal(left, right));
          break;
        case LT:
          _switchResult = (left.compareTo(right) < 0);
          break;
        case LET:
          _switchResult = (left.compareTo(right) <= 0);
          break;
        case GET:
          _switchResult = (left.compareTo(right) >= 0);
          break;
        case GT:
          _switchResult = (left.compareTo(right) > 0);
          break;
        default:
          _switchResult = false;
          break;
      }
    } else {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public boolean intCompare(final int left, final EvaluationOperator op, final int right) {
    boolean _switchResult = false;
    if (op != null) {
      switch (op) {
        case EQ:
          _switchResult = (left == right);
          break;
        case NEQ:
          _switchResult = (left != right);
          break;
        case LT:
          _switchResult = (left < right);
          break;
        case LET:
          _switchResult = (left <= right);
          break;
        case GET:
          _switchResult = (left >= right);
          break;
        case GT:
          _switchResult = (left > right);
          break;
        default:
          _switchResult = false;
          break;
      }
    } else {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public boolean doubleCompare(final double left, final EvaluationOperator op, final double right) {
    boolean _switchResult = false;
    if (op != null) {
      switch (op) {
        case EQ:
          _switchResult = (left == right);
          break;
        case NEQ:
          _switchResult = (left != right);
          break;
        case LT:
          _switchResult = (left < right);
          break;
        case LET:
          _switchResult = (left <= right);
          break;
        case GET:
          _switchResult = (left >= right);
          break;
        case GT:
          _switchResult = (left > right);
          break;
        default:
          _switchResult = false;
          break;
      }
    } else {
      _switchResult = false;
    }
    return _switchResult;
  }
}
