/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.deployment.ui.contentassist;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformPackage;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.smartmdsd.xtext.system.deployment.ui.contentassist.AbstractDeploymentProposalProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class DeploymentProposalProvider extends AbstractDeploymentProposalProvider {
  @Inject
  private XtextResourceIndex index;
  
  @Override
  public void completeDeploymentModel_Name(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeDeploymentModel_Name(model, assignment, context, acceptor);
    if ((model != null)) {
      final URI uri = model.eResource().getURI();
      boolean _isPlatform = uri.isPlatform();
      if (_isPlatform) {
        final String projectName = uri.segment(1);
        acceptor.accept(this.createCompletionProposal(projectName, (projectName + " - ProjectName"), this.getImage(model), context));
      }
    } else {
      final IWorkbench iworkbench = PlatformUI.getWorkbench();
      if ((iworkbench != null)) {
        final IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
        final IWorkbenchPage iworkbenchpage = iworkbenchwindow.getActivePage();
        final String resourceName = iworkbenchpage.getActiveEditor().getEditorInput().<IResource>getAdapter(IResource.class).getName();
        final String projectName_1 = resourceName.substring(0, resourceName.indexOf("."));
        acceptor.accept(this.createCompletionProposal(projectName_1, (projectName_1 + " - ProjectName"), null, context));
      }
    }
  }
  
  @Override
  public void completeTargetPlatformReference_Name(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    final Iterable<IEObjectDescription> platforms = this.index.getVisibleEObjectDescriptions(model, TargetPlatformPackage.eINSTANCE.getTargetPlatformDefinition());
    final Consumer<IEObjectDescription> _function = (IEObjectDescription platform) -> {
      final String fqn = platform.getName().toString();
      final String simpleName = platform.getName().getLastSegment();
      final String text = ((simpleName + " using ") + fqn);
      acceptor.accept(this.createCompletionProposal(text, (fqn + " - TargetPlatform"), this.getImage(platform), context));
    };
    platforms.forEach(_function);
  }
}
