/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.deployment.ui.quickfix;

import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentFactory;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentModel;
import org.eclipse.smartmdsd.ecore.system.deployment.NetworkInterfaceSelection;
import org.eclipse.smartmdsd.ecore.system.deployment.TargetPlatformReference;
import org.eclipse.smartmdsd.ecore.system.deployment.UploadDirectory;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.NetworkInterface;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;

public class DeploymentQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="org.xtext.system.deployment.MultipleNamingServices")
    public void fixDuplicateOperationModeBinding(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            EObject _eContainer = element.eContainer();
            DeploymentModel model = (DeploymentModel)_eContainer;
            model.getElements().remove((Object)element);
        };
        acceptor.accept(issue, "Remove duplicate NamingService", "Remove duplicate NamingService.", "", _function);
    }

    @Fix(value="org.xtext.system.deployment.MissingUploadDirectory")
    public void fixMissingUploadDirectoy(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            TargetPlatformReference platform = (TargetPlatformReference)element;
            platform.setDirectory(DeploymentFactory.eINSTANCE.createUploadDirectory());
            UploadDirectory _directory = platform.getDirectory();
            _directory.setPath("/tmp");
        };
        acceptor.accept(issue, "Create a default UploadDirectory", "Create a default UploadDirectory", "", _function);
    }

    @Fix(value="org.xtext.system.deployment.MissingNetworkInterface")
    public void fixMissingNetworkInterface(Issue issue, IssueResolutionAcceptor acceptor) {
        EObject object = this.getEObject(issue);
        if (object instanceof TargetPlatformReference) {
            Iterable _filter = Iterables.filter((Iterable)((TargetPlatformReference)object).getPlatform().getElements(), NetworkInterface.class);
            for (NetworkInterface network : _filter) {
                String _name = network.getName();
                String _plus = "Use the NetworkInterface " + _name;
                String _name_1 = network.getName();
                String _plus_1 = "Use the NetworkInterface " + _name_1;
                ISemanticModification _function = (element, context) -> {
                    TargetPlatformReference platform = (TargetPlatformReference)element;
                    platform.setHost(DeploymentFactory.eINSTANCE.createNetworkInterfaceSelection());
                    NetworkInterfaceSelection _host = platform.getHost();
                    _host.setNetwork(network);
                };
                acceptor.accept(issue, _plus, _plus_1, "", _function);
            }
        }
    }

    private EObject getEObject(final Issue issue) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        EObject object = (EObject)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

            public EObject exec(XtextResource state) throws Exception {
                return state.getEObject(issue.getUriToProblem().fragment());
            }
        });
        return object;
    }
}

