/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.deployment.validation;

import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentModel;
import org.eclipse.smartmdsd.ecore.system.deployment.NamingService;
import org.eclipse.smartmdsd.ecore.system.deployment.NetworkInterfaceSelection;
import org.eclipse.smartmdsd.ecore.system.deployment.TargetPlatformReference;
import org.eclipse.smartmdsd.ecore.system.deployment.UploadDirectory;
import org.eclipse.smartmdsd.xtext.system.deployment.validation.AbstractDeploymentValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DeploymentValidator
extends AbstractDeploymentValidator {
    protected static final String DEPLOYMENT_ISSUE_PREFIX = "org.xtext.system.deployment.";
    public static final String MULTIPLE_NAMING_SERVICES = "org.xtext.system.deployment.MultipleNamingServices";
    public static final String MISSING_NETWORK_INTERFACE = "org.xtext.system.deployment.MissingNetworkInterface";
    public static final String MISSING_UPLOAD_DIRECTORY = "org.xtext.system.deployment.MissingUploadDirectory";

    @Check
    public void checkSingleNamingService(NamingService ns) {
        EObject parent = ns.eContainer();
        if (parent instanceof DeploymentModel) {
            boolean _greaterThan;
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((DeploymentModel)parent).getElements(), NamingService.class));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.error("Multiple NamingService-elements found, but (at most) one is allowed.", null, MULTIPLE_NAMING_SERVICES, new String[0]);
            }
        }
    }

    @Check
    public void checkMissingElements(TargetPlatformReference ref) {
        UploadDirectory _directory;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        NetworkInterfaceSelection _host = ref.getHost();
        boolean bl = _tripleEquals = _host == null;
        if (_tripleEquals) {
            this.warning("Missing NetworkInterfaceInstance.", null, MISSING_NETWORK_INTERFACE, new String[0]);
        }
        boolean bl2 = _tripleEquals_1 = (_directory = ref.getDirectory()) == null;
        if (_tripleEquals_1) {
            this.warning("Missing UploadDirectory.", null, MISSING_UPLOAD_DIRECTORY, new String[0]);
        }
    }
}

