/********************************************************************************
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.system.systemDatasheet.parser.antlr;

import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtext.system.systemDatasheet.parser.antlr.internal.InternalSystemDatasheetParser;
import org.eclipse.smartmdsd.xtext.system.systemDatasheet.services.SystemDatasheetGrammarAccess;
import org.eclipse.xtext.parser.antlr.AbstractAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;

public class SystemDatasheetParser extends AbstractAntlrParser {

	@Inject
	private SystemDatasheetGrammarAccess grammarAccess;

	@Override
	protected void setInitialHiddenTokens(XtextTokenStream tokenStream) {
		tokenStream.setInitialHiddenTokens("RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT");
	}
	

	@Override
	protected InternalSystemDatasheetParser createParser(XtextTokenStream stream) {
		return new InternalSystemDatasheetParser(stream, getGrammarAccess());
	}

	@Override 
	protected String getDefaultRuleName() {
		return "SystemDatasheet";
	}

	public SystemDatasheetGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(SystemDatasheetGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
}
