/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.systemParameter.ui.contentassist;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesModelUtility;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterBase;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.InternalParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ComponentParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ParameterRefinement;
import org.eclipse.smartmdsd.xtext.system.systemParameter.ui.contentassist.AbstractSystemParameterProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class SystemParameterProposalProvider extends AbstractSystemParameterProposalProvider {
  @Inject
  private BasicAttributesModelUtility util;
  
  @Override
  public void completeAttributeRefinement_Value(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeAttributeRefinement_Value(model, assignment, context, acceptor);
    if ((model instanceof AttributeRefinement)) {
      final EObject parent = ((AttributeRefinement)model).eContainer();
      if ((parent instanceof ParameterRefinement)) {
        final ComponentParameterBase parameter = ((ParameterRefinement)parent).getParameter();
        if ((parameter instanceof ParameterInstance)) {
          final Function1<AttributeRefinement, Boolean> _function = (AttributeRefinement it) -> {
            AttributeDefinition _attribute = it.getAttribute();
            AttributeDefinition _attribute_1 = ((AttributeRefinement)model).getAttribute();
            return Boolean.valueOf(Objects.equal(_attribute, _attribute_1));
          };
          final AttributeRefinement origin = IterableExtensions.<AttributeRefinement>findFirst(((ParameterInstance)parameter).getAttributes(), _function);
          if ((origin != null)) {
            final AbstractAttributeType attrType = ((AttributeRefinement)model).getAttribute().getType();
            if ((attrType instanceof PrimitiveType)) {
              final String text = this.util.getValueString(origin.getValue());
              String _literal = ((PrimitiveType)attrType).getTypeName().getLiteral();
              String _plus = ((text + " - ") + _literal);
              acceptor.accept(this.createCompletionProposal(text, _plus, this.getImage(attrType), context));
            }
          }
        }
      }
    }
  }
  
  @Override
  public void completeParameterRefinement_Attributes(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeParameterRefinement_Attributes(model, assignment, context, acceptor);
    EObject paramRefinement = model;
    if ((paramRefinement instanceof AttributeRefinement)) {
      paramRefinement = model.eContainer();
    }
    if ((paramRefinement instanceof ParameterRefinement)) {
      final ComponentParameterBase parameter = ((ParameterRefinement)paramRefinement).getParameter();
      if ((parameter instanceof ParameterInstance)) {
        String attributeEntries = "";
        EList<AttributeRefinement> _attributes = ((ParameterInstance)parameter).getAttributes();
        for (final AttributeRefinement attr : _attributes) {
          final Function1<AttributeRefinement, Boolean> _function = (AttributeRefinement it) -> {
            AttributeDefinition _attribute = it.getAttribute();
            AttributeDefinition _attribute_1 = attr.getAttribute();
            return Boolean.valueOf(Objects.equal(_attribute, _attribute_1));
          };
          boolean _exists = IterableExtensions.<AttributeRefinement>exists(((ParameterRefinement)paramRefinement).getAttributes(), _function);
          boolean _not = (!_exists);
          if (_not) {
            String _attributeEntries = attributeEntries;
            String _name = attr.getAttribute().getName();
            String _plus = (_name + " = ");
            String _valueString = this.util.getValueString(attr.getValue());
            String _plus_1 = (_plus + _valueString);
            attributeEntries = (_attributeEntries + _plus_1);
            AttributeRefinement _last = IterableExtensions.<AttributeRefinement>last(((ParameterInstance)parameter).getAttributes());
            boolean _notEquals = (!Objects.equal(attr, _last));
            if (_notEquals) {
              String _attributeEntries_1 = attributeEntries;
              attributeEntries = (_attributeEntries_1 + "\n\t\t\t");
            }
          }
        }
        acceptor.accept(this.createCompletionProposal(attributeEntries, "add all missing attribute entries", this.getImage(paramRefinement), context));
      } else {
        if ((parameter instanceof InternalParameter)) {
          String attributeEntries_1 = "";
          EList<AttributeDefinition> _attributes_1 = ((InternalParameter)parameter).getAttributes();
          for (final AttributeDefinition attr_1 : _attributes_1) {
            final Function1<AttributeRefinement, Boolean> _function_1 = (AttributeRefinement it) -> {
              AttributeDefinition _attribute = it.getAttribute();
              return Boolean.valueOf(Objects.equal(_attribute, attr_1));
            };
            boolean _exists_1 = IterableExtensions.<AttributeRefinement>exists(((ParameterRefinement)paramRefinement).getAttributes(), _function_1);
            boolean _not_1 = (!_exists_1);
            if (_not_1) {
              String _attributeEntries_2 = attributeEntries_1;
              String _name_1 = attr_1.getName();
              String _plus_2 = (_name_1 + " = ");
              attributeEntries_1 = (_attributeEntries_2 + _plus_2);
              AbstractValue _defaultvalue = attr_1.getDefaultvalue();
              boolean _tripleNotEquals = (_defaultvalue != null);
              if (_tripleNotEquals) {
                String _attributeEntries_3 = attributeEntries_1;
                String _valueString_1 = this.util.getValueString(attr_1.getDefaultvalue());
                attributeEntries_1 = (_attributeEntries_3 + _valueString_1);
              } else {
                String _attributeEntries_4 = attributeEntries_1;
                String _get = ((String[])Conversions.unwrapArray(this.util.getDefaultValuesFor(attr_1.getType()), String.class))[0];
                attributeEntries_1 = (_attributeEntries_4 + _get);
              }
              AttributeDefinition _last_1 = IterableExtensions.<AttributeDefinition>last(((InternalParameter)parameter).getAttributes());
              boolean _notEquals_1 = (!Objects.equal(attr_1, _last_1));
              if (_notEquals_1) {
                String _attributeEntries_5 = attributeEntries_1;
                attributeEntries_1 = (_attributeEntries_5 + "\n\t\t\t");
              }
            }
          }
          acceptor.accept(this.createCompletionProposal(attributeEntries_1, "add all missing attribute entries", this.getImage(paramRefinement), context));
        } else {
          if ((parameter instanceof ExtendedParameter)) {
            String attributeEntries_2 = "";
            EList<AttributeDefinition> _attributes_2 = ((ExtendedParameter)parameter).getAttributes();
            for (final AttributeDefinition attr_2 : _attributes_2) {
              final Function1<AttributeRefinement, Boolean> _function_2 = (AttributeRefinement it) -> {
                AttributeDefinition _attribute = it.getAttribute();
                return Boolean.valueOf(Objects.equal(_attribute, attr_2));
              };
              boolean _exists_2 = IterableExtensions.<AttributeRefinement>exists(((ParameterRefinement)paramRefinement).getAttributes(), _function_2);
              boolean _not_2 = (!_exists_2);
              if (_not_2) {
                String _attributeEntries_6 = attributeEntries_2;
                String _name_2 = attr_2.getName();
                String _plus_3 = (_name_2 + " = ");
                attributeEntries_2 = (_attributeEntries_6 + _plus_3);
                AbstractValue _defaultvalue_1 = attr_2.getDefaultvalue();
                boolean _tripleNotEquals_1 = (_defaultvalue_1 != null);
                if (_tripleNotEquals_1) {
                  String _attributeEntries_7 = attributeEntries_2;
                  String _valueString_2 = this.util.getValueString(attr_2.getDefaultvalue());
                  attributeEntries_2 = (_attributeEntries_7 + _valueString_2);
                } else {
                  String _attributeEntries_8 = attributeEntries_2;
                  String _get_1 = ((String[])Conversions.unwrapArray(this.util.getDefaultValuesFor(attr_2.getType()), String.class))[0];
                  attributeEntries_2 = (_attributeEntries_8 + _get_1);
                }
                AttributeDefinition _last_2 = IterableExtensions.<AttributeDefinition>last(((ExtendedParameter)parameter).getAttributes());
                boolean _notEquals_2 = (!Objects.equal(attr_2, _last_2));
                if (_notEquals_2) {
                  String _attributeEntries_9 = attributeEntries_2;
                  attributeEntries_2 = (_attributeEntries_9 + "\n\t\t\t");
                }
              }
            }
            acceptor.accept(this.createCompletionProposal(attributeEntries_2, "add all missing attribute entries", this.getImage(paramRefinement), context));
          }
        }
      }
    }
  }
  
  @Override
  public void completeComponentParameterInstance_ComponentParam(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    if ((model instanceof ComponentParameterInstance)) {
      final ComponentParametersRef componentParams = IterableExtensions.<ComponentParametersRef>head(Iterables.<ComponentParametersRef>filter(((ComponentParameterInstance)model).getComponentInstance().getComponent().getElements(), ComponentParametersRef.class));
      if ((componentParams != null)) {
        final String text = componentParams.getParameter().getName();
        acceptor.accept(this.createCompletionProposal(text, (text + " - ComponentParameter"), this.getImage(componentParams), context));
      }
    }
  }
}
