/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.systemParameter.ui.quickfix;

import org.eclipse.smartmdsd.xtext.base.basicAttributes.ui.quickfix.BasicAttributesQuickfixProvider;
import org.eclipse.smartmdsd.xtext.system.systemParameter.validation.SystemParameterValidator;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

/**
 * Custom quickfixes.
 * 
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#quick-fixes
 */
@SuppressWarnings("all")
public class SystemParameterQuickfixProvider extends BasicAttributesQuickfixProvider {
  @Fix(SystemParameterValidator.INVALID_COMP_PARAM)
  public void fixInvalidComponentParameter(final Issue issue, final IssueResolutionAcceptor acceptor) {
    String _get = issue.getData()[0];
    String _plus = ("Change to " + _get);
    String _get_1 = issue.getData()[0];
    String _plus_1 = ("Change to " + _get_1);
    final IModification _function = (IModificationContext context) -> {
      final IXtextDocument xtextDocument = context.getXtextDocument();
      xtextDocument.replace((issue.getOffset()).intValue(), (issue.getLength()).intValue(), issue.getData()[0]);
    };
    acceptor.accept(issue, _plus, _plus_1, "", _function);
  }
}
