/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.targetPlatform.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smartmdsd.xtext.system.targetPlatform.TargetPlatformRuntimeModule;
import org.eclipse.smartmdsd.xtext.system.targetPlatform.TargetPlatformStandaloneSetup;
import org.eclipse.smartmdsd.xtext.system.targetPlatform.ide.TargetPlatformIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class TargetPlatformIdeSetup extends TargetPlatformStandaloneSetup {
  @Override
  public Injector createInjector() {
    TargetPlatformRuntimeModule _targetPlatformRuntimeModule = new TargetPlatformRuntimeModule();
    TargetPlatformIdeModule _targetPlatformIdeModule = new TargetPlatformIdeModule();
    return Guice.createInjector(Modules2.mixin(_targetPlatformRuntimeModule, _targetPlatformIdeModule));
  }
}
