/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.base.genericDatasheet;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DefaultDatasheetProperties implements Enumerator
{
    HOMEPAGE(0, "Homepage", "Homepage"),
    SPDX_LICENSE(1, "SpdxLicense", "SpdxLicense"),
    PROPRIETARY_LICENSE(2, "ProprietaryLicense", "ProprietaryLicense"),
    PURPOSE(3, "Purpose", "Purpose"),
    TECHNOLOGY_READINESS_LEVEL(5, "TechnologyReadinessLevel", "TechnologyReadinessLevel"),
    SUPPLIER(5, "Supplier", "Supplier");

    public static final int HOMEPAGE_VALUE = 0;
    public static final int SPDX_LICENSE_VALUE = 1;
    public static final int PROPRIETARY_LICENSE_VALUE = 2;
    public static final int PURPOSE_VALUE = 3;
    public static final int TECHNOLOGY_READINESS_LEVEL_VALUE = 5;
    public static final int SUPPLIER_VALUE = 5;
    private static final DefaultDatasheetProperties[] VALUES_ARRAY;
    public static final List<DefaultDatasheetProperties> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DefaultDatasheetProperties[]{HOMEPAGE, SPDX_LICENSE, PROPRIETARY_LICENSE, PURPOSE, TECHNOLOGY_READINESS_LEVEL, SUPPLIER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DefaultDatasheetProperties get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DefaultDatasheetProperties result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DefaultDatasheetProperties getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DefaultDatasheetProperties result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DefaultDatasheetProperties get(int value) {
        switch (value) {
            case 0: {
                return HOMEPAGE;
            }
            case 1: {
                return SPDX_LICENSE;
            }
            case 2: {
                return PROPRIETARY_LICENSE;
            }
            case 3: {
                return PURPOSE;
            }
            case 5: {
                return TECHNOLOGY_READINESS_LEVEL;
            }
        }
        return null;
    }

    private DefaultDatasheetProperties(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

