/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.service.serviceDefinition.validation;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.ParameterPattern;
import org.eclipse.smartmdsd.ecore.service.coordinationPattern.StatePattern;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.AbstractServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CoordinationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefRepository;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionPackage;
import org.eclipse.smartmdsd.xtext.service.serviceDefinition.validation.AbstractServiceDefinitionValidator;
import org.eclipse.xtext.validation.Check;

public class ServiceDefinitionValidator
extends AbstractServiceDefinitionValidator {
    protected static final String ISSUE_PREFIX = "org.xtext.service.serviceDefinition.";
    public static final String MISSING_PARAMETER_PATTERN = "org.xtext.service.serviceDefinition.MissingParameterPattern";
    public static final String MISSING_STATE_PATTERN = "org.xtext.service.serviceDefinition.MissingStatePattern";
    public static final String INVALID_REPO_NAME = "org.xtext.service.serviceDefinition.InvalidRepoName";
    public static final String CAPITAL_SERVICE_NAME = "org.xtext.service.serviceDefinition.CapitalServiceName";

    @Check
    public void checkMissingCoordinationPatterns(CoordinationServiceDefinition service) {
        StatePattern _statePattern;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        ParameterPattern _parameterPattern = service.getParameterPattern();
        boolean bl = _tripleEquals = _parameterPattern == null;
        if (_tripleEquals) {
            this.error("Missing ParameterPattern definition", (EStructuralFeature)ServiceDefinitionPackage.Literals.ABSTRACT_SERVICE_DEFINITION__NAME, MISSING_PARAMETER_PATTERN, new String[0]);
        }
        boolean bl2 = _tripleEquals_1 = (_statePattern = service.getStatePattern()) == null;
        if (_tripleEquals_1) {
            this.error("Missing StatePattern definition", (EStructuralFeature)ServiceDefinitionPackage.Literals.ABSTRACT_SERVICE_DEFINITION__NAME, MISSING_STATE_PATTERN, new String[0]);
        }
    }

    @Check
    public void checkRepositoryNameIsProjectName(ServiceDefRepository repo) {
        URI uri = repo.eResource().getURI();
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            boolean _notEquals;
            String projectName = uri.segment(1);
            String _name = repo.getName();
            boolean bl = _notEquals = !Objects.equal((Object)_name, (Object)projectName);
            if (_notEquals) {
                this.warning("Repository name should match project name.", (EStructuralFeature)ServiceDefinitionPackage.Literals.SERVICE_DEF_REPOSITORY__NAME, INVALID_REPO_NAME, new String[]{projectName});
            }
        }
    }

    @Check
    public void checkServicedDefNameStartsWithCapital(AbstractServiceDefinition service) {
        boolean _not;
        boolean _isUpperCase = Character.isUpperCase(service.getName().charAt(0));
        boolean bl = _not = !_isUpperCase;
        if (_not) {
            this.warning("ServiceDefinition name should start with a capital!", (EStructuralFeature)ServiceDefinitionPackage.Literals.ABSTRACT_SERVICE_DEFINITION__NAME, CAPITAL_SERVICE_NAME, new String[0]);
        }
    }
}

