/**
 * Copyright (c) 2021 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.behavior.taskDefinition;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.behavior.taskDefinition.TaskDefinitionFactory;
import org.eclipse.smartmdsd.ecore.behavior.taskDefinition.TaskDefinitionModel;
import org.eclipse.smartmdsd.ecore.behavior.taskDefinition.TaskDefinitionPackage;
import org.eclipse.smartmdsd.ecore.behavior.taskDefinition.TaskDefinitionRepository;
import org.eclipse.smartmdsd.ui.factories.ISmartMDSDModelFactory;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@SuppressWarnings("all")
public class SmartMDSDTaskDefinitionFactory implements ISmartMDSDModelFactory {
  @Override
  public EPackage getEPackage() {
    return TaskDefinitionPackage.eINSTANCE;
  }
  
  @Override
  public Collection<EPackage> getParentEPackages() {
    return CollectionLiterals.<EPackage>newArrayList();
  }
  
  @Override
  public EObject createDefaultModel(final String projectName, final Collection<EObject> parentModels) {
    final TaskDefinitionModel model = TaskDefinitionFactory.eINSTANCE.createTaskDefinitionModel();
    final TaskDefinitionRepository repo = TaskDefinitionFactory.eINSTANCE.createTaskDefinitionRepository();
    repo.setName(projectName);
    model.setRepository(repo);
    return model;
  }
}
