/**
 * Copyright (c) 2021 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.system.causeEffectChain;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitectureModel;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitecturePackage;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.CauseEffectChainFactory;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.CauseEffectChainPackage;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.CuaseEffectChainModel;
import org.eclipse.smartmdsd.ui.factories.ISmartMDSDModelFactory;

@SuppressWarnings("all")
public class SmartMDSDCauseEffectChainFactory implements ISmartMDSDModelFactory {
  @Override
  public EPackage getEPackage() {
    return CauseEffectChainPackage.eINSTANCE;
  }
  
  @Override
  public Collection<EPackage> getParentEPackages() {
    return Collections.<EPackage>singletonList(ActivityArchitecturePackage.eINSTANCE);
  }
  
  @Override
  public EObject createDefaultModel(final String projectName, final Collection<EObject> parentModels) {
    ActivityArchitectureModel activityArch = null;
    for (final EObject parent : parentModels) {
      if ((parent instanceof ActivityArchitectureModel)) {
        activityArch = ((ActivityArchitectureModel)parent);
      }
    }
    final CuaseEffectChainModel model = CauseEffectChainFactory.eINSTANCE.createCuaseEffectChainModel();
    model.setName(projectName);
    if ((activityArch != null)) {
      model.setActArch(activityArch);
    }
    return model;
  }
}
