/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.system.componentArchitecture.design;

import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstanceExtension;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ParameterStructInstance;
import org.eclipse.smartmdsd.sirius.system.componentArchitecture.design.SystemParameterViewPart;
import org.eclipse.smartmdsd.sirius.utils.xtext.AbstractOpenXtextEditorViewPartAction;
import org.eclipse.smartmdsd.sirius.utils.xtext.AbstractXtextEditorViewPart;

public class OpenSystemParameterEditorAction
extends AbstractOpenXtextEditorViewPartAction {
    public String getViewPartID() {
        return "org.eclipse.smartmdsd.sirius.system.componentArchitecture.design.SystemParamView";
    }

    public String getDefaultModelConent(URI xtextResourceUri) {
        return "SystemParameterModel " + xtextResourceUri.segment(1) + " extendsSystem " + xtextResourceUri.segment(1) + " {\n\n}";
    }

    public boolean checkModelConstraints(DDiagramElement diagramElement) {
        return true;
    }

    protected void updateSemanticModel(DRepresentationElement representationElem, AbstractXtextEditorViewPart xtextViewPart) {
        if (xtextViewPart instanceof SystemParameterViewPart) {
            SystemParameterViewPart paramView = (SystemParameterViewPart)xtextViewPart;
            if (representationElem.getTarget() instanceof ComponentInstance) {
                ComponentInstance componentInstance = (ComponentInstance)representationElem.getTarget();
                boolean hasParameterStruct = false;
                for (ComponentInstanceExtension ext : componentInstance.getExtensions()) {
                    if (!(ext instanceof ParameterStructInstance)) continue;
                    hasParameterStruct = true;
                    break;
                }
                if (hasParameterStruct) {
                    paramView.setSemanticElement(componentInstance);
                }
            }
        }
    }
}

