/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.system.componentArchitecture.design;

import com.google.inject.Injector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AnswerPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionPackage;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestPort;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaReadServer;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.EventPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.PushPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.QueryPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.SendPattern;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ForkingServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.JoiningServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.RequestAnswerServiceDefinition;
import org.eclipse.smartmdsd.ecore.system.compArchSeronetExtension.OpcUaReadServerInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitectureFactory;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitectureModelUtility;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.Connection;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ProvidedService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.RequiredService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ServiceInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ComponentParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParamModel;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterFactory;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterPackage;
import org.eclipse.smartmdsd.sirius.utils.DiagramHelperServices;
import org.eclipse.smartmdsd.xtext.component.componentDefinition.ui.internal.ComponentDefinitionActivator;
import org.eclipse.smartmdsd.xtext.system.systemParameter.ui.internal.SystemParameterActivator;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public class Services {
    public String getProjectName(EObject obj) {
        return DiagramHelperServices.getProjectName((EObject)obj);
    }

    public EObject importModels(EObject context) {
        DiagramHelperServices.triggerModelImportCommand();
        return context;
    }

    public EObject selectOpcUaReadServerPortReference(EObject context) {
        if (context instanceof OpcUaReadServerInstance) {
            OpcUaReadServerInstance readServerInstance = (OpcUaReadServerInstance)context;
            EObject parent = context.eContainer();
            if (parent instanceof ComponentInstance) {
                ComponentInstance compInstance = (ComponentInstance)parent;
                for (EObject element : compInstance.getComponent().getElements()) {
                    if (!(element instanceof OpcUaReadServer)) continue;
                    OpcUaReadServer readServer = (OpcUaReadServer)element;
                    if (!readServerInstance.getReadServer().equals(readServer)) continue;
                    for (ServiceInstance serviceInstance : compInstance.getPorts()) {
                        if (!serviceInstance.getPort().equals(readServer.getOutPort())) continue;
                        return serviceInstance;
                    }
                }
            }
        }
        return null;
    }

    public EObject deleteComponentAndRelatedConnections(EObject context) {
        if (context instanceof ComponentInstance) {
            ComponentInstance componentInstance = (ComponentInstance)context;
            EObject parent = context.eContainer();
            if (parent instanceof SystemComponentArchitecture) {
                SystemComponentArchitecture system = (SystemComponentArchitecture)parent;
                ArrayList<Connection> relatedConnections = new ArrayList<Connection>();
                for (Connection connection : system.getConnections()) {
                    for (ServiceInstance port : componentInstance.getPorts()) {
                        if (port instanceof ProvidedService) {
                            if (!connection.getTo().equals(port)) continue;
                            relatedConnections.add(connection);
                            continue;
                        }
                        if (!connection.getFrom().equals(port)) continue;
                        relatedConnections.add(connection);
                    }
                }
                for (Connection connection : relatedConnections) {
                    EcoreUtil.delete((EObject)connection);
                }
            }
            EcoreUtil.delete((EObject)componentInstance);
        }
        return context;
    }

    public Boolean hasLogo(EObject context) {
        ComponentInstance component;
        if (context instanceof ComponentInstance && (component = (ComponentInstance)context).getComponent() != null && component.getComponent().getLogo() != null) {
            String logoPathString = component.getComponent().getLogo();
            if (!logoPathString.startsWith(System.getProperty("file.separator"))) {
                URI uri = component.getComponent().eResource().getURI();
                logoPathString = uri.trimSegments(1).appendSegment(logoPathString).toPlatformString(true);
            }
            Path logoPath = new Path(logoPathString);
            IFile logoFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)logoPath);
            if (logoFile.exists()) {
                return true;
            }
        }
        return false;
    }

    public String getLogoPath(EObject context) {
        ComponentInstance component;
        if (context instanceof ComponentInstance && (component = (ComponentInstance)context).getComponent() != null && component.getComponent().getLogo() != null) {
            String logoPathString = component.getComponent().getLogo();
            if (!logoPathString.startsWith(System.getProperty("file.separator"))) {
                URI uri = component.getComponent().eResource().getURI();
                logoPathString = uri.trimSegments(1).appendSegment(logoPathString).toPlatformString(true);
            }
            Path logoPath = new Path(logoPathString);
            IFile logoFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)logoPath);
            if (logoFile.exists()) {
                return logoPathString;
            }
        }
        return "";
    }

    public EObject getComponentParameter(EObject obj) {
        if (obj instanceof ComponentInstance) {
            ComponentInstance inst = (ComponentInstance)obj;
            for (AbstractComponentElement compElem : inst.getComponent().getElements()) {
                if (!(compElem instanceof ComponentParametersRef)) continue;
                return ((ComponentParametersRef)compElem).getParameter();
            }
        }
        return null;
    }

    public EObject createAndGetComponentParameterInstance(EObject context) {
        if (context instanceof ComponentInstance) {
            ComponentInstance compInstance = (ComponentInstance)context;
            EObject parent = context.eContainer();
            if (parent instanceof SystemComponentArchitecture) {
                SystemComponentArchitecture system = (SystemComponentArchitecture)parent;
                Injector injector = this.getSystemParameterInjector();
                EClass type = SystemParameterPackage.eINSTANCE.getSystemParamModel();
                Collection<EObject> objects = this.geXtextIndexEObjetcsByType(injector, context, type);
                for (EObject obj : objects) {
                    ComponentParameterInstance paramInstance2;
                    SystemParamModel paramModel;
                    if (!(obj instanceof SystemParamModel) || !(paramModel = (SystemParamModel)obj).getSystem().equals(system)) continue;
                    for (ComponentParameterInstance paramInstance2 : paramModel.getComponents()) {
                        if (!paramInstance2.getComponentInstance().equals(compInstance)) continue;
                        return paramInstance2;
                    }
                    paramInstance2 = SystemParameterFactory.eINSTANCE.createComponentParameterInstance();
                    paramInstance2.setComponentInstance(compInstance);
                    EObject compParam = this.getComponentParameter((EObject)compInstance);
                    if (compParam != null) {
                        paramInstance2.setComponentParam((ComponentParameter)compParam);
                    }
                    paramModel.getComponents().add((Object)paramInstance2);
                    try {
                        paramModel.eResource().save(SaveOptions.defaultOptions().toOptionsMap());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return paramInstance2;
                }
            }
        }
        return null;
    }

    public boolean isForkingConnection(EObject obj) {
        Connection connection;
        ComponentPort service;
        return obj instanceof Connection && (service = (connection = (Connection)obj).getTo().getPort()) instanceof OutputPort;
    }

    public boolean isJoyningService(EObject obj) {
        InputPort port;
        ServiceInstance svcInstance;
        ComponentPort service;
        return obj instanceof ServiceInstance && ((service = (svcInstance = (ServiceInstance)obj).getPort()) instanceof InputPort ? (port = (InputPort)service).getService() instanceof JoiningServiceDefinition : service instanceof OutputPort && (port = (OutputPort)service).getService() instanceof JoiningServiceDefinition);
    }

    public boolean is2WayService(EObject obj) {
        ServiceInstance svcInstance;
        ComponentPort service;
        return obj instanceof ServiceInstance && ((service = (svcInstance = (ServiceInstance)obj).getPort()) instanceof AnswerPort || service instanceof RequestPort);
    }

    public boolean isRequestAnswerConnection(EObject obj) {
        Connection connection;
        ComponentPort service;
        return obj instanceof Connection && (service = (connection = (Connection)obj).getTo().getPort()) instanceof AnswerPort;
    }

    public String getCommObjectName(EObject obj) {
        if (obj instanceof Connection) {
            Connection connection = (Connection)obj;
            ComponentPort service = connection.getTo().getPort();
            if (service instanceof OutputPort) {
                OutputPort port = (OutputPort)service;
                if (port.getService() instanceof ForkingServiceDefinition) {
                    ForkingServiceDefinition sdef = (ForkingServiceDefinition)port.getService();
                    if (sdef.getPattern() instanceof PushPattern) {
                        PushPattern push = (PushPattern)sdef.getPattern();
                        return push.getDataType().getName();
                    }
                    if (sdef.getPattern() instanceof EventPattern) {
                        EventPattern event = (EventPattern)sdef.getPattern();
                        return event.getEventType().getName();
                    }
                }
            } else if (service instanceof InputPort) {
                JoiningServiceDefinition sdef;
                InputPort port = (InputPort)service;
                if (port.getService() instanceof JoiningServiceDefinition && (sdef = (JoiningServiceDefinition)port.getService()).getPattern() instanceof SendPattern) {
                    SendPattern send = (SendPattern)sdef.getPattern();
                    return send.getDataType().getName();
                }
            } else if (service instanceof AnswerPort) {
                AnswerPort port = (AnswerPort)service;
                RequestAnswerServiceDefinition ra = (RequestAnswerServiceDefinition)port.getService();
                QueryPattern query = (QueryPattern)ra.getPattern();
                return "R=" + query.getRequestType().getName() + " / A=" + query.getAnswerType().getName();
            }
        }
        return "";
    }

    public Iterable<ComponentPort> getAllServiceUses(EObject context) {
        if (context instanceof ComponentInstance) {
            ComponentInstance component = (ComponentInstance)context;
            Iterable allPorts = ComponentArchitectureModelUtility.getAllClientPorts((ComponentInstance)component);
            ArrayList<ComponentPort> newPortsOnly = new ArrayList<ComponentPort>();
            for (ComponentPort port : allPorts) {
                boolean portExists = false;
                for (ServiceInstance inst : component.getPorts()) {
                    if (!inst.getPort().equals(port)) continue;
                    portExists = true;
                    break;
                }
                if (portExists) continue;
                newPortsOnly.add(port);
            }
            return newPortsOnly;
        }
        return new ArrayList<ComponentPort>();
    }

    public boolean isCompatibleConnection(EObject left, EObject right) {
        return ComponentArchitectureModelUtility.servicePortsCompatible((ServiceInstance)((ServiceInstance)left), (ServiceInstance)((ServiceInstance)right));
    }

    public Iterable<ComponentPort> getAllServiceRealizations(EObject context) {
        if (context instanceof ComponentInstance) {
            ComponentInstance component = (ComponentInstance)context;
            Iterable allPorts = ComponentArchitectureModelUtility.getAllServerPorts((ComponentInstance)component);
            ArrayList<ComponentPort> newPortsOnly = new ArrayList<ComponentPort>();
            for (ComponentPort port : allPorts) {
                boolean portExists = false;
                for (ServiceInstance inst : component.getPorts()) {
                    if (!inst.getPort().equals(port)) continue;
                    portExists = true;
                    break;
                }
                if (portExists) continue;
                newPortsOnly.add(port);
            }
            return newPortsOnly;
        }
        return new ArrayList<ComponentPort>();
    }

    public EObject instantiateAllComponentPorts(EObject context) {
        if (context instanceof ComponentInstance) {
            RequiredService service;
            ComponentInstance component = (ComponentInstance)context;
            for (ComponentPort port : ComponentArchitectureModelUtility.getAllClientPorts((ComponentInstance)component)) {
                service = ComponentArchitectureFactory.eINSTANCE.createRequiredService();
                service.setPort(port);
                component.getPorts().add((Object)service);
            }
            for (ComponentPort port : ComponentArchitectureModelUtility.getAllServerPorts((ComponentInstance)component)) {
                service = ComponentArchitectureFactory.eINSTANCE.createProvidedService();
                service.setPort(port);
                component.getPorts().add((Object)service);
            }
        }
        return context;
    }

    public Collection<EObject> getAllVisibleComponentDefinitions(EObject context) {
        Injector injector = this.getComponentDefinitionInjector();
        EClass type = ComponentDefinitionPackage.eINSTANCE.getComponentDefinition();
        return this.geXtextIndexEObjetcsByType(injector, context, type);
    }

    private Injector getComponentDefinitionInjector() {
        return ComponentDefinitionActivator.getInstance().getInjector("org.eclipse.smartmdsd.xtext.component.componentDefinition.ComponentDefinition");
    }

    private Injector getSystemParameterInjector() {
        return SystemParameterActivator.getInstance().getInjector("org.eclipse.smartmdsd.xtext.system.systemParameter.SystemParameter");
    }

    private Collection<EObject> geXtextIndexEObjetcsByType(Injector injector, EObject context, EClass type) {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        ResourceDescriptionsProvider rdp = (ResourceDescriptionsProvider)injector.getInstance(ResourceDescriptionsProvider.class);
        IResourceDescriptions descriptions = rdp.getResourceDescriptions(context.eResource());
        IResourceDescription description = descriptions.getResourceDescription(context.eResource().getURI());
        IContainer.Manager manager = (IContainer.Manager)injector.getInstance(IContainer.Manager.class);
        List containters = manager.getVisibleContainers(description, descriptions);
        for (IContainer container : containters) {
            Iterable objectDescriptions = container.getExportedObjectsByType(type);
            for (IEObjectDescription objectDescription : objectDescriptions) {
                EObject serviceRepoProxy = objectDescription.getEObjectOrProxy();
                if (serviceRepoProxy.eIsProxy()) {
                    EObject serviceRepo = context.eResource().getResourceSet().getEObject(objectDescription.getEObjectURI(), true);
                    objects.add(serviceRepo);
                    continue;
                }
                objects.add(serviceRepoProxy);
            }
        }
        return objects;
    }
}

