/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.sirius.system.componentArchitecture.design;

import com.google.inject.Injector;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameter;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstanceExtension;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ComponentParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ParameterStructInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParamModel;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterFactory;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterPackage;
import org.eclipse.smartmdsd.sirius.utils.xtext.AbstractXtextEditorViewPart;
import org.eclipse.smartmdsd.xtext.system.systemParameter.ui.internal.SystemParameterActivator;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class SystemParameterViewPart
extends AbstractXtextEditorViewPart {
    public Injector getInjector() {
        return SystemParameterActivator.getInstance().getInjector("org.eclipse.smartmdsd.xtext.system.systemParameter.SystemParameter");
    }

    protected ISelectionListener createNewSelectionListener() {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof DDiagramEditor) {
                    DDiagramEditor dEditor = (DDiagramEditor)part;
                    Session session = dEditor.getSession();
                    for (DView view : session.getOwnedViews()) {
                        if (!view.getViewpoint().getName().equals("SystemArchitectureViewpoint") || !(selection instanceof IStructuredSelection)) continue;
                        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                        Object object = structuredSelection.getFirstElement();
                        if (object instanceof IDiagramElementEditPart) {
                            IDiagramElementEditPart diagramElementEditPart = (IDiagramElementEditPart)object;
                            EObject modelObject = diagramElementEditPart.resolveTargetSemanticElement();
                            if (modelObject instanceof ParameterStructInstance) {
                                modelObject = modelObject.eContainer();
                            }
                            if (!(modelObject instanceof ComponentInstance)) continue;
                            ComponentInstance componentInstance = (ComponentInstance)modelObject;
                            boolean hasParameterStruct = false;
                            for (ComponentInstanceExtension ext : componentInstance.getExtensions()) {
                                if (!(ext instanceof ParameterStructInstance)) continue;
                                hasParameterStruct = true;
                                break;
                            }
                            if (!hasParameterStruct) continue;
                            if (!SystemParameterViewPart.this.getResourceProvider().isCurrentSession(session)) {
                                URI diagramUri = modelObject.eResource().getURI();
                                String modelFileExtension = SystemParameterViewPart.this.getModelFileExtension();
                                URI xtextResourceUri = diagramUri.trimFileExtension().appendFileExtension(modelFileExtension);
                                SystemParameterViewPart.this.setExternalEmfBase((DRepresentationElement)diagramElementEditPart.resolveDiagramElement(), xtextResourceUri);
                            }
                            SystemParameterViewPart.this.setSemanticElement(componentInstance);
                            return;
                        }
                        if (!SystemParameterViewPart.this.getResourceProvider().isCurrentSession(session)) continue;
                        SystemParameterViewPart.this.getResourceProvider().setEditableTextRegion(0, 0);
                        SystemParameterViewPart.this.reloadCurrentModelText();
                        SystemParameterViewPart.this.showEmbeddedEditor();
                        return;
                    }
                }
                SystemParameterViewPart.this.hideEmbeddedEditor();
            }
        };
    }

    public void setSemanticElement(ComponentInstance componentInstance) {
        ICompositeNode rootNode = this.getResourceProvider().getCurrentRootNode();
        if (rootNode != null) {
            for (INode childNode : rootNode.getChildren()) {
                ComponentParameterInstance sysParamUsage;
                CompositeNodeWithSemanticElement semanticNode;
                EObject semanticElement;
                if (!(childNode instanceof CompositeNodeWithSemanticElement) || !((semanticElement = (semanticNode = (CompositeNodeWithSemanticElement)childNode).getSemanticElement()) instanceof ComponentParameterInstance) || !(sysParamUsage = (ComponentParameterInstance)semanticElement).getComponentInstance().getName().equals(componentInstance.getName())) continue;
                this.getResourceProvider().setEditableTextRegion(childNode.getOffset(), childNode.getEndOffset());
                this.reloadCurrentModelText();
                this.showEmbeddedEditor();
                break;
            }
        }
    }

    public void createRefinedParamNode(ComponentInstance componentInstance) {
        boolean hasParameterStruct = false;
        String paramStructName = "";
        for (ComponentInstanceExtension ext : componentInstance.getExtensions()) {
            if (!(ext instanceof ParameterStructInstance)) continue;
            hasParameterStruct = true;
            ParameterStructInstance par = (ParameterStructInstance)ext;
            paramStructName = par.getName();
            break;
        }
        if (!hasParameterStruct) {
            return;
        }
        URI diagramUri = componentInstance.eResource().getURI();
        String modelFileExtension = this.getModelFileExtension();
        URI xtextResourceUri = diagramUri.trimFileExtension().appendFileExtension(modelFileExtension);
        String projectName = xtextResourceUri.segment(1);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            Injector injector = this.getInjector();
            XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
            resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
            Resource resource = resourceSet.getResource(xtextResourceUri, true);
            EObject model = (EObject)resource.getContents().get(0);
            if (model instanceof SystemParamModel) {
                SystemParamModel sysParamModel = (SystemParamModel)model;
                boolean foundParamEntry = false;
                for (ComponentParameterInstance compRef : sysParamModel.getComponents()) {
                    if (!compRef.getComponentInstance().getName().equals(componentInstance.getName())) continue;
                    foundParamEntry = true;
                    break;
                }
                if (!foundParamEntry) {
                    EObject eObject;
                    IEObjectDescription description;
                    ComponentParameterInstance newCompRef = SystemParameterFactory.eINSTANCE.createComponentParameterInstance();
                    newCompRef.setComponentInstance(componentInstance);
                    IScopeProvider scopeProvider = (IScopeProvider)injector.getInstance(IScopeProvider.class);
                    IScope scope = scopeProvider.getScope((EObject)componentInstance, SystemParameterPackage.Literals.COMPONENT_PARAMETER_INSTANCE__COMPONENT_PARAM);
                    String parameterName = paramStructName;
                    if (scope != IScope.NULLSCOPE && (description = scope.getSingleElement(QualifiedName.create((String)parameterName))) != null && (eObject = description.getEObjectOrProxy()) instanceof ComponentParameter) {
                        ComponentParameter paramStruct = (ComponentParameter)eObject;
                        newCompRef.setComponentParam(paramStruct);
                        sysParamModel.getComponents().add((Object)newCompRef);
                        try {
                            resource.save(SaveOptions.defaultOptions().toOptionsMap());
                            this.getResourceProvider().reloadExternalResource(xtextResourceUri);
                            this.reloadCurrentModelText();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

