/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import com.google.common.base.Objects;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaClient;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaClientImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaObjectInterface;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaObjectInterfaceImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaServer;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaServerImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;
import org.eclipse.smartmdsd.xtend.open62541.compiler.SpecificModelViewController;
import org.eclipse.smartmdsd.xtend.open62541.compiler.SpecificModelViewControllerImpl;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class OpcUaXmlCompilerMain {
    public static void main(String[] args) {
        int _equals_2;
        int _equals_1;
        boolean _lessThan;
        SimpleDateFormat _simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        Date _date = new Date();
        String TimeStamp = _simpleDateFormat.format(_date);
        int _size = ((List)Conversions.doWrapArray((Object)args)).size();
        boolean bl = _lessThan = _size < 1;
        if (_lessThan) {
            System.err.println("TIMESTAMP: " + TimeStamp);
            System.err.println("ERROR: no XML file specified");
            System.err.println("Arguments: <XML-File> ( [ALL] | ([SERVER] [CLIENT] [MVC]) ) (USE_TS)");
            return;
        }
        String _get = args[0];
        File xmlFile = new File(_get);
        boolean generateServer = false;
        boolean generateClient = false;
        boolean generateMVC = false;
        boolean useTimeStamp = false;
        String TAG = args[0].replace(".xml", "");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _notEquals;
            String arg = stringArray[n2];
            Object _head = IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)args)));
            boolean bl2 = _notEquals = !Objects.equal((Object)arg, (Object)_head);
            if (_notEquals) {
                boolean _equals = arg.equals("ALL");
                if (_equals) {
                    generateServer = true;
                    generateClient = true;
                    generateMVC = true;
                } else {
                    _equals_1 = arg.equals("SERVER");
                    if (_equals_1 != 0) {
                        generateServer = true;
                    } else {
                        _equals_2 = arg.equals("CLIENT");
                        if (_equals_2 != 0) {
                            generateClient = true;
                        } else {
                            boolean _equals_3 = arg.equals("MVC");
                            if (_equals_3) {
                                generateServer = true;
                                generateMVC = true;
                            } else {
                                boolean _equals_4 = arg.equals("USE_TS");
                                if (_equals_4) {
                                    useTimeStamp = true;
                                }
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        String TargetOutputPath = "output_" + TAG;
        if (useTimeStamp) {
            TargetOutputPath = String.valueOf(TargetOutputPath) + "_" + TimeStamp;
        }
        TargetOutputPath = String.valueOf(TargetOutputPath) + "/src-gen";
        JavaIoFileSystemAccess fsa = new JavaIoFileSystemAccess();
        String _replace = TargetOutputPath.replace("/src-gen", "");
        String _plus = "Output path set to: " + _replace;
        InputOutput.println((Object)_plus);
        fsa.setOutputPath(TargetOutputPath);
        File outDir = new File(TargetOutputPath);
        if (outDir.exists() && outDir.isDirectory()) {
            File[] _listFiles;
            InputOutput.println((Object)("Cleanup Directory: " + TargetOutputPath));
            File[] _equals_3 = _listFiles = outDir.listFiles();
            _equals_2 = _listFiles.length;
            _equals_1 = 0;
            while (_equals_1 < _equals_2) {
                File f = _equals_3[_equals_1];
                boolean _isDirectory = f.isDirectory();
                if (_isDirectory) {
                    File[] _listFiles_1;
                    File[] fileArray = _listFiles_1 = f.listFiles();
                    int n3 = _listFiles_1.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        boolean _not;
                        File f2 = fileArray[n4];
                        boolean _isDirectory_1 = f2.isDirectory();
                        boolean bl3 = _not = !_isDirectory_1;
                        if (_not) {
                            f2.delete();
                        }
                        ++n4;
                    }
                } else {
                    f.delete();
                }
                ++_equals_1;
            }
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().bind(OpcUaObjectInterface.class).to(OpcUaObjectInterfaceImpl.class);
                this.binder().bind(OpcUaServer.class).to(OpcUaServerImpl.class);
                this.binder().bind(OpcUaClient.class).to(OpcUaClientImpl.class);
                this.binder().bind(SpecificModelViewController.class).to(SpecificModelViewControllerImpl.class);
                this.binder().bind(IEncodingProvider.class).to(IEncodingProvider.Runtime.class);
            }
        }});
        injector.injectMembers((Object)fsa);
        OpcUaXmlParser parser = new OpcUaXmlParser();
        String objectName = parser.getObjectName(xmlFile);
        Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList = parser.getEntityList(xmlFile);
        Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList = parser.getMethodList(xmlFile);
        OpcUaObjectInterface interfaceGenerator = (OpcUaObjectInterface)injector.getInstance(OpcUaObjectInterface.class);
        fsa.generateFile(interfaceGenerator.getOpcUaDevice_Interface_HeaderFileName(objectName), interfaceGenerator.compileOpcUaDevice_Interface_HeaderFileContent(objectName, entityList, methodList));
        if (generateServer) {
            OpcUaServer serverGenerator = (OpcUaServer)injector.getInstance(OpcUaServer.class);
            String _opcUaDevice_Server_HeaderFileName = serverGenerator.getOpcUaDevice_Server_HeaderFileName(objectName);
            String _plus_1 = "server/" + _opcUaDevice_Server_HeaderFileName;
            fsa.generateFile(_plus_1, serverGenerator.compileOpcUaDevice_Server_HeaderFileContent(objectName, entityList, methodList));
            String _opcUaDevice_Server_SourceFileName = serverGenerator.getOpcUaDevice_Server_SourceFileName(objectName);
            String _plus_2 = "server/" + _opcUaDevice_Server_SourceFileName;
            fsa.generateFile(_plus_2, serverGenerator.compileOpcUaDevice_Server_SourceFileContent(objectName, entityList, methodList));
        }
        if (generateClient) {
            OpcUaClient clientGenerator = (OpcUaClient)injector.getInstance(OpcUaClient.class);
            String _opcUa_DeviceClient_HeaderFileName = clientGenerator.getOpcUa_DeviceClient_HeaderFileName(objectName);
            String _plus_3 = "client/" + _opcUa_DeviceClient_HeaderFileName;
            fsa.generateFile(_plus_3, clientGenerator.compileOpcUa_DeviceClient_HeaderFileContent(objectName, entityList, methodList));
            String _opcUa_DeviceClient_SourceFileName = clientGenerator.getOpcUa_DeviceClient_SourceFileName(objectName);
            String _plus_4 = "client/" + _opcUa_DeviceClient_SourceFileName;
            fsa.generateFile(_plus_4, clientGenerator.compileOpcUa_DeviceClient_SourceFileContent(objectName, entityList, methodList));
            String _opcUa_DeviceClient_TestMain_SourceFileName = clientGenerator.getOpcUa_DeviceClient_TestMain_SourceFileName(objectName);
            String _plus_5 = "client/" + _opcUa_DeviceClient_TestMain_SourceFileName;
            fsa.generateFile(_plus_5, clientGenerator.compileOpcUa_DeviceClient_TestMain_SourceFileContent(objectName, entityList, methodList));
            fsa.generateFile("client/CMakeLists.txt", clientGenerator.compileOpcUa_DeviceClient_Test_CMakeListsContent(objectName));
        }
        if (generateMVC) {
            SpecificModelViewController mvcGenerator = (SpecificModelViewController)injector.getInstance(SpecificModelViewController.class);
            String _specificDriverModelHeader = mvcGenerator.getSpecificDriverModelHeader(objectName);
            String _plus_6 = "server/" + _specificDriverModelHeader;
            fsa.generateFile(_plus_6, mvcGenerator.compileSpecificDriverModelHeader(objectName));
            String _specificViewHeader = mvcGenerator.getSpecificViewHeader(objectName);
            String _plus_7 = "server/" + _specificViewHeader;
            fsa.generateFile(_plus_7, mvcGenerator.compileSpecificViewHeader(objectName));
            String _specificViewSource = mvcGenerator.getSpecificViewSource(objectName);
            String _plus_8 = "server/" + _specificViewSource;
            fsa.generateFile(_plus_8, mvcGenerator.compileSpecificViewSource(objectName));
            String _specificControllerHeader = mvcGenerator.getSpecificControllerHeader(objectName);
            String _plus_9 = "server/" + _specificControllerHeader;
            fsa.generateFile(_plus_9, mvcGenerator.compileSpecificControllerHeader(objectName, entityList, methodList));
            String _specificControllerSource = mvcGenerator.getSpecificControllerSource(objectName);
            String _plus_10 = "server/" + _specificControllerSource;
            fsa.generateFile(_plus_10, mvcGenerator.compileSpecificControllerSource(objectName, entityList, methodList));
            String _specificTestServer = mvcGenerator.getSpecificTestServer(objectName);
            String _plus_11 = "server/" + _specificTestServer;
            fsa.generateFile(_plus_11, mvcGenerator.compileSpecificTestServer(objectName));
            fsa.generateFile("server/CMakeLists.txt", mvcGenerator.compileSpecificCMakeLists(objectName));
        }
        fsa.generateFile("CMakeLists.txt", OpcUaXmlCompilerMain.compileSrcGenCMakeLists(generateServer, generateClient));
        fsa.generateFile("../CMakeLists.txt", OpcUaXmlCompilerMain.compileTopLevelCMakeLists());
    }

    public static CharSequence compileSrcGenCMakeLists(boolean hasServer, boolean hasClient) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.5)");
        _builder.newLine();
        _builder.newLine();
        if (hasServer) {
            _builder.append("# compile the test server");
            _builder.newLine();
            _builder.append("ADD_SUBDIRECTORY(server)");
            _builder.newLine();
        }
        if (hasClient) {
            _builder.append("# compile the test client");
            _builder.newLine();
            _builder.append("ADD_SUBDIRECTORY(client)");
            _builder.newLine();
        }
        return _builder;
    }

    public static CharSequence compileTopLevelCMakeLists() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.5)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("ADD_SUBDIRECTORY(src-gen)");
        _builder.newLine();
        return _builder;
    }
}

