/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.extensions;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaDeviceClient;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaReadServer;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaDeviceClient;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaStatusServer;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGeneratorExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PlainOpcUaComponentGeneratorExtensionImpl
implements ComponentGeneratorExtension {
    @Inject
    @Extension
    private PlainOpcUaDeviceClient _plainOpcUaDeviceClient;
    @Inject
    @Extension
    private PlainOpcUaStatusServer _plainOpcUaStatusServer;

    public String getExtensionName(ComponentDefinition component) {
        String _name = component.getName();
        String _plus = "PlainOpcUa" + _name;
        return String.valueOf(_plus) + "Extension";
    }

    public CharSequence getHeaderIncludes(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// include plain OPC UA device clients");
        _builder.newLine();
        Iterable _filter = Iterables.filter((Iterable)component.getElements(), OpcUaDeviceClient.class);
        for (OpcUaDeviceClient opcDeviceClient : _filter) {
            _builder.append("#include \"");
            String _opcUaDeviceClientHeader = this._plainOpcUaDeviceClient.getOpcUaDeviceClientHeader(opcDeviceClient);
            _builder.append(_opcUaDeviceClientHeader);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("// include plain OPC UA status servers");
        _builder.newLine();
        Iterable _filter_1 = Iterables.filter((Iterable)component.getElements(), OpcUaReadServer.class);
        for (OpcUaReadServer opcStatusServer : _filter_1) {
            _builder.append("#include \"");
            String _serverControllerHeaderFileName = this._plainOpcUaStatusServer.getServerControllerHeaderFileName(opcStatusServer);
            _builder.append(_serverControllerHeaderFileName);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence getSourceIncludes(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence getClassMemberDefinition(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)component.getElements(), OpcUaDeviceClient.class);
        for (OpcUaDeviceClient opcDeviceClient : _filter) {
            _builder.append("OPCUA::");
            String _firstUpper = StringExtensions.toFirstUpper((String)opcDeviceClient.getName());
            _builder.append(_firstUpper);
            _builder.append(" *");
            String _firstLower = StringExtensions.toFirstLower((String)opcDeviceClient.getName());
            _builder.append(_firstLower);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        Iterable _filter_1 = Iterables.filter((Iterable)component.getElements(), OpcUaReadServer.class);
        for (OpcUaReadServer opcStatusServer : _filter_1) {
            _builder.append("OPCUA::");
            String _className = this._plainOpcUaStatusServer.getClassName(opcStatusServer);
            _builder.append(_className);
            _builder.append(" *");
            String _firstLower_1 = StringExtensions.toFirstLower((String)opcStatusServer.getName());
            _builder.append(_firstLower_1);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence getIniStructDefinition(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)component.getElements(), OpcUaDeviceClient.class);
        for (OpcUaDeviceClient client : _filter) {
            _builder.append("struct ");
            String _firstUpper = StringExtensions.toFirstUpper((String)client.getName());
            _builder.append(_firstUpper);
            _builder.append("_struct {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("bool autoConnect;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("std::string deviceURI;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("std::string rootObjectPath;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("std::string opcuaXmlFile;");
            _builder.newLine();
            _builder.append("} ");
            String _firstLower = StringExtensions.toFirstLower((String)client.getName());
            _builder.append(_firstLower);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getLoadParameters(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)component.getElements(), OpcUaDeviceClient.class);
        for (OpcUaDeviceClient client : _filter) {
            _builder.append("// load parameteters for OpcUaDeviceClient ");
            String _name = client.getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            _builder.append("if(parameter.checkIfParameterExists(\"");
            String _name_1 = client.getName();
            _builder.append(_name_1);
            _builder.append("\", \"autoConnect\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("parameter.getBoolean(\"");
            String _name_2 = client.getName();
            _builder.append(_name_2, "\t");
            _builder.append("\", \"autoConnect\", connections.");
            String _firstLower = StringExtensions.toFirstLower((String)client.getName());
            _builder.append(_firstLower, "\t");
            _builder.append(".autoConnect);");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.append("if(parameter.checkIfParameterExists(\"");
            String _name_3 = client.getName();
            _builder.append(_name_3);
            _builder.append("\", \"rootObjectPath\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("parameter.getString(\"");
            String _name_4 = client.getName();
            _builder.append(_name_4, "\t");
            _builder.append("\", \"rootObjectPath\", connections.");
            String _firstLower_1 = StringExtensions.toFirstLower((String)client.getName());
            _builder.append(_firstLower_1, "\t");
            _builder.append(".rootObjectPath);");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.append("if(parameter.checkIfParameterExists(\"");
            String _name_5 = client.getName();
            _builder.append(_name_5);
            _builder.append("\", \"deviceURI\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("parameter.getString(\"");
            String _name_6 = client.getName();
            _builder.append(_name_6, "\t");
            _builder.append("\", \"deviceURI\", connections.");
            String _firstLower_2 = StringExtensions.toFirstLower((String)client.getName());
            _builder.append(_firstLower_2, "\t");
            _builder.append(".deviceURI);");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.append("if(parameter.checkIfParameterExists(\"");
            String _name_7 = client.getName();
            _builder.append(_name_7);
            _builder.append("\", \"opcuaXmlFile\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("parameter.getString(\"");
            String _name_8 = client.getName();
            _builder.append(_name_8, "\t");
            _builder.append("\", \"opcuaXmlFile\", connections.");
            String _firstLower_3 = StringExtensions.toFirstLower((String)client.getName());
            _builder.append(_firstLower_3, "\t");
            _builder.append(".opcuaXmlFile);");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getIniFileParameters(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)component.getElements(), OpcUaDeviceClient.class);
        for (OpcUaDeviceClient client : _filter) {
            _builder.append("[");
            String _name = client.getName();
            _builder.append(_name);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            _builder.append("autoConnect ");
            boolean _isAutoConnect = client.isAutoConnect();
            _builder.append((Object)_isAutoConnect);
            _builder.newLineIfNotEmpty();
            _builder.append("deviceURI ");
            String _deviceURI = client.getDeviceURI();
            _builder.append(_deviceURI);
            _builder.newLineIfNotEmpty();
            _builder.append("rootObjectPath ");
            String _rootObjectPath = client.getRootObjectPath();
            _builder.append(_rootObjectPath);
            _builder.newLineIfNotEmpty();
            _builder.append("opcuaXmlFile ");
            String _opcuaXmlFile = client.getOpcuaXmlFile();
            _builder.append(_opcuaXmlFile);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.newLine();
        Iterable _filter_1 = Iterables.filter((Iterable)component.getElements(), OpcUaReadServer.class);
        for (OpcUaReadServer server : _filter_1) {
            _builder.append("[");
            String _name_1 = server.getName();
            _builder.append(_name_1);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            _builder.append("portNumber ");
            int _portNumber = server.getPortNumber();
            _builder.append((Object)_portNumber);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getCMakeIncludes(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("GET_FILENAME_COMPONENT(PlainOPCUA_DIR \"${PROJECT_SOURCE_DIR}/../plainOpcUa\" REALPATH)");
        _builder.newLine();
        _builder.append("IF(EXISTS ${PlainOPCUA_DIR})");
        _builder.newLine();
        _builder.append("INCLUDE(\"${PlainOPCUA_DIR}/src-gen/");
        String _name = component.getName();
        _builder.append(_name);
        _builder.append("PlainOpcUa.cmake\")");
        _builder.newLineIfNotEmpty();
        _builder.append("LIST(APPEND FURTHER_SRCS ${PLAIN_OPCUA_SRCS})");
        _builder.newLine();
        _builder.append("ENDIF(EXISTS ${PlainOPCUA_DIR})");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence getCMakeTargetConfiguration(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("IF(Open62541CppWrapper_FOUND)");
        _builder.newLine();
        _builder.append("TARGET_LINK_LIBRARIES(${PROJECT_NAME} Open62541CppWrapper)");
        _builder.newLine();
        _builder.append("TARGET_COMPILE_DEFINITIONS(${PROJECT_NAME} PUBLIC HAS_OPCUA)");
        _builder.newLine();
        _builder.append("ENDIF(Open62541CppWrapper_FOUND)");
        _builder.newLine();
        return _builder;
    }
}

