/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component.docu;

import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class HtmlTableHelpers {
  public CharSequence getTableBegin() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<table style=\"border-collapse:collapse;\">");
    return _builder;
  }
  
  public CharSequence getTableEnd() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("</table>");
    return _builder;
  }
  
  public CharSequence getAsTableCaption(final String text) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<caption><i>Table:</i> ");
    _builder.append(text);
    _builder.append("</caption>");
    return _builder;
  }
  
  public CharSequence getTableHeaderBegin() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<tr style=\"background-color:#ccc;\">");
    return _builder;
  }
  
  public CharSequence getTableHeaderEnd() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("</tr>");
    return _builder;
  }
  
  public CharSequence getAsTableHeaderCell(final String text) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<th style=\"border:1px solid black; padding: 5px;\"><i>");
    _builder.append(text);
    _builder.append("</i></th>");
    return _builder;
  }
  
  public CharSequence getAsTableCell(final String text) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<td style=\"border:1px solid black; padding: 5px;\">");
    _builder.append(text);
    _builder.append("</td>");
    return _builder;
  }
  
  public CharSequence getEmptyTableCell() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<td style=\"border:1px solid black; padding: 5px;\"></td>");
    return _builder;
  }
}
