/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputHandler;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.PublicOperationMode;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.ActivationConstraints;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultInputTrigger;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultPeriodicTimer;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultTrigger;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGeneratorExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SmartIniParameter {
    @Inject
    @Extension
    private ComponentGenHelpers _componentGenHelpers;
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;

    public CharSequence iniParametersConstructor(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// set default ini parameter values");
        _builder.newLine();
        _builder.append("connections.component.name = \"");
        String _name = component.getName();
        _builder.append(_name);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("connections.component.initialComponentMode = \"");
        String _initialComponentMode = this.getInitialComponentMode(component);
        _builder.append(_initialComponentMode);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("connections.component.defaultScheduler = \"DEFAULT\";");
        _builder.newLine();
        _builder.append("connections.component.useLogger = false;");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy(this._componentGenHelpers.getAllServerPorts(component), (Functions.Function1)_function);
        for (ComponentPort server : _sortBy) {
            _builder.append("connections.");
            String _nameInstance = this._componentGenHelpers.nameInstance((AbstractComponentElement)server);
            _builder.append(_nameInstance);
            _builder.append(".serviceName = \"");
            String _nameOriginal = this._componentGenHelpers.nameOriginal((AbstractComponentElement)server);
            _builder.append(_nameOriginal);
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("connections.");
            String _nameInstance_1 = this._componentGenHelpers.nameInstance((AbstractComponentElement)server);
            _builder.append(_nameInstance_1);
            _builder.append(".roboticMiddleware = \"");
            String _defaultMiddlewareString = this._componentGenHelpers.getDefaultMiddlewareString(server);
            _builder.append(_defaultMiddlewareString);
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy(this._componentGenHelpers.getAllClientPorts(component), (Functions.Function1)_function_1);
        for (ComponentPort client : _sortBy_1) {
            boolean _isOptional = this.isOptional(client);
            if (_isOptional) {
                _builder.append("connections.");
                String _nameInstance_2 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
                _builder.append(_nameInstance_2);
                _builder.append(".initialConnect = false;");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("connections.");
            String _nameInstance_3 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
            _builder.append(_nameInstance_3);
            _builder.append(".wiringName = \"");
            String _name_1 = client.getName();
            _builder.append(_name_1);
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("connections.");
            String _nameInstance_4 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
            _builder.append(_nameInstance_4);
            _builder.append(".serverName = \"unknown\";");
            _builder.newLineIfNotEmpty();
            _builder.append("connections.");
            String _nameInstance_5 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
            _builder.append(_nameInstance_5);
            _builder.append(".serviceName = \"unknown\";");
            _builder.newLineIfNotEmpty();
            _builder.append("connections.");
            String _nameInstance_6 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
            _builder.append(_nameInstance_6);
            _builder.append(".interval = 1;");
            _builder.newLineIfNotEmpty();
            _builder.append("connections.");
            String _nameInstance_7 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
            _builder.append(_nameInstance_7);
            _builder.append(".roboticMiddleware = \"");
            String _defaultMiddlewareString_1 = this._componentGenHelpers.getDefaultMiddlewareString(client);
            _builder.append(_defaultMiddlewareString_1);
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1 _function_2 = e -> e.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)ComponentDefinitionModelUtility.getActivities((ComponentDefinition)component), Activity.class), (Functions.Function1)_function_2);
        for (Activity task : _sortBy_2) {
            boolean _not;
            Functions.Function1 _function_3 = it -> {
                boolean _isConfigurable = it.isConfigurable();
                return !_isConfigurable;
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)task.getExtensions(), ActivationConstraints.class), (Functions.Function1)_function_3);
            boolean bl = _not = !_exists;
            if (_not) {
                _builder.append("connections.");
                String _nameInstance_8 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_8);
                _builder.append(".minActFreq = ");
                Double _minActFreq = this._componentGenHelpers.getMinActFreq(task);
                _builder.append((Object)_minActFreq);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("connections.");
                String _nameInstance_9 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_9);
                _builder.append(".maxActFreq = ");
                Double _maxActFreq = this._componentGenHelpers.getMaxActFreq(task);
                _builder.append((Object)_maxActFreq);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            Iterable _filter = Iterables.filter((Iterable)task.getExtensions(), DefaultTrigger.class);
            for (DefaultTrigger trigger : _filter) {
                if (trigger instanceof DefaultPeriodicTimer) {
                    _builder.append("connections.");
                    String _nameInstance_10 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                    _builder.append(_nameInstance_10);
                    _builder.append(".trigger = \"PeriodicTimer\";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("connections.");
                    String _nameInstance_11 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                    _builder.append(_nameInstance_11);
                    _builder.append(".periodicActFreq = ");
                    double _periodicActFreq = ((DefaultPeriodicTimer)trigger).getPeriodicActFreq();
                    _builder.append((Object)_periodicActFreq);
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                if (!(trigger instanceof DefaultInputTrigger)) continue;
                _builder.append("connections.");
                String _nameInstance_12 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_12);
                _builder.append(".trigger = \"DataTriggered\";");
                _builder.newLineIfNotEmpty();
                _builder.append("connections.");
                String _nameInstance_13 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_13);
                _builder.append(".inPortRef = \"");
                String _name_2 = ((DefaultInputTrigger)trigger).getInputLink().getInputPort().getName();
                _builder.append(_name_2);
                _builder.append("\";\t");
                _builder.newLineIfNotEmpty();
                _builder.append("connections.");
                String _nameInstance_14 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_14);
                _builder.append(".prescale = ");
                int _prescale = ((DefaultInputTrigger)trigger).getPrescale();
                _builder.append((Object)_prescale);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("// scheduling default parameters");
            _builder.newLine();
            _builder.append("connections.");
            String _nameInstance_15 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
            _builder.append(_nameInstance_15);
            _builder.append(".scheduler = \"DEFAULT\";");
            _builder.newLineIfNotEmpty();
            _builder.append("connections.");
            String _nameInstance_16 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
            _builder.append(_nameInstance_16);
            _builder.append(".priority = -1;");
            _builder.newLineIfNotEmpty();
            _builder.append("connections.");
            String _nameInstance_17 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
            _builder.append(_nameInstance_17);
            _builder.append(".cpuAffinity = -1;");
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1 _function_4 = it -> it.getName();
        List _sortBy_3 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputHandlers((ComponentDefinition)component), (Functions.Function1)_function_4);
        for (InputHandler handler : _sortBy_3) {
            _builder.append("connections.");
            String _nameInstance_18 = this._componentGenHelpers.nameInstance((AbstractComponentElement)handler);
            _builder.append(_nameInstance_18);
            _builder.append(".prescale = 1;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Functions.Function1 _function_5 = it -> it.getExtensionName(component);
        List _sortBy_4 = IterableExtensions.sortBy(this._componentGenHelpers.getComponentGeneratorExtensions(), (Functions.Function1)_function_5);
        for (ComponentGeneratorExtension ext : _sortBy_4) {
            _builder.append("// initialize members of ");
            String _extensionName = ext.getExtensionName(component);
            _builder.append(_extensionName);
            _builder.newLineIfNotEmpty();
            CharSequence _classMemberConstruction = ext.getClassMemberConstruction(component);
            _builder.append((Object)_classMemberConstruction);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence loadParameterImplementation(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        String _name = component.getName();
        _builder.append(_name);
        _builder.append("::loadParameter(int argc, char *argv[])");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("Parameters can be specified via command line --filename=<filename> or -f <filename>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("With this parameter present:");
        _builder.newLine();
        _builder.append("\t   ");
        _builder.append("- The component will look for the file in the current working directory,");
        _builder.newLine();
        _builder.append("\t     ");
        _builder.append("a path relative to the current directory or any absolute path");
        _builder.newLine();
        _builder.append("\t   ");
        _builder.append("- The component will use the default values if the file cannot be found");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("With this parameter absent:");
        _builder.newLine();
        _builder.append("\t   ");
        _builder.append("- <Name of Component>.ini will be read from current working directory, if found there");
        _builder.newLine();
        _builder.append("\t   ");
        _builder.append("- $SMART_ROOT/etc/<Name of Component>.ini will be read otherwise");
        _builder.newLine();
        _builder.append("\t   ");
        _builder.append("- Default values will be used if neither found in working directory or /etc");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SmartACE::SmartIniParameter parameter;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::ifstream parameterfile;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bool parameterFileFound = false;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// load parameters");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// if paramfile is given as argument");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(parameter.tryAddFileFromArgs(argc,argv,\"filename\", 'f'))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("parameterFileFound = true;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("std::cout << \"parameter file is loaded from an argv argument \\n\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else if(parameter.searchFile(\"");
        String _name_1 = component.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append(".ini\", parameterfile)) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("parameterFileFound = true;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("std::cout << \"load ");
        String _name_2 = component.getName();
        _builder.append(_name_2, "\t\t\t");
        _builder.append(".ini parameter file\\n\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("parameter.addFile(parameterfile);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("std::cout << \"WARNING: ");
        String _name_3 = component.getName();
        _builder.append(_name_3, "\t\t\t");
        _builder.append(".ini parameter file not found! (using default values or command line arguments)\\n\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// add command line arguments to allow overwriting of parameters");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// from file");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("parameter.addCommandLineArgs(argc,argv,\"component\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// initialize the naming service using the command line parameters parsed in the");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// SmartIniParameter class. The naming service parameters are expected to be in");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// the \"component\" parameter group.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("SmartACE::NAMING::instance()->checkForHelpArg(argc,argv);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(parameterFileFound) ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(SmartACE::NAMING::instance()->init(parameter.getAllParametersFromGroup(\"component\")) != 0) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// initialization of naming service failed");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("throw std::logic_error( \"<NamingService> Service initialization failed!\\nPossible causes could be:\\n-> Erroneous configuration.\\n-> Naming service not reachable.\\n\" );");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(SmartACE::NAMING::instance()->init(argc, argv) != 0) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// initialization of naming service failed");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("throw std::logic_error( \"<NamingService> Service initialization failed!\\nPossible causes could be:\\n-> Erroneous configuration.\\n-> Naming service not reachable.\\n\" );");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// print all known parameters");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// parameter.print();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//--- server port // client port // other parameter ---");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// load parameter");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("parameter.getString(\"component\", \"name\", connections.component.name);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("parameter.getString(\"component\", \"initialComponentMode\", connections.component.initialComponentMode);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(parameter.checkIfParameterExists(\"component\", \"defaultScheduler\")) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("parameter.getString(\"component\", \"defaultScheduler\", connections.component.defaultScheduler);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(parameter.checkIfParameterExists(\"component\", \"useLogger\")) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("parameter.getBoolean(\"component\", \"useLogger\", connections.component.useLogger);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy(this._componentGenHelpers.getAllClientPorts(component), (Functions.Function1)_function);
        for (ComponentPort client : _sortBy) {
            _builder.append("\t\t");
            _builder.append("// load parameters for client ");
            String _name_4 = client.getName();
            _builder.append(_name_4, "\t\t");
            _builder.newLineIfNotEmpty();
            boolean _isOptional = this.isOptional(client);
            if (_isOptional) {
                _builder.append("\t\t");
                _builder.append("parameter.getBoolean(\"");
                String _nameOriginal = this._componentGenHelpers.nameOriginal((AbstractComponentElement)client);
                _builder.append(_nameOriginal, "\t\t");
                _builder.append("\", \"initialConnect\", connections.");
                String _nameInstance = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
                _builder.append(_nameInstance, "\t\t");
                _builder.append(".initialConnect);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("parameter.getString(\"");
            String _nameOriginal_1 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)client);
            _builder.append(_nameOriginal_1, "\t\t");
            _builder.append("\", \"serviceName\", connections.");
            String _nameInstance_1 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
            _builder.append(_nameInstance_1, "\t\t");
            _builder.append(".serviceName);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("parameter.getString(\"");
            String _nameOriginal_2 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)client);
            _builder.append(_nameOriginal_2, "\t\t");
            _builder.append("\", \"serverName\", connections.");
            String _nameInstance_2 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
            _builder.append(_nameInstance_2, "\t\t");
            _builder.append(".serverName);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("parameter.getString(\"");
            String _nameOriginal_3 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)client);
            _builder.append(_nameOriginal_3, "\t\t");
            _builder.append("\", \"wiringName\", connections.");
            String _nameInstance_3 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
            _builder.append(_nameInstance_3, "\t\t");
            _builder.append(".wiringName);");
            _builder.newLineIfNotEmpty();
            boolean _isSubscriber = this._componentGenHelpers.isSubscriber(client);
            if (_isSubscriber) {
                _builder.append("\t\t");
                _builder.append("parameter.getInteger(\"");
                String _nameOriginal_4 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)client);
                _builder.append(_nameOriginal_4, "\t\t");
                _builder.append("\", \"interval\", connections.");
                String _nameInstance_4 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
                _builder.append(_nameInstance_4, "\t\t");
                _builder.append(".interval);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("if(parameter.checkIfParameterExists(\"");
            String _nameOriginal_5 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)client);
            _builder.append(_nameOriginal_5, "\t\t");
            _builder.append("\", \"roboticMiddleware\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("parameter.getString(\"");
            String _nameOriginal_6 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)client);
            _builder.append(_nameOriginal_6, "\t\t\t");
            _builder.append("\", \"roboticMiddleware\", connections.");
            String _nameInstance_5 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
            _builder.append(_nameInstance_5, "\t\t\t");
            _builder.append(".roboticMiddleware);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy(this._componentGenHelpers.getAllServerPorts(component), (Functions.Function1)_function_1);
        for (ComponentPort server : _sortBy_1) {
            _builder.append("\t\t");
            _builder.append("// load parameters for server ");
            String _name_5 = server.getName();
            _builder.append(_name_5, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("parameter.getString(\"");
            String _nameOriginal_7 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)server);
            _builder.append(_nameOriginal_7, "\t\t");
            _builder.append("\", \"serviceName\", connections.");
            String _nameInstance_6 = this._componentGenHelpers.nameInstance((AbstractComponentElement)server);
            _builder.append(_nameInstance_6, "\t\t");
            _builder.append(".serviceName);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if(parameter.checkIfParameterExists(\"");
            String _nameOriginal_8 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)server);
            _builder.append(_nameOriginal_8, "\t\t");
            _builder.append("\", \"roboticMiddleware\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("parameter.getString(\"");
            String _nameOriginal_9 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)server);
            _builder.append(_nameOriginal_9, "\t\t\t");
            _builder.append("\", \"roboticMiddleware\", connections.");
            String _nameInstance_7 = this._componentGenHelpers.nameInstance((AbstractComponentElement)server);
            _builder.append(_nameInstance_7, "\t\t\t");
            _builder.append(".roboticMiddleware);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)ComponentDefinitionModelUtility.getActivities((ComponentDefinition)component), Activity.class), (Functions.Function1)_function_2);
        for (Activity task : _sortBy_2) {
            boolean _not;
            _builder.append("\t\t");
            _builder.append("// load parameters for task ");
            String _name_6 = task.getName();
            _builder.append(_name_6, "\t\t");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_3 = it -> {
                boolean _isConfigurable = it.isConfigurable();
                return !_isConfigurable;
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)task.getExtensions(), ActivationConstraints.class), (Functions.Function1)_function_3);
            boolean bl = _not = !_exists;
            if (_not) {
                _builder.append("\t\t");
                _builder.append("parameter.getDouble(\"");
                String _nameOriginal_10 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
                _builder.append(_nameOriginal_10, "\t\t");
                _builder.append("\", \"minActFreqHz\", connections.");
                String _nameInstance_8 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_8, "\t\t");
                _builder.append(".minActFreq);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("parameter.getDouble(\"");
                String _nameOriginal_11 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
                _builder.append(_nameOriginal_11, "\t\t");
                _builder.append("\", \"maxActFreqHz\", connections.");
                String _nameInstance_9 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_9, "\t\t");
                _builder.append(".maxActFreq);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("parameter.getString(\"");
                String _nameOriginal_12 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
                _builder.append(_nameOriginal_12, "\t\t");
                _builder.append("\", \"triggerType\", connections.");
                String _nameInstance_10 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_10, "\t\t");
                _builder.append(".trigger);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("if(connections.");
                String _nameInstance_11 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_11, "\t\t");
                _builder.append(".trigger == \"PeriodicTimer\") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("parameter.getDouble(\"");
                String _nameOriginal_13 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
                _builder.append(_nameOriginal_13, "\t\t\t");
                _builder.append("\", \"periodicActFreqHz\", connections.");
                String _nameInstance_12 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_12, "\t\t\t");
                _builder.append(".periodicActFreq);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("} else if(connections.");
                String _nameInstance_13 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_13, "\t\t");
                _builder.append(".trigger == \"DataTriggered\") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("parameter.getString(\"");
                String _nameOriginal_14 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
                _builder.append(_nameOriginal_14, "\t\t\t");
                _builder.append("\", \"inPortRef\", connections.");
                String _nameInstance_14 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_14, "\t\t\t");
                _builder.append(".inPortRef);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("parameter.getInteger(\"");
                String _nameOriginal_15 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
                _builder.append(_nameOriginal_15, "\t\t\t");
                _builder.append("\", \"prescale\", connections.");
                String _nameInstance_15 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
                _builder.append(_nameInstance_15, "\t\t\t");
                _builder.append(".prescale);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t\t");
            _builder.append("if(parameter.checkIfParameterExists(\"");
            String _nameOriginal_16 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
            _builder.append(_nameOriginal_16, "\t\t");
            _builder.append("\", \"scheduler\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("parameter.getString(\"");
            String _nameOriginal_17 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
            _builder.append(_nameOriginal_17, "\t\t\t");
            _builder.append("\", \"scheduler\", connections.");
            String _nameInstance_16 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
            _builder.append(_nameInstance_16, "\t\t\t");
            _builder.append(".scheduler);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if(parameter.checkIfParameterExists(\"");
            String _nameOriginal_18 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
            _builder.append(_nameOriginal_18, "\t\t");
            _builder.append("\", \"priority\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("parameter.getInteger(\"");
            String _nameOriginal_19 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
            _builder.append(_nameOriginal_19, "\t\t\t");
            _builder.append("\", \"priority\", connections.");
            String _nameInstance_17 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
            _builder.append(_nameInstance_17, "\t\t\t");
            _builder.append(".priority);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if(parameter.checkIfParameterExists(\"");
            String _nameOriginal_20 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
            _builder.append(_nameOriginal_20, "\t\t");
            _builder.append("\", \"cpuAffinity\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("parameter.getInteger(\"");
            String _nameOriginal_21 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)task);
            _builder.append(_nameOriginal_21, "\t\t\t");
            _builder.append("\", \"cpuAffinity\", connections.");
            String _nameInstance_18 = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
            _builder.append(_nameInstance_18, "\t\t\t");
            _builder.append(".cpuAffinity);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        Functions.Function1 _function_4 = it -> it.getName();
        List _sortBy_3 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputHandlers((ComponentDefinition)component), (Functions.Function1)_function_4);
        for (InputHandler handler : _sortBy_3) {
            _builder.append("\t\t");
            _builder.append("if(parameter.checkIfParameterExists(\"");
            String _nameOriginal_22 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)handler);
            _builder.append(_nameOriginal_22, "\t\t");
            _builder.append("\", \"prescale\")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("parameter.getInteger(\"");
            String _nameOriginal_23 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)handler);
            _builder.append(_nameOriginal_23, "\t\t\t");
            _builder.append("\", \"prescale\", connections.");
            String _nameInstance_19 = this._componentGenHelpers.nameInstance((AbstractComponentElement)handler);
            _builder.append(_nameInstance_19, "\t\t\t");
            _builder.append(".prescale);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.newLine();
        Functions.Function1 _function_5 = it -> it.getExtensionName(component);
        List _sortBy_4 = IterableExtensions.sortBy(this._componentGenHelpers.getComponentGeneratorExtensions(), (Functions.Function1)_function_5);
        for (ComponentGeneratorExtension ext : _sortBy_4) {
            _builder.append("\t\t");
            _builder.append("// load parameters for ");
            String _extensionName = ext.getExtensionName(component);
            _builder.append(_extensionName, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            CharSequence _loadParameters = ext.getLoadParameters(component);
            _builder.append((Object)_loadParameters, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// load parameters for all registered component-extensions");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(auto extension = componentExtensionRegistry.begin(); extension != componentExtensionRegistry.end(); extension++) ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("extension->second->loadParameters(parameter);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        Boolean _hasParameters = this._componentGenHelpers.hasParameters(component);
        if (_hasParameters.booleanValue()) {
            _builder.append("\t\t");
            _builder.append("paramHandler.loadParameter(parameter);");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (const SmartACE::IniParameterError & e) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::cerr << e.what() << std::endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (const std::exception &ex) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::cerr << \"Uncaught std::exception: \" << ex.what() << std::endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (...) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::cerr << \"Uncaught exception\" << std::endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private String getIniStructName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("connections");
        return _builder.toString();
    }

    public CharSequence CreateIniStruct(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// ");
        String _iniStructName = this.getIniStructName();
        _builder.append(_iniStructName);
        _builder.append(" parameter");
        _builder.newLineIfNotEmpty();
        _builder.append("struct ");
        String _iniStructName_1 = this.getIniStructName();
        _builder.append(_iniStructName_1);
        _builder.append("_struct");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// component struct");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("struct component_struct");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// the name of the component");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::string name;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::string initialComponentMode;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::string defaultScheduler;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("bool useLogger;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} component;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//--- task parameter ---");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)ComponentDefinitionModelUtility.getActivities((ComponentDefinition)component), Activity.class), (Functions.Function1)_function);
        for (Activity task : _sortBy) {
            boolean _not;
            _builder.append("\t");
            _builder.append("struct ");
            String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)task);
            _builder.append(_nameClass, "\t");
            _builder.append("_struct {");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_1 = it -> {
                boolean _isConfigurable = it.isConfigurable();
                return !_isConfigurable;
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)task.getExtensions(), ActivationConstraints.class), (Functions.Function1)_function_1);
            boolean bl = _not = !_exists;
            if (_not) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("double minActFreq;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("double maxActFreq;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("std::string trigger;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("// only one of the following two params is ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("// actually used at run-time according ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("// to the system config model");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("double periodicActFreq;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("// or");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("std::string inPortRef;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("int prescale;");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// scheduling parameters");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("std::string scheduler;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("int priority;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("int cpuAffinity;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} ");
            String _nameInstance = this._componentGenHelpers.nameInstance((AbstractComponentElement)task);
            _builder.append(_nameInstance, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//--- upcall parameter ---");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputHandlers((ComponentDefinition)component), (Functions.Function1)_function_2);
        for (InputHandler handler : _sortBy_1) {
            _builder.append("\t");
            _builder.append("struct ");
            String _nameClass_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
            _builder.append(_nameClass_1, "\t");
            _builder.append("_struct {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("int prescale;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} ");
            String _nameInstance_1 = this._componentGenHelpers.nameInstance((AbstractComponentElement)handler);
            _builder.append(_nameInstance_1, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//--- server port parameter ---");
        _builder.newLine();
        Functions.Function1 _function_3 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy(this._componentGenHelpers.getAllServerPorts(component), (Functions.Function1)_function_3);
        for (ComponentPort server : _sortBy_2) {
            _builder.append("\t");
            _builder.append("struct ");
            String _nameClass_2 = this._componentGenHelpers.nameClass((AbstractComponentElement)server);
            _builder.append(_nameClass_2, "\t");
            _builder.append("_struct {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("std::string serviceName;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("std::string roboticMiddleware;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} ");
            String _nameInstance_2 = this._componentGenHelpers.nameInstance((AbstractComponentElement)server);
            _builder.append(_nameInstance_2, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//--- client port parameter ---");
        _builder.newLine();
        Functions.Function1 _function_4 = it -> it.getName();
        List _sortBy_3 = IterableExtensions.sortBy(this._componentGenHelpers.getAllClientPorts(component), (Functions.Function1)_function_4);
        for (ComponentPort client : _sortBy_3) {
            _builder.append("\t");
            _builder.append("struct ");
            String _nameClass_3 = this._componentGenHelpers.nameClass((AbstractComponentElement)client);
            _builder.append(_nameClass_3, "\t");
            _builder.append("_struct {");
            _builder.newLineIfNotEmpty();
            boolean _isOptional = this.isOptional(client);
            if (_isOptional) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("bool initialConnect;");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("std::string serverName;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("std::string serviceName;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("std::string wiringName;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("long interval;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("std::string roboticMiddleware;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} ");
            String _nameInstance_3 = this._componentGenHelpers.nameInstance((AbstractComponentElement)client);
            _builder.append(_nameInstance_3, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        Functions.Function1 _function_5 = it -> it.getExtensionName(component);
        List _sortBy_4 = IterableExtensions.sortBy(this._componentGenHelpers.getComponentGeneratorExtensions(), (Functions.Function1)_function_5);
        for (ComponentGeneratorExtension ext : _sortBy_4) {
            _builder.append("\t");
            _builder.append("// -- parameters for ");
            String _extensionName = ext.getExtensionName(component);
            _builder.append(_extensionName, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _iniStructDefinition = ext.getIniStructDefinition(component);
            _builder.append((Object)_iniStructDefinition, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("} ");
        String _iniStructName_2 = this.getIniStructName();
        _builder.append(_iniStructName_2);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence CreateIniFile(ComponentDefinition component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[smartsoft]");
        _builder.newLine();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# component parameters");
        _builder.newLine();
        _builder.newLine();
        _builder.append("[component]");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# the name of the component for the naming service");
        _builder.newLine();
        _builder.append("name ");
        String _name = component.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# the initial ComponentMode");
        _builder.newLine();
        _builder.append("initialComponentMode ");
        String _initialComponentMode = this.getInitialComponentMode(component);
        _builder.append(_initialComponentMode);
        _builder.newLineIfNotEmpty();
        _builder.append("#defaultScheduler FIFO");
        _builder.newLine();
        _builder.append("#useLogger true");
        _builder.newLine();
        _builder.newLine();
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# Task parameters");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)ComponentDefinitionModelUtility.getActivities((ComponentDefinition)component), Activity.class), (Functions.Function1)_function);
        for (Activity task : _sortBy) {
            boolean _not;
            _builder.newLine();
            _builder.append("[");
            String _name_1 = task.getName();
            _builder.append(_name_1);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_1 = it -> {
                boolean _isConfigurable = it.isConfigurable();
                return !_isConfigurable;
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)task.getExtensions(), ActivationConstraints.class), (Functions.Function1)_function_1);
            boolean bl = _not = !_exists;
            if (_not) {
                _builder.append("minActFreqHz ");
                Double _minActFreq = this._componentGenHelpers.getMinActFreq(task);
                _builder.append((Object)_minActFreq);
                _builder.newLineIfNotEmpty();
                _builder.append("maxActFreqHz ");
                Double _maxActFreq = this._componentGenHelpers.getMaxActFreq(task);
                _builder.append((Object)_maxActFreq);
                _builder.newLineIfNotEmpty();
                Iterable _filter = Iterables.filter((Iterable)task.getExtensions(), DefaultTrigger.class);
                for (DefaultTrigger trigger : _filter) {
                    if (trigger instanceof DefaultPeriodicTimer) {
                        _builder.append("# setup default trigger as PeriodicTimer");
                        _builder.newLine();
                        _builder.append("triggerType PeriodicTimer");
                        _builder.newLine();
                        _builder.append("periodicActFreqHz ");
                        double _periodicActFreq = ((DefaultPeriodicTimer)trigger).getPeriodicActFreq();
                        _builder.append((Object)_periodicActFreq);
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    if (!(trigger instanceof DefaultInputTrigger)) continue;
                    _builder.append("# setup default trigger as DataTriggered");
                    _builder.newLine();
                    _builder.append("triggerType DataTriggered");
                    _builder.newLine();
                    _builder.append("inPortRef ");
                    String _name_2 = ((DefaultInputTrigger)trigger).getInputLink().getInputPort().getName();
                    _builder.append(_name_2);
                    _builder.newLineIfNotEmpty();
                    _builder.append("prescale ");
                    int _prescale = ((DefaultInputTrigger)trigger).getPrescale();
                    _builder.append((Object)_prescale);
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("# other trigger-types are:");
                _builder.newLine();
                _builder.append("#triggerType PeriodicTimer");
                _builder.newLine();
                _builder.append("#periodicActFreqHz ");
                Double _minActFreq_1 = this._componentGenHelpers.getMinActFreq(task);
                _builder.append((Object)_minActFreq_1);
                _builder.newLineIfNotEmpty();
                _builder.append("# or alternatively:");
                _builder.newLine();
                _builder.append("#triggerType DataTriggered");
                _builder.newLine();
                _builder.append("#inPortRef <InPortName>");
                _builder.newLine();
                _builder.append("#prescale 1");
                _builder.newLine();
            }
            _builder.append("# optional scheduling parameters");
            _builder.newLine();
            _builder.append("# scheduler FIFO");
            _builder.newLine();
            _builder.append("# priority 0");
            _builder.newLine();
            _builder.append("# cpuAffinity 0");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# InputHandler parameters");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputHandlers((ComponentDefinition)component), (Functions.Function1)_function_2);
        for (InputHandler handler : _sortBy_1) {
            _builder.newLine();
            _builder.append("[");
            String _name_3 = handler.getName();
            _builder.append(_name_3);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            _builder.append("prescale 1");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# server port parameter");
        _builder.newLine();
        Functions.Function1 _function_3 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy(this._componentGenHelpers.getAllServerPorts(component), (Functions.Function1)_function_3);
        for (ComponentPort server : _sortBy_2) {
            _builder.newLine();
            _builder.append("[");
            String _nameOriginal = this._componentGenHelpers.nameOriginal((AbstractComponentElement)server);
            _builder.append(_nameOriginal);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            _builder.append("serviceName ");
            String _nameOriginal_1 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)server);
            _builder.append(_nameOriginal_1);
            _builder.newLineIfNotEmpty();
            _builder.append("roboticMiddleware ");
            String _defaultMiddlewareString = this._componentGenHelpers.getDefaultMiddlewareString(server);
            _builder.append(_defaultMiddlewareString);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# client port parameter");
        _builder.newLine();
        Functions.Function1 _function_4 = it -> it.getName();
        List _sortBy_3 = IterableExtensions.sortBy(this._componentGenHelpers.getAllClientPorts(component), (Functions.Function1)_function_4);
        for (ComponentPort client : _sortBy_3) {
            _builder.newLine();
            _builder.append("[");
            String _nameOriginal_2 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)client);
            _builder.append(_nameOriginal_2);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            boolean _isOptional = this.isOptional(client);
            if (_isOptional) {
                _builder.append("initialConnect false");
                _builder.newLine();
            }
            _builder.append("serverName unknown");
            _builder.newLine();
            _builder.append("serviceName unknown");
            _builder.newLine();
            _builder.append("wiringName ");
            String _nameOriginal_3 = this._componentGenHelpers.nameOriginal((AbstractComponentElement)client);
            _builder.append(_nameOriginal_3);
            _builder.newLineIfNotEmpty();
            _builder.append("interval 1");
            _builder.newLine();
            _builder.append("roboticMiddleware ");
            String _defaultMiddlewareString_1 = this._componentGenHelpers.getDefaultMiddlewareString(client);
            _builder.append(_defaultMiddlewareString_1);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Functions.Function1 _function_5 = it -> it.getExtensionName(component);
        List _sortBy_4 = IterableExtensions.sortBy(this._componentGenHelpers.getComponentGeneratorExtensions(), (Functions.Function1)_function_5);
        for (ComponentGeneratorExtension ext : _sortBy_4) {
            _builder.append("##########################");
            _builder.newLine();
            _builder.append("## parameters of ");
            String _extensionName = ext.getExtensionName(component);
            _builder.append(_extensionName);
            _builder.newLineIfNotEmpty();
            CharSequence _iniFileParameters = ext.getIniFileParameters(component);
            _builder.append((Object)_iniFileParameters);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.newLine();
        return _builder;
    }

    private String getInitialComponentMode(ComponentDefinition component) {
        Iterable _filter = Iterables.filter((Iterable)component.getElements(), CoordinationSlavePort.class);
        for (CoordinationSlavePort slave : _filter) {
            Functions.Function1 _function = it -> {
                boolean _isIsDefaultInit = it.isIsDefaultInit();
                return _isIsDefaultInit;
            };
            PublicOperationMode mode = (PublicOperationMode)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)slave.getElements(), PublicOperationMode.class), (Functions.Function1)_function);
            if (mode == null) continue;
            return mode.getName();
        }
        return "Neutral";
    }

    public boolean isOptional(ComponentPort client) {
        EObject _eContainer = client.eContainer();
        ComponentDefinition component = (ComponentDefinition)_eContainer;
        Iterable _activities = ComponentDefinitionModelUtility.getActivities((ComponentDefinition)component);
        for (Activity task : _activities) {
            Functions.Function1 _function = it -> it.getInputPort().equals(client);
            Functions.Function1 _function_1 = it -> {
                boolean _isOptional = it.isOptional();
                return !_isOptional;
            };
            boolean _exists = IterableExtensions.exists((Iterable)IterableExtensions.filter((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)task), (Functions.Function1)_function), (Functions.Function1)_function_1);
            if (!_exists) continue;
            return false;
        }
        return true;
    }
}

