/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.activityArchitecture.ui.contentassist;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.ui.contentassist.AbstractActivityArchitectureProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class ActivityArchitectureProposalProvider extends AbstractActivityArchitectureProposalProvider {
  @Override
  public void completeActivityArchitectureModel_Name(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeActivityArchitectureModel_Name(model, assignment, context, acceptor);
    final URI uri = model.eResource().getURI();
    boolean _isPlatform = uri.isPlatform();
    if (_isPlatform) {
      final String projectName = uri.segment(1);
      acceptor.accept(this.createCompletionProposal(projectName, (projectName + " - ProjectName"), this.getImage(model), context));
    }
  }
  
  @Override
  public void completeDataTriggered_Prescale(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeDataTriggered_Prescale(model, assignment, context, acceptor);
    acceptor.accept(this.createCompletionProposal("1", "1 - prescale factor", this.getImage(model), context));
  }
  
  @Override
  public void completeInputHandlerNode_Prescale(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeInputHandlerNode_Prescale(model, assignment, context, acceptor);
    acceptor.accept(this.createCompletionProposal("1", "1 - prescale factor", this.getImage(model), context));
  }
  
  @Override
  public void completePeriodicTimer_PeriodicActFreq(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completePeriodicTimer_PeriodicActFreq(model, assignment, context, acceptor);
    acceptor.accept(this.createCompletionProposal("1.0 Hz", "1.0 Hz - activation frequency", this.getImage(model), context));
  }
  
  @Override
  public void completeTimeValue_Value(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeTimeValue_Value(model, assignment, context, acceptor);
    acceptor.accept(this.createCompletionProposal("100 ms", "100 ms - time value", this.getImage(model), context));
  }
}
