/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz
 */
package org.eclipse.smartmdsd.xtext.system.causeEffectChain.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smartmdsd.xtext.system.causeEffectChain.CauseEffectChainRuntimeModule;
import org.eclipse.smartmdsd.xtext.system.causeEffectChain.CauseEffectChainStandaloneSetup;
import org.eclipse.smartmdsd.xtext.system.causeEffectChain.ide.CauseEffectChainIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class CauseEffectChainIdeSetup extends CauseEffectChainStandaloneSetup {
  @Override
  public Injector createInjector() {
    CauseEffectChainRuntimeModule _causeEffectChainRuntimeModule = new CauseEffectChainRuntimeModule();
    CauseEffectChainIdeModule _causeEffectChainIdeModule = new CauseEffectChainIdeModule();
    return Guice.createInjector(Modules2.mixin(_causeEffectChainRuntimeModule, _causeEffectChainIdeModule));
  }
}
