/**
 * Copyright (c) 2021 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.causeEffectChain.ui;

import com.google.inject.Injector;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.CauseEffectChainPackage;
import org.eclipse.smartmdsd.ui.models.ISmartMDSDXtextContribution;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;
import org.eclipse.smartmdsd.xtext.system.causeEffectChain.ui.internal.CauseEffectChainActivator;

@SuppressWarnings("all")
public class SmartMDSDCauseEffectChainContribution implements ISmartMDSDXtextContribution {
  @Override
  public EPackage getEPackage() {
    return CauseEffectChainPackage.eINSTANCE;
  }
  
  @Override
  public SmartMDSDNatureEnum getSmartMDSDNatureEnum() {
    return SmartMDSDNatureEnum.SystemNature;
  }
  
  @Override
  public String getXtextEditorID() {
    return CauseEffectChainActivator.ORG_ECLIPSE_SMARTMDSD_XTEXT_SYSTEM_CAUSEEFFECTCHAIN_CAUSEEFFECTCHAIN;
  }
  
  @Override
  public Injector getXtextInjector() {
    return CauseEffectChainActivator.getInstance().getInjector(this.getXtextEditorID());
  }
  
  @Override
  public boolean isDefaultLanguage() {
    return false;
  }
}
