/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.service.communicationObject;

import com.google.common.collect.Iterables;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesModelUtility;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationValue;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementValue;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;

public class CommunicationObjectUtility
extends BasicAttributesModelUtility {
    public String getValueString(AbstractValue av) {
        String _xifexpression = null;
        if (av instanceof EnumerationValue) {
            return ((EnumerationValue)av).getValue().getName();
        }
        String _xifexpression_1 = null;
        if (av instanceof CommElementValue) {
            return ((CommElementValue)av).getValue().getName();
        }
        _xifexpression = _xifexpression_1 = super.getValueString(av);
        return _xifexpression;
    }

    public String getTypeName(AbstractAttributeType attrType) {
        String _xifexpression = null;
        if (attrType instanceof CommElementReference) {
            return ((CommElementReference)attrType).getTypeName().getName();
        }
        _xifexpression = super.getTypeName(attrType);
        return _xifexpression;
    }

    public boolean isComposedType(AbstractAttributeType attrType) {
        if (attrType instanceof CommElementReference) {
            AbstractCommElement _typeName = ((CommElementReference)attrType).getTypeName();
            return _typeName instanceof CommunicationObject;
        }
        return false;
    }

    public boolean isCommunicationObject(AbstractAttributeType attrType) {
        AbstractCommElement _typeName;
        return attrType instanceof CommElementReference && (_typeName = ((CommElementReference)attrType).getTypeName()) instanceof CommunicationObject;
    }

    public boolean isEnumeration(AbstractAttributeType attrType) {
        AbstractCommElement _typeName;
        return attrType instanceof CommElementReference && (_typeName = ((CommElementReference)attrType).getTypeName()) instanceof Enumeration;
    }

    public CommunicationObject getCommunicationObjectRef(AbstractAttributeType attrType) {
        AbstractCommElement typeName;
        if (attrType instanceof CommElementReference && (typeName = ((CommElementReference)attrType).getTypeName()) instanceof CommunicationObject) {
            return (CommunicationObject)typeName;
        }
        return null;
    }

    public Iterable<CommunicationObject> getCommunicationObjects(CommObjectsRepository repo) {
        return Iterables.filter(repo.getElements(), CommunicationObject.class);
    }

    public Iterable<Enumeration> getEnumerations(CommObjectsRepository repo) {
        return Iterables.filter(repo.getElements(), Enumeration.class);
    }
}

