/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.service.communicationPattern;

import java.util.Arrays;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectStyledLabelProvider;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.CommunicationPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.EventPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.PushPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.QueryPattern;
import org.eclipse.smartmdsd.ecore.service.communicationPattern.SendPattern;

@SuppressWarnings("all")
public class CommunicationPatternStyledLabelProvider extends CommunicationObjectStyledLabelProvider {
  protected StyledString _getStyledString(final PushPattern pattern) {
    String _name = pattern.getDataType().getName();
    String _plus = ("Push<" + _name);
    String _plus_1 = (_plus + ">");
    return new StyledString(_plus_1, StyledString.QUALIFIER_STYLER);
  }
  
  protected StyledString _getStyledString(final SendPattern pattern) {
    String _name = pattern.getDataType().getName();
    String _plus = ("Send<" + _name);
    String _plus_1 = (_plus + ">");
    return new StyledString(_plus_1, StyledString.QUALIFIER_STYLER);
  }
  
  protected StyledString _getStyledString(final QueryPattern pattern) {
    String _name = pattern.getRequestType().getName();
    String _plus = ("Query<" + _name);
    String _plus_1 = (_plus + ", ");
    String _name_1 = pattern.getAnswerType().getName();
    String _plus_2 = (_plus_1 + _name_1);
    String _plus_3 = (_plus_2 + ">");
    return new StyledString(_plus_3, StyledString.QUALIFIER_STYLER);
  }
  
  protected StyledString _getStyledString(final EventPattern pattern) {
    String _name = pattern.getEventType().getName();
    String _plus = ("Event<" + _name);
    String _plus_1 = (_plus + ", ");
    String _name_1 = pattern.getActivationType().getName();
    String _plus_2 = (_plus_1 + _name_1);
    String _plus_3 = (_plus_2 + ">");
    return new StyledString(_plus_3, StyledString.QUALIFIER_STYLER);
  }
  
  public StyledString getStyledString(final CommunicationPattern pattern) {
    if (pattern instanceof EventPattern) {
      return _getStyledString((EventPattern)pattern);
    } else if (pattern instanceof PushPattern) {
      return _getStyledString((PushPattern)pattern);
    } else if (pattern instanceof QueryPattern) {
      return _getStyledString((QueryPattern)pattern);
    } else if (pattern instanceof SendPattern) {
      return _getStyledString((SendPattern)pattern);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(pattern).toString());
    }
  }
}
