/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.base.basicAttributes.ui.contentassist;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesModelUtility;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.ui.contentassist.AbstractBasicAttributesProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class BasicAttributesProposalProvider
extends AbstractBasicAttributesProposalProvider {
    @Inject
    private BasicAttributesModelUtility util;

    @Override
    public void complete_AttributeDefinition(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_AttributeDefinition(model, ruleCall, context, acceptor);
        if (model instanceof AttributeDefinition) {
            boolean _tripleNotEquals;
            String _name = ((AttributeDefinition)model).getName();
            String _plus = String.valueOf(_name) + " : ";
            String _typeName = this.util.getTypeName(((AttributeDefinition)model).getType());
            String proposalText = String.valueOf(_plus) + _typeName;
            AbstractValue _defaultvalue = ((AttributeDefinition)model).getDefaultvalue();
            boolean bl = _tripleNotEquals = _defaultvalue != null;
            if (_tripleNotEquals) {
                String _proposalText = proposalText;
                String _valueString = this.util.getValueString(((AttributeDefinition)model).getDefaultvalue());
                String _plus_1 = " = " + _valueString;
                proposalText = String.valueOf(_proposalText) + _plus_1;
            }
            String _name_1 = ruleCall.getRule().getName();
            String _plus_2 = "clone previous " + _name_1;
            acceptor.accept(this.createCompletionProposal(proposalText, _plus_2, this.getImage(model), context));
        }
    }

    @Override
    public void completeSingleValue_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject attr = model;
        if (model instanceof ArrayValue) {
            attr = ((ArrayValue)model).eContainer();
        }
        AbstractAttributeType attrType = null;
        if (attr instanceof AttributeDefinition) {
            attrType = ((AttributeDefinition)attr).getType();
        } else if (attr instanceof AttributeRefinement && (attrType = ((AttributeRefinement)attr).getAttribute().getType()) instanceof PrimitiveType) {
            AbstractValue defVal = ((AttributeRefinement)attr).getAttribute().getDefaultvalue();
            String text = this.util.getValueString(defVal);
            if (defVal != null) {
                String _literal = ((PrimitiveType)attrType).getTypeName().getLiteral();
                String _plus = String.valueOf(text) + " - " + _literal;
                acceptor.accept(this.createCompletionProposal(text, _plus, this.getImage((EObject)attrType), context));
            }
        }
        if (attrType != null) {
            AbstractAttributeType type = attrType;
            Iterable textList = this.util.getDefaultValuesFor(attrType);
            Consumer<String> _function = text_1 -> {
                String _typeName = this.util.getTypeName(type);
                String _plus_1 = String.valueOf(text_1) + " - " + _typeName;
                acceptor.accept(this.createCompletionProposal((String)text_1, _plus_1, this.getImage((EObject)type), context));
            };
            textList.forEach(_function);
        }
    }
}

