/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.genericDatasheet.ui.contentassist;

import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.datasheet.indexer.WorkspaceDatasheetIndexer;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DefaultDatasheetProperties;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.TechnologyReadinessLevel;
import org.eclipse.smartmdsd.xtext.base.genericDatasheet.GenericDatasheetUtils;
import org.eclipse.smartmdsd.xtext.base.genericDatasheet.ui.contentassist.AbstractGenericDatasheetProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class GenericDatasheetProposalProvider extends AbstractGenericDatasheetProposalProvider {
  @Override
  public void completeMandatoryDatasheetElement_Value(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    if ((model instanceof MandatoryDatasheetElement)) {
      boolean _equals = ((MandatoryDatasheetElement)model).getName().equals(MandatoryDatasheetElementNames.BASE_URI);
      if (_equals) {
        final String text = "\"http://www.servicerobotik-ulm.de\"";
        acceptor.accept(this.createCompletionProposal(text, context));
      } else {
        boolean _equals_1 = ((MandatoryDatasheetElement)model).getName().equals(MandatoryDatasheetElementNames.SHORT_DESCRIPTION);
        if (_equals_1) {
          String _segment = ((MandatoryDatasheetElement)model).eResource().getURI().segment(1);
          String _plus = ("\"TODO: add short description for " + _segment);
          final String text_1 = (_plus + "\"");
          final String proposal = "default short description";
          acceptor.accept(this.createCompletionProposal(text_1, proposal, null, context));
        }
      }
    }
  }
  
  @Override
  public void completeDatasheetProperty_Name(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    final Set<String> custom_properties = WorkspaceDatasheetIndexer.getInstance().getAllIndexedPropertyNames();
    for (final DefaultDatasheetProperties value : DefaultDatasheetProperties.VALUES) {
      {
        final String proposal = value.getLiteral();
        custom_properties.remove(proposal);
        final String text = (proposal + " - default property");
        acceptor.accept(this.createCompletionProposal(proposal, text, null, context));
      }
    }
    for (final String property : custom_properties) {
      {
        final String text = (property + " - custom property");
        acceptor.accept(this.createCompletionProposal(property, text, null, context));
      }
    }
  }
  
  @Override
  public void completeDatasheetProperty_Value(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    if ((model instanceof DatasheetProperty)) {
      boolean _equals = ((DatasheetProperty)model).getName().equals(DefaultDatasheetProperties.SPDX_LICENSE.getLiteral());
      if (_equals) {
        Collection<String> _spdxLicenseNames = GenericDatasheetUtils.getSpdxLicenseNames();
        for (final String license : _spdxLicenseNames) {
          {
            final String text = ("\"" + license);
            acceptor.accept(this.createCompletionProposal(text, context));
          }
        }
      } else {
        boolean _equals_1 = ((DatasheetProperty)model).getName().equals(DefaultDatasheetProperties.TECHNOLOGY_READINESS_LEVEL.getLiteral());
        if (_equals_1) {
          for (final TechnologyReadinessLevel trl : TechnologyReadinessLevel.VALUES) {
            {
              String _literal = trl.getLiteral();
              String _plus = ("\"" + _literal);
              final String text = (_plus + "\"");
              acceptor.accept(this.createCompletionProposal(text, context));
            }
          }
        } else {
          final Set<String> all_values = WorkspaceDatasheetIndexer.getInstance().getAllMatchingPropertyValues(((DatasheetProperty)model).getName());
          for (final String value : all_values) {
            {
              final String text = (("\"" + value) + "\"");
              acceptor.accept(this.createCompletionProposal(text, context));
            }
          }
        }
      }
    }
  }
  
  @Override
  public void completeDatasheetProperty_Unit(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeDatasheetProperty_Unit(model, assignment, context, acceptor);
    if ((model instanceof DatasheetProperty)) {
      final Set<String> all_units = WorkspaceDatasheetIndexer.getInstance().getAllMatchingPropertyUnits(((DatasheetProperty)model).getName());
      for (final String unit : all_units) {
        {
          final String text = (("\"" + unit) + "\"");
          acceptor.accept(this.createCompletionProposal(text, context));
        }
      }
    }
  }
  
  @Override
  public void completeDatasheetProperty_SemanticID(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeDatasheetProperty_SemanticID(model, assignment, context, acceptor);
    if ((model instanceof DatasheetProperty)) {
      boolean _equals = ((DatasheetProperty)model).getName().equals(DefaultDatasheetProperties.SPDX_LICENSE.getLiteral());
      if (_equals) {
        String _value = ((DatasheetProperty)model).getValue();
        String _plus = ("\"https://spdx.org/licenses/" + _value);
        final String uri = (_plus + ".html\"");
        acceptor.accept(this.createCompletionProposal(uri, context));
      } else {
        final Set<String> all_uris = WorkspaceDatasheetIndexer.getInstance().getAllMatchingPropertySemanticURIs(((DatasheetProperty)model).getName());
        for (final String uri_1 : all_uris) {
          {
            final String text = (("\"" + uri_1) + "\"");
            acceptor.accept(this.createCompletionProposal(text, context));
          }
        }
      }
    }
  }
}
