/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.service.parameterDefinition.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesTypeConformance;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.AbstractParameter;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinitionPackage;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.TriggerDefinition;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ParameterDefinitionXtextUtils;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.validation.AbstractParameterDefinitionValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ParameterDefinitionValidator
extends AbstractParameterDefinitionValidator {
    @Inject
    @Extension
    private ParameterDefinitionXtextUtils _parameterDefinitionXtextUtils;
    protected static final String ISSUE_PREFIX = "org.xtext.service.parameterDefinition.";
    public static final String RESERVED_PARAMETER_SET_NAME = "org.xtext.service.parameterDefinition.ReservedParameterSetName";
    public static final String PARAM_SET_HIERARCHY = "org.xtext.service.parameterDefinition.ParemeterSetHierarchy";
    public static final String PARAMETER_DUPLICATE = "org.xtext.service.parameterDefinition.ParameterDuplicate";
    public static final String TRIGGER_DUPLICATE = "org.xtext.service.parameterDefinition.TriggerDuplicate";
    public static final String CPP_KEYWORD_PARAM_SET_NAME = "org.xtext.service.parameterDefinition.CppKeywordParamSetName";
    public static final String CPP_KEYWORD_PARAM_NAME = "org.xtext.service.parameterDefinition.CppKeywordParamName";

    @Check
    public void checkReservedParameterSetNames(ParameterSetDefinition s) {
        String _name = s.getName();
        String fqn = "defaultParameterLib." + _name;
        boolean _equals = Objects.equal((Object)fqn, (Object)"defaultParameterLib.EmptyDefaultParameterSet");
        if (_equals) {
            String _name_1 = s.getName();
            String _plus = "'" + _name_1;
            String _plus_1 = String.valueOf(_plus) + "' is a reserved library name";
            this.warning(_plus_1, (EStructuralFeature)ParameterDefinitionPackage.Literals.PARAMETER_SET_DEFINITION__NAME, RESERVED_PARAMETER_SET_NAME, new String[0]);
        }
    }

    @Check
    public void checkParameterSetHierarchy(ParameterSetDefinition s) {
        EList _extends = s.getExtends();
        for (ParameterSetDefinition next : _extends) {
            if (next == s) {
                String _name = s.getName();
                String _plus = "Cycle in extensions, '" + _name;
                String _plus_1 = String.valueOf(_plus) + "' cannot extend itself";
                this.error(_plus_1, (EStructuralFeature)ParameterDefinitionPackage.Literals.PARAMETER_SET_DEFINITION__EXTENDS, s.getExtends().indexOf((Object)next), PARAM_SET_HIERARCHY, new String[0]);
                continue;
            }
            boolean _contains = this._parameterDefinitionXtextUtils.getParameterSetHierarchy(next).contains(s);
            if (!_contains) continue;
            String _name_1 = next.getName();
            String _plus_2 = "Cycle in extensions hierarchy of ParameterSet '" + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.error(_plus_3, (EStructuralFeature)ParameterDefinitionPackage.Literals.PARAMETER_SET_DEFINITION__EXTENDS, s.getExtends().indexOf((Object)next), PARAM_SET_HIERARCHY, new String[0]);
        }
    }

    @Check
    public void checkDulpcateInheritedParameters(ParameterDefinition param) {
        Functions.Function1 _function;
        EObject _eContainer = param.eContainer();
        ParameterSetDefinition parent = (ParameterSetDefinition)_eContainer;
        Iterable visibleParentParameters = this._parameterDefinitionXtextUtils.getParameterHierarchy(parent);
        boolean _exists = IterableExtensions.exists((Iterable)visibleParentParameters, (Functions.Function1)(_function = it -> {
            String _name = it.getName();
            String _name_1 = param.getName();
            return Objects.equal((Object)_name, (Object)_name_1);
        }));
        if (_exists) {
            this.warning("This Parameter is a duplicate for one of the inherited Parameters", (EStructuralFeature)ParameterDefinitionPackage.Literals.ABSTRACT_PARAMETER__NAME, PARAMETER_DUPLICATE, new String[0]);
        }
    }

    @Check
    public void checkDulpcateInheritedTriggers(TriggerDefinition trigger) {
        Functions.Function1 _function;
        EObject _eContainer = trigger.eContainer();
        ParameterSetDefinition parent = (ParameterSetDefinition)_eContainer;
        Iterable visibleParentTriggers = this._parameterDefinitionXtextUtils.getTriggerHierarchy(parent);
        boolean _exists = IterableExtensions.exists((Iterable)visibleParentTriggers, (Functions.Function1)(_function = it -> {
            String _name = it.getName();
            String _name_1 = trigger.getName();
            return Objects.equal((Object)_name, (Object)_name_1);
        }));
        if (_exists) {
            this.warning("This Trigger is a duplicate for one of the inherited Triggers", (EStructuralFeature)ParameterDefinitionPackage.Literals.ABSTRACT_PARAMETER__NAME, PARAMETER_DUPLICATE, new String[0]);
        }
    }

    @Check
    public void checkCppReservedKeywords(ParameterSetDefinition elem) {
        boolean _contains = BasicAttributesTypeConformance.cppKeywords.contains(elem.getName());
        if (_contains) {
            this.error("Element name must not be a C++ reserved keyword.", (EStructuralFeature)ParameterDefinitionPackage.Literals.PARAMETER_SET_DEFINITION__NAME, CPP_KEYWORD_PARAM_SET_NAME, new String[0]);
        }
    }

    @Check
    public void checkCppReservedKeywords(AbstractParameter elem) {
        boolean _contains = BasicAttributesTypeConformance.cppKeywords.contains(elem.getName());
        if (_contains) {
            this.error("Element name must not be a C++ reserved keyword.", (EStructuralFeature)ParameterDefinitionPackage.Literals.ABSTRACT_PARAMETER__NAME, CPP_KEYWORD_PARAM_NAME, new String[0]);
        }
    }
}

