/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectUtility;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.ExtendedOutputConfigurationProvider;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectCMakeGenerator;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectMarshalling;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.ConstructorParamGenHelper;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.DocumentationGenerator;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.EnumerationGenerator;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.GetterAndSetterGenHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class CommObjGenerator2Impl extends AbstractGenerator {
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private CommObjectMarshalling _commObjectMarshalling;
  
  @Inject
  @Extension
  private CommObjectCMakeGenerator _commObjectCMakeGenerator;
  
  @Inject
  @Extension
  private GetterAndSetterGenHelper _getterAndSetterGenHelper;
  
  @Inject
  @Extension
  private ConstructorParamGenHelper _constructorParamGenHelper;
  
  @Inject
  @Extension
  private EnumerationGenerator _enumerationGenerator;
  
  @Inject
  @Extension
  private DocumentationGenerator _documentationGenerator;
  
  @Inject
  @Extension
  private CommunicationObjectUtility _communicationObjectUtility;
  
  @Override
  public void doGenerate(final Resource input, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    Iterable<CommObjectsRepository> _filter = Iterables.<CommObjectsRepository>filter(IteratorExtensions.<EObject>toIterable(input.getAllContents()), CommObjectsRepository.class);
    for (final CommObjectsRepository repo : _filter) {
      {
        String _name = repo.getName();
        String _plus = (_name + "/hash.hh.in");
        fsa.generateFile(_plus, this.compileHashFile(repo));
        fsa.generateFile("info.txt", this.compileToolchainVersionFile(repo));
        fsa.generateFile("CMakeLists.txt", ExtendedOutputConfigurationProvider.SMARTSOFT_OUTPUT, this._commObjectCMakeGenerator.generateCmakeListsFile(repo));
        fsa.generateFile("DomainModelsExtensions.cmake", this._commObjectCMakeGenerator.generateCmakeDomainModelsExtensionsFile(repo));
        fsa.generateFile("CommObjectProject.cmake", this._commObjectCMakeGenerator.generateCmakeProjectFile(repo));
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(repo);
        String _plus_1 = (_repoNamespace + "Config.cmake.in");
        fsa.generateFile(_plus_1, this._commObjectCMakeGenerator.generateCmakeConfigFile(repo));
        CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(repo);
        String _plus_2 = (_repoNamespace_1 + "Dependencies.cmake.in");
        fsa.generateFile(_plus_2, this._commObjectCMakeGenerator.generateCmakeDependenciesFile(repo));
        Iterable<CommunicationObject> _communicationObjects = this._communicationObjectUtility.getCommunicationObjects(repo);
        for (final CommunicationObject co : _communicationObjects) {
          {
            String _name_1 = repo.getName();
            String _plus_3 = (_name_1 + "/");
            CharSequence _idlHeaderFileName = this._commObjectGenHelpers.getIdlHeaderFileName(co);
            String _plus_4 = (_plus_3 + _idlHeaderFileName);
            fsa.generateFile(_plus_4, this.compileIdlHeader(co));
            String _name_2 = repo.getName();
            String _plus_5 = (_name_2 + "/");
            CharSequence _serializationHeaderFileName = this._commObjectGenHelpers.getSerializationHeaderFileName(co);
            String _plus_6 = (_plus_5 + _serializationHeaderFileName);
            fsa.generateFile(_plus_6, this.compileSerializationHeader(co));
            String _name_3 = repo.getName();
            String _plus_7 = (_name_3 + "/");
            CharSequence _serializationSourceFileName = this._commObjectGenHelpers.getSerializationSourceFileName(co);
            String _plus_8 = (_plus_7 + _serializationSourceFileName);
            fsa.generateFile(_plus_8, this.compileSerializationSource(co));
            String _name_4 = repo.getName();
            String _plus_9 = (_name_4 + "/");
            CharSequence _baseClassHeaderFileName = this._commObjectGenHelpers.getBaseClassHeaderFileName(co);
            String _plus_10 = (_plus_9 + _baseClassHeaderFileName);
            fsa.generateFile(_plus_10, this.compileBaseClassH(co));
            String _name_5 = repo.getName();
            String _plus_11 = (_name_5 + "/");
            CharSequence _baseClassSourceFileName = this._commObjectGenHelpers.getBaseClassSourceFileName(co);
            String _plus_12 = (_plus_11 + _baseClassSourceFileName);
            fsa.generateFile(_plus_12, this.compileBaseClassCpp(co));
            String _name_6 = repo.getName();
            String _plus_13 = (_name_6 + "/");
            CharSequence _userClassHeaderFileName = this._commObjectGenHelpers.getUserClassHeaderFileName(co);
            String _plus_14 = (_plus_13 + _userClassHeaderFileName);
            fsa.generateFile(_plus_14, 
              ExtendedOutputConfigurationProvider.SRC_OUTPUT, 
              this.compileDerivedHeaderFile(co));
            String _name_7 = repo.getName();
            String _plus_15 = (_name_7 + "/");
            CharSequence _userClassSourceFileName = this._commObjectGenHelpers.getUserClassSourceFileName(co);
            String _plus_16 = (_plus_15 + _userClassSourceFileName);
            fsa.generateFile(_plus_16, 
              ExtendedOutputConfigurationProvider.SRC_OUTPUT, 
              this.compileDerivedSourceFile(co));
          }
        }
        Iterable<Enumeration> _enumerations = this._communicationObjectUtility.getEnumerations(repo);
        for (final Enumeration en : _enumerations) {
          {
            String _name_1 = repo.getName();
            String _plus_3 = (_name_1 + "/");
            CharSequence _enumIdlFileName = this._commObjectGenHelpers.getEnumIdlFileName(en);
            String _plus_4 = (_plus_3 + _enumIdlFileName);
            fsa.generateFile(_plus_4, this._enumerationGenerator.compileEnumIDL(en));
            String _name_2 = repo.getName();
            String _plus_5 = (_name_2 + "/");
            CharSequence _enumClassFileName = this._commObjectGenHelpers.getEnumClassFileName(en);
            String _plus_6 = (_plus_5 + _enumClassFileName);
            fsa.generateFile(_plus_6, this._enumerationGenerator.compileEnum(en));
          }
        }
        String _name_1 = repo.getName();
        String _plus_3 = (_name_1 + "/");
        String _name_2 = repo.getName();
        String _plus_4 = (_plus_3 + _name_2);
        String _plus_5 = (_plus_4 + ".dox");
        fsa.generateFile(_plus_5, this._documentationGenerator.generateDocumentation(repo));
      }
    }
  }
  
  public CharSequence compileToolchainVersionFile(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    String _toolchainVersionFileString = this._copyrightHelpers.getToolchainVersionFileString();
    _builder.append(_toolchainVersionFileString);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * compileHashFile <repo-name>Hash.h.in
   */
  public CharSequence compileHashFile(final CommObjectsRepository repo) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef HASH_HH");
    _builder.newLine();
    _builder.append("#define HASH_HH");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.append("#include <list>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("namespace ");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(repo);
    _builder.append(_repoNamespace);
    _builder.append("IDL");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("const char * const REPO_HASH = \"@HASH_VALUE@\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("typedef std::list<std::string> HashList;");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * compile the IDL Struct for each CommObj
   */
  public CharSequence compileIdlHeader(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef ");
    CharSequence _idlHeaderDefine = this._commObjectGenHelpers.getIdlHeaderDefine(co);
    _builder.append(_idlHeaderDefine);
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    CharSequence _idlHeaderDefine_1 = this._commObjectGenHelpers.getIdlHeaderDefine(co);
    _builder.append(_idlHeaderDefine_1);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      Set<String> _generateIdlInclude = this._commObjectGenHelpers.generateIdlInclude(co.getAttributes());
      for(final String inc : _generateIdlInclude) {
        _builder.append(inc);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      final Function1<AttributeDefinition, Boolean> _function = (AttributeDefinition e) -> {
        boolean _many = this._commObjectGenHelpers.getMany(e);
        return Boolean.valueOf((_many == true));
      };
      boolean _exists = IterableExtensions.<AttributeDefinition>exists(co.getAttributes(), _function);
      if (_exists) {
        _builder.append("#include <vector>");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      final Function1<AttributeDefinition, Boolean> _function_1 = (AttributeDefinition e) -> {
        return Boolean.valueOf(this._communicationObjectUtility.isStringType(e.getType()));
      };
      boolean _exists_1 = IterableExtensions.<AttributeDefinition>exists(co.getAttributes(), _function_1);
      if (_exists_1) {
        _builder.append("#include <string>");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("namespace ");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("IDL ");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      EList<AttributeDefinition> _attributes = co.getAttributes();
      for(final AttributeDefinition el : _attributes) {
        {
          boolean _many = this._commObjectGenHelpers.getMany(el);
          if (_many) {
            {
              AbstractAttributeType _type = el.getType();
              if ((_type instanceof PrimitiveType)) {
                _builder.append("\t");
                _builder.append("typedef std::vector<");
                String _compileCppType = this._commObjectGenHelpers.compileCppType(el.getType());
                _builder.append(_compileCppType, "\t");
                _builder.append("> ");
                String _name = co.getName();
                _builder.append(_name, "\t");
                _builder.append("_");
                String _name_1 = el.getName();
                _builder.append(_name_1, "\t");
                _builder.append("_type;");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("typedef std::vector<");
                CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(el.getType());
                _builder.append(_repoNamespace_1, "\t");
                _builder.append("IDL::");
                String _typeName = this._communicationObjectUtility.getTypeName(el.getType());
                _builder.append(_typeName, "\t");
                _builder.append("> ");
                String _name_2 = co.getName();
                _builder.append(_name_2, "\t");
                _builder.append("_");
                String _name_3 = el.getName();
                _builder.append(_name_3, "\t");
                _builder.append("_type;");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("struct ");
    CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    {
      EList<AttributeDefinition> _attributes_1 = co.getAttributes();
      for(final AttributeDefinition el_1 : _attributes_1) {
        {
          boolean _many_1 = this._commObjectGenHelpers.getMany(el_1);
          if (_many_1) {
            _builder.append("\t\t");
            String _name_4 = co.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append("_");
            String _name_5 = el_1.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("_type ");
            String _name_6 = el_1.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          } else {
            {
              AbstractAttributeType _type_1 = el_1.getType();
              if ((_type_1 instanceof PrimitiveType)) {
                _builder.append("\t\t");
                String _compileCppType_1 = this._commObjectGenHelpers.compileCppType(el_1.getType());
                _builder.append(_compileCppType_1, "\t\t");
                _builder.append(" ");
                String _name_7 = el_1.getName();
                _builder.append(_name_7, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t\t");
                CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace(el_1.getType());
                _builder.append(_repoNamespace_2, "\t\t");
                _builder.append("IDL::");
                CharSequence _compileType = this._commObjectGenHelpers.compileType(el_1.getType());
                _builder.append(_compileType, "\t\t");
                _builder.append(" ");
                String _name_8 = el_1.getName();
                _builder.append(_name_8, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    _builder.append("  \t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif /* ");
    CharSequence _idlHeaderDefine_2 = this._commObjectGenHelpers.getIdlHeaderDefine(co);
    _builder.append(_idlHeaderDefine_2);
    _builder.append(" */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence compileSerializationHeader(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef ");
    CharSequence _serializationHeaderDefine = this._commObjectGenHelpers.getSerializationHeaderDefine(co);
    _builder.append(_serializationHeaderDefine);
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    CharSequence _serializationHeaderDefine_1 = this._commObjectGenHelpers.getSerializationHeaderDefine(co);
    _builder.append(_serializationHeaderDefine_1);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("/");
    CharSequence _userClassHeaderFileName = this._commObjectGenHelpers.getUserClassHeaderFileName(co);
    _builder.append(_userClassHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <ace/CDR_Stream.h>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// serialization operator for DataStructure ");
    String _name = co.getName();
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    _builder.append("ACE_CDR::Boolean operator<<(ACE_OutputCDR &cdr, const ");
    CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_1);
    _builder.append("IDL::");
    CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName);
    _builder.append(" &data);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// de-serialization operator for DataStructure ");
    String _name_1 = co.getName();
    _builder.append(_name_1);
    _builder.newLineIfNotEmpty();
    _builder.append("ACE_CDR::Boolean operator>>(ACE_InputCDR &cdr, ");
    CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_2);
    _builder.append("IDL::");
    CharSequence _idlStructName_1 = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName_1);
    _builder.append(" &data);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// serialization operator for CommunicationObject ");
    String _name_2 = co.getName();
    _builder.append(_name_2);
    _builder.newLineIfNotEmpty();
    _builder.append("ACE_CDR::Boolean operator<<(ACE_OutputCDR &cdr, const ");
    CharSequence _repoNamespace_3 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_3);
    _builder.append("::");
    CharSequence _idlStructName_2 = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName_2);
    _builder.append(" &obj);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// de-serialization operator for CommunicationObject ");
    String _name_3 = co.getName();
    _builder.append(_name_3);
    _builder.newLineIfNotEmpty();
    _builder.append("ACE_CDR::Boolean operator>>(ACE_InputCDR &cdr, ");
    CharSequence _repoNamespace_4 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_4);
    _builder.append("::");
    CharSequence _idlStructName_3 = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName_3);
    _builder.append(" &obj);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#endif /* ");
    CharSequence _serializationHeaderDefine_2 = this._commObjectGenHelpers.getSerializationHeaderDefine(co);
    _builder.append(_serializationHeaderDefine_2);
    _builder.append(" */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence compileSerializationSource(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("/");
    CharSequence _serializationHeaderFileName = this._commObjectGenHelpers.getSerializationHeaderFileName(co);
    _builder.append(_serializationHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include <ace/SString.h>");
    _builder.newLine();
    {
      Set<String> _generateSerializationInclude = this._commObjectGenHelpers.generateSerializationInclude(co.getAttributes());
      for(final String inc : _generateSerializationInclude) {
        _builder.append(inc);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("// serialization operator for element ");
    String _name = co.getName();
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    _builder.append("ACE_CDR::Boolean operator<<(ACE_OutputCDR &cdr, const ");
    CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_1);
    _builder.append("IDL::");
    CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName);
    _builder.append(" &data)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ACE_CDR::Boolean good_bit = true;");
    _builder.newLine();
    _builder.append("\t");
    String _generateOutputCdrOperator = this._commObjectMarshalling.generateOutputCdrOperator(co);
    _builder.append(_generateOutputCdrOperator, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return good_bit;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// de-serialization operator for element ");
    String _name_1 = co.getName();
    _builder.append(_name_1);
    _builder.newLineIfNotEmpty();
    _builder.append("ACE_CDR::Boolean operator>>(ACE_InputCDR &cdr, ");
    CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_2);
    _builder.append("IDL::");
    CharSequence _idlStructName_1 = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName_1);
    _builder.append(" &data)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ACE_CDR::Boolean good_bit = true;");
    _builder.newLine();
    _builder.append("\t");
    String _generateInputCdrOperator = this._commObjectMarshalling.generateInputCdrOperator(co);
    _builder.append(_generateInputCdrOperator, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return good_bit;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// serialization operator for CommunicationObject ");
    String _name_2 = co.getName();
    _builder.append(_name_2);
    _builder.newLineIfNotEmpty();
    _builder.append("ACE_CDR::Boolean operator<<(ACE_OutputCDR &cdr, const ");
    CharSequence _repoNamespace_3 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_3);
    _builder.append("::");
    CharSequence _idlStructName_2 = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName_2);
    _builder.append(" &obj)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return cdr << obj.get();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// de-serialization operator for CommunicationObject ");
    String _name_3 = co.getName();
    _builder.append(_name_3);
    _builder.newLineIfNotEmpty();
    _builder.append("ACE_CDR::Boolean operator>>(ACE_InputCDR &cdr, ");
    CharSequence _repoNamespace_4 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_4);
    _builder.append("::");
    CharSequence _idlStructName_3 = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName_3);
    _builder.append(" &obj)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return cdr >> obj.set();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Compile the BaseClass-HeaderFile of a communication object
   */
  public CharSequence compileBaseClassH(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef ");
    CharSequence _baseClassHeaderDefine = this._commObjectGenHelpers.getBaseClassHeaderDefine(co);
    _builder.append(_baseClassHeaderDefine);
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    CharSequence _baseClassHeaderDefine_1 = this._commObjectGenHelpers.getBaseClassHeaderDefine(co);
    _builder.append(_baseClassHeaderDefine_1);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("/");
    CharSequence _idlHeaderFileName = this._commObjectGenHelpers.getIdlHeaderFileName(co);
    _builder.append(_idlHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    {
      Set<String> _generateClassInclude = this._commObjectGenHelpers.generateClassInclude(co.getAttributes());
      for(final String inc : _generateClassInclude) {
        _builder.append(inc);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.append("#include <list>");
    _builder.newLine();
    {
      final Function1<AttributeDefinition, Boolean> _function = (AttributeDefinition e) -> {
        return Boolean.valueOf(this._commObjectGenHelpers.getMany(e));
      };
      final Function1<AttributeDefinition, Boolean> _function_1 = (AttributeDefinition e) -> {
        return Boolean.valueOf(this._communicationObjectUtility.isStringType(e.getType()));
      };
      boolean _exists = IterableExtensions.<AttributeDefinition>exists(IterableExtensions.<AttributeDefinition>filter(co.getAttributes(), _function), _function_1);
      if (_exists) {
        _builder.append("#include <algorithm> // for using std::transform");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("namespace ");
    CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_1);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("class ");
    CharSequence _baseClassName = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("protected:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// data structure");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_2, "\t");
    _builder.append("IDL::");
    CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName, "\t");
    _builder.append(" ");
    CharSequence _idlInstanceName = this._commObjectGenHelpers.getIdlInstanceName(co);
    _builder.append(_idlInstanceName, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// give a publicly accessible type-name for the template parameter IDL");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("typedef ");
    CharSequence _repoNamespace_3 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_3, "\t");
    _builder.append("IDL::");
    CharSequence _idlStructName_1 = this._commObjectGenHelpers.getIdlStructName(co);
    _builder.append(_idlStructName_1, "\t");
    _builder.append(" DATATYPE;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("#ifdef ENABLE_HASH");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("static size_t generateDataHash(const DATATYPE &);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("#endif");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static const char* getCompiledHash();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static void getAllHashValues(std::list<std::string> &hashes);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static void checkAllHashValues(std::list<std::string> &hashes);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// default constructors");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _baseClassName_1 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_1, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _baseClassName_2 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_2, "\t");
    _builder.append("(const DATATYPE &data);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("// default destructor");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ~");
    CharSequence _baseClassName_3 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_3, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("const DATATYPE& get() const { return ");
    CharSequence _idlInstanceName_1 = this._commObjectGenHelpers.getIdlInstanceName(co);
    _builder.append(_idlInstanceName_1, "\t");
    _builder.append("; }");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("operator const DATATYPE&() const { return ");
    CharSequence _idlInstanceName_2 = this._commObjectGenHelpers.getIdlInstanceName(co);
    _builder.append(_idlInstanceName_2, "\t");
    _builder.append("; }");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("DATATYPE& set() { return ");
    CharSequence _idlInstanceName_3 = this._commObjectGenHelpers.getIdlInstanceName(co);
    _builder.append(_idlInstanceName_3, "\t");
    _builder.append("; }");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static inline std::string identifier(void) { return \"");
    CharSequence _repoNamespace_4 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_4, "\t");
    _builder.append("::");
    CharSequence _userClassName = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName, "\t");
    _builder.append("\"; }");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// helper method to easily implement output stream in derived classes");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void to_ostream(std::ostream &os = std::cout) const;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// convert to xml stream");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void to_xml(std::ostream &os, const std::string &indent = \"\") const;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// restore from xml stream");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void from_xml(std::istream &is);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// User Interface");
    _builder.newLine();
    {
      EList<AttributeDefinition> _attributes = co.getAttributes();
      for(final AttributeDefinition el : _attributes) {
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// getter and setter for element ");
        String _firstUpper = StringExtensions.toFirstUpper(el.getName());
        _builder.append(_firstUpper, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateGetterMethod = this._getterAndSetterGenHelper.generateGetterMethod(el, this._commObjectGenHelpers.getIdlInstanceName(co));
        _builder.append(_generateGetterMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateSetterMethod = this._getterAndSetterGenHelper.generateSetterMethod(el, this._commObjectGenHelpers.getIdlInstanceName(co), this._commObjectGenHelpers.getBaseClassName(co));
        _builder.append(_generateSetterMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} /* namespace ");
    CharSequence _repoNamespace_5 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_5);
    _builder.append(" */");
    _builder.newLineIfNotEmpty();
    _builder.append("#endif /* ");
    CharSequence _baseClassHeaderDefine_2 = this._commObjectGenHelpers.getBaseClassHeaderDefine(co);
    _builder.append(_baseClassHeaderDefine_2);
    _builder.append(" */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * Compile the BaseClass-SourceFile of a communication object
   */
  public CharSequence compileBaseClassCpp(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("/");
    CharSequence _baseClassHeaderFileName = this._commObjectGenHelpers.getBaseClassHeaderFileName(co);
    _builder.append(_baseClassHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// serialization/deserialization operators");
    _builder.newLine();
    _builder.append("//#include \"");
    CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_1);
    _builder.append("/");
    CharSequence _serializationHeaderFileName = this._commObjectGenHelpers.getSerializationHeaderFileName(co);
    _builder.append(_serializationHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// include the hash.idl containing the hash constant");
    _builder.newLine();
    _builder.append("#include \"hash.hh\"");
    _builder.newLine();
    _builder.append("#include <assert.h>");
    _builder.newLine();
    _builder.append("#include <cstring>");
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// SmartUtils used in from_xml method");
    _builder.newLine();
    _builder.append("#include \"smartKnuthMorrisPratt.hh\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#ifdef ENABLE_HASH");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("#include <boost/functional/hash.hpp>");
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    _builder.newLine();
    _builder.append("namespace ");
    CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_2);
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("const char* ");
    CharSequence _baseClassName = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName, "\t");
    _builder.append("::getCompiledHash()");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _repoNamespace_3 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_3, "\t\t");
    _builder.append("IDL::REPO_HASH;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void ");
    CharSequence _baseClassName_1 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_1, "\t");
    _builder.append("::getAllHashValues(std::list<std::string> &hashes)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// get own hash value");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("hashes.push_back(getCompiledHash());");
    _builder.newLine();
    {
      final Function1<AttributeDefinition, Boolean> _function = (AttributeDefinition e) -> {
        return Boolean.valueOf(this._communicationObjectUtility.isCommunicationObject(e.getType()));
      };
      Iterable<AttributeDefinition> _filter = IterableExtensions.<AttributeDefinition>filter(co.getAttributes(), _function);
      for(final AttributeDefinition coref : _filter) {
        _builder.append("\t\t");
        _builder.append("// get hash value(s) for ");
        CommunicationObject _communicationObjectRef = this._communicationObjectUtility.getCommunicationObjectRef(coref.getType());
        CharSequence _repoNamespace_4 = null;
        if (_communicationObjectRef!=null) {
          _repoNamespace_4=this._commObjectGenHelpers.getRepoNamespace(_communicationObjectRef);
        }
        _builder.append(_repoNamespace_4, "\t\t");
        _builder.append("::");
        CommunicationObject _communicationObjectRef_1 = this._communicationObjectUtility.getCommunicationObjectRef(coref.getType());
        CharSequence _userClassName = null;
        if (_communicationObjectRef_1!=null) {
          _userClassName=this._commObjectGenHelpers.getUserClassName(_communicationObjectRef_1);
        }
        _builder.append(_userClassName, "\t\t");
        _builder.append("(");
        CharSequence _idlInstanceName = this._commObjectGenHelpers.getIdlInstanceName(co);
        _builder.append(_idlInstanceName, "\t\t");
        _builder.append(".");
        String _name = coref.getName();
        _builder.append(_name, "\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CommunicationObject _communicationObjectRef_2 = this._communicationObjectUtility.getCommunicationObjectRef(coref.getType());
        CharSequence _repoNamespace_5 = null;
        if (_communicationObjectRef_2!=null) {
          _repoNamespace_5=this._commObjectGenHelpers.getRepoNamespace(_communicationObjectRef_2);
        }
        _builder.append(_repoNamespace_5, "\t\t");
        _builder.append("::");
        CommunicationObject _communicationObjectRef_3 = this._communicationObjectUtility.getCommunicationObjectRef(coref.getType());
        CharSequence _userClassName_1 = null;
        if (_communicationObjectRef_3!=null) {
          _userClassName_1=this._commObjectGenHelpers.getUserClassName(_communicationObjectRef_3);
        }
        _builder.append(_userClassName_1, "\t\t");
        _builder.append("::getAllHashValues(hashes);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void ");
    CharSequence _baseClassName_2 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_2, "\t");
    _builder.append("::checkAllHashValues(std::list<std::string> &hashes)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// check own hash value");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (strcmp(getCompiledHash(), hashes.front().c_str()) != 0)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("std::cerr << \"###################################################\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("std::cerr << \"WARNING: HASHES OF COMMUNICATION OBJECTS MISSMATCH!\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("std::cerr << \"");
    CharSequence _baseClassName_3 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_3, "\t\t\t");
    _builder.append(" hash\" << std::endl;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("std::cerr << \"Expected: \" << getCompiledHash() << std::endl;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("std::cerr << \"Received: \" << hashes.front() << std::endl;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("std::cerr << \"###################################################\" << std::endl;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("assert(strcmp(getCompiledHash(), hashes.front().c_str()) == 0);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("hashes.pop_front();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    {
      final Function1<AttributeDefinition, Boolean> _function_1 = (AttributeDefinition e) -> {
        return Boolean.valueOf(this._communicationObjectUtility.isCommunicationObject(e.getType()));
      };
      Iterable<AttributeDefinition> _filter_1 = IterableExtensions.<AttributeDefinition>filter(co.getAttributes(), _function_1);
      for(final AttributeDefinition coref_1 : _filter_1) {
        _builder.append("\t\t");
        _builder.append("// check hash value(s) for ");
        CommunicationObject _communicationObjectRef_4 = this._communicationObjectUtility.getCommunicationObjectRef(coref_1.getType());
        CharSequence _repoNamespace_6 = null;
        if (_communicationObjectRef_4!=null) {
          _repoNamespace_6=this._commObjectGenHelpers.getRepoNamespace(_communicationObjectRef_4);
        }
        _builder.append(_repoNamespace_6, "\t\t");
        _builder.append("::");
        CommunicationObject _communicationObjectRef_5 = this._communicationObjectUtility.getCommunicationObjectRef(coref_1.getType());
        CharSequence _userClassName_2 = null;
        if (_communicationObjectRef_5!=null) {
          _userClassName_2=this._commObjectGenHelpers.getUserClassName(_communicationObjectRef_5);
        }
        _builder.append(_userClassName_2, "\t\t");
        _builder.append("(");
        CharSequence _idlInstanceName_1 = this._commObjectGenHelpers.getIdlInstanceName(co);
        _builder.append(_idlInstanceName_1, "\t\t");
        _builder.append(".");
        String _name_1 = coref_1.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CommunicationObject _communicationObjectRef_6 = this._communicationObjectUtility.getCommunicationObjectRef(coref_1.getType());
        CharSequence _repoNamespace_7 = null;
        if (_communicationObjectRef_6!=null) {
          _repoNamespace_7=this._commObjectGenHelpers.getRepoNamespace(_communicationObjectRef_6);
        }
        _builder.append(_repoNamespace_7, "\t\t");
        _builder.append("::");
        CommunicationObject _communicationObjectRef_7 = this._communicationObjectUtility.getCommunicationObjectRef(coref_1.getType());
        CharSequence _userClassName_3 = null;
        if (_communicationObjectRef_7!=null) {
          _userClassName_3=this._commObjectGenHelpers.getUserClassName(_communicationObjectRef_7);
        }
        _builder.append(_userClassName_3, "\t\t");
        _builder.append("::checkAllHashValues(hashes);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("#ifdef ENABLE_HASH");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("size_t ");
    CharSequence _baseClassName_4 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_4, "\t");
    _builder.append("::generateDataHash(const DATATYPE &data)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("size_t seed = 0;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    String _generateDataHash = this._commObjectMarshalling.generateDataHash(co);
    _builder.append(_generateDataHash, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return seed;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("#endif");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// default constructor");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _baseClassName_5 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_5, "\t");
    _builder.append("::");
    CharSequence _baseClassName_6 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_6, "\t");
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(":\t");
    CharSequence _idlInstanceName_2 = this._commObjectGenHelpers.getIdlInstanceName(co);
    _builder.append(_idlInstanceName_2, "\t");
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{  ");
    _builder.newLine();
    _builder.append("\t\t");
    String _generateDefaultConstructorContent = this._constructorParamGenHelper.generateDefaultConstructorContent(co);
    _builder.append(_generateDefaultConstructorContent, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _baseClassName_7 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_7, "\t");
    _builder.append("::");
    CharSequence _baseClassName_8 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_8, "\t");
    _builder.append("(const DATATYPE &data)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(":\t");
    CharSequence _idlInstanceName_3 = this._commObjectGenHelpers.getIdlInstanceName(co);
    _builder.append(_idlInstanceName_3, "\t");
    _builder.append("(data)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _baseClassName_9 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_9, "\t");
    _builder.append("::~");
    CharSequence _baseClassName_10 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_10, "\t");
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{  }");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void ");
    CharSequence _baseClassName_11 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_11, "\t");
    _builder.append("::to_ostream(std::ostream &os) const");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t  ");
    String _generateSTLOutputStream = this._commObjectMarshalling.generateSTLOutputStream(co);
    _builder.append(_generateSTLOutputStream, "\t  ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// convert to xml stream");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void ");
    CharSequence _baseClassName_12 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_12, "\t");
    _builder.append("::to_xml(std::ostream &os, const std::string &indent) const {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    String _generateXmlOutputStream = this._commObjectMarshalling.generateXmlOutputStream(co);
    _builder.append(_generateXmlOutputStream, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// restore from xml stream");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void ");
    CharSequence _baseClassName_13 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_13, "\t");
    _builder.append("::from_xml(std::istream &is) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    String _generateXmlInputStream = this._commObjectMarshalling.generateXmlInputStream(co);
    _builder.append(_generateXmlInputStream, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/*");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void ");
    CharSequence _baseClassName_14 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_14, "\t");
    _builder.append("::get(ACE_Message_Block *&msg) const");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// start with a default internal buffer size(will automatically grow if needed)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ACE_OutputCDR cdr(ACE_DEFAULT_CDR_BUFSIZE);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _repoNamespace_8 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_8, "\t\t");
    _builder.append("IDL::HashList hashes;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("getAllHashValues(hashes);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("cdr << static_cast<ACE_CDR::Long>(hashes.size());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for(");
    CharSequence _repoNamespace_9 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_9, "\t\t");
    _builder.append("IDL::HashList::const_iterator it=hashes.begin(); it!=hashes.end(); it++)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("cdr << ACE_CString(it->c_str());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// Here the actual serialization takes place using the OutputCDR serialization operator<<");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// (see ");
    CharSequence _serializationHeaderFileName_1 = this._commObjectGenHelpers.getSerializationHeaderFileName(co);
    _builder.append(_serializationHeaderFileName_1, "\t\t");
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("cdr << ");
    CharSequence _idlInstanceName_4 = this._commObjectGenHelpers.getIdlInstanceName(co);
    _builder.append(_idlInstanceName_4, "\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("#ifdef ENABLE_HASH");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ACE_CDR::ULong data_hash = generateDataHash(");
    CharSequence _idlInstanceName_5 = this._commObjectGenHelpers.getIdlInstanceName(co);
    _builder.append(_idlInstanceName_5, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("cdr << data_hash;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// std::cout << \"");
    CharSequence _baseClassName_15 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_15, "\t\t");
    _builder.append(": current data hash: \" << data_hash << std::endl;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("#endif");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// return a shallow copy of the serialized message ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// (no data is actually copied, only the internal reference counter is incremented)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// in order to prevent memory leaks the caller of this get(msg) method must");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// manually free the memory by calling the release() method of the message block msg");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("msg = cdr.begin()->duplicate();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void ");
    CharSequence _baseClassName_16 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_16, "\t");
    _builder.append("::set(const ACE_Message_Block *msg)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ACE_InputCDR cdr(msg);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _repoNamespace_10 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_10, "\t\t");
    _builder.append("IDL::HashList hashes;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("ACE_CDR::Long hashes_size;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("cdr >> hashes_size;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for(int i=0; i<hashes_size; ++i) ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("ACE_CString hash;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("cdr >> hash;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("hashes.push_back(hash.c_str());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("checkAllHashValues(hashes);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// Here the actual de-serialization takes place using the InputCDR serialization operator>>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// (see ");
    CharSequence _serializationHeaderFileName_2 = this._commObjectGenHelpers.getSerializationHeaderFileName(co);
    _builder.append(_serializationHeaderFileName_2, "\t\t");
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("cdr >> ");
    CharSequence _idlInstanceName_6 = this._commObjectGenHelpers.getIdlInstanceName(co);
    _builder.append(_idlInstanceName_6, "\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("#ifdef ENABLE_HASH");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ACE_CDR::Long data_hash;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("cdr >> data_hash;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ACE_CDR::Long own_hash = generateDataHash(");
    CharSequence _idlInstanceName_7 = this._commObjectGenHelpers.getIdlInstanceName(co);
    _builder.append(_idlInstanceName_7, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("assert(data_hash == own_hash);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// std::cout << \"");
    CharSequence _baseClassName_17 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_17, "\t\t");
    _builder.append(": own data hash: \" << own_hash << \"; received data hash: \" << data_hash << std::endl;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("#endif");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("} /* namespace ");
    CharSequence _repoNamespace_11 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_11);
    _builder.append(" */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * Compile the UserClass-HeaderFile of a communication object
   */
  public CharSequence compileDerivedHeaderFile(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef ");
    CharSequence _userClassHeaderDefine = this._commObjectGenHelpers.getUserClassHeaderDefine(co);
    _builder.append(_userClassHeaderDefine);
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    CharSequence _userClassHeaderDefine_1 = this._commObjectGenHelpers.getUserClassHeaderDefine(co);
    _builder.append(_userClassHeaderDefine_1);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("/");
    CharSequence _baseClassHeaderFileName = this._commObjectGenHelpers.getBaseClassHeaderFileName(co);
    _builder.append(_baseClassHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("namespace ");
    CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_1);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("class ");
    CharSequence _userClassName = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName);
    _builder.append(" : public ");
    CharSequence _baseClassName = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// default constructors");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _userClassName_1 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_1, "\t\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* Constructor to set all values.");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* NOTE that you have to keep this constructor consistent with the model!");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* Use  at your own choice.");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* The preferred way to set values for initialization is:");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("*      CommRepository::MyCommObject obj;");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("*      obj.setX(1).setY(2).setZ(3)...;");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// ");
    CharSequence _userClassName_2 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_2, "\t\t");
    _builder.append("(");
    String _generateConstructorHeaderParameters = this._constructorParamGenHelper.generateConstructorHeaderParameters(co);
    _builder.append(_generateConstructorHeaderParameters, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _userClassName_3 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_3, "\t\t");
    _builder.append("(const ");
    CharSequence _baseClassName_1 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_1, "\t\t");
    _builder.append(" &");
    String _firstLower = StringExtensions.toFirstLower(co.getName());
    _builder.append(_firstLower, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _userClassName_4 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_4, "\t\t");
    _builder.append("(const DATATYPE &");
    String _firstLower_1 = StringExtensions.toFirstLower(co.getName());
    _builder.append(_firstLower_1, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("virtual ~");
    CharSequence _userClassName_5 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_5, "\t\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// use framework specific getter and setter methods from core (base) class");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("using ");
    CharSequence _baseClassName_2 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_2, "\t\t");
    _builder.append("::get;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("using ");
    CharSequence _baseClassName_3 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_3, "\t\t");
    _builder.append("::set;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// feel free to add customized methods here");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("inline std::ostream &operator<<(std::ostream &os, const ");
    CharSequence _userClassName_6 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_6);
    _builder.append(" &co)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("co.to_ostream(os);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return os;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("} /* namespace ");
    CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_2);
    _builder.append(" */");
    _builder.newLineIfNotEmpty();
    _builder.append("#endif /* ");
    CharSequence _userClassHeaderDefine_2 = this._commObjectGenHelpers.getUserClassHeaderDefine(co);
    _builder.append(_userClassHeaderDefine_2);
    _builder.append(" */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * Compile the UserClass-HeaderFile of a communication object
   */
  public CharSequence compileDerivedSourceFile(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace);
    _builder.append("/");
    CharSequence _userClassHeaderFileName = this._commObjectGenHelpers.getUserClassHeaderFileName(co);
    _builder.append(_userClassHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("using namespace ");
    CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace(co);
    _builder.append(_repoNamespace_1);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _userClassName = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName);
    _builder.append("::");
    CharSequence _userClassName_1 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_1);
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append(":\t");
    CharSequence _baseClassName = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName);
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Constructor to set all values.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* NOTE that you have to keep this constructor consistent with the model!");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Use  at your own choice.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* The preferred way to set values for initialization is:");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*      CommRepository::MyCommObject obj;");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*      obj.setX(1).setY(2).setZ(3)...;");
    _builder.newLine();
    CharSequence _userClassName_2 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_2);
    _builder.append("::");
    CharSequence _userClassName_3 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_3);
    _builder.append("(");
    String _generateConstructorSourceParameters = this._constructorParamGenHelper.generateConstructorSourceParameters(co);
    _builder.append(_generateConstructorSourceParameters);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append(":\t");
    CharSequence _baseClassName_1 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_1);
    _builder.append("() // base constructor sets default values as defined in the model");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      EList<AttributeDefinition> _attributes = co.getAttributes();
      for(final AttributeDefinition el : _attributes) {
        _builder.append("\t");
        _builder.append("set");
        String _firstUpper = StringExtensions.toFirstUpper(el.getName());
        _builder.append(_firstUpper, "\t");
        _builder.append("(");
        String _name = el.getName();
        _builder.append(_name, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    CharSequence _userClassName_4 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_4);
    _builder.append("::");
    CharSequence _userClassName_5 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_5);
    _builder.append("(const ");
    CharSequence _baseClassName_2 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_2);
    _builder.append(" &");
    String _firstLower = StringExtensions.toFirstLower(co.getName());
    _builder.append(_firstLower);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append(":\t");
    CharSequence _baseClassName_3 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_3);
    _builder.append("(");
    String _firstLower_1 = StringExtensions.toFirstLower(co.getName());
    _builder.append(_firstLower_1);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    CharSequence _userClassName_6 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_6);
    _builder.append("::");
    CharSequence _userClassName_7 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_7);
    _builder.append("(const DATATYPE &");
    String _firstLower_2 = StringExtensions.toFirstLower(co.getName());
    _builder.append(_firstLower_2);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append(":\t");
    CharSequence _baseClassName_4 = this._commObjectGenHelpers.getBaseClassName(co);
    _builder.append(_baseClassName_4);
    _builder.append("(");
    String _firstLower_3 = StringExtensions.toFirstLower(co.getName());
    _builder.append(_firstLower_3);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    CharSequence _userClassName_8 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_8);
    _builder.append("::~");
    CharSequence _userClassName_9 = this._commObjectGenHelpers.getUserClassName(co);
    _builder.append(_userClassName_9);
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    return _builder;
  }
}
