/**
 * Copyright (c) 2013 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component.params;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.SingleValue;
import org.eclipse.smartmdsd.ecore.base.documentation.AbstractDocumentationElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentParameter.AbstractComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterBase;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedTrigger;
import org.eclipse.smartmdsd.ecore.component.componentParameter.InternalParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterSetInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.TriggerInstance;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.AbstractParameter;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetRepository;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.TriggerDefinition;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.ExtendedOutputConfigurationProvider;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponent;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.params.ComponentParamsGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class SmartComponentParameter {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private SmartComponent _smartComponent;
  
  @Inject
  @Extension
  private ComponentParamsGenHelpers _componentParamsGenHelpers;
  
  @Inject
  @Extension
  private ComponentParameterModelUtility _componentParameterModelUtility;
  
  public String ParameterUpdateHandlerHeaderFileName(final ComponentParameter h) {
    return "ParameterUpdateHandler.hh";
  }
  
  public String ParameterUpdateHandlerSourceFileName(final ComponentParameter h) {
    return "ParameterUpdateHandler.cc";
  }
  
  public String TriggerHandlerCoreHeaderFileName(final ComponentParameter h) {
    return "TriggerHandlerCore.hh";
  }
  
  public String TriggerHandlerCoreSourceFileName(final ComponentParameter h) {
    return "TriggerHandlerCore.cc";
  }
  
  public String TriggerHandlerHeaderFileName(final ComponentParameter h) {
    return "TriggerHandler.hh";
  }
  
  public String TriggerHandlerSourceFileName(final ComponentParameter h) {
    return "TriggerHandler.cc";
  }
  
  public String ParameterStateStructCoreHeaderFileName(final ComponentParameter h) {
    return "ParameterStateStructCore.hh";
  }
  
  public String ParameterStateStructHeaderFileName(final ComponentParameter h) {
    return "ParameterStateStruct.hh";
  }
  
  public String ParameterStateStructSourceFileName(final ComponentParameter h) {
    return "ParameterStateStruct.cc";
  }
  
  public String ParameterIniFileName(final ComponentParameter h) {
    String _name = h.getComponent().getName();
    return (_name + ".ini.bottom");
  }
  
  public String ParameterIniFileHeadName(final ComponentParameter h) {
    String _name = h.getComponent().getName();
    return (_name + ".ini.head");
  }
  
  public String ParameterIniFileTemplateName(final ComponentParameter h) {
    String _name = h.getComponent().getName();
    return (_name + ".ini.template");
  }
  
  public void CreateSmartComponentParameterSlave(final ComponentParameter p, final IFileSystemAccess2 fsa) {
    final CharSequence iniFileBottomContent = this.compileIniFile(p);
    fsa.generateFile(this.ParameterIniFileName(p), ExtendedOutputConfigurationProvider.SRC_GEN_PARAMS, iniFileBottomContent);
    boolean _isFile = fsa.isFile(this.ParameterIniFileHeadName(p));
    if (_isFile) {
      final String iniFileHeadContent = fsa.readTextFile(this.ParameterIniFileHeadName(p)).toString();
      fsa.generateFile(this.ParameterIniFileTemplateName(p), (iniFileHeadContent + iniFileBottomContent));
    }
    fsa.generateFile(this.ParameterStateStructCoreHeaderFileName(p), ExtendedOutputConfigurationProvider.SRC_GEN_PARAMS, this.compileStructCore(p));
    fsa.generateFile(this.ParameterUpdateHandlerHeaderFileName(p), ExtendedOutputConfigurationProvider.SRC_GEN_PARAMS, this.compileUpdateHandlerHH(p));
    fsa.generateFile(this.ParameterUpdateHandlerSourceFileName(p), ExtendedOutputConfigurationProvider.SRC_GEN_PARAMS, this.compileUpdateHandlerCC(p));
    if ((IterableExtensions.<ParameterSetInstance>exists(Iterables.<ParameterSetInstance>filter(p.getParameters(), ParameterSetInstance.class), ((Function1<ParameterSetInstance, Boolean>) (ParameterSetInstance pi) -> {
      final Function1<AbstractParameter, Boolean> _function = (AbstractParameter pd) -> {
        return Boolean.valueOf((pd instanceof TriggerDefinition));
      };
      return Boolean.valueOf(IterableExtensions.<AbstractParameter>exists(pi.getParamSet().getParameters(), _function));
    })) || IterableExtensions.<AbstractComponentParameter>exists(p.getParameters(), ((Function1<AbstractComponentParameter, Boolean>) (AbstractComponentParameter tr) -> {
      return Boolean.valueOf((tr instanceof ExtendedTrigger));
    })))) {
      fsa.generateFile(this.TriggerHandlerCoreHeaderFileName(p), ExtendedOutputConfigurationProvider.SRC_GEN_PARAMS, this.compileTriggerHandlerCoreHH(p));
      fsa.generateFile(this.TriggerHandlerCoreSourceFileName(p), ExtendedOutputConfigurationProvider.SRC_GEN_PARAMS, this.compileTriggerHandlerCoreCC(p));
      fsa.generateFile(this.TriggerHandlerHeaderFileName(p), ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileTriggerHandlerHH(p));
      fsa.generateFile(this.TriggerHandlerSourceFileName(p), ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileTriggerHandlerCC(p));
    } else {
    }
    fsa.generateFile(this.ParameterStateStructHeaderFileName(p), ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileStructHH(p));
    fsa.generateFile(this.ParameterStateStructSourceFileName(p), ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.compileStructCC(p));
  }
  
  private String _getFullyQualifiedName(final ParameterDefinition par) {
    EObject _eContainer = par.eContainer();
    ParameterSetDefinition set = ((ParameterSetDefinition) _eContainer);
    String _fullyQualifiedName = this.getFullyQualifiedName(set);
    String _plus = (_fullyQualifiedName + ".");
    String _name = par.getName();
    String result = (_plus + _name);
    return result;
  }
  
  private String _getFullyQualifiedVariableName(final ParameterDefinition par) {
    EObject _eContainer = par.eContainer();
    ParameterSetDefinition set = ((ParameterSetDefinition) _eContainer);
    String _fullyQualifiedVariableName = this.getFullyQualifiedVariableName(set);
    String _plus = (_fullyQualifiedVariableName + "_");
    String _name = par.getName();
    String result = (_plus + _name);
    return result;
  }
  
  private String _getFullyQualifiedName(final TriggerDefinition trig) {
    EObject _eContainer = trig.eContainer();
    ParameterSetDefinition set = ((ParameterSetDefinition) _eContainer);
    String _fullyQualifiedName = this.getFullyQualifiedName(set);
    String _plus = (_fullyQualifiedName + ".");
    String _name = trig.getName();
    String result = (_plus + _name);
    return result;
  }
  
  private String _getFullyQualifiedVariableName(final TriggerDefinition trig) {
    EObject _eContainer = trig.eContainer();
    ParameterSetDefinition set = ((ParameterSetDefinition) _eContainer);
    String _fullyQualifiedVariableName = this.getFullyQualifiedVariableName(set);
    String _plus = (_fullyQualifiedVariableName + "_");
    String _name = trig.getName();
    String result = (_plus + _name);
    return result;
  }
  
  private String _getFullyQualifiedName(final ParameterSetDefinition set) {
    EObject _eContainer = set.eContainer();
    ParameterSetRepository repo = ((ParameterSetRepository) _eContainer);
    String _name = repo.getName();
    String _plus = (_name + ".");
    String _name_1 = set.getName();
    String result = (_plus + _name_1);
    return result;
  }
  
  private String _getFullyQualifiedVariableName(final ParameterSetDefinition set) {
    EObject _eContainer = set.eContainer();
    ParameterSetRepository repo = ((ParameterSetRepository) _eContainer);
    String _name = repo.getName();
    String _plus = (_name + "_");
    String _name_1 = set.getName();
    String result = (_plus + _name_1);
    return result;
  }
  
  private String _generateTriggerAttributeDefinitions(final TriggerDefinition t) {
    String result = "";
    EList<AttributeDefinition> _attributes = t.getAttributes();
    for (final AttributeDefinition el : _attributes) {
      {
        Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(el);
        if ((_isArrayType).booleanValue()) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("const std::list<");
          String _compileCppType = this._componentParamsGenHelpers.compileCppType(el);
          _builder.append(_compileCppType);
          _builder.append("> &");
          String _name = el.getName();
          _builder.append(_name);
          String _plus = (result + _builder);
          result = _plus;
        } else {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("const ");
          String _compileCppType_1 = this._componentParamsGenHelpers.compileCppType(el);
          _builder_1.append(_compileCppType_1);
          _builder_1.append(" &");
          String _name_1 = el.getName();
          _builder_1.append(_name_1);
          String _plus_1 = (result + _builder_1);
          result = _plus_1;
        }
        AttributeDefinition _last = IterableExtensions.<AttributeDefinition>last(t.getAttributes());
        boolean _notEquals = (!Objects.equal(el, _last));
        if (_notEquals) {
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append(", ");
          String _plus_2 = (result + _builder_2);
          result = _plus_2;
        }
      }
    }
    return result;
  }
  
  private String _generateTriggerAttributeDefinitions(final ExtendedTrigger t) {
    String result = "";
    EList<AttributeDefinition> _attributes = t.getAttributes();
    for (final AttributeDefinition el : _attributes) {
      {
        Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(el);
        if ((_isArrayType).booleanValue()) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("const std::list<");
          String _compileCppType = this._componentParamsGenHelpers.compileCppType(el);
          _builder.append(_compileCppType);
          _builder.append("> &");
          String _name = el.getName();
          _builder.append(_name);
          String _plus = (result + _builder);
          result = _plus;
        } else {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("const ");
          String _compileCppType_1 = this._componentParamsGenHelpers.compileCppType(el);
          _builder_1.append(_compileCppType_1);
          _builder_1.append(" &");
          String _name_1 = el.getName();
          _builder_1.append(_name_1);
          String _plus_1 = (result + _builder_1);
          result = _plus_1;
        }
        AttributeDefinition _last = IterableExtensions.<AttributeDefinition>last(t.getAttributes());
        boolean _notEquals = (!Objects.equal(el, _last));
        if (_notEquals) {
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append(", ");
          String _plus_2 = (result + _builder_2);
          result = _plus_2;
        }
      }
    }
    return result;
  }
  
  private String _generateTriggerAttributeNames(final TriggerDefinition t, final String prefix) {
    String result = "";
    EList<AttributeDefinition> _attributes = t.getAttributes();
    for (final AttributeDefinition el : _attributes) {
      {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(prefix);
        String _name = el.getName();
        _builder.append(_name);
        String _plus = (result + _builder);
        result = _plus;
        AttributeDefinition _last = IterableExtensions.<AttributeDefinition>last(t.getAttributes());
        boolean _notEquals = (!Objects.equal(el, _last));
        if (_notEquals) {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append(", ");
          String _plus_1 = (result + _builder_1);
          result = _plus_1;
        }
      }
    }
    return result;
  }
  
  private String _generateTriggerAttributeNames(final ExtendedTrigger t, final String prefix) {
    String result = "";
    EList<AttributeDefinition> _attributes = t.getAttributes();
    for (final AttributeDefinition el : _attributes) {
      {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(prefix);
        String _name = el.getName();
        _builder.append(_name);
        String _plus = (result + _builder);
        result = _plus;
        AttributeDefinition _last = IterableExtensions.<AttributeDefinition>last(t.getAttributes());
        boolean _notEquals = (!Objects.equal(el, _last));
        if (_notEquals) {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append(", ");
          String _plus_1 = (result + _builder_1);
          result = _plus_1;
        }
      }
    }
    return result;
  }
  
  public boolean hasActiveTriggers(final ComponentParameter usage) {
    Iterable<ParameterSetInstance> _filter = Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class);
    for (final ParameterSetInstance inst : _filter) {
      final Function1<TriggerInstance, Boolean> _function = (TriggerInstance t) -> {
        return Boolean.valueOf(t.isActive());
      };
      boolean _exists = IterableExtensions.<TriggerInstance>exists(Iterables.<TriggerInstance>filter(inst.getParameterInstances(), TriggerInstance.class), _function);
      if (_exists) {
        return true;
      }
    }
    Iterable<ExtendedTrigger> _filter_1 = Iterables.<ExtendedTrigger>filter(usage.getParameters(), ExtendedTrigger.class);
    for (final ExtendedTrigger extTr : _filter_1) {
      boolean _isActive = extTr.isActive();
      if (_isActive) {
        return true;
      }
    }
    return false;
  }
  
  public CharSequence compileTriggerHandlerCoreHH(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _TRIGGERHANDLERCORE_HH");
    _builder.newLine();
    _builder.append("#define _TRIGGERHANDLERCORE_HH");
    _builder.newLine();
    _builder.newLine();
    {
      boolean _hasActiveTriggers = this.hasActiveTriggers(usage);
      if (_hasActiveTriggers) {
        _builder.append("#include \"aceSmartSoft.hh\"");
        _builder.newLine();
        _builder.append("#include <queue>");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("#include <string>");
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.append("#include <list>");
    _builder.newLine();
    _builder.newLine();
    {
      boolean _hasActiveTriggers_1 = this.hasActiveTriggers(usage);
      if (_hasActiveTriggers_1) {
        _builder.append("class TriggerHandlerCore : public SmartACE::ManagedTask");
        _builder.newLine();
      } else {
        _builder.append("class TriggerHandlerCore");
        _builder.newLine();
      }
    }
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("friend class ParamUpdateHandler;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("TriggerHandlerCore() ");
    _builder.newLine();
    {
      boolean _hasActiveTriggers_2 = this.hasActiveTriggers(usage);
      if (_hasActiveTriggers_2) {
        _builder.append("\t");
        _builder.append(":\tSmartACE::ManagedTask(NULL) //TODO: a propper component pointer should be probably used here instead of NULL");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(",\tmutex()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(",\tsema(0) // initialize semaphore in blocking mode");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(",\tcurrent_trigger_enumerator(TriggerEnumerators::UNDEFINED_TRIGGER_ACTION)");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("{  ");
    _builder.newLine();
    {
      boolean _hasActiveTriggers_3 = this.hasActiveTriggers(usage);
      if (_hasActiveTriggers_3) {
        _builder.append("\t\t");
        _builder.append("this->start();");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ~TriggerHandlerCore() {  }");
    _builder.newLine();
    _builder.newLine();
    {
      final Function1<ParameterSetInstance, String> _function = (ParameterSetInstance it) -> {
        return it.getName();
      };
      List<ParameterSetInstance> _sortBy = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function);
      for(final ParameterSetInstance paramSetInst : _sortBy) {
        _builder.append("\t");
        _builder.append("// trigger user methods");
        _builder.newLine();
        {
          final Function1<TriggerDefinition, String> _function_1 = (TriggerDefinition it) -> {
            return it.getName();
          };
          List<TriggerDefinition> _sortBy_1 = IterableExtensions.<TriggerDefinition, String>sortBy(Iterables.<TriggerDefinition>filter(paramSetInst.getParamSet().getParameters(), TriggerDefinition.class), _function_1);
          for(final TriggerDefinition trigger : _sortBy_1) {
            _builder.append("\t");
            _builder.newLine();
            {
              final Function1<AttributeDefinition, Boolean> _function_2 = (AttributeDefinition el) -> {
                AbstractAttributeType _type = el.getType();
                return Boolean.valueOf((_type instanceof InlineEnumerationType));
              };
              boolean _exists = IterableExtensions.<AttributeDefinition>exists(trigger.getAttributes(), _function_2);
              if (_exists) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("class ");
                String _name = trigger.getName();
                _builder.append(_name, "\t\t");
                _builder.append("Type {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
              }
            }
            {
              final Function1<AttributeDefinition, Boolean> _function_3 = (AttributeDefinition el) -> {
                AbstractAttributeType _type = el.getType();
                return Boolean.valueOf((_type instanceof InlineEnumerationType));
              };
              final Function1<AttributeDefinition, String> _function_4 = (AttributeDefinition it) -> {
                return it.getName();
              };
              List<AttributeDefinition> _sortBy_2 = IterableExtensions.<AttributeDefinition, String>sortBy(IterableExtensions.<AttributeDefinition>filter(trigger.getAttributes(), _function_3), _function_4);
              for(final AttributeDefinition attr : _sortBy_2) {
                _builder.append("\t");
                _builder.append("\t\t");
                CharSequence _generateEnumClass = this.generateEnumClass(attr);
                _builder.append(_generateEnumClass, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.newLine();
                {
                  Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(attr);
                  if ((_isArrayType).booleanValue()) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("static std::list<");
                    String _compileCppType = this._componentParamsGenHelpers.compileCppType(attr);
                    _builder.append(_compileCppType, "\t\t\t");
                    _builder.append("> convert");
                    String _firstUpper = StringExtensions.toFirstUpper(attr.getName());
                    _builder.append(_firstUpper, "\t\t\t");
                    _builder.append("Type(const std::list<std::string> &");
                    String _name_1 = attr.getName();
                    _builder.append(_name_1, "\t\t\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("static std::list<");
                    String _compileCppType_1 = this._componentParamsGenHelpers.compileCppType(attr);
                    _builder.append(_compileCppType_1, "\t\t\t\t");
                    _builder.append("> result;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("std::list<std::string>::const_iterator it;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("for(it=");
                    String _name_2 = attr.getName();
                    _builder.append(_name_2, "\t\t\t\t");
                    _builder.append(".begin(); it!=");
                    String _name_3 = attr.getName();
                    _builder.append(_name_3, "\t\t\t\t");
                    _builder.append(".end(); it++) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t\t");
                    _builder.append("result.push_back(*it);");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("return result;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.newLine();
                  }
                }
              }
            }
            {
              final Function1<AttributeDefinition, Boolean> _function_5 = (AttributeDefinition el) -> {
                AbstractAttributeType _type = el.getType();
                return Boolean.valueOf((_type instanceof InlineEnumerationType));
              };
              boolean _exists_1 = IterableExtensions.<AttributeDefinition>exists(trigger.getAttributes(), _function_5);
              if (_exists_1) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}; // end class ");
                String _name_4 = trigger.getName();
                _builder.append(_name_4, "\t\t");
                _builder.append("Type");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("virtual void handle");
            String _firstUpper_1 = StringExtensions.toFirstUpper(this.getFullyQualifiedVariableName(trigger));
            _builder.append(_firstUpper_1, "\t\t");
            _builder.append("(");
            String _generateTriggerAttributeDefinitions = this.generateTriggerAttributeDefinitions(trigger);
            _builder.append(_generateTriggerAttributeDefinitions, "\t\t");
            _builder.append(") = 0;");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// extended trigger user methods");
    _builder.newLine();
    {
      final Function1<ExtendedTrigger, String> _function_6 = (ExtendedTrigger it) -> {
        return it.getName();
      };
      List<ExtendedTrigger> _sortBy_3 = IterableExtensions.<ExtendedTrigger, String>sortBy(Iterables.<ExtendedTrigger>filter(usage.getParameters(), ExtendedTrigger.class), _function_6);
      for(final ExtendedTrigger extendedTrigger : _sortBy_3) {
        {
          Boolean _haveEnums = this._componentParameterModelUtility.haveEnums(extendedTrigger.getAttributes());
          if ((_haveEnums).booleanValue()) {
            _builder.append("\t");
            _builder.append("class ");
            String _name_5 = extendedTrigger.getName();
            _builder.append(_name_5, "\t");
            _builder.append("Type {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("public:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
          }
        }
        {
          final Function1<AttributeDefinition, Boolean> _function_7 = (AttributeDefinition it) -> {
            AbstractAttributeType _type = it.getType();
            return Boolean.valueOf((_type instanceof InlineEnumerationType));
          };
          final Function1<AttributeDefinition, String> _function_8 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_4 = IterableExtensions.<AttributeDefinition, String>sortBy(IterableExtensions.<AttributeDefinition>filter(extendedTrigger.getAttributes(), _function_7), _function_8);
          for(final AttributeDefinition attr_1 : _sortBy_4) {
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generateEnumClass_1 = this.generateEnumClass(attr_1);
            _builder.append(_generateEnumClass_1, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            {
              Boolean _isArrayType_1 = this._componentParameterModelUtility.isArrayType(attr_1);
              if ((_isArrayType_1).booleanValue()) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("static std::list<");
                String _compileCppType_2 = this._componentParamsGenHelpers.compileCppType(attr_1);
                _builder.append(_compileCppType_2, "\t\t");
                _builder.append("> convert");
                String _firstUpper_2 = StringExtensions.toFirstUpper(attr_1.getName());
                _builder.append(_firstUpper_2, "\t\t");
                _builder.append("Type(const std::list<std::string> &");
                String _name_6 = attr_1.getName();
                _builder.append(_name_6, "\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("static std::list<");
                String _compileCppType_3 = this._componentParamsGenHelpers.compileCppType(attr_1);
                _builder.append(_compileCppType_3, "\t\t\t");
                _builder.append("> result;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("std::list<std::string>::const_iterator it;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("for(it=");
                String _name_7 = attr_1.getName();
                _builder.append(_name_7, "\t\t\t");
                _builder.append(".begin(); it!=");
                String _name_8 = attr_1.getName();
                _builder.append(_name_8, "\t\t\t");
                _builder.append(".end(); it++) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("result.push_back(*it);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return result;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
              }
            }
          }
        }
        {
          Boolean _haveEnums_1 = this._componentParameterModelUtility.haveEnums(extendedTrigger.getAttributes());
          if ((_haveEnums_1).booleanValue()) {
            _builder.append("\t");
            _builder.append("}; // end class ");
            String _name_9 = extendedTrigger.getName();
            _builder.append(_name_9, "\t");
            _builder.append("Type");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void handle");
        String _firstUpper_3 = StringExtensions.toFirstUpper(extendedTrigger.getName());
        _builder.append(_firstUpper_3, "\t");
        _builder.append("(");
        String _generateTriggerAttributeDefinitions_1 = this.generateTriggerAttributeDefinitions(extendedTrigger);
        _builder.append(_generateTriggerAttributeDefinitions_1, "\t");
        _builder.append(") = 0;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      boolean _hasActiveTriggers_4 = this.hasActiveTriggers(usage);
      if (_hasActiveTriggers_4) {
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SmartACE::SmartMutex mutex;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SmartACE::SmartSemaphore sema;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int on_execute();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class TriggerEnumerators {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("enum ENUM {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("UNDEFINED_TRIGGER_ACTION");
        _builder.newLine();
        {
          final Function1<ParameterSetInstance, String> _function_9 = (ParameterSetInstance it) -> {
            return it.getName();
          };
          List<ParameterSetInstance> _sortBy_5 = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function_9);
          for(final ParameterSetInstance inst : _sortBy_5) {
            {
              final Function1<TriggerInstance, Boolean> _function_10 = (TriggerInstance t) -> {
                return Boolean.valueOf(t.isActive());
              };
              final Function1<TriggerInstance, String> _function_11 = (TriggerInstance it) -> {
                return it.getTriggerDef().getName();
              };
              List<TriggerInstance> _sortBy_6 = IterableExtensions.<TriggerInstance, String>sortBy(IterableExtensions.<TriggerInstance>filter(Iterables.<TriggerInstance>filter(inst.getParameterInstances(), TriggerInstance.class), _function_10), _function_11);
              for(final TriggerInstance t : _sortBy_6) {
                _builder.append("\t\t\t");
                _builder.append(", ");
                String _upperCase = this.getFullyQualifiedVariableName(t.getTriggerDef()).toUpperCase();
                _builder.append(_upperCase, "\t\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            {
              final Function1<ExtendedTrigger, Boolean> _function_12 = (ExtendedTrigger t_1) -> {
                return Boolean.valueOf(t_1.isActive());
              };
              final Function1<ExtendedTrigger, String> _function_13 = (ExtendedTrigger it) -> {
                return it.getName();
              };
              List<ExtendedTrigger> _sortBy_7 = IterableExtensions.<ExtendedTrigger, String>sortBy(IterableExtensions.<ExtendedTrigger>filter(Iterables.<ExtendedTrigger>filter(usage.getParameters(), ExtendedTrigger.class), _function_12), _function_13);
              for(final ExtendedTrigger extTr : _sortBy_7) {
                _builder.append("\t\t\t");
                _builder.append(", ");
                String _upperCase_1 = extTr.getName().toUpperCase();
                _builder.append(_upperCase_1, "\t\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("TriggerEnumerators::ENUM current_trigger_enumerator;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::queue<TriggerEnumerators::ENUM> trigger_queue;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        {
          final Function1<ParameterSetInstance, String> _function_14 = (ParameterSetInstance it) -> {
            return it.getName();
          };
          List<ParameterSetInstance> _sortBy_8 = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function_14);
          for(final ParameterSetInstance inst_1 : _sortBy_8) {
            {
              final Function1<TriggerInstance, Boolean> _function_15 = (TriggerInstance t_1) -> {
                return Boolean.valueOf(t_1.isActive());
              };
              final Function1<TriggerInstance, String> _function_16 = (TriggerInstance it) -> {
                return it.getTriggerDef().getName();
              };
              List<TriggerInstance> _sortBy_9 = IterableExtensions.<TriggerInstance, String>sortBy(IterableExtensions.<TriggerInstance>filter(Iterables.<TriggerInstance>filter(inst_1.getParameterInstances(), TriggerInstance.class), _function_15), _function_16);
              for(final TriggerInstance t_1 : _sortBy_9) {
                _builder.append("\t");
                _builder.append("// active trigger ");
                String _name_10 = t_1.getTriggerDef().getName();
                _builder.append(_name_10, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("struct ");
                String _fullyQualifiedVariableName = this.getFullyQualifiedVariableName(t_1.getTriggerDef());
                _builder.append(_fullyQualifiedVariableName, "\t");
                _builder.append("Attributes {");
                _builder.newLineIfNotEmpty();
                {
                  final Function1<AttributeDefinition, String> _function_17 = (AttributeDefinition it) -> {
                    return it.getName();
                  };
                  List<AttributeDefinition> _sortBy_10 = IterableExtensions.<AttributeDefinition, String>sortBy(t_1.getTriggerDef().getAttributes(), _function_17);
                  for(final AttributeDefinition el : _sortBy_10) {
                    {
                      Boolean _isArrayType_2 = this._componentParameterModelUtility.isArrayType(el);
                      if ((_isArrayType_2).booleanValue()) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("std::list<");
                        String _compileCppType_4 = this._componentParamsGenHelpers.compileCppType(el);
                        _builder.append(_compileCppType_4, "\t\t");
                        _builder.append("> ");
                        String _name_11 = el.getName();
                        _builder.append(_name_11, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("\t");
                        String _compileCppType_5 = this._componentParamsGenHelpers.compileCppType(el);
                        _builder.append(_compileCppType_5, "\t\t");
                        _builder.append(" ");
                        String _name_12 = el.getName();
                        _builder.append(_name_12, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  }
                }
                _builder.append("\t");
                _builder.append("}current_");
                String _fullyQualifiedVariableName_1 = this.getFullyQualifiedVariableName(t_1.getTriggerDef());
                _builder.append(_fullyQualifiedVariableName_1, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("std::queue<");
                String _fullyQualifiedVariableName_2 = this.getFullyQualifiedVariableName(t_1.getTriggerDef());
                _builder.append(_fullyQualifiedVariableName_2, "\t");
                _builder.append("Attributes> ");
                String _fullyQualifiedVariableName_3 = this.getFullyQualifiedVariableName(t_1.getTriggerDef());
                _builder.append(_fullyQualifiedVariableName_3, "\t");
                _builder.append("_queue;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.newLine();
              }
            }
          }
        }
        {
          final Function1<ExtendedTrigger, Boolean> _function_18 = (ExtendedTrigger t_2) -> {
            return Boolean.valueOf(t_2.isActive());
          };
          final Function1<ExtendedTrigger, String> _function_19 = (ExtendedTrigger it) -> {
            return it.getName();
          };
          List<ExtendedTrigger> _sortBy_11 = IterableExtensions.<ExtendedTrigger, String>sortBy(IterableExtensions.<ExtendedTrigger>filter(Iterables.<ExtendedTrigger>filter(usage.getParameters(), ExtendedTrigger.class), _function_18), _function_19);
          for(final ExtendedTrigger extTr_1 : _sortBy_11) {
            _builder.append("\t");
            _builder.append("// active trigger ");
            String _name_13 = extTr_1.getName();
            _builder.append(_name_13, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("struct ");
            String _name_14 = extTr_1.getName();
            _builder.append(_name_14, "\t");
            _builder.append("Attributes {");
            _builder.newLineIfNotEmpty();
            {
              final Function1<AttributeDefinition, String> _function_20 = (AttributeDefinition it) -> {
                return it.getName();
              };
              List<AttributeDefinition> _sortBy_12 = IterableExtensions.<AttributeDefinition, String>sortBy(extTr_1.getAttributes(), _function_20);
              for(final AttributeDefinition el_1 : _sortBy_12) {
                {
                  Boolean _isArrayType_3 = this._componentParameterModelUtility.isArrayType(el_1);
                  if ((_isArrayType_3).booleanValue()) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("std::list<");
                    String _compileCppType_6 = this._componentParamsGenHelpers.compileCppType(el_1);
                    _builder.append(_compileCppType_6, "\t\t");
                    _builder.append("> ");
                    String _name_15 = el_1.getName();
                    _builder.append(_name_15, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("\t");
                    _builder.append("\t");
                    String _compileCppType_7 = this._componentParamsGenHelpers.compileCppType(el_1);
                    _builder.append(_compileCppType_7, "\t\t");
                    _builder.append(" ");
                    String _name_16 = el_1.getName();
                    _builder.append(_name_16, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
            _builder.append("\t");
            _builder.append("}current_");
            String _name_17 = extTr_1.getName();
            _builder.append(_name_17, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("std::queue<");
            String _name_18 = extTr_1.getName();
            _builder.append(_name_18, "\t");
            _builder.append("Attributes> ");
            String _name_19 = extTr_1.getName();
            _builder.append(_name_19, "\t");
            _builder.append("_queue;");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("private:");
    _builder.newLine();
    {
      final Function1<ParameterSetInstance, String> _function_21 = (ParameterSetInstance it) -> {
        return it.getName();
      };
      List<ParameterSetInstance> _sortBy_13 = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function_21);
      for(final ParameterSetInstance paramSetInst_1 : _sortBy_13) {
        _builder.append("\t");
        _builder.append("// trigger internal methods");
        _builder.newLine();
        {
          final Function1<TriggerDefinition, String> _function_22 = (TriggerDefinition it) -> {
            return it.getName();
          };
          List<TriggerDefinition> _sortBy_14 = IterableExtensions.<TriggerDefinition, String>sortBy(Iterables.<TriggerDefinition>filter(paramSetInst_1.getParamSet().getParameters(), TriggerDefinition.class), _function_22);
          for(final TriggerDefinition trigger_1 : _sortBy_14) {
            _builder.append("\t");
            _builder.append("void handle");
            String _firstUpper_4 = StringExtensions.toFirstUpper(this.getFullyQualifiedVariableName(trigger_1));
            _builder.append(_firstUpper_4, "\t");
            _builder.append("Core(");
            String _generateTriggerAttributeDefinitions_2 = this.generateTriggerAttributeDefinitions(trigger_1);
            _builder.append(_generateTriggerAttributeDefinitions_2, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// extended trigger internal methods ");
    _builder.newLine();
    {
      final Function1<ExtendedTrigger, String> _function_23 = (ExtendedTrigger it) -> {
        return it.getName();
      };
      List<ExtendedTrigger> _sortBy_15 = IterableExtensions.<ExtendedTrigger, String>sortBy(Iterables.<ExtendedTrigger>filter(usage.getParameters(), ExtendedTrigger.class), _function_23);
      for(final ExtendedTrigger extendedTrigger_1 : _sortBy_15) {
        _builder.append("\t");
        _builder.append("void handle");
        String _firstUpper_5 = StringExtensions.toFirstUpper(extendedTrigger_1.getName());
        _builder.append(_firstUpper_5, "\t");
        _builder.append("Core(");
        String _generateTriggerAttributeDefinitions_3 = this.generateTriggerAttributeDefinitions(extendedTrigger_1);
        _builder.append(_generateTriggerAttributeDefinitions_3, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif // _TRIGGERHANDLERCORE_HH");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileTriggerHandlerCoreCC(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _TriggerHandlerCoreHeaderFileName = this.TriggerHandlerCoreHeaderFileName(usage);
    _builder.append(_TriggerHandlerCoreHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _hasActiveTriggers = this.hasActiveTriggers(usage);
      if (_hasActiveTriggers) {
        _builder.append("int TriggerHandlerCore::on_execute()");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// blocking wait until some active trigger request(s) come in");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sema.acquire();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("SmartACE::SmartGuard g(mutex);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// get the top trigger from the queue");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("current_trigger_enumerator = trigger_queue.front();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("trigger_queue.pop();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// retrieve the corresponding trigger attributes from the trigger specific queue");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch(current_trigger_enumerator) {");
        _builder.newLine();
        {
          final Function1<ParameterSetInstance, String> _function = (ParameterSetInstance it) -> {
            return it.getName();
          };
          List<ParameterSetInstance> _sortBy = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function);
          for(final ParameterSetInstance inst : _sortBy) {
            {
              final Function1<TriggerInstance, Boolean> _function_1 = (TriggerInstance t) -> {
                return Boolean.valueOf(t.isActive());
              };
              final Function1<TriggerInstance, String> _function_2 = (TriggerInstance it) -> {
                return it.getTriggerDef().getName();
              };
              List<TriggerInstance> _sortBy_1 = IterableExtensions.<TriggerInstance, String>sortBy(IterableExtensions.<TriggerInstance>filter(Iterables.<TriggerInstance>filter(inst.getParameterInstances(), TriggerInstance.class), _function_1), _function_2);
              for(final TriggerInstance t : _sortBy_1) {
                _builder.append("\t\t");
                _builder.append("case TriggerEnumerators::");
                String _upperCase = this.getFullyQualifiedVariableName(t.getTriggerDef()).toUpperCase();
                _builder.append(_upperCase, "\t\t");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("current_");
                String _fullyQualifiedVariableName = this.getFullyQualifiedVariableName(t.getTriggerDef());
                _builder.append(_fullyQualifiedVariableName, "\t\t\t");
                _builder.append(" = ");
                String _fullyQualifiedVariableName_1 = this.getFullyQualifiedVariableName(t.getTriggerDef());
                _builder.append(_fullyQualifiedVariableName_1, "\t\t\t");
                _builder.append("_queue.front();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                String _fullyQualifiedVariableName_2 = this.getFullyQualifiedVariableName(t.getTriggerDef());
                _builder.append(_fullyQualifiedVariableName_2, "\t\t\t");
                _builder.append("_queue.pop();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("break;");
                _builder.newLine();
              }
            }
          }
        }
        {
          final Function1<ExtendedTrigger, Boolean> _function_3 = (ExtendedTrigger t_1) -> {
            return Boolean.valueOf(t_1.isActive());
          };
          final Function1<ExtendedTrigger, String> _function_4 = (ExtendedTrigger it) -> {
            return it.getName();
          };
          List<ExtendedTrigger> _sortBy_2 = IterableExtensions.<ExtendedTrigger, String>sortBy(IterableExtensions.<ExtendedTrigger>filter(Iterables.<ExtendedTrigger>filter(usage.getParameters(), ExtendedTrigger.class), _function_3), _function_4);
          for(final ExtendedTrigger extTr : _sortBy_2) {
            _builder.append("\t\t");
            _builder.append("case TriggerEnumerators::");
            String _upperCase_1 = extTr.getName().toUpperCase();
            _builder.append(_upperCase_1, "\t\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("current_");
            String _name = extTr.getName();
            _builder.append(_name, "\t\t");
            _builder.append(" = ");
            String _name_1 = extTr.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append("_queue.front();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _name_2 = extTr.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append("_queue.pop();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
          }
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} // mutex release");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// now call the corresponding trigger handler");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// (releasing the mutex before, allows to store newly incoming trigger commands on the queue in parallel)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("switch(current_trigger_enumerator) {");
        _builder.newLine();
        {
          final Function1<ParameterSetInstance, String> _function_5 = (ParameterSetInstance it) -> {
            return it.getName();
          };
          List<ParameterSetInstance> _sortBy_3 = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function_5);
          for(final ParameterSetInstance inst_1 : _sortBy_3) {
            {
              final Function1<TriggerInstance, Boolean> _function_6 = (TriggerInstance t_1) -> {
                return Boolean.valueOf(t_1.isActive());
              };
              final Function1<TriggerInstance, String> _function_7 = (TriggerInstance it) -> {
                return it.getTriggerDef().getName();
              };
              List<TriggerInstance> _sortBy_4 = IterableExtensions.<TriggerInstance, String>sortBy(IterableExtensions.<TriggerInstance>filter(Iterables.<TriggerInstance>filter(inst_1.getParameterInstances(), TriggerInstance.class), _function_6), _function_7);
              for(final TriggerInstance t_1 : _sortBy_4) {
                _builder.append("\t");
                _builder.append("case TriggerEnumerators::");
                String _upperCase_2 = this.getFullyQualifiedVariableName(t_1.getTriggerDef()).toUpperCase();
                _builder.append(_upperCase_2, "\t");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("this->handle");
                String _firstUpper = StringExtensions.toFirstUpper(this.getFullyQualifiedVariableName(t_1.getTriggerDef()));
                _builder.append(_firstUpper, "\t\t");
                _builder.append("(");
                TriggerDefinition _triggerDef = t_1.getTriggerDef();
                String _fullyQualifiedVariableName_3 = this.getFullyQualifiedVariableName(t_1.getTriggerDef());
                String _plus = ("current_" + _fullyQualifiedVariableName_3);
                String _plus_1 = (_plus + ".");
                String _generateTriggerAttributeNames = this.generateTriggerAttributeNames(_triggerDef, _plus_1);
                _builder.append(_generateTriggerAttributeNames, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("break;");
                _builder.newLine();
              }
            }
          }
        }
        {
          final Function1<ExtendedTrigger, Boolean> _function_8 = (ExtendedTrigger t_2) -> {
            return Boolean.valueOf(t_2.isActive());
          };
          final Function1<ExtendedTrigger, String> _function_9 = (ExtendedTrigger it) -> {
            return it.getName();
          };
          List<ExtendedTrigger> _sortBy_5 = IterableExtensions.<ExtendedTrigger, String>sortBy(IterableExtensions.<ExtendedTrigger>filter(Iterables.<ExtendedTrigger>filter(usage.getParameters(), ExtendedTrigger.class), _function_8), _function_9);
          for(final ExtendedTrigger extTr_1 : _sortBy_5) {
            _builder.append("\t");
            _builder.append("case TriggerEnumerators::");
            String _upperCase_3 = extTr_1.getName().toUpperCase();
            _builder.append(_upperCase_3, "\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("this->handle");
            String _firstUpper_1 = StringExtensions.toFirstUpper(extTr_1.getName());
            _builder.append(_firstUpper_1, "\t\t");
            _builder.append("(");
            String _name_3 = extTr_1.getName();
            String _plus_2 = ("current_" + _name_3);
            String _plus_3 = (_plus_2 + ".");
            String _generateTriggerAttributeNames_1 = this.generateTriggerAttributeNames(extTr_1, _plus_3);
            _builder.append(_generateTriggerAttributeNames_1, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    {
      final Function1<ParameterSetInstance, String> _function_10 = (ParameterSetInstance it) -> {
        return it.getName();
      };
      List<ParameterSetInstance> _sortBy_6 = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function_10);
      for(final ParameterSetInstance paramSetInst : _sortBy_6) {
        _builder.append("//");
        _builder.newLine();
        _builder.append("// trigger internal handler methods");
        _builder.newLine();
        _builder.append("//");
        _builder.newLine();
        {
          final Function1<TriggerDefinition, String> _function_11 = (TriggerDefinition it) -> {
            return it.getName();
          };
          List<TriggerDefinition> _sortBy_7 = IterableExtensions.<TriggerDefinition, String>sortBy(Iterables.<TriggerDefinition>filter(paramSetInst.getParamSet().getParameters(), TriggerDefinition.class), _function_11);
          for(final TriggerDefinition trigger : _sortBy_7) {
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// handle ");
            String _name_4 = trigger.getName();
            _builder.append(_name_4, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("void TriggerHandlerCore::handle");
            String _firstUpper_2 = StringExtensions.toFirstUpper(this.getFullyQualifiedVariableName(trigger));
            _builder.append(_firstUpper_2, "\t");
            _builder.append("Core(");
            String _generateTriggerAttributeDefinitions = this.generateTriggerAttributeDefinitions(trigger);
            _builder.append(_generateTriggerAttributeDefinitions, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            {
              final Function1<TriggerInstance, Boolean> _function_12 = (TriggerInstance t_2) -> {
                return Boolean.valueOf((Objects.equal(t_2.getTriggerDef(), trigger) && t_2.isActive()));
              };
              boolean _exists = IterableExtensions.<TriggerInstance>exists(Iterables.<TriggerInstance>filter(paramSetInst.getParameterInstances(), TriggerInstance.class), _function_12);
              if (_exists) {
                _builder.append("\t\t");
                _builder.append("SmartACE::SmartGuard g(mutex);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("// store the current set of trigger-attributes in a queue");
                _builder.newLine();
                _builder.append("\t\t");
                String _fullyQualifiedVariableName_4 = this.getFullyQualifiedVariableName(trigger);
                _builder.append(_fullyQualifiedVariableName_4, "\t\t");
                _builder.append("Attributes attr;");
                _builder.newLineIfNotEmpty();
                {
                  final Function1<AttributeDefinition, String> _function_13 = (AttributeDefinition it) -> {
                    return it.getName();
                  };
                  List<AttributeDefinition> _sortBy_8 = IterableExtensions.<AttributeDefinition, String>sortBy(trigger.getAttributes(), _function_13);
                  for(final AttributeDefinition el : _sortBy_8) {
                    _builder.append("\t\t");
                    _builder.append("attr.");
                    String _name_5 = el.getName();
                    _builder.append(_name_5, "\t\t");
                    _builder.append(" = ");
                    String _name_6 = el.getName();
                    _builder.append(_name_6, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("\t\t");
                String _fullyQualifiedVariableName_5 = this.getFullyQualifiedVariableName(trigger);
                _builder.append(_fullyQualifiedVariableName_5, "\t\t");
                _builder.append("_queue.push(attr);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("// store the current trigger call in the shared trigger-queue");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("trigger_queue.push(TriggerEnumerators::");
                String _upperCase_4 = this.getFullyQualifiedVariableName(trigger).toUpperCase();
                _builder.append(_upperCase_4, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("// signal the task, in case it is waiting");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("sema.release();");
                _builder.newLine();
              } else {
                _builder.append("\t\t");
                _builder.append("this->handle");
                String _firstUpper_3 = StringExtensions.toFirstUpper(this.getFullyQualifiedVariableName(trigger));
                _builder.append(_firstUpper_3, "\t\t");
                _builder.append("(");
                String _generateTriggerAttributeNames_2 = this.generateTriggerAttributeNames(trigger, "");
                _builder.append(_generateTriggerAttributeNames_2, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("//");
    _builder.newLine();
    _builder.append("// extended trigger internal handler methods");
    _builder.newLine();
    _builder.append("//");
    _builder.newLine();
    {
      final Function1<ExtendedTrigger, String> _function_14 = (ExtendedTrigger it) -> {
        return it.getName();
      };
      List<ExtendedTrigger> _sortBy_9 = IterableExtensions.<ExtendedTrigger, String>sortBy(Iterables.<ExtendedTrigger>filter(usage.getParameters(), ExtendedTrigger.class), _function_14);
      for(final ExtendedTrigger extendedTrigger : _sortBy_9) {
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// handle ");
        String _name_7 = extendedTrigger.getName();
        _builder.append(_name_7, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("void TriggerHandlerCore::handle");
        String _firstUpper_4 = StringExtensions.toFirstUpper(extendedTrigger.getName());
        _builder.append(_firstUpper_4, "\t\t");
        _builder.append("Core(");
        String _generateTriggerAttributeDefinitions_1 = this.generateTriggerAttributeDefinitions(extendedTrigger);
        _builder.append(_generateTriggerAttributeDefinitions_1, "\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        {
          boolean _isActive = extendedTrigger.isActive();
          if (_isActive) {
            _builder.append("\t\t\t");
            _builder.append("SmartACE::SmartGuard g(mutex);");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// store the current set of trigger-attributes in a queue");
            _builder.newLine();
            _builder.append("\t\t\t");
            String _name_8 = extendedTrigger.getName();
            _builder.append(_name_8, "\t\t\t");
            _builder.append("Attributes attr;");
            _builder.newLineIfNotEmpty();
            {
              final Function1<AttributeDefinition, String> _function_15 = (AttributeDefinition it) -> {
                return it.getName();
              };
              List<AttributeDefinition> _sortBy_10 = IterableExtensions.<AttributeDefinition, String>sortBy(extendedTrigger.getAttributes(), _function_15);
              for(final AttributeDefinition el_1 : _sortBy_10) {
                _builder.append("\t\t\t");
                _builder.append("attr.");
                String _name_9 = el_1.getName();
                _builder.append(_name_9, "\t\t\t");
                _builder.append(" = ");
                String _name_10 = el_1.getName();
                _builder.append(_name_10, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t\t\t");
            String _name_11 = extendedTrigger.getName();
            _builder.append(_name_11, "\t\t\t");
            _builder.append("_queue.push(attr);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// store the current trigger call in the shared trigger-queue");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("trigger_queue.push(TriggerEnumerators::");
            String _upperCase_5 = extendedTrigger.getName().toUpperCase();
            _builder.append(_upperCase_5, "\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// signal the task, in case it is waiting");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("cond.signal();");
            _builder.newLine();
          } else {
            _builder.append("\t\t\t");
            _builder.append("this->handle");
            String _firstUpper_5 = StringExtensions.toFirstUpper(extendedTrigger.getName());
            _builder.append(_firstUpper_5, "\t\t\t");
            _builder.append("(");
            String _generateTriggerAttributeNames_3 = this.generateTriggerAttributeNames(extendedTrigger, "");
            _builder.append(_generateTriggerAttributeNames_3, "\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence compileTriggerHandlerHH(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _TRIGGERHANDLER_HH");
    _builder.newLine();
    _builder.append("#define _TRIGGERHANDLER_HH");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _TriggerHandlerCoreHeaderFileName = this.TriggerHandlerCoreHeaderFileName(usage);
    _builder.append(_TriggerHandlerCoreHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("class TriggerHandler: public TriggerHandlerCore ");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("TriggerHandler() {  }");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ~TriggerHandler() {  }");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// trigger user methods");
    _builder.newLine();
    {
      final Function1<ParameterSetInstance, String> _function = (ParameterSetInstance it) -> {
        return it.getName();
      };
      List<ParameterSetInstance> _sortBy = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function);
      for(final ParameterSetInstance paramSetInst : _sortBy) {
        {
          final Function1<TriggerDefinition, String> _function_1 = (TriggerDefinition it) -> {
            return it.getName();
          };
          List<TriggerDefinition> _sortBy_1 = IterableExtensions.<TriggerDefinition, String>sortBy(Iterables.<TriggerDefinition>filter(paramSetInst.getParamSet().getParameters(), TriggerDefinition.class), _function_1);
          for(final TriggerDefinition trigger : _sortBy_1) {
            _builder.append("\t");
            _builder.append("virtual void handle");
            String _firstUpper = StringExtensions.toFirstUpper(this.getFullyQualifiedVariableName(trigger));
            _builder.append(_firstUpper, "\t");
            _builder.append("(");
            String _generateTriggerAttributeDefinitions = this.generateTriggerAttributeDefinitions(trigger);
            _builder.append(_generateTriggerAttributeDefinitions, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    {
      final Function1<ExtendedTrigger, String> _function_2 = (ExtendedTrigger it) -> {
        return it.getName();
      };
      List<ExtendedTrigger> _sortBy_2 = IterableExtensions.<ExtendedTrigger, String>sortBy(Iterables.<ExtendedTrigger>filter(usage.getParameters(), ExtendedTrigger.class), _function_2);
      for(final ExtendedTrigger extendedTrigger : _sortBy_2) {
        _builder.append("\t");
        _builder.append("virtual void handle");
        String _firstUpper_1 = StringExtensions.toFirstUpper(extendedTrigger.getName());
        _builder.append(_firstUpper_1, "\t");
        _builder.append("(");
        String _generateTriggerAttributeDefinitions_1 = this.generateTriggerAttributeDefinitions(extendedTrigger);
        _builder.append(_generateTriggerAttributeDefinitions_1, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif // _TRIGGERHANDLER_HH");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileTriggerHandlerCC(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _TriggerHandlerHeaderFileName = this.TriggerHandlerHeaderFileName(usage);
    _builder.append(_TriggerHandlerHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    ComponentDefinition _component = usage.getComponent();
    String _compHeaderFilename = null;
    if (_component!=null) {
      _compHeaderFilename=this._smartComponent.getCompHeaderFilename(_component);
    }
    _builder.append(_compHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// trigger user methods");
    _builder.newLine();
    {
      final Function1<ParameterSetInstance, String> _function = (ParameterSetInstance it) -> {
        return it.getName();
      };
      List<ParameterSetInstance> _sortBy = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function);
      for(final ParameterSetInstance paramSetInst : _sortBy) {
        {
          final Function1<TriggerDefinition, String> _function_1 = (TriggerDefinition it) -> {
            return it.getName();
          };
          List<TriggerDefinition> _sortBy_1 = IterableExtensions.<TriggerDefinition, String>sortBy(Iterables.<TriggerDefinition>filter(paramSetInst.getParamSet().getParameters(), TriggerDefinition.class), _function_1);
          for(final TriggerDefinition trigger : _sortBy_1) {
            _builder.append("void TriggerHandler::handle");
            String _firstUpper = StringExtensions.toFirstUpper(this.getFullyQualifiedVariableName(trigger));
            _builder.append(_firstUpper);
            _builder.append("(");
            String _generateTriggerAttributeDefinitions = this.generateTriggerAttributeDefinitions(trigger);
            _builder.append(_generateTriggerAttributeDefinitions);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// implement the trigger behavior here. Be aware, if you must use blocking calls here, please set this");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// trigger as active in the model. For an active trigger an active queue will be generated internally ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// (transparent for the usage here). Thus an active trigger will be called within a separate task scope.");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    {
      final Function1<ExtendedTrigger, String> _function_2 = (ExtendedTrigger it) -> {
        return it.getName();
      };
      List<ExtendedTrigger> _sortBy_2 = IterableExtensions.<ExtendedTrigger, String>sortBy(Iterables.<ExtendedTrigger>filter(usage.getParameters(), ExtendedTrigger.class), _function_2);
      for(final ExtendedTrigger extendedTrigger : _sortBy_2) {
        _builder.append("void TriggerHandler::handle");
        String _firstUpper_1 = StringExtensions.toFirstUpper(extendedTrigger.getName());
        _builder.append(_firstUpper_1);
        _builder.append("(");
        String _generateTriggerAttributeDefinitions_1 = this.generateTriggerAttributeDefinitions(extendedTrigger);
        _builder.append(_generateTriggerAttributeDefinitions_1);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// implement the trigger behavior here. Be aware, if you must use blocking calls here, please set this");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// trigger as active in the model. For an active trigger an active queue will be generated internally ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// (transparent for the usage here). Thus an active trigger will be called within a separate task scope.");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence compileStructHH(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef _PARAMETERSTATESTRUCT_HH");
    _builder.newLine();
    _builder.append("#define _PARAMETERSTATESTRUCT_HH");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _ParameterStateStructCoreHeaderFileName = this.ParameterStateStructCoreHeaderFileName(usage);
    _builder.append(_ParameterStateStructCoreHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("class ParameterStateStruct: public ParameterStateStructCore");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ParameterStateStruct() {  }");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ~ParameterStateStruct() {  }");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// implement this method to check whether the incoming parameters");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// provided by the commit state are consistent, in case the ParameterResponseType");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// is not OK, the commit parameter is NOT copied into the global state.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// HINT: avoid using blocking calls from within this handler, use Triggers for that instead.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual SmartACE::ParamResponseType handleCOMMIT(const ParameterStateStruct &commitState);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// define your own getter methods here");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// (to provide conversion functions and/or more convenient getter methods)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// these own getter methods will be accessible through \"COMP->getParameters().yourOwnMethod()\"");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// inside of your methods use the getter methods from the parent class ParameterStateStructCore");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// (they provide parameter values from the global state only, which are available after the last commit)");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("inline std::ostream &operator<<(std::ostream &os, const ParameterStateStruct &pss)");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("pss.to_ostream(os);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return os;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileStructCC(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _ParameterStateStructHeaderFileName = this.ParameterStateStructHeaderFileName(usage);
    _builder.append(_ParameterStateStructHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _compHeaderFilename = this._smartComponent.getCompHeaderFilename(usage.getComponent());
    _builder.append(_compHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("SmartACE::ParamResponseType ParameterStateStruct::handleCOMMIT(const ParameterStateStruct &commitState) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// implement any consistency checks here which ensure that the incoming parameter meets components");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// internal constraints. If the current parameter violates any consistency checks, return ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// SmartACE::ParamResponseType::INVALID, which will result in this commitState to be rejected (not ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// copied into the globalState) and the corresponding response type is communicated back to the");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ParameterMaster. Be aware, that you should avoid blocking calls here. If you need blocking");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// calls, use an active trigger in combination with commit.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return SmartACE::ParamResponseType::OK;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// implement your custom getter methods here");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileUpdateHandlerCC(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _ParameterUpdateHandlerHeaderFileName = this.ParameterUpdateHandlerHeaderFileName(usage);
    _builder.append(_ParameterUpdateHandlerHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _compHeaderFilename = this._smartComponent.getCompHeaderFilename(usage.getComponent());
    _builder.append(_compHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("SmartACE::CommParameterResponse ParamUpdateHandler::handleParameter(const SmartACE::CommParameterRequest& request)");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("SmartACE::CommParameterResponse answer;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string tag = request.getTag();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout<<\"PARAMETER: \"<<tag<<std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generateHandleEntries = this.generateHandleEntries(usage.getParameters());
    _builder.append(_generateHandleEntries, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout<<\"[handleQuery] PARAMETER \"<<tag<<\" DONE\\n\\n\";");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return answer;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("ParameterStateStruct ParamUpdateHandler::getGlobalState() const{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("SmartACE::SmartGuard g(globalStateLock);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return this->globalState;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ParamUpdateHandler::loadParameter(SmartACE::SmartIniParameter &parameter)");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("Parameters can be specified via command line -filename=<filename>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("With this parameter present:");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("- The component will look for the file in the current working directory,");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("a path relative to the current directory or any absolute path");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("- The component will use the default values if the file cannot be found");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("With this parameter absent:");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("- <Name of Component>.ini will be read from current working directory, if found there");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("- $SMART_ROOT/etc/<Name of Component>.ini will be read otherwise");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("- Default values will be used if neither found in working directory or /etc");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// load parameters");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// print all known parameters");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("parameter.print();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// load internal parameters (if any)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//");
    _builder.newLine();
    {
      final Function1<InternalParameter, String> _function = (InternalParameter it) -> {
        return it.getName();
      };
      List<InternalParameter> _sortBy = IterableExtensions.<InternalParameter, String>sortBy(Iterables.<InternalParameter>filter(usage.getParameters(), InternalParameter.class), _function);
      for(final InternalParameter p : _sortBy) {
        _builder.append("\t\t");
        _builder.append("// parameter ");
        String _name = p.getName();
        _builder.append(_name, "\t\t");
        _builder.newLineIfNotEmpty();
        {
          final Function1<AttributeDefinition, String> _function_1 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_1 = IterableExtensions.<AttributeDefinition, String>sortBy(p.getAttributes(), _function_1);
          for(final AttributeDefinition v : _sortBy_1) {
            {
              AbstractAttributeType _type = v.getType();
              if ((_type instanceof InlineEnumerationType)) {
                {
                  Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(v);
                  if ((_isArrayType).booleanValue()) {
                    _builder.append("\t\t");
                    _builder.append("std::list<std::string> temp_");
                    String _name_1 = p.getName();
                    _builder.append(_name_1, "\t\t");
                    _builder.append("_");
                    String _name_2 = v.getName();
                    _builder.append(_name_2, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType = this._componentParamsGenHelpers.compileCommObjType(v);
                    _builder.append(_compileCommObjType, "\t\t");
                    _builder.append("List(\"");
                    String _name_3 = p.getName();
                    _builder.append(_name_3, "\t\t");
                    _builder.append("\", \"");
                    String _name_4 = v.getName();
                    _builder.append(_name_4, "\t\t");
                    _builder.append("\", temp_");
                    String _name_5 = p.getName();
                    _builder.append(_name_5, "\t\t");
                    _builder.append("_");
                    String _name_6 = v.getName();
                    _builder.append(_name_6, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("commitState.");
                    String _name_7 = p.getName();
                    _builder.append(_name_7, "\t\t\t");
                    _builder.append(".set");
                    String _firstUpper = StringExtensions.toFirstUpper(v.getName());
                    _builder.append(_firstUpper, "\t\t\t");
                    _builder.append("Type(temp_");
                    String _name_8 = p.getName();
                    _builder.append(_name_8, "\t\t\t");
                    _builder.append("_");
                    String _name_9 = v.getName();
                    _builder.append(_name_9, "\t\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("globalState.");
                    String _name_10 = p.getName();
                    _builder.append(_name_10, "\t\t\t");
                    _builder.append(".");
                    String _name_11 = v.getName();
                    _builder.append(_name_11, "\t\t\t");
                    _builder.append(" = commitState.");
                    String _name_12 = p.getName();
                    _builder.append(_name_12, "\t\t\t");
                    _builder.append(".");
                    String _name_13 = v.getName();
                    _builder.append(_name_13, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                  } else {
                    _builder.append("\t\t");
                    _builder.append("std::string temp_");
                    String _name_14 = p.getName();
                    _builder.append(_name_14, "\t\t");
                    _builder.append("_");
                    String _name_15 = v.getName();
                    _builder.append(_name_15, "\t\t");
                    _builder.append(" = \"\";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_1 = this._componentParamsGenHelpers.compileCommObjType(v);
                    _builder.append(_compileCommObjType_1, "\t\t");
                    _builder.append("(\"");
                    String _name_16 = p.getName();
                    _builder.append(_name_16, "\t\t");
                    _builder.append("\", \"");
                    String _name_17 = v.getName();
                    _builder.append(_name_17, "\t\t");
                    _builder.append("\", temp_");
                    String _name_18 = p.getName();
                    _builder.append(_name_18, "\t\t");
                    _builder.append("_");
                    String _name_19 = v.getName();
                    _builder.append(_name_19, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("commitState.");
                    String _name_20 = p.getName();
                    _builder.append(_name_20, "\t\t\t");
                    _builder.append(".");
                    String _name_21 = v.getName();
                    _builder.append(_name_21, "\t\t\t");
                    _builder.append(" = temp_");
                    String _name_22 = p.getName();
                    _builder.append(_name_22, "\t\t\t");
                    _builder.append("_");
                    String _name_23 = v.getName();
                    _builder.append(_name_23, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("globalState.");
                    String _name_24 = p.getName();
                    _builder.append(_name_24, "\t\t\t");
                    _builder.append(".");
                    String _name_25 = v.getName();
                    _builder.append(_name_25, "\t\t\t");
                    _builder.append(" = commitState.");
                    String _name_26 = p.getName();
                    _builder.append(_name_26, "\t\t\t");
                    _builder.append(".");
                    String _name_27 = v.getName();
                    _builder.append(_name_27, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                  }
                }
              } else {
                {
                  Boolean _isArrayType_1 = this._componentParameterModelUtility.isArrayType(v);
                  if ((_isArrayType_1).booleanValue()) {
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_2 = this._componentParamsGenHelpers.compileCommObjType(v);
                    _builder.append(_compileCommObjType_2, "\t\t");
                    _builder.append("List(\"");
                    String _name_28 = p.getName();
                    _builder.append(_name_28, "\t\t");
                    _builder.append("\", \"");
                    String _name_29 = v.getName();
                    _builder.append(_name_29, "\t\t");
                    _builder.append("\", commitState.");
                    String _name_30 = p.getName();
                    _builder.append(_name_30, "\t\t");
                    _builder.append(".");
                    String _name_31 = v.getName();
                    _builder.append(_name_31, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_3 = this._componentParamsGenHelpers.compileCommObjType(v);
                    _builder.append(_compileCommObjType_3, "\t\t");
                    _builder.append("(\"");
                    String _name_32 = p.getName();
                    _builder.append(_name_32, "\t\t");
                    _builder.append("\", \"");
                    String _name_33 = v.getName();
                    _builder.append(_name_33, "\t\t");
                    _builder.append("\", commitState.");
                    String _name_34 = p.getName();
                    _builder.append(_name_34, "\t\t");
                    _builder.append(".");
                    String _name_35 = v.getName();
                    _builder.append(_name_35, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("\t\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("globalState.");
                String _name_36 = p.getName();
                _builder.append(_name_36, "\t\t\t");
                _builder.append(".");
                String _name_37 = v.getName();
                _builder.append(_name_37, "\t\t\t");
                _builder.append(" = commitState.");
                String _name_38 = p.getName();
                _builder.append(_name_38, "\t\t\t");
                _builder.append(".");
                String _name_39 = v.getName();
                _builder.append(_name_39, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// load extended parameters (if any)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//");
    _builder.newLine();
    {
      final Function1<ExtendedParameter, String> _function_2 = (ExtendedParameter it) -> {
        return it.getName();
      };
      List<ExtendedParameter> _sortBy_2 = IterableExtensions.<ExtendedParameter, String>sortBy(Iterables.<ExtendedParameter>filter(usage.getParameters(), ExtendedParameter.class), _function_2);
      for(final ExtendedParameter p_1 : _sortBy_2) {
        _builder.append("\t\t");
        _builder.append("// parameter ");
        String _name_40 = p_1.getName();
        _builder.append(_name_40, "\t\t");
        _builder.newLineIfNotEmpty();
        {
          final Function1<AttributeDefinition, String> _function_3 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_3 = IterableExtensions.<AttributeDefinition, String>sortBy(p_1.getAttributes(), _function_3);
          for(final AttributeDefinition v_1 : _sortBy_3) {
            {
              AbstractAttributeType _type_1 = v_1.getType();
              if ((_type_1 instanceof InlineEnumerationType)) {
                {
                  Boolean _isArrayType_2 = this._componentParameterModelUtility.isArrayType(v_1);
                  if ((_isArrayType_2).booleanValue()) {
                    _builder.append("\t\t");
                    _builder.append("std::list<std::string> temp_");
                    String _name_41 = p_1.getName();
                    _builder.append(_name_41, "\t\t");
                    _builder.append("_");
                    String _name_42 = v_1.getName();
                    _builder.append(_name_42, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_4 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                    _builder.append(_compileCommObjType_4, "\t\t");
                    _builder.append("List(\"");
                    String _name_43 = p_1.getName();
                    _builder.append(_name_43, "\t\t");
                    _builder.append("\", \"");
                    String _name_44 = v_1.getName();
                    _builder.append(_name_44, "\t\t");
                    _builder.append("\", temp_");
                    String _name_45 = p_1.getName();
                    _builder.append(_name_45, "\t\t");
                    _builder.append("_");
                    String _name_46 = v_1.getName();
                    _builder.append(_name_46, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("commitState.");
                    String _name_47 = p_1.getName();
                    _builder.append(_name_47, "\t\t\t");
                    _builder.append(".set");
                    String _firstUpper_1 = StringExtensions.toFirstUpper(v_1.getName());
                    _builder.append(_firstUpper_1, "\t\t\t");
                    _builder.append("Type(temp_");
                    String _name_48 = p_1.getName();
                    _builder.append(_name_48, "\t\t\t");
                    _builder.append("_");
                    String _name_49 = v_1.getName();
                    _builder.append(_name_49, "\t\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("globalState.");
                    String _name_50 = p_1.getName();
                    _builder.append(_name_50, "\t\t\t");
                    _builder.append(".");
                    String _name_51 = v_1.getName();
                    _builder.append(_name_51, "\t\t\t");
                    _builder.append(" = commitState.");
                    String _name_52 = p_1.getName();
                    _builder.append(_name_52, "\t\t\t");
                    _builder.append(".");
                    String _name_53 = v_1.getName();
                    _builder.append(_name_53, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                  } else {
                    _builder.append("\t\t");
                    _builder.append("std::string temp_");
                    String _name_54 = p_1.getName();
                    _builder.append(_name_54, "\t\t");
                    _builder.append("_");
                    String _name_55 = v_1.getName();
                    _builder.append(_name_55, "\t\t");
                    _builder.append(" = \"\";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_5 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                    _builder.append(_compileCommObjType_5, "\t\t");
                    _builder.append("(\"");
                    String _name_56 = p_1.getName();
                    _builder.append(_name_56, "\t\t");
                    _builder.append("\", \"");
                    String _name_57 = v_1.getName();
                    _builder.append(_name_57, "\t\t");
                    _builder.append("\", temp_");
                    String _name_58 = p_1.getName();
                    _builder.append(_name_58, "\t\t");
                    _builder.append("_");
                    String _name_59 = v_1.getName();
                    _builder.append(_name_59, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("commitState.");
                    String _name_60 = p_1.getName();
                    _builder.append(_name_60, "\t\t\t");
                    _builder.append(".");
                    String _name_61 = v_1.getName();
                    _builder.append(_name_61, "\t\t\t");
                    _builder.append(" = temp_");
                    String _name_62 = p_1.getName();
                    _builder.append(_name_62, "\t\t\t");
                    _builder.append("_");
                    String _name_63 = v_1.getName();
                    _builder.append(_name_63, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("globalState.");
                    String _name_64 = p_1.getName();
                    _builder.append(_name_64, "\t\t\t");
                    _builder.append(".");
                    String _name_65 = v_1.getName();
                    _builder.append(_name_65, "\t\t\t");
                    _builder.append(" = commitState.");
                    String _name_66 = p_1.getName();
                    _builder.append(_name_66, "\t\t\t");
                    _builder.append(".");
                    String _name_67 = v_1.getName();
                    _builder.append(_name_67, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                  }
                }
              } else {
                {
                  Boolean _isArrayType_3 = this._componentParameterModelUtility.isArrayType(v_1);
                  if ((_isArrayType_3).booleanValue()) {
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_6 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                    _builder.append(_compileCommObjType_6, "\t\t");
                    _builder.append("List(\"");
                    String _name_68 = p_1.getName();
                    _builder.append(_name_68, "\t\t");
                    _builder.append("\", \"");
                    String _name_69 = v_1.getName();
                    _builder.append(_name_69, "\t\t");
                    _builder.append("\", commitState.");
                    String _name_70 = p_1.getName();
                    _builder.append(_name_70, "\t\t");
                    _builder.append(".");
                    String _name_71 = v_1.getName();
                    _builder.append(_name_71, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("\t\t");
                    _builder.append("if(parameter.get");
                    String _compileCommObjType_7 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                    _builder.append(_compileCommObjType_7, "\t\t");
                    _builder.append("(\"");
                    String _name_72 = p_1.getName();
                    _builder.append(_name_72, "\t\t");
                    _builder.append("\", \"");
                    String _name_73 = v_1.getName();
                    _builder.append(_name_73, "\t\t");
                    _builder.append("\", commitState.");
                    String _name_74 = p_1.getName();
                    _builder.append(_name_74, "\t\t");
                    _builder.append(".");
                    String _name_75 = v_1.getName();
                    _builder.append(_name_75, "\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("\t\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("globalState.");
                String _name_76 = p_1.getName();
                _builder.append(_name_76, "\t\t\t");
                _builder.append(".");
                String _name_77 = v_1.getName();
                _builder.append(_name_77, "\t\t\t");
                _builder.append(" = commitState.");
                String _name_78 = p_1.getName();
                _builder.append(_name_78, "\t\t\t");
                _builder.append(".");
                String _name_79 = v_1.getName();
                _builder.append(_name_79, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// load instance parameters (if a parameter definition was instantiated in the model)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//");
    _builder.newLine();
    {
      final Function1<ParameterSetInstance, String> _function_4 = (ParameterSetInstance it) -> {
        return it.getName();
      };
      List<ParameterSetInstance> _sortBy_4 = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function_4);
      for(final ParameterSetInstance inst : _sortBy_4) {
        {
          final Function1<ParameterDefinition, String> _function_5 = (ParameterDefinition it) -> {
            return it.getName();
          };
          List<ParameterDefinition> _sortBy_5 = IterableExtensions.<ParameterDefinition, String>sortBy(Iterables.<ParameterDefinition>filter(inst.getParamSet().getParameters(), ParameterDefinition.class), _function_5);
          for(final ParameterDefinition p_2 : _sortBy_5) {
            _builder.append("\t\t");
            _builder.append("// parameter ");
            String _fullyQualifiedName = this.getFullyQualifiedName(p_2);
            _builder.append(_fullyQualifiedName, "\t\t");
            _builder.newLineIfNotEmpty();
            {
              final Function1<AttributeDefinition, String> _function_6 = (AttributeDefinition it) -> {
                return it.getName();
              };
              List<AttributeDefinition> _sortBy_6 = IterableExtensions.<AttributeDefinition, String>sortBy(p_2.getAttributes(), _function_6);
              for(final AttributeDefinition v_2 : _sortBy_6) {
                {
                  AbstractAttributeType _type_2 = v_2.getType();
                  if ((_type_2 instanceof InlineEnumerationType)) {
                    {
                      Boolean _isArrayType_4 = this._componentParameterModelUtility.isArrayType(v_2);
                      if ((_isArrayType_4).booleanValue()) {
                        _builder.append("\t\t");
                        _builder.append("std::list<std::string> temp_");
                        String _fullyQualifiedVariableName = this.getFullyQualifiedVariableName(p_2);
                        _builder.append(_fullyQualifiedVariableName, "\t\t");
                        _builder.append("_");
                        String _name_80 = v_2.getName();
                        _builder.append(_name_80, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("if(parameter.get");
                        String _compileCommObjType_8 = this._componentParamsGenHelpers.compileCommObjType(v_2);
                        _builder.append(_compileCommObjType_8, "\t\t");
                        _builder.append("List(\"");
                        String _fullyQualifiedName_1 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_1, "\t\t");
                        _builder.append("\", \"");
                        String _name_81 = v_2.getName();
                        _builder.append(_name_81, "\t\t");
                        _builder.append("\", temp_");
                        String _fullyQualifiedVariableName_1 = this.getFullyQualifiedVariableName(p_2);
                        _builder.append(_fullyQualifiedVariableName_1, "\t\t");
                        _builder.append("_");
                        String _name_82 = v_2.getName();
                        _builder.append(_name_82, "\t\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("{");
                        _builder.newLine();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("commitState.");
                        String _fullyQualifiedName_2 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_2, "\t\t\t");
                        _builder.append(".set");
                        String _firstUpper_2 = StringExtensions.toFirstUpper(v_2.getName());
                        _builder.append(_firstUpper_2, "\t\t\t");
                        _builder.append("Type(temp_");
                        String _fullyQualifiedVariableName_2 = this.getFullyQualifiedVariableName(p_2);
                        _builder.append(_fullyQualifiedVariableName_2, "\t\t\t");
                        _builder.append("_");
                        String _name_83 = v_2.getName();
                        _builder.append(_name_83, "\t\t\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("globalState.");
                        String _fullyQualifiedName_3 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_3, "\t\t\t");
                        _builder.append(".");
                        String _name_84 = v_2.getName();
                        _builder.append(_name_84, "\t\t\t");
                        _builder.append(" = commitState.");
                        String _fullyQualifiedName_4 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_4, "\t\t\t");
                        _builder.append(".");
                        String _name_85 = v_2.getName();
                        _builder.append(_name_85, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("}");
                        _builder.newLine();
                      } else {
                        _builder.append("\t\t");
                        _builder.append("std::string temp_");
                        String _fullyQualifiedVariableName_3 = this.getFullyQualifiedVariableName(p_2);
                        _builder.append(_fullyQualifiedVariableName_3, "\t\t");
                        _builder.append("_");
                        String _name_86 = v_2.getName();
                        _builder.append(_name_86, "\t\t");
                        _builder.append(" = \"\";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("if(parameter.get");
                        String _compileCommObjType_9 = this._componentParamsGenHelpers.compileCommObjType(v_2);
                        _builder.append(_compileCommObjType_9, "\t\t");
                        _builder.append("(\"");
                        String _fullyQualifiedName_5 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_5, "\t\t");
                        _builder.append("\", \"");
                        String _name_87 = v_2.getName();
                        _builder.append(_name_87, "\t\t");
                        _builder.append("\", temp_");
                        String _fullyQualifiedVariableName_4 = this.getFullyQualifiedVariableName(p_2);
                        _builder.append(_fullyQualifiedVariableName_4, "\t\t");
                        _builder.append("_");
                        String _name_88 = v_2.getName();
                        _builder.append(_name_88, "\t\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("{");
                        _builder.newLine();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("commitState.");
                        String _fullyQualifiedName_6 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_6, "\t\t\t");
                        _builder.append(".");
                        String _name_89 = v_2.getName();
                        _builder.append(_name_89, "\t\t\t");
                        _builder.append(" = temp_");
                        String _fullyQualifiedVariableName_5 = this.getFullyQualifiedVariableName(p_2);
                        _builder.append(_fullyQualifiedVariableName_5, "\t\t\t");
                        _builder.append("_");
                        String _name_90 = v_2.getName();
                        _builder.append(_name_90, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("globalState.");
                        String _fullyQualifiedName_7 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_7, "\t\t\t");
                        _builder.append(".");
                        String _name_91 = v_2.getName();
                        _builder.append(_name_91, "\t\t\t");
                        _builder.append(" = commitState.");
                        String _fullyQualifiedName_8 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_8, "\t\t\t");
                        _builder.append(".");
                        String _name_92 = v_2.getName();
                        _builder.append(_name_92, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("}");
                        _builder.newLine();
                      }
                    }
                  } else {
                    {
                      Boolean _isArrayType_5 = this._componentParameterModelUtility.isArrayType(v_2);
                      if ((_isArrayType_5).booleanValue()) {
                        _builder.append("\t\t");
                        _builder.append("if(parameter.get");
                        String _compileCommObjType_10 = this._componentParamsGenHelpers.compileCommObjType(v_2);
                        _builder.append(_compileCommObjType_10, "\t\t");
                        _builder.append("List(\"");
                        String _fullyQualifiedName_9 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_9, "\t\t");
                        _builder.append("\", \"");
                        String _name_93 = v_2.getName();
                        _builder.append(_name_93, "\t\t");
                        _builder.append("\", commitState.");
                        String _fullyQualifiedName_10 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_10, "\t\t");
                        _builder.append(".");
                        String _name_94 = v_2.getName();
                        _builder.append(_name_94, "\t\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t\t");
                        _builder.append("if(parameter.get");
                        String _compileCommObjType_11 = this._componentParamsGenHelpers.compileCommObjType(v_2);
                        _builder.append(_compileCommObjType_11, "\t\t");
                        _builder.append("(\"");
                        String _fullyQualifiedName_11 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_11, "\t\t");
                        _builder.append("\", \"");
                        String _name_95 = v_2.getName();
                        _builder.append(_name_95, "\t\t");
                        _builder.append("\", commitState.");
                        String _fullyQualifiedName_12 = this.getFullyQualifiedName(p_2);
                        _builder.append(_fullyQualifiedName_12, "\t\t");
                        _builder.append(".");
                        String _name_96 = v_2.getName();
                        _builder.append(_name_96, "\t\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("globalState.");
                    String _fullyQualifiedName_13 = this.getFullyQualifiedName(p_2);
                    _builder.append(_fullyQualifiedName_13, "\t\t\t");
                    _builder.append(".");
                    String _name_97 = v_2.getName();
                    _builder.append(_name_97, "\t\t\t");
                    _builder.append(" = commitState.");
                    String _fullyQualifiedName_14 = this.getFullyQualifiedName(p_2);
                    _builder.append(_fullyQualifiedName_14, "\t\t\t");
                    _builder.append(".");
                    String _name_98 = v_2.getName();
                    _builder.append(_name_98, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                  }
                }
              }
            }
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (const SmartACE::IniParameterError & e)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cerr << \"Exception from parameter handling: \" << e << std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (const std::exception &ex)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cerr << \"Uncaught std:: exception\" << ex.what() << std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (...)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("std::cerr << \"Uncaught exception\" << std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateHandleEntries(final EList<AbstractComponentParameter> list) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (tag == \"COMMIT\")");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("answer.setResponse(globalState.handleCOMMIT(commitState));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(answer.getResponse() == SmartACE::ParamResponseType::OK) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("globalStateLock.acquire();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// change the content of the globalState, however change only the generated content");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// without affecting potential user member variables (which is more intuitive for the user)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("globalState.setContent(commitState);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("globalStateLock.release();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// the commit validation check returned != OK");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// the commit state is rejected and is not copied into the global state");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    {
      final Function1<ExtendedParameter, String> _function = (ExtendedParameter it) -> {
        return it.getName();
      };
      List<ExtendedParameter> _sortBy = IterableExtensions.<ExtendedParameter, String>sortBy(Iterables.<ExtendedParameter>filter(list, ExtendedParameter.class), _function);
      for(final ExtendedParameter ex : _sortBy) {
        _builder.append("else if (tag == \"");
        String _upperCase = ex.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("\")");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("answer.setResponse(SmartACE::ParamResponseType::OK); // TODO: this should be decided according to validation checks defined in the model (not yet implemented)");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        int counter = 0;
        _builder.newLineIfNotEmpty();
        {
          EList<AttributeDefinition> _attributes = ex.getAttributes();
          for(final AttributeDefinition v : _attributes) {
            {
              Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(v);
              if ((_isArrayType).booleanValue()) {
                _builder.append("\t");
                _builder.append("std::list<");
                String _compileParamHandlerCppType = this._componentParamsGenHelpers.compileParamHandlerCppType(v.getType());
                _builder.append(_compileParamHandlerCppType, "\t");
                _builder.append("> temp_");
                String _name = v.getName();
                _builder.append(_name, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if(request.get");
                String _compileCommObjType = this._componentParamsGenHelpers.compileCommObjType(v);
                _builder.append(_compileCommObjType, "\t");
                _builder.append("List(\"");
                _builder.append(counter = (counter + 1), "\t");
                _builder.append("\", temp_");
                String _name_1 = v.getName();
                _builder.append(_name_1, "\t");
                _builder.append(") == 0) {");
                _builder.newLineIfNotEmpty();
                {
                  AbstractAttributeType _type = v.getType();
                  if ((_type instanceof InlineEnumerationType)) {
                    _builder.append("\t");
                    _builder.append("commitState.");
                    String _name_2 = ex.getName();
                    _builder.append(_name_2, "\t");
                    _builder.append(".set");
                    String _firstUpper = StringExtensions.toFirstUpper(v.getName());
                    _builder.append(_firstUpper, "\t");
                    _builder.append("Type(temp_");
                    String _name_3 = v.getName();
                    _builder.append(_name_3, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("\t");
                    _builder.append("commitState.");
                    String _name_4 = ex.getName();
                    _builder.append(_name_4, "\t");
                    _builder.append(".");
                    String _name_5 = v.getName();
                    _builder.append(_name_5, "\t");
                    _builder.append(" = temp_");
                    String _name_6 = v.getName();
                    _builder.append(_name_6, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                  }
                }
              } else {
                _builder.append("\t");
                String _compileParamHandlerCppType_1 = this._componentParamsGenHelpers.compileParamHandlerCppType(v.getType());
                _builder.append(_compileParamHandlerCppType_1, "\t");
                _builder.append(" temp_");
                String _name_7 = v.getName();
                _builder.append(_name_7, "\t");
                _builder.append(" = ");
                String _standardValue = this._componentParamsGenHelpers.getStandardValue(v);
                _builder.append(_standardValue, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if(request.get");
                String _compileCommObjType_1 = this._componentParamsGenHelpers.compileCommObjType(v);
                _builder.append(_compileCommObjType_1, "\t");
                _builder.append("(\"");
                _builder.append(counter = (counter + 1), "\t");
                _builder.append("\", temp_");
                String _name_8 = v.getName();
                _builder.append(_name_8, "\t");
                _builder.append(") == 0) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("commitState.");
                String _name_9 = ex.getName();
                _builder.append(_name_9, "\t\t");
                _builder.append(".");
                String _name_10 = v.getName();
                _builder.append(_name_10, "\t\t");
                _builder.append(" = temp_");
                String _name_11 = v.getName();
                _builder.append(_name_11, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("answer.setResponse(SmartACE::ParamResponseType::INVALID);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      final Function1<ExtendedTrigger, String> _function_1 = (ExtendedTrigger it) -> {
        return it.getName();
      };
      List<ExtendedTrigger> _sortBy_1 = IterableExtensions.<ExtendedTrigger, String>sortBy(Iterables.<ExtendedTrigger>filter(list, ExtendedTrigger.class), _function_1);
      for(final ExtendedTrigger exTr : _sortBy_1) {
        _builder.append("else if (tag == \"");
        String _upperCase_1 = exTr.getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("\")");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        int counter_1 = 0;
        _builder.newLineIfNotEmpty();
        {
          EList<AttributeDefinition> _attributes_1 = exTr.getAttributes();
          for(final AttributeDefinition v_1 : _attributes_1) {
            {
              Boolean _isArrayType_1 = this._componentParameterModelUtility.isArrayType(v_1);
              if ((_isArrayType_1).booleanValue()) {
                _builder.append("\t");
                _builder.append("std::list<");
                String _compileParamHandlerCppType_2 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_1.getType());
                _builder.append(_compileParamHandlerCppType_2, "\t");
                _builder.append("> temp_");
                String _name_12 = v_1.getName();
                _builder.append(_name_12, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if(request.get");
                String _compileCommObjType_2 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                _builder.append(_compileCommObjType_2, "\t");
                _builder.append("List(\"");
                _builder.append(counter_1 = (counter_1 + 1), "\t");
                _builder.append("\", temp_");
                String _name_13 = v_1.getName();
                _builder.append(_name_13, "\t");
                _builder.append(") != 0) {");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                String _compileParamHandlerCppType_3 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_1.getType());
                _builder.append(_compileParamHandlerCppType_3, "\t");
                _builder.append(" temp_");
                String _name_14 = v_1.getName();
                _builder.append(_name_14, "\t");
                _builder.append(" = ");
                String _standardValue_1 = this._componentParamsGenHelpers.getStandardValue(v_1);
                _builder.append(_standardValue_1, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if(request.get");
                String _compileCommObjType_3 = this._componentParamsGenHelpers.compileCommObjType(v_1);
                _builder.append(_compileCommObjType_3, "\t");
                _builder.append("(\"");
                _builder.append(counter_1 = (counter_1 + 1), "\t");
                _builder.append("\", temp_");
                String _name_15 = v_1.getName();
                _builder.append(_name_15, "\t");
                _builder.append(") != 0) {");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("answer.setResponse(SmartACE::ParamResponseType::INVALID);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(answer.getResponse() == SmartACE::ParamResponseType::OK) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("triggerHandler.handle");
        String _firstUpper_1 = StringExtensions.toFirstUpper(exTr.getName());
        _builder.append(_firstUpper_1, "\t\t");
        _builder.append("Core(");
        _builder.newLineIfNotEmpty();
        {
          EList<AttributeDefinition> _attributes_2 = exTr.getAttributes();
          for(final AttributeDefinition v_2 : _attributes_2) {
            {
              if (((this._componentParameterModelUtility.isArrayType(v_2)).booleanValue() && (v_2.getType() instanceof InlineEnumerationType))) {
                _builder.append("\t\t");
                _builder.append("TriggerHandler::");
                String _name_16 = exTr.getName();
                _builder.append(_name_16, "\t\t");
                _builder.append("Type::convert");
                String _firstUpper_2 = StringExtensions.toFirstUpper(v_2.getName());
                _builder.append(_firstUpper_2, "\t\t");
                _builder.append("Type(temp_");
                String _name_17 = v_2.getName();
                _builder.append(_name_17, "\t\t");
                _builder.append(")");
                {
                  AttributeDefinition _last = IterableExtensions.<AttributeDefinition>last(exTr.getAttributes());
                  boolean _notEquals = (!Objects.equal(v_2, _last));
                  if (_notEquals) {
                    _builder.append(", ");
                  }
                }
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t\t");
                _builder.append("temp_");
                String _name_18 = v_2.getName();
                _builder.append(_name_18, "\t\t");
                {
                  AttributeDefinition _last_1 = IterableExtensions.<AttributeDefinition>last(exTr.getAttributes());
                  boolean _notEquals_1 = (!Objects.equal(v_2, _last_1));
                  if (_notEquals_1) {
                    _builder.append(", ");
                  }
                }
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      final Function1<ParameterSetInstance, String> _function_2 = (ParameterSetInstance it) -> {
        return it.getName();
      };
      List<ParameterSetInstance> _sortBy_2 = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(list, ParameterSetInstance.class), _function_2);
      for(final ParameterSetInstance ex_1 : _sortBy_2) {
        {
          final Function1<AbstractParameter, String> _function_3 = (AbstractParameter it) -> {
            return it.getName();
          };
          List<AbstractParameter> _sortBy_3 = IterableExtensions.<AbstractParameter, String>sortBy(ex_1.getParamSet().getParameters(), _function_3);
          for(final AbstractParameter p : _sortBy_3) {
            _builder.append("else if (tag == \"");
            String _upperCase_2 = this.getFullyQualifiedName(p).toUpperCase();
            _builder.append(_upperCase_2);
            _builder.append("\")");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            {
              if ((p instanceof TriggerDefinition)) {
                _builder.append("\t");
                _builder.append("answer.setResponse(SmartACE::ParamResponseType::OK);");
                _builder.newLine();
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                int counter_2 = 0;
                _builder.newLineIfNotEmpty();
                {
                  EList<AttributeDefinition> _attributes_3 = ((TriggerDefinition)p).getAttributes();
                  for(final AttributeDefinition v_3 : _attributes_3) {
                    {
                      Boolean _isArrayType_2 = this._componentParameterModelUtility.isArrayType(v_3);
                      if ((_isArrayType_2).booleanValue()) {
                        _builder.append("\t");
                        _builder.append("std::list<");
                        String _compileParamHandlerCppType_4 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_3.getType());
                        _builder.append(_compileParamHandlerCppType_4, "\t");
                        _builder.append("> temp_");
                        String _name_19 = v_3.getName();
                        _builder.append(_name_19, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("if(request.get");
                        String _compileCommObjType_4 = this._componentParamsGenHelpers.compileCommObjType(v_3);
                        _builder.append(_compileCommObjType_4, "\t");
                        _builder.append("List(\"");
                        _builder.append(counter_2 = (counter_2 + 1), "\t");
                        _builder.append("\", temp_");
                        String _name_20 = v_3.getName();
                        _builder.append(_name_20, "\t");
                        _builder.append(") != 0) {");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        String _compileParamHandlerCppType_5 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_3.getType());
                        _builder.append(_compileParamHandlerCppType_5, "\t");
                        _builder.append(" temp_");
                        String _name_21 = v_3.getName();
                        _builder.append(_name_21, "\t");
                        _builder.append(" = ");
                        String _standardValue_2 = this._componentParamsGenHelpers.getStandardValue(v_3);
                        _builder.append(_standardValue_2, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("if(request.get");
                        String _compileCommObjType_5 = this._componentParamsGenHelpers.compileCommObjType(v_3);
                        _builder.append(_compileCommObjType_5, "\t");
                        _builder.append("(\"");
                        _builder.append(counter_2 = (counter_2 + 1), "\t");
                        _builder.append("\", temp_");
                        String _name_22 = v_3.getName();
                        _builder.append(_name_22, "\t");
                        _builder.append(") != 0) {");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("answer.setResponse(SmartACE::ParamResponseType::INVALID);");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                  }
                }
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if(answer.getResponse() == SmartACE::ParamResponseType::OK) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("triggerHandler.handle");
                String _firstUpper_3 = StringExtensions.toFirstUpper(this.getFullyQualifiedVariableName(p));
                _builder.append(_firstUpper_3, "\t\t");
                _builder.append("Core(");
                _builder.newLineIfNotEmpty();
                {
                  EList<AttributeDefinition> _attributes_4 = ((TriggerDefinition)p).getAttributes();
                  for(final AttributeDefinition v_4 : _attributes_4) {
                    {
                      if (((this._componentParameterModelUtility.isArrayType(v_4)).booleanValue() && (v_4.getType() instanceof InlineEnumerationType))) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("TriggerHandler::");
                        String _name_23 = ((TriggerDefinition)p).getName();
                        _builder.append(_name_23, "\t\t");
                        _builder.append("Type::convert");
                        String _firstUpper_4 = StringExtensions.toFirstUpper(v_4.getName());
                        _builder.append(_firstUpper_4, "\t\t");
                        _builder.append("Type(temp_");
                        String _name_24 = v_4.getName();
                        _builder.append(_name_24, "\t\t");
                        _builder.append(")");
                        {
                          AttributeDefinition _last_2 = IterableExtensions.<AttributeDefinition>last(((TriggerDefinition)p).getAttributes());
                          boolean _notEquals_2 = (!Objects.equal(v_4, _last_2));
                          if (_notEquals_2) {
                            _builder.append(", ");
                          }
                        }
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("temp_");
                        String _name_25 = v_4.getName();
                        _builder.append(_name_25, "\t\t");
                        {
                          AttributeDefinition _last_3 = IterableExtensions.<AttributeDefinition>last(((TriggerDefinition)p).getAttributes());
                          boolean _notEquals_3 = (!Objects.equal(v_4, _last_3));
                          if (_notEquals_3) {
                            _builder.append(", ");
                          }
                        }
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  }
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(");");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              } else {
                if ((p instanceof ParameterDefinition)) {
                  _builder.append("\t");
                  _builder.append("answer.setResponse(SmartACE::ParamResponseType::OK); // TODO: this should be decided according to validation checks defined in the model (not yet implemented)");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.newLine();
                  _builder.append("\t");
                  int counter_3 = 0;
                  _builder.newLineIfNotEmpty();
                  {
                    EList<AttributeDefinition> _attributes_5 = ((ParameterDefinition)p).getAttributes();
                    for(final AttributeDefinition v_5 : _attributes_5) {
                      {
                        Boolean _isArrayType_3 = this._componentParameterModelUtility.isArrayType(v_5);
                        if ((_isArrayType_3).booleanValue()) {
                          _builder.append("\t");
                          _builder.append("std::list<");
                          String _compileParamHandlerCppType_6 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_5.getType());
                          _builder.append(_compileParamHandlerCppType_6, "\t");
                          _builder.append("> temp_");
                          String _name_26 = v_5.getName();
                          _builder.append(_name_26, "\t");
                          _builder.append(";");
                          _builder.newLineIfNotEmpty();
                          _builder.append("\t");
                          _builder.append("if(request.get");
                          String _compileCommObjType_6 = this._componentParamsGenHelpers.compileCommObjType(v_5);
                          _builder.append(_compileCommObjType_6, "\t");
                          _builder.append("List(\"");
                          _builder.append(counter_3 = (counter_3 + 1), "\t");
                          _builder.append("\", temp_");
                          String _name_27 = v_5.getName();
                          _builder.append(_name_27, "\t");
                          _builder.append(") == 0) {");
                          _builder.newLineIfNotEmpty();
                          {
                            AbstractAttributeType _type_1 = v_5.getType();
                            if ((_type_1 instanceof InlineEnumerationType)) {
                              _builder.append("\t");
                              _builder.append("\t");
                              _builder.append("commitState.");
                              String _fullyQualifiedName = this.getFullyQualifiedName(p);
                              _builder.append(_fullyQualifiedName, "\t\t");
                              _builder.append(".set");
                              String _firstUpper_5 = StringExtensions.toFirstUpper(v_5.getName());
                              _builder.append(_firstUpper_5, "\t\t");
                              _builder.append("Type(temp_");
                              String _name_28 = v_5.getName();
                              _builder.append(_name_28, "\t\t");
                              _builder.append(");");
                              _builder.newLineIfNotEmpty();
                            } else {
                              _builder.append("\t");
                              _builder.append("\t");
                              _builder.append("commitState.");
                              String _fullyQualifiedName_1 = this.getFullyQualifiedName(p);
                              _builder.append(_fullyQualifiedName_1, "\t\t");
                              _builder.append(".");
                              String _name_29 = v_5.getName();
                              _builder.append(_name_29, "\t\t");
                              _builder.append(" = temp_");
                              String _name_30 = v_5.getName();
                              _builder.append(_name_30, "\t\t");
                              _builder.append(";");
                              _builder.newLineIfNotEmpty();
                            }
                          }
                        } else {
                          _builder.append("\t");
                          String _compileParamHandlerCppType_7 = this._componentParamsGenHelpers.compileParamHandlerCppType(v_5.getType());
                          _builder.append(_compileParamHandlerCppType_7, "\t");
                          _builder.append(" temp_");
                          String _name_31 = v_5.getName();
                          _builder.append(_name_31, "\t");
                          _builder.append(" = ");
                          String _standardValue_3 = this._componentParamsGenHelpers.getStandardValue(v_5);
                          _builder.append(_standardValue_3, "\t");
                          _builder.append(";");
                          _builder.newLineIfNotEmpty();
                          _builder.append("\t");
                          _builder.append("if(request.get");
                          String _compileCommObjType_7 = this._componentParamsGenHelpers.compileCommObjType(v_5);
                          _builder.append(_compileCommObjType_7, "\t");
                          _builder.append("(\"");
                          _builder.append(counter_3 = (counter_3 + 1), "\t");
                          _builder.append("\", temp_");
                          String _name_32 = v_5.getName();
                          _builder.append(_name_32, "\t");
                          _builder.append(") == 0) {");
                          _builder.newLineIfNotEmpty();
                          _builder.append("\t");
                          _builder.append("\t");
                          _builder.append("commitState.");
                          String _fullyQualifiedName_2 = this.getFullyQualifiedName(p);
                          _builder.append(_fullyQualifiedName_2, "\t\t");
                          _builder.append(".");
                          String _name_33 = v_5.getName();
                          _builder.append(_name_33, "\t\t");
                          _builder.append(" = temp_");
                          String _name_34 = v_5.getName();
                          _builder.append(_name_34, "\t\t");
                          _builder.append(";");
                          _builder.newLineIfNotEmpty();
                        }
                      }
                      _builder.append("\t");
                      _builder.append("} else {");
                      _builder.newLine();
                      _builder.append("\t");
                      _builder.append("\t");
                      _builder.append("answer.setResponse(SmartACE::ParamResponseType::INVALID);");
                      _builder.newLine();
                      _builder.append("\t");
                      _builder.append("}");
                      _builder.newLine();
                    }
                  }
                  _builder.append("\t");
                  _builder.newLine();
                }
              }
            }
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("else");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/////////////////////////////////////////////////////////////////////");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// default new");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout<<\"ERROR wrong Parameter!\"<<std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("answer.setResponse(SmartACE::ParamResponseType::INVALID);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileUpdateHandlerHH(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _PARAMUPDATEHANDLER_HH_");
    _builder.newLine();
    _builder.append("#define _PARAMUPDATEHANDLER_HH_");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.append("#include \"");
    String _ParameterStateStructHeaderFileName = this.ParameterStateStructHeaderFileName(usage);
    _builder.append(_ParameterStateStructHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    {
      if ((IterableExtensions.<ParameterSetInstance>exists(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), ((Function1<ParameterSetInstance, Boolean>) (ParameterSetInstance pi) -> {
        final Function1<AbstractParameter, Boolean> _function = (AbstractParameter pd) -> {
          return Boolean.valueOf((pd instanceof TriggerDefinition));
        };
        return Boolean.valueOf(IterableExtensions.<AbstractParameter>exists(pi.getParamSet().getParameters(), _function));
      })) || IterableExtensions.<AbstractComponentParameter>exists(usage.getParameters(), ((Function1<AbstractComponentParameter, Boolean>) (AbstractComponentParameter tr) -> {
        return Boolean.valueOf((tr instanceof ExtendedTrigger));
      })))) {
        _builder.append("#include \"");
        String _TriggerHandlerHeaderFileName = this.TriggerHandlerHeaderFileName(usage);
        _builder.append(_TriggerHandlerHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("class ParamUpdateHandler: public SmartACE::ParameterUpdateHandler {");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("SmartACE::CommParameterResponse handleParameter(const SmartACE::CommParameterRequest& request);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ParameterStateStruct getGlobalState() const;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void loadParameter(SmartACE::SmartIniParameter &parameter);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("protected:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//local globale state stuff");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ParameterStateStruct globalState,commitState;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("mutable SmartACE::SmartMutex globalStateLock;");
    _builder.newLine();
    {
      if ((IterableExtensions.<ParameterSetInstance>exists(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), ((Function1<ParameterSetInstance, Boolean>) (ParameterSetInstance pi) -> {
        final Function1<AbstractParameter, Boolean> _function = (AbstractParameter pd) -> {
          return Boolean.valueOf((pd instanceof TriggerDefinition));
        };
        return Boolean.valueOf(IterableExtensions.<AbstractParameter>exists(pi.getParamSet().getParameters(), _function));
      })) || IterableExtensions.<AbstractComponentParameter>exists(usage.getParameters(), ((Function1<AbstractComponentParameter, Boolean>) (AbstractComponentParameter tr) -> {
        return Boolean.valueOf((tr instanceof ExtendedTrigger));
      })))) {
        _builder.append("\t");
        _builder.append("TriggerHandler triggerHandler;");
        _builder.newLine();
      }
    }
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileStructCore(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _PARAMETERSTATESTRUCTCORE_HH");
    _builder.newLine();
    _builder.append("#define _PARAMETERSTATESTRUCTCORE_HH");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// forward declaration (in order to define validateCOMMIT(ParameterStateStruct) which is implemented in derived class)");
    _builder.newLine();
    _builder.append("class ParameterStateStruct;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("class ParameterStateStructCore");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("friend class ParamUpdateHandler;");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generateMemberStructs = this.generateMemberStructs(usage);
    _builder.append(_generateMemberStructs, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("protected:");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generateMemberVariables = this.generateMemberVariables(usage);
    _builder.append(_generateMemberVariables, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generateMembersCopyFunction = this.generateMembersCopyFunction(usage);
    _builder.append(_generateMembersCopyFunction, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// special trigger method (user upcall) called before updating parameter global state");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual SmartACE::ParamResponseType handleCOMMIT(const ParameterStateStruct &commitState) = 0;");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ParameterStateStructCore() {  }");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ~ParameterStateStructCore() {  }");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generateGetterMethods = this.generateGetterMethods(usage);
    _builder.append(_generateGetterMethods, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// helper method to easily implement output stream in derived classes");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void to_ostream(std::ostream &os = std::cout) const");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generateOSmembers = this.generateOSmembers(usage);
    _builder.append(_generateOSmembers, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateEnumClass(final AttributeDefinition attr) {
    CharSequence _xifexpression = null;
    AbstractAttributeType _type = attr.getType();
    if ((_type instanceof InlineEnumerationType)) {
      CharSequence _xblockexpression = null;
      {
        AbstractAttributeType _type_1 = attr.getType();
        InlineEnumerationType en = ((InlineEnumerationType) _type_1);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Wrapper class for Enum ");
        String _name = attr.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("class ");
        String _name_1 = attr.getName();
        _builder.append(_name_1);
        _builder.append("Type {");
        _builder.newLineIfNotEmpty();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("enum ENUM_");
        String _name_2 = attr.getName();
        _builder.append(_name_2, "\t");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("ENUM_VALUE_UNDEFINED = 0,");
        _builder.newLine();
        _builder.append("\t\t");
        int counter = 0;
        _builder.newLineIfNotEmpty();
        {
          EList<EnumerationElement> _enums = en.getEnums();
          for(final EnumerationElement el : _enums) {
            _builder.append("\t\t");
            String _name_3 = el.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append(" = ");
            _builder.append(counter = (counter + 1), "\t\t");
            {
              EnumerationElement _last = IterableExtensions.<EnumerationElement>last(en.getEnums());
              boolean _notEquals = (!Objects.equal(el, _last));
              if (_notEquals) {
                _builder.append(",");
              }
            }
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// default constructor");
        _builder.newLine();
        _builder.append("\t");
        String _name_4 = attr.getName();
        _builder.append(_name_4, "\t");
        _builder.append("Type() { ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("value = ENUM_VALUE_UNDEFINED;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// copy constructor for enum type");
        _builder.newLine();
        _builder.append("\t");
        String _name_5 = attr.getName();
        _builder.append(_name_5, "\t");
        _builder.append("Type(ENUM_");
        String _name_6 = attr.getName();
        _builder.append(_name_6, "\t");
        _builder.append(" e) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("value = e;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// copy constructor for String type");
        _builder.newLine();
        _builder.append("\t");
        String _name_7 = attr.getName();
        _builder.append(_name_7, "\t");
        _builder.append("Type(const std::string &literal) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("from_string(literal);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// from_string assignment operator");
        _builder.newLine();
        _builder.append("\t");
        String _name_8 = attr.getName();
        _builder.append(_name_8, "\t");
        _builder.append("Type& operator = (const std::string &literal) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("from_string(literal);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return *this;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// ENUM operator");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("operator ENUM_");
        String _name_9 = attr.getName();
        _builder.append(_name_9, "\t");
        _builder.append("() const {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return value;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// String operator");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("operator std::string() const {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return to_string();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// compare operator");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bool operator == (const ENUM_");
        String _name_10 = attr.getName();
        _builder.append(_name_10, "\t");
        _builder.append(" t) const {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return this->value == t;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::string to_string() const {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::string result = \"\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch (value) {");
        _builder.newLine();
        {
          final Function1<EnumerationElement, String> _function = (EnumerationElement it) -> {
            return it.getName();
          };
          List<EnumerationElement> _sortBy = IterableExtensions.<EnumerationElement, String>sortBy(en.getEnums(), _function);
          for(final EnumerationElement el_1 : _sortBy) {
            _builder.append("\t\t\t");
            _builder.append("case ");
            String _name_11 = el_1.getName();
            _builder.append(_name_11, "\t\t\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("result = \"");
            String _name_12 = el_1.getName();
            _builder.append(_name_12, "\t\t\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
          }
        }
        _builder.append("\t\t\t");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("result = \"ENUM_VALUE_UNDEFINED\";");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void from_string(const std::string &literal) {");
        _builder.newLine();
        {
          EList<EnumerationElement> _enums_1 = en.getEnums();
          for(final EnumerationElement el_2 : _enums_1) {
            {
              EnumerationElement _head = IterableExtensions.<EnumerationElement>head(en.getEnums());
              boolean _equals = Objects.equal(el_2, _head);
              if (_equals) {
                _builder.append("\t\t");
                _builder.append("if(literal == \"");
                String _name_13 = el_2.getName();
                _builder.append(_name_13, "\t\t");
                _builder.append("\") {");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t\t");
                _builder.append("} else if(literal == \"");
                String _name_14 = el_2.getName();
                _builder.append(_name_14, "\t\t");
                _builder.append("\") {");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("value = ");
            String _name_15 = el_2.getName();
            _builder.append(_name_15, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("value = ENUM_VALUE_UNDEFINED;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// helper method to easily implement output stream");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void to_ostream(std::ostream &os = std::cout) const {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("os << to_string();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("private:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ENUM_");
        String _name_16 = attr.getName();
        _builder.append(_name_16, "\t");
        _builder.append(" value;");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  public CharSequence generateMemberStructs(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("///////////////////////////////////////////");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Internal params");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("///////////////////////////////////////////");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    {
      Iterable<InternalParameter> _filter = Iterables.<InternalParameter>filter(usage.getParameters(), InternalParameter.class);
      for(final InternalParameter p : _filter) {
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("* Definition of Parameter ");
        String _name = p.getName();
        _builder.append(_name, "\t ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class ");
        String _name_1 = p.getName();
        _builder.append(_name_1, "\t");
        _builder.append("Type ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("friend class ParamUpdateHandler;");
        _builder.newLine();
        {
          final Function1<AttributeDefinition, Boolean> _function = (AttributeDefinition v) -> {
            AbstractAttributeType _type = v.getType();
            return Boolean.valueOf((_type instanceof InlineEnumerationType));
          };
          final Function1<AttributeDefinition, String> _function_1 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy = IterableExtensions.<AttributeDefinition, String>sortBy(IterableExtensions.<AttributeDefinition>filter(p.getAttributes(), _function), _function_1);
          for(final AttributeDefinition attr : _sortBy) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generateEnumClass = this.generateEnumClass(attr);
            _builder.append(_generateEnumClass, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            {
              Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(attr);
              if ((_isArrayType).booleanValue()) {
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _generateEnumArrayConversionMethod = this.generateEnumArrayConversionMethod(attr);
                _builder.append(_generateEnumArrayConversionMethod, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t ");
        _builder.append("* here are the member definitions");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        {
          final Function1<AttributeDefinition, String> _function_2 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_1 = IterableExtensions.<AttributeDefinition, String>sortBy(p.getAttributes(), _function_2);
          for(final AttributeDefinition el : _sortBy_1) {
            {
              Boolean _isArrayType_1 = this._componentParameterModelUtility.isArrayType(el);
              if ((_isArrayType_1).booleanValue()) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("std::list<");
                String _compileCppType = this._componentParamsGenHelpers.compileCppType(el);
                _builder.append(_compileCppType, "\t\t");
                _builder.append("> ");
                String _name_2 = el.getName();
                _builder.append(_name_2, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("\t");
                String _compileCppType_1 = this._componentParamsGenHelpers.compileCppType(el);
                _builder.append(_compileCppType_1, "\t\t");
                _builder.append(" ");
                String _name_3 = el.getName();
                _builder.append(_name_3, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("// default constructor");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        String _name_4 = p.getName();
        _builder.append(_name_4, "\t\t");
        _builder.append("Type() {");
        _builder.newLineIfNotEmpty();
        {
          final Function1<AttributeDefinition, String> _function_3 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_2 = IterableExtensions.<AttributeDefinition, String>sortBy(p.getAttributes(), _function_3);
          for(final AttributeDefinition el_1 : _sortBy_2) {
            {
              ArrayType _array = el_1.getType().getArray();
              boolean _tripleNotEquals = (_array != null);
              if (_tripleNotEquals) {
                {
                  AbstractValue _defaultvalue = el_1.getDefaultvalue();
                  EList<SingleValue> _values = ((ArrayValue) _defaultvalue).getValues();
                  for(final SingleValue v : _values) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    String _name_5 = el_1.getName();
                    _builder.append(_name_5, "\t\t\t");
                    _builder.append(".push_back(");
                    String _compileContent = this._componentParamsGenHelpers.compileContent(v);
                    _builder.append(_compileContent, "\t\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                  }
                }
              } else {
                _builder.append("\t");
                _builder.append("\t\t");
                String _name_6 = el_1.getName();
                _builder.append(_name_6, "\t\t\t");
                _builder.append(" = ");
                String _compileContent_1 = this._componentParamsGenHelpers.compileContent(el_1.getDefaultvalue());
                _builder.append(_compileContent_1, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t ");
        _builder.append("* here are the public getters");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        {
          final Function1<AttributeDefinition, String> _function_4 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_3 = IterableExtensions.<AttributeDefinition, String>sortBy(p.getAttributes(), _function_4);
          for(final AttributeDefinition el_2 : _sortBy_3) {
            {
              ArrayType _array_1 = el_2.getType().getArray();
              boolean _tripleNotEquals_1 = (_array_1 != null);
              if (_tripleNotEquals_1) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("inline std::list<");
                String _compileCppType_2 = this._componentParamsGenHelpers.compileCppType(el_2);
                _builder.append(_compileCppType_2, "\t\t");
                _builder.append("> get");
                String _firstUpper = StringExtensions.toFirstUpper(el_2.getName());
                _builder.append(_firstUpper, "\t\t");
                _builder.append("() const { return ");
                String _name_7 = el_2.getName();
                _builder.append(_name_7, "\t\t");
                _builder.append("; }");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("inline ");
                String _compileCppType_3 = this._componentParamsGenHelpers.compileCppType(el_2);
                _builder.append(_compileCppType_3, "\t\t");
                _builder.append(" get");
                String _firstUpper_1 = StringExtensions.toFirstUpper(el_2.getName());
                _builder.append(_firstUpper_1, "\t\t");
                _builder.append("() const { return ");
                String _name_8 = el_2.getName();
                _builder.append(_name_8, "\t\t");
                _builder.append("; }");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("void to_ostream(std::ostream &os = std::cout) const");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("os << \"");
        String _name_9 = p.getName();
        _builder.append(_name_9, "\t\t\t");
        _builder.append("(\";");
        _builder.newLineIfNotEmpty();
        {
          final Function1<AttributeDefinition, String> _function_5 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_4 = IterableExtensions.<AttributeDefinition, String>sortBy(p.getAttributes(), _function_5);
          for(final AttributeDefinition el_3 : _sortBy_4) {
            {
              AbstractValue _defaultvalue_1 = el_3.getDefaultvalue();
              if ((_defaultvalue_1 instanceof ArrayValue)) {
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("std::list<");
                String _compileCppType_4 = this._componentParamsGenHelpers.compileCppType(el_3);
                _builder.append(_compileCppType_4, "\t\t\t");
                _builder.append(">::const_iterator ");
                String _name_10 = el_3.getName();
                _builder.append(_name_10, "\t\t\t");
                _builder.append("It;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("for(");
                String _name_11 = el_3.getName();
                _builder.append(_name_11, "\t\t\t");
                _builder.append("It=");
                String _name_12 = el_3.getName();
                _builder.append(_name_12, "\t\t\t");
                _builder.append(".begin(); ");
                String _name_13 = el_3.getName();
                _builder.append(_name_13, "\t\t\t");
                _builder.append("It!=");
                String _name_14 = el_3.getName();
                _builder.append(_name_14, "\t\t\t");
                _builder.append(".end(); ");
                String _name_15 = el_3.getName();
                _builder.append(_name_15, "\t\t\t");
                _builder.append("It++)");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("{");
                _builder.newLine();
                {
                  AbstractValue _defaultvalue_2 = el_3.getDefaultvalue();
                  EList<SingleValue> _values_1 = ((ArrayValue) _defaultvalue_2).getValues();
                  for(final SingleValue v_1 : _values_1) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("os << \"");
                    String _name_16 = el_3.getName();
                    _builder.append(_name_16, "\t\t\t");
                    _builder.append(" = \" << *");
                    String _name_17 = el_3.getName();
                    _builder.append(_name_17, "\t\t\t");
                    _builder.append("It << \", \";");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
              } else {
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("os << \"");
                String _name_18 = el_3.getName();
                _builder.append(_name_18, "\t\t\t");
                _builder.append(" = \" << ");
                String _name_19 = el_3.getName();
                _builder.append(_name_19, "\t\t\t");
                _builder.append(" << \", \";");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("os << \")\\n\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}; // end class ");
        String _name_20 = p.getName();
        _builder.append(_name_20, "\t");
        _builder.append("Type");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("///////////////////////////////////////////");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// External params");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("///////////////////////////////////////////");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    {
      Iterable<ExtendedParameter> _filter_1 = Iterables.<ExtendedParameter>filter(usage.getParameters(), ExtendedParameter.class);
      for(final ExtendedParameter ex : _filter_1) {
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("* Definition of Parameter ");
        String _name_21 = ex.getName();
        _builder.append(_name_21, "\t ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class ");
        String _name_22 = ex.getName();
        _builder.append(_name_22, "\t");
        _builder.append("Type ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("friend class ParamUpdateHandler;");
        _builder.newLine();
        {
          final Function1<AttributeDefinition, Boolean> _function_6 = (AttributeDefinition v_2) -> {
            AbstractAttributeType _type = v_2.getType();
            return Boolean.valueOf((_type instanceof InlineEnumerationType));
          };
          final Function1<AttributeDefinition, String> _function_7 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_5 = IterableExtensions.<AttributeDefinition, String>sortBy(IterableExtensions.<AttributeDefinition>filter(ex.getAttributes(), _function_6), _function_7);
          for(final AttributeDefinition attr_1 : _sortBy_5) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generateEnumClass_1 = this.generateEnumClass(attr_1);
            _builder.append(_generateEnumClass_1, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            {
              Boolean _isArrayType_2 = this._componentParameterModelUtility.isArrayType(attr_1);
              if ((_isArrayType_2).booleanValue()) {
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _generateEnumArrayConversionMethod_1 = this.generateEnumArrayConversionMethod(attr_1);
                _builder.append(_generateEnumArrayConversionMethod_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t ");
        _builder.append("* here are the member definitions");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        {
          final Function1<AttributeDefinition, String> _function_8 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_6 = IterableExtensions.<AttributeDefinition, String>sortBy(ex.getAttributes(), _function_8);
          for(final AttributeDefinition el_4 : _sortBy_6) {
            {
              Boolean _isArrayType_3 = this._componentParameterModelUtility.isArrayType(el_4);
              if ((_isArrayType_3).booleanValue()) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("std::list<");
                String _compileCppType_5 = this._componentParamsGenHelpers.compileCppType(el_4);
                _builder.append(_compileCppType_5, "\t\t");
                _builder.append("> ");
                String _name_23 = el_4.getName();
                _builder.append(_name_23, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("\t");
                String _compileCppType_6 = this._componentParamsGenHelpers.compileCppType(el_4);
                _builder.append(_compileCppType_6, "\t\t");
                _builder.append(" ");
                String _name_24 = el_4.getName();
                _builder.append(_name_24, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("// default constructor");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        String _name_25 = ex.getName();
        _builder.append(_name_25, "\t\t");
        _builder.append("Type() {");
        _builder.newLineIfNotEmpty();
        {
          final Function1<AttributeDefinition, String> _function_9 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_7 = IterableExtensions.<AttributeDefinition, String>sortBy(ex.getAttributes(), _function_9);
          for(final AttributeDefinition el_5 : _sortBy_7) {
            {
              AbstractValue _defaultvalue_3 = el_5.getDefaultvalue();
              if ((_defaultvalue_3 instanceof ArrayValue)) {
                {
                  AbstractValue _defaultvalue_4 = el_5.getDefaultvalue();
                  EList<SingleValue> _values_2 = ((ArrayValue) _defaultvalue_4).getValues();
                  for(final SingleValue v_2 : _values_2) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    String _name_26 = el_5.getName();
                    _builder.append(_name_26, "\t\t\t");
                    _builder.append(".push_back(");
                    String _compileContent_2 = this._componentParamsGenHelpers.compileContent(v_2);
                    _builder.append(_compileContent_2, "\t\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                  }
                }
              } else {
                _builder.append("\t");
                _builder.append("\t\t");
                String _name_27 = el_5.getName();
                _builder.append(_name_27, "\t\t\t");
                _builder.append(" = ");
                String _compileContent_3 = this._componentParamsGenHelpers.compileContent(el_5.getDefaultvalue());
                _builder.append(_compileContent_3, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t ");
        _builder.append("* here are the public getters");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        {
          final Function1<AttributeDefinition, String> _function_10 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_8 = IterableExtensions.<AttributeDefinition, String>sortBy(ex.getAttributes(), _function_10);
          for(final AttributeDefinition el_6 : _sortBy_8) {
            {
              Boolean _isArrayType_4 = this._componentParameterModelUtility.isArrayType(el_6);
              if ((_isArrayType_4).booleanValue()) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("inline std::list<");
                String _compileCppType_7 = this._componentParamsGenHelpers.compileCppType(el_6);
                _builder.append(_compileCppType_7, "\t\t");
                _builder.append("> get");
                String _firstUpper_2 = StringExtensions.toFirstUpper(el_6.getName());
                _builder.append(_firstUpper_2, "\t\t");
                _builder.append("() const { return ");
                String _name_28 = el_6.getName();
                _builder.append(_name_28, "\t\t");
                _builder.append("; }");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("inline ");
                String _compileCppType_8 = this._componentParamsGenHelpers.compileCppType(el_6);
                _builder.append(_compileCppType_8, "\t\t");
                _builder.append(" get");
                String _firstUpper_3 = StringExtensions.toFirstUpper(el_6.getName());
                _builder.append(_firstUpper_3, "\t\t");
                _builder.append("() const { return ");
                String _name_29 = el_6.getName();
                _builder.append(_name_29, "\t\t");
                _builder.append("; }");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("void to_ostream(std::ostream &os = std::cout) const");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("os << \"");
        String _name_30 = ex.getName();
        _builder.append(_name_30, "\t\t\t");
        _builder.append("(\";");
        _builder.newLineIfNotEmpty();
        {
          final Function1<AttributeDefinition, String> _function_11 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_9 = IterableExtensions.<AttributeDefinition, String>sortBy(ex.getAttributes(), _function_11);
          for(final AttributeDefinition el_7 : _sortBy_9) {
            {
              AbstractValue _defaultvalue_5 = el_7.getDefaultvalue();
              if ((_defaultvalue_5 instanceof ArrayValue)) {
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("std::list<");
                String _compileCppType_9 = this._componentParamsGenHelpers.compileCppType(el_7);
                _builder.append(_compileCppType_9, "\t\t\t");
                _builder.append(">::const_iterator ");
                String _name_31 = el_7.getName();
                _builder.append(_name_31, "\t\t\t");
                _builder.append("It;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("for(");
                String _name_32 = el_7.getName();
                _builder.append(_name_32, "\t\t\t");
                _builder.append("It=");
                String _name_33 = el_7.getName();
                _builder.append(_name_33, "\t\t\t");
                _builder.append(".begin(); ");
                String _name_34 = el_7.getName();
                _builder.append(_name_34, "\t\t\t");
                _builder.append("It!=");
                String _name_35 = el_7.getName();
                _builder.append(_name_35, "\t\t\t");
                _builder.append(".end(); ");
                String _name_36 = el_7.getName();
                _builder.append(_name_36, "\t\t\t");
                _builder.append("It++)");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("{");
                _builder.newLine();
                {
                  AbstractValue _defaultvalue_6 = el_7.getDefaultvalue();
                  EList<SingleValue> _values_3 = ((ArrayValue) _defaultvalue_6).getValues();
                  for(final SingleValue v_3 : _values_3) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("os << \"");
                    String _name_37 = el_7.getName();
                    _builder.append(_name_37, "\t\t\t");
                    _builder.append(" = \" << *");
                    String _name_38 = el_7.getName();
                    _builder.append(_name_38, "\t\t\t");
                    _builder.append("It << \", \";");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
              } else {
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("os << \"");
                String _name_39 = el_7.getName();
                _builder.append(_name_39, "\t\t\t");
                _builder.append(" = \" << ");
                String _name_40 = el_7.getName();
                _builder.append(_name_40, "\t\t\t");
                _builder.append(" << \", \";");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("os << \")\\n\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}; // end class ");
        String _name_41 = ex.getName();
        _builder.append(_name_41, "\t");
        _builder.append("Type");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("///////////////////////////////////////////");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Instance params");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("///////////////////////////////////////////");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    {
      Set<Map.Entry<String, List<ParameterSetInstance>>> _entrySet = this.getAllRepos(usage).entrySet();
      for(final Map.Entry<String, List<ParameterSetInstance>> repo : _entrySet) {
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("* Definition of instantiated ParameterRepository ");
        String _key = repo.getKey();
        _builder.append(_key, "\t ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class ");
        String _key_1 = repo.getKey();
        _builder.append(_key_1, "\t");
        _builder.append("Type {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("friend class ParamUpdateHandler;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        {
          List<ParameterSetInstance> _value = repo.getValue();
          for(final ParameterSetInstance set_inst : _value) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* Definition of instantiated ParameterSet ");
            String _name_42 = set_inst.getParamSet().getName();
            _builder.append(_name_42, "\t\t ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("class ");
            String _name_43 = set_inst.getParamSet().getName();
            _builder.append(_name_43, "\t\t");
            _builder.append("Type {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("friend class ParamUpdateHandler;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public:");
            _builder.newLine();
            {
              final Function1<ParameterDefinition, String> _function_12 = (ParameterDefinition it) -> {
                return it.getName();
              };
              List<ParameterDefinition> _sortBy_10 = IterableExtensions.<ParameterDefinition, String>sortBy(Iterables.<ParameterDefinition>filter(set_inst.getParamSet().getParameters(), ParameterDefinition.class), _function_12);
              for(final ParameterDefinition param : _sortBy_10) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("/**");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("* Definition of Parameter ");
                String _name_44 = param.getName();
                _builder.append(_name_44, "\t\t\t ");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("class ");
                String _name_45 = param.getName();
                _builder.append(_name_45, "\t\t\t");
                _builder.append("Type {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("friend class ParamUpdateHandler;");
                _builder.newLine();
                {
                  final Function1<AttributeDefinition, Boolean> _function_13 = (AttributeDefinition it) -> {
                    AbstractAttributeType _type = it.getType();
                    return Boolean.valueOf((_type instanceof InlineEnumerationType));
                  };
                  final Function1<AttributeDefinition, String> _function_14 = (AttributeDefinition it) -> {
                    return it.getName();
                  };
                  List<AttributeDefinition> _sortBy_11 = IterableExtensions.<AttributeDefinition, String>sortBy(IterableExtensions.<AttributeDefinition>filter(param.getAttributes(), _function_13), _function_14);
                  for(final AttributeDefinition attr_2 : _sortBy_11) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("public:");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _generateEnumClass_2 = this.generateEnumClass(attr_2);
                    _builder.append(_generateEnumClass_2, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    {
                      Boolean _isArrayType_5 = this._componentParameterModelUtility.isArrayType(attr_2);
                      if ((_isArrayType_5).booleanValue()) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        CharSequence _generateEnumArrayConversionMethod_2 = this.generateEnumArrayConversionMethod(attr_2);
                        _builder.append(_generateEnumArrayConversionMethod_2, "\t\t\t\t");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                  }
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("protected:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("/**");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t ");
                _builder.append("* here are the member definitions");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t ");
                _builder.append("*/");
                _builder.newLine();
                {
                  final Function1<AttributeDefinition, String> _function_15 = (AttributeDefinition it) -> {
                    return it.getName();
                  };
                  List<AttributeDefinition> _sortBy_12 = IterableExtensions.<AttributeDefinition, String>sortBy(param.getAttributes(), _function_15);
                  for(final AttributeDefinition v_4 : _sortBy_12) {
                    {
                      Boolean _isArrayType_6 = this._componentParameterModelUtility.isArrayType(v_4);
                      if ((_isArrayType_6).booleanValue()) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("std::list<");
                        String _compileCppType_10 = this._componentParamsGenHelpers.compileCppType(v_4);
                        _builder.append(_compileCppType_10, "\t\t\t\t");
                        _builder.append("> ");
                        String _name_46 = v_4.getName();
                        _builder.append(_name_46, "\t\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        String _compileCppType_11 = this._componentParamsGenHelpers.compileCppType(v_4);
                        _builder.append(_compileCppType_11, "\t\t\t\t");
                        _builder.append(" ");
                        String _name_47 = v_4.getName();
                        _builder.append(_name_47, "\t\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  }
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("// default constructor");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                String _name_48 = param.getName();
                _builder.append(_name_48, "\t\t\t\t");
                _builder.append("Type() {");
                _builder.newLineIfNotEmpty();
                {
                  final Function1<AttributeDefinition, String> _function_16 = (AttributeDefinition it) -> {
                    return it.getName();
                  };
                  List<AttributeDefinition> _sortBy_13 = IterableExtensions.<AttributeDefinition, String>sortBy(param.getAttributes(), _function_16);
                  for(final AttributeDefinition v_5 : _sortBy_13) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    String _generateConstructorDefaultValues = this.generateConstructorDefaultValues(v_5, param, set_inst);
                    _builder.append(_generateConstructorDefaultValues, "\t\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("/**");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t ");
                _builder.append("* here are the getter methods");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t ");
                _builder.append("*/");
                _builder.newLine();
                {
                  final Function1<AttributeDefinition, String> _function_17 = (AttributeDefinition it) -> {
                    return it.getName();
                  };
                  List<AttributeDefinition> _sortBy_14 = IterableExtensions.<AttributeDefinition, String>sortBy(param.getAttributes(), _function_17);
                  for(final AttributeDefinition v_6 : _sortBy_14) {
                    {
                      Boolean _isArrayType_7 = this._componentParameterModelUtility.isArrayType(v_6);
                      if ((_isArrayType_7).booleanValue()) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("inline std::list<");
                        String _compileCppType_12 = this._componentParamsGenHelpers.compileCppType(v_6);
                        _builder.append(_compileCppType_12, "\t\t\t\t");
                        _builder.append("> get");
                        String _firstUpper_4 = StringExtensions.toFirstUpper(v_6.getName());
                        _builder.append(_firstUpper_4, "\t\t\t\t");
                        _builder.append("() const { return ");
                        String _name_49 = v_6.getName();
                        _builder.append(_name_49, "\t\t\t\t");
                        _builder.append("; }");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("inline ");
                        String _compileCppType_13 = this._componentParamsGenHelpers.compileCppType(v_6);
                        _builder.append(_compileCppType_13, "\t\t\t\t");
                        _builder.append(" get");
                        String _firstUpper_5 = StringExtensions.toFirstUpper(v_6.getName());
                        _builder.append(_firstUpper_5, "\t\t\t\t");
                        _builder.append("() const { return ");
                        String _name_50 = v_6.getName();
                        _builder.append(_name_50, "\t\t\t\t");
                        _builder.append("; }");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  }
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("void to_ostream(std::ostream &os = std::cout) const");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("os << \"\\t");
                String _name_51 = param.getName();
                _builder.append(_name_51, "\t\t\t\t\t");
                _builder.append("(\";");
                _builder.newLineIfNotEmpty();
                {
                  final Function1<AttributeDefinition, String> _function_18 = (AttributeDefinition it) -> {
                    return it.getName();
                  };
                  List<AttributeDefinition> _sortBy_15 = IterableExtensions.<AttributeDefinition, String>sortBy(param.getAttributes(), _function_18);
                  for(final AttributeDefinition el_8 : _sortBy_15) {
                    {
                      if ((el_8 instanceof ArrayValue)) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("std::list<");
                        String _compileCppType_14 = this._componentParamsGenHelpers.compileCppType(el_8);
                        _builder.append(_compileCppType_14, "\t\t\t\t\t");
                        _builder.append(">::const_iterator ");
                        String _name_52 = el_8.getName();
                        _builder.append(_name_52, "\t\t\t\t\t");
                        _builder.append("It;");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("for(");
                        String _name_53 = el_8.getName();
                        _builder.append(_name_53, "\t\t\t\t\t");
                        _builder.append("It=");
                        String _name_54 = el_8.getName();
                        _builder.append(_name_54, "\t\t\t\t\t");
                        _builder.append(".begin(); ");
                        String _name_55 = el_8.getName();
                        _builder.append(_name_55, "\t\t\t\t\t");
                        _builder.append("It!=");
                        String _name_56 = el_8.getName();
                        _builder.append(_name_56, "\t\t\t\t\t");
                        _builder.append(".end(); ");
                        String _name_57 = el_8.getName();
                        _builder.append(_name_57, "\t\t\t\t\t");
                        _builder.append("It++)");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("{");
                        _builder.newLine();
                        {
                          EList<SingleValue> _values_4 = ((ArrayValue) el_8).getValues();
                          for(final SingleValue v_7 : _values_4) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t\t");
                            _builder.append("os << \"");
                            String _name_58 = el_8.getName();
                            _builder.append(_name_58, "\t\t\t\t\t");
                            _builder.append(" = \" << *");
                            String _name_59 = el_8.getName();
                            _builder.append(_name_59, "\t\t\t\t\t");
                            _builder.append("It << \", \";");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("}");
                        _builder.newLine();
                      } else {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("os << \"");
                        String _name_60 = el_8.getName();
                        _builder.append(_name_60, "\t\t\t\t\t");
                        _builder.append(" = \" << ");
                        String _name_61 = el_8.getName();
                        _builder.append(_name_61, "\t\t\t\t\t");
                        _builder.append(" << \", \";");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  }
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("os << \")\\n\";");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}; // end of parameter class ");
                String _name_62 = param.getName();
                _builder.append(_name_62, "\t\t\t");
                _builder.append("Type");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
              }
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("protected:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t ");
            _builder.append("* internal members");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t ");
            _builder.append("*/");
            _builder.newLine();
            {
              final Function1<ParameterDefinition, String> _function_19 = (ParameterDefinition it) -> {
                return it.getName();
              };
              List<ParameterDefinition> _sortBy_16 = IterableExtensions.<ParameterDefinition, String>sortBy(Iterables.<ParameterDefinition>filter(set_inst.getParamSet().getParameters(), ParameterDefinition.class), _function_19);
              for(final ParameterDefinition param_1 : _sortBy_16) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                String _name_63 = param_1.getName();
                _builder.append(_name_63, "\t\t\t\t");
                _builder.append("Type ");
                String _name_64 = param_1.getName();
                _builder.append(_name_64, "\t\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t ");
            _builder.append("* public getter methods");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t ");
            _builder.append("*/");
            _builder.newLine();
            {
              final Function1<ParameterDefinition, String> _function_20 = (ParameterDefinition it) -> {
                return it.getName();
              };
              List<ParameterDefinition> _sortBy_17 = IterableExtensions.<ParameterDefinition, String>sortBy(Iterables.<ParameterDefinition>filter(set_inst.getParamSet().getParameters(), ParameterDefinition.class), _function_20);
              for(final ParameterDefinition param_2 : _sortBy_17) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("inline ");
                String _name_65 = param_2.getName();
                _builder.append(_name_65, "\t\t\t\t");
                _builder.append("Type get");
                String _firstUpper_6 = StringExtensions.toFirstUpper(param_2.getName());
                _builder.append(_firstUpper_6, "\t\t\t\t");
                _builder.append("() const { return ");
                String _name_66 = param_2.getName();
                _builder.append(_name_66, "\t\t\t\t");
                _builder.append("; }");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("void to_ostream(std::ostream &os = std::cout) const");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("os << \"");
            String _name_67 = set_inst.getParamSet().getName();
            _builder.append(_name_67, "\t\t\t\t\t");
            _builder.append("(\\n\";");
            _builder.newLineIfNotEmpty();
            {
              final Function1<ParameterDefinition, String> _function_21 = (ParameterDefinition it) -> {
                return it.getName();
              };
              List<ParameterDefinition> _sortBy_18 = IterableExtensions.<ParameterDefinition, String>sortBy(Iterables.<ParameterDefinition>filter(set_inst.getParamSet().getParameters(), ParameterDefinition.class), _function_21);
              for(final ParameterDefinition param_3 : _sortBy_18) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t\t");
                String _name_68 = param_3.getName();
                _builder.append(_name_68, "\t\t\t\t\t");
                _builder.append(".to_ostream(os);");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("os << \")\";");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}; // end of parameter-set class ");
            String _name_69 = set_inst.getParamSet().getName();
            _builder.append(_name_69, "\t\t");
            _builder.append("Type");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t ");
        _builder.append("* internal members");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        {
          List<ParameterSetInstance> _value_1 = repo.getValue();
          for(final ParameterSetInstance set_inst_1 : _value_1) {
            _builder.append("\t");
            _builder.append("\t\t");
            String _name_70 = set_inst_1.getParamSet().getName();
            _builder.append(_name_70, "\t\t\t");
            _builder.append("Type ");
            String _name_71 = set_inst_1.getParamSet().getName();
            _builder.append(_name_71, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t ");
        _builder.append("* public getter methods");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        {
          List<ParameterSetInstance> _value_2 = repo.getValue();
          for(final ParameterSetInstance set_inst_2 : _value_2) {
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("inline ");
            String _name_72 = set_inst_2.getParamSet().getName();
            _builder.append(_name_72, "\t\t\t");
            _builder.append("Type get");
            String _firstUpper_7 = StringExtensions.toFirstUpper(set_inst_2.getParamSet().getName());
            _builder.append(_firstUpper_7, "\t\t\t");
            _builder.append("() const { return ");
            String _name_73 = set_inst_2.getParamSet().getName();
            _builder.append(_name_73, "\t\t\t");
            _builder.append("; }");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("void to_ostream(std::ostream &os = std::cout) const");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("os << \"");
        String _key_2 = repo.getKey();
        _builder.append(_key_2, "\t\t\t\t");
        _builder.append("(\\n\";");
        _builder.newLineIfNotEmpty();
        {
          List<ParameterSetInstance> _value_3 = repo.getValue();
          for(final ParameterSetInstance set_inst_3 : _value_3) {
            _builder.append("\t");
            _builder.append("\t\t\t");
            String _name_74 = set_inst_3.getParamSet().getName();
            _builder.append(_name_74, "\t\t\t\t");
            _builder.append(".to_ostream(os);");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("os << \")\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}; // end of parameter-repository wrapper class ");
        String _key_3 = repo.getKey();
        _builder.append(_key_3, "\t");
        _builder.append("Type");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  private String generateConstructorDefaultValues(final AttributeDefinition attr, final ParameterDefinition par, final ParameterSetInstance set_inst) {
    Iterable<ParameterInstance> _filter = Iterables.<ParameterInstance>filter(set_inst.getParameterInstances(), ParameterInstance.class);
    ParameterInstance _findFirst = null;
    if (_filter!=null) {
      final Function1<ParameterInstance, Boolean> _function = (ParameterInstance p) -> {
        return Boolean.valueOf(p.getParameterDef().equals(par));
      };
      _findFirst=IterableExtensions.<ParameterInstance>findFirst(_filter, _function);
    }
    ParameterInstance par_inst = _findFirst;
    String result = "";
    if ((par_inst != null)) {
      final Function1<AttributeRefinement, Boolean> _function_1 = (AttributeRefinement a) -> {
        return Boolean.valueOf(a.getAttribute().equals(attr));
      };
      AttributeRefinement attr_inst = IterableExtensions.<AttributeRefinement>findFirst(par_inst.getAttributes(), _function_1);
      if ((attr_inst != null)) {
        AbstractValue _value = attr_inst.getValue();
        if ((_value instanceof ArrayValue)) {
          AbstractValue _value_1 = attr_inst.getValue();
          EList<SingleValue> _values = ((ArrayValue) _value_1).getValues();
          for (final SingleValue curr_attr : _values) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = attr_inst.getAttribute().getName();
            _builder.append(_name);
            _builder.append(".push_back(");
            String _compileContent = this._componentParamsGenHelpers.compileContent(curr_attr);
            _builder.append(_compileContent);
            _builder.append(");");
            String _plus = (result + _builder);
            result = _plus;
          }
        } else {
          StringConcatenation _builder_1 = new StringConcatenation();
          String _name_1 = attr_inst.getAttribute().getName();
          _builder_1.append(_name_1);
          _builder_1.append(" = ");
          String _compileContent_1 = this._componentParamsGenHelpers.compileContent(attr_inst.getValue());
          _builder_1.append(_compileContent_1);
          _builder_1.append(";");
          result = _builder_1.toString();
        }
      }
    }
    boolean _isEmpty = result.isEmpty();
    if (_isEmpty) {
      StringConcatenation _builder_2 = new StringConcatenation();
      String _name_2 = attr.getName();
      _builder_2.append(_name_2);
      _builder_2.append(" = ");
      String _standardValue = this._componentParamsGenHelpers.getStandardValue(attr);
      _builder_2.append(_standardValue);
      _builder_2.append(";");
      result = _builder_2.toString();
    }
    return result;
  }
  
  private Map<String, List<ParameterSetInstance>> getAllRepos(final ComponentParameter usage) {
    Map<String, List<ParameterSetInstance>> repos = new HashMap<String, List<ParameterSetInstance>>();
    Iterable<ParameterSetInstance> _filter = Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class);
    for (final ParameterSetInstance set_inst : _filter) {
      {
        EObject _eContainer = set_inst.getParamSet().eContainer();
        ParameterSetRepository curr_repo = ((ParameterSetRepository) _eContainer);
        List<ParameterSetInstance> _get = repos.get(curr_repo.getName());
        boolean _tripleEquals = (_get == null);
        if (_tripleEquals) {
          String _name = curr_repo.getName();
          ArrayList<ParameterSetInstance> _arrayList = new ArrayList<ParameterSetInstance>();
          repos.put(_name, _arrayList);
        }
        repos.get(curr_repo.getName()).add(set_inst);
      }
    }
    return repos;
  }
  
  private CharSequence generateEnumArrayConversionMethod(final AttributeDefinition attr) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("void set");
    String _firstUpper = StringExtensions.toFirstUpper(attr.getName());
    _builder.append(_firstUpper);
    _builder.append("Type(const std::list<std::string> &");
    String _name = attr.getName();
    _builder.append(_name);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::list<std::string>::const_iterator it;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this->");
    String _name_1 = attr.getName();
    _builder.append(_name_1, "\t");
    _builder.append(".clear();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for(it=");
    String _name_2 = attr.getName();
    _builder.append(_name_2, "\t");
    _builder.append(".begin(); it!=");
    String _name_3 = attr.getName();
    _builder.append(_name_3, "\t");
    _builder.append(".end(); it++) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this->");
    String _name_4 = attr.getName();
    _builder.append(_name_4, "\t\t");
    _builder.append(".push_back(*it);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateMembersCopyFunction(final ComponentParameter model) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("void setContent(const ParameterStateStructCore &commit) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// External params");
    _builder.newLine();
    {
      final Function1<ExtendedParameter, String> _function = (ExtendedParameter it) -> {
        return it.getName();
      };
      List<ExtendedParameter> _sortBy = IterableExtensions.<ExtendedParameter, String>sortBy(Iterables.<ExtendedParameter>filter(model.getParameters(), ExtendedParameter.class), _function);
      for(final ExtendedParameter ex : _sortBy) {
        _builder.append("\t");
        _builder.append("this->");
        String _name = ex.getName();
        _builder.append(_name, "\t");
        _builder.append(" = commit.get");
        String _firstUpper = StringExtensions.toFirstUpper(ex.getName());
        _builder.append(_firstUpper, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      Set<String> _keySet = this.getAllRepos(model).keySet();
      for(final String repo : _keySet) {
        _builder.append("\t");
        _builder.append("this->");
        _builder.append(repo, "\t");
        _builder.append(" = commit.get");
        String _firstUpper_1 = StringExtensions.toFirstUpper(repo);
        _builder.append(_firstUpper_1, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateMemberVariables(final ComponentParameter model) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Internal params");
    _builder.newLine();
    {
      final Function1<InternalParameter, String> _function = (InternalParameter it) -> {
        return it.getName();
      };
      List<InternalParameter> _sortBy = IterableExtensions.<InternalParameter, String>sortBy(Iterables.<InternalParameter>filter(model.getParameters(), InternalParameter.class), _function);
      for(final InternalParameter p : _sortBy) {
        String _name = p.getName();
        _builder.append(_name);
        _builder.append("Type ");
        String _name_1 = p.getName();
        _builder.append(_name_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("// External params");
    _builder.newLine();
    {
      final Function1<ExtendedParameter, String> _function_1 = (ExtendedParameter it) -> {
        return it.getName();
      };
      List<ExtendedParameter> _sortBy_1 = IterableExtensions.<ExtendedParameter, String>sortBy(Iterables.<ExtendedParameter>filter(model.getParameters(), ExtendedParameter.class), _function_1);
      for(final ExtendedParameter ex : _sortBy_1) {
        String _name_2 = ex.getName();
        _builder.append(_name_2);
        _builder.append("Type ");
        String _name_3 = ex.getName();
        _builder.append(_name_3);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("// Instance params (encapsulated in a wrapper class for each instantiated parameter repository)");
    _builder.newLine();
    {
      Set<String> _keySet = this.getAllRepos(model).keySet();
      for(final String repo : _keySet) {
        _builder.append(repo);
        _builder.append("Type ");
        _builder.append(repo);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence generateOSmembers(final ComponentParameter model) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Internal params");
    _builder.newLine();
    {
      final Function1<InternalParameter, String> _function = (InternalParameter it) -> {
        return it.getName();
      };
      List<InternalParameter> _sortBy = IterableExtensions.<InternalParameter, String>sortBy(Iterables.<InternalParameter>filter(model.getParameters(), InternalParameter.class), _function);
      for(final InternalParameter p : _sortBy) {
        String _name = p.getName();
        _builder.append(_name);
        _builder.append(".to_ostream(os);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("// External params");
    _builder.newLine();
    {
      final Function1<ExtendedParameter, String> _function_1 = (ExtendedParameter it) -> {
        return it.getName();
      };
      List<ExtendedParameter> _sortBy_1 = IterableExtensions.<ExtendedParameter, String>sortBy(Iterables.<ExtendedParameter>filter(model.getParameters(), ExtendedParameter.class), _function_1);
      for(final ExtendedParameter ex : _sortBy_1) {
        String _name_1 = ex.getName();
        _builder.append(_name_1);
        _builder.append(".to_ostream(os);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("// Instance params (encapsulated in a wrapper class for each instantiated parameter repository)");
    _builder.newLine();
    {
      Set<String> _keySet = this.getAllRepos(model).keySet();
      for(final String repo : _keySet) {
        _builder.append(repo);
        _builder.append(".to_ostream(os);");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence generateUpcallsCore(final ComponentParameter model) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Extended param upcall methods");
    _builder.newLine();
    {
      final Function1<ExtendedParameter, String> _function = (ExtendedParameter it) -> {
        return it.getName();
      };
      List<ExtendedParameter> _sortBy = IterableExtensions.<ExtendedParameter, String>sortBy(Iterables.<ExtendedParameter>filter(model.getParameters(), ExtendedParameter.class), _function);
      for(final ExtendedParameter ex : _sortBy) {
        _builder.append("SmartACE::ParamResponseType handle");
        String _upperCase = ex.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("Core(");
        String _nameTypes = this._componentParamsGenHelpers.getNameTypes(ex.getAttributes(), true);
        _builder.append(_nameTypes);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        {
          final Function1<AttributeDefinition, String> _function_1 = (AttributeDefinition it) -> {
            return it.getName();
          };
          List<AttributeDefinition> _sortBy_1 = IterableExtensions.<AttributeDefinition, String>sortBy(ex.getAttributes(), _function_1);
          for(final AttributeDefinition el : _sortBy_1) {
            _builder.append("\t");
            _builder.append("this->");
            String _name = ex.getName();
            _builder.append(_name, "\t");
            _builder.append(".");
            String _name_1 = el.getName();
            _builder.append(_name_1, "\t");
            _builder.append(" = ");
            String _name_2 = el.getName();
            _builder.append(_name_2, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("return handle");
        String _upperCase_1 = ex.getName().toUpperCase();
        _builder.append(_upperCase_1, "\t");
        _builder.append("(");
        String _name_3 = ex.getName();
        _builder.append(_name_3, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    {
      final Function1<ParameterSetInstance, String> _function_2 = (ParameterSetInstance it) -> {
        return it.getName();
      };
      List<ParameterSetInstance> _sortBy_2 = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(model.getParameters(), ParameterSetInstance.class), _function_2);
      for(final ParameterSetInstance paramSetInst : _sortBy_2) {
        _builder.append("// Instance param upcall methods");
        _builder.newLine();
        {
          Iterable<ParameterDefinition> _filter = Iterables.<ParameterDefinition>filter(paramSetInst.getParamSet().getParameters(), ParameterDefinition.class);
          for(final ParameterDefinition p : _filter) {
            _builder.append("SmartACE::ParamResponseType handle");
            String _upperCase_2 = p.getName().toUpperCase();
            _builder.append(_upperCase_2);
            _builder.append("Core(");
            String _nameTypes_1 = this._componentParamsGenHelpers.getNameTypes(p.getAttributes(), true);
            _builder.append(_nameTypes_1);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            {
              final Function1<AttributeDefinition, String> _function_3 = (AttributeDefinition it) -> {
                return it.getName();
              };
              List<AttributeDefinition> _sortBy_3 = IterableExtensions.<AttributeDefinition, String>sortBy(p.getAttributes(), _function_3);
              for(final AttributeDefinition v : _sortBy_3) {
                _builder.append("\t");
                _builder.append("this->");
                String _name_4 = p.getName();
                _builder.append(_name_4, "\t");
                _builder.append(".");
                String _name_5 = v.getName();
                _builder.append(_name_5, "\t");
                _builder.append(" = ");
                String _name_6 = v.getName();
                _builder.append(_name_6, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("return handle");
            String _upperCase_3 = p.getName().toUpperCase();
            _builder.append(_upperCase_3, "\t");
            _builder.append("(");
            String _ntNames = this._componentParamsGenHelpers.getNtNames(p.getAttributes());
            _builder.append(_ntNames, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence generateUpcalls(final ComponentParameter model) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Extended param user upcall methods");
    _builder.newLine();
    {
      final Function1<ExtendedParameter, String> _function = (ExtendedParameter it) -> {
        return it.getName();
      };
      List<ExtendedParameter> _sortBy = IterableExtensions.<ExtendedParameter, String>sortBy(Iterables.<ExtendedParameter>filter(model.getParameters(), ExtendedParameter.class), _function);
      for(final ExtendedParameter ex : _sortBy) {
        _builder.append("virtual SmartACE::ParamResponseType handle");
        String _upperCase = ex.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("(");
        String _nameTypes = this._componentParamsGenHelpers.getNameTypes(ex.getAttributes(), true);
        _builder.append(_nameTypes);
        _builder.append(") = 0;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      final Function1<ParameterSetInstance, String> _function_1 = (ParameterSetInstance it) -> {
        return it.getName();
      };
      List<ParameterSetInstance> _sortBy_1 = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(model.getParameters(), ParameterSetInstance.class), _function_1);
      for(final ParameterSetInstance paramSetInst : _sortBy_1) {
        _builder.append("// Instance param user upcall methods");
        _builder.newLine();
        {
          final Function1<ParameterDefinition, String> _function_2 = (ParameterDefinition it) -> {
            return it.getName();
          };
          List<ParameterDefinition> _sortBy_2 = IterableExtensions.<ParameterDefinition, String>sortBy(Iterables.<ParameterDefinition>filter(paramSetInst.getParamSet().getParameters(), ParameterDefinition.class), _function_2);
          for(final ParameterDefinition p : _sortBy_2) {
            _builder.append("virtual SmartACE::ParamResponseType handle");
            String _upperCase_1 = p.getName().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("(");
            String _nameTypes_1 = this._componentParamsGenHelpers.getNameTypes(p.getAttributes(), true);
            _builder.append(_nameTypes_1);
            _builder.append(") = 0;");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence generateGetterMethods(final ComponentParameter model) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// internal param getters");
    _builder.newLine();
    {
      final Function1<InternalParameter, String> _function = (InternalParameter it) -> {
        return it.getName();
      };
      List<InternalParameter> _sortBy = IterableExtensions.<InternalParameter, String>sortBy(Iterables.<InternalParameter>filter(model.getParameters(), InternalParameter.class), _function);
      for(final InternalParameter in : _sortBy) {
        {
          boolean _isEmpty = in.getAttributes().isEmpty();
          boolean _not = (!_isEmpty);
          if (_not) {
            String _name = in.getName();
            _builder.append(_name);
            _builder.append("Type get");
            String _firstUpper = StringExtensions.toFirstUpper(in.getName());
            _builder.append(_firstUpper);
            _builder.append("() const {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return ");
            String _name_1 = in.getName();
            _builder.append(_name_1, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("// external param getters");
    _builder.newLine();
    {
      final Function1<ExtendedParameter, String> _function_1 = (ExtendedParameter it) -> {
        return it.getName();
      };
      List<ExtendedParameter> _sortBy_1 = IterableExtensions.<ExtendedParameter, String>sortBy(Iterables.<ExtendedParameter>filter(model.getParameters(), ExtendedParameter.class), _function_1);
      for(final ExtendedParameter ex : _sortBy_1) {
        {
          boolean _isEmpty_1 = ex.getAttributes().isEmpty();
          boolean _not_1 = (!_isEmpty_1);
          if (_not_1) {
            String _name_2 = ex.getName();
            _builder.append(_name_2);
            _builder.append("Type get");
            String _firstUpper_1 = StringExtensions.toFirstUpper(ex.getName());
            _builder.append(_firstUpper_1);
            _builder.append("() const {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return ");
            String _name_3 = ex.getName();
            _builder.append(_name_3, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("// repo wrapper class getter(s)");
    _builder.newLine();
    {
      Set<String> _keySet = this.getAllRepos(model).keySet();
      for(final String repo : _keySet) {
        _builder.append(repo);
        _builder.append("Type get");
        String _firstUpper_2 = StringExtensions.toFirstUpper(repo);
        _builder.append(_firstUpper_2);
        _builder.append("() const {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        _builder.append(repo, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence compileIniFile(final ComponentParameter usage) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#####################");
    _builder.newLine();
    _builder.append("# internal parameters");
    _builder.newLine();
    _builder.append("#####################");
    _builder.newLine();
    {
      final Function1<InternalParameter, String> _function = (InternalParameter g) -> {
        return g.getName();
      };
      List<InternalParameter> _sortBy = IterableExtensions.<InternalParameter, String>sortBy(Iterables.<InternalParameter>filter(usage.getParameters(), InternalParameter.class), _function);
      for(final InternalParameter internalGroup : _sortBy) {
        CharSequence _compileIniFileParameter = this.compileIniFileParameter(internalGroup);
        _builder.append(_compileIniFileParameter);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("#####################");
    _builder.newLine();
    _builder.append("# extended parameters");
    _builder.newLine();
    _builder.append("#####################");
    _builder.newLine();
    {
      final Function1<ExtendedParameter, String> _function_1 = (ExtendedParameter it) -> {
        return it.getName();
      };
      List<ExtendedParameter> _sortBy_1 = IterableExtensions.<ExtendedParameter, String>sortBy(Iterables.<ExtendedParameter>filter(usage.getParameters(), ExtendedParameter.class), _function_1);
      for(final ExtendedParameter extended : _sortBy_1) {
        CharSequence _compileIniFileParameter_1 = this.compileIniFileParameter(extended);
        _builder.append(_compileIniFileParameter_1);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("#####################");
    _builder.newLine();
    _builder.append("# instance parameters");
    _builder.newLine();
    _builder.append("#####################");
    _builder.newLine();
    {
      final Function1<ParameterSetInstance, String> _function_2 = (ParameterSetInstance it) -> {
        return it.getName();
      };
      List<ParameterSetInstance> _sortBy_2 = IterableExtensions.<ParameterSetInstance, String>sortBy(Iterables.<ParameterSetInstance>filter(usage.getParameters(), ParameterSetInstance.class), _function_2);
      for(final ParameterSetInstance paramSetInstance : _sortBy_2) {
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# ParameterSet ");
        String _name = paramSetInstance.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        {
          final Function1<ParameterDefinition, String> _function_3 = (ParameterDefinition it) -> {
            return it.getName();
          };
          List<ParameterDefinition> _sortBy_3 = IterableExtensions.<ParameterDefinition, String>sortBy(Iterables.<ParameterDefinition>filter(paramSetInstance.getParamSet().getParameters(), ParameterDefinition.class), _function_3);
          for(final ParameterDefinition par : _sortBy_3) {
            {
              final Function1<ParameterInstance, Boolean> _function_4 = (ParameterInstance p) -> {
                ParameterDefinition _parameterDef = p.getParameterDef();
                return Boolean.valueOf(Objects.equal(_parameterDef, par));
              };
              boolean _exists = IterableExtensions.<ParameterInstance>exists(Iterables.<ParameterInstance>filter(paramSetInstance.getParameterInstances(), ParameterInstance.class), _function_4);
              if (_exists) {
                final Function1<ParameterInstance, Boolean> _function_5 = (ParameterInstance p) -> {
                  ParameterDefinition _parameterDef = p.getParameterDef();
                  return Boolean.valueOf(Objects.equal(_parameterDef, par));
                };
                CharSequence _compileIniFileParameter_2 = this.compileIniFileParameter(IterableExtensions.<ParameterInstance>findFirst(Iterables.<ParameterInstance>filter(paramSetInstance.getParameterInstances(), ParameterInstance.class), _function_5));
                _builder.append(_compileIniFileParameter_2);
                _builder.newLineIfNotEmpty();
              } else {
                {
                  final Function1<AttributeDefinition, String> _function_6 = (AttributeDefinition it) -> {
                    return it.getName();
                  };
                  List<AttributeDefinition> _sortBy_4 = IterableExtensions.<AttributeDefinition, String>sortBy(par.getAttributes(), _function_6);
                  for(final AttributeDefinition el : _sortBy_4) {
                    {
                      Boolean _isArrayType = this._componentParameterModelUtility.isArrayType(el);
                      if ((_isArrayType).booleanValue()) {
                        _builder.append("# element ");
                        String _name_1 = el.getName();
                        _builder.append(_name_1);
                        _builder.append(" is an array type without a default value");
                        _builder.newLineIfNotEmpty();
                      } else {
                        String _name_2 = el.getName();
                        _builder.append(_name_2);
                        _builder.append(" ");
                        CharSequence _defaultValue = this._componentParamsGenHelpers.getDefaultValue(el.getType());
                        _builder.append(_defaultValue);
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  }
                }
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence compileIniFileParameter(final ComponentParameterBase parameter) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((parameter instanceof InternalParameter)) {
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# InternalParameter ");
        String _name = ((InternalParameter)parameter).getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("[");
        String _name_1 = ((InternalParameter)parameter).getName();
        _builder.append(_name_1);
        _builder.append("]");
        _builder.newLineIfNotEmpty();
        {
          final Function1<AttributeDefinition, String> _function = (AttributeDefinition v) -> {
            return v.getName();
          };
          List<AttributeDefinition> _sortBy = IterableExtensions.<AttributeDefinition, String>sortBy(((InternalParameter)parameter).getAttributes(), _function);
          for(final AttributeDefinition el : _sortBy) {
            CharSequence _compileIniAttribute = this.compileIniAttribute(el);
            _builder.append(_compileIniAttribute);
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        if ((parameter instanceof ExtendedParameter)) {
          _builder.append("##########################");
          _builder.newLine();
          _builder.append("# ExtendedParameter ");
          String _name_2 = ((ExtendedParameter)parameter).getName();
          _builder.append(_name_2);
          _builder.newLineIfNotEmpty();
          _builder.append("[");
          String _name_3 = ((ExtendedParameter)parameter).getName();
          _builder.append(_name_3);
          _builder.append("]");
          _builder.newLineIfNotEmpty();
          {
            final Function1<AttributeDefinition, String> _function_1 = (AttributeDefinition it) -> {
              return it.getName();
            };
            List<AttributeDefinition> _sortBy_1 = IterableExtensions.<AttributeDefinition, String>sortBy(((ExtendedParameter)parameter).getAttributes(), _function_1);
            for(final AttributeDefinition nv : _sortBy_1) {
              CharSequence _compileIniAttribute_1 = this.compileIniAttribute(nv);
              _builder.append(_compileIniAttribute_1);
              _builder.newLineIfNotEmpty();
            }
          }
        } else {
          if ((parameter instanceof ParameterInstance)) {
            _builder.append("##########################");
            _builder.newLine();
            _builder.append("# ParameterInstance ");
            String _name_4 = ((ParameterInstance)parameter).getName();
            _builder.append(_name_4);
            _builder.newLineIfNotEmpty();
            _builder.append("[");
            String _name_5 = ((ParameterInstance)parameter).getName();
            _builder.append(_name_5);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            {
              EList<AttributeRefinement> _attributes = ((ParameterInstance)parameter).getAttributes();
              for(final AttributeRefinement v : _attributes) {
                CharSequence _compileIniAttribute_2 = this.compileIniAttribute(v);
                _builder.append(_compileIniAttribute_2);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _compileIniAttribute(final AttributeDefinition attr) {
    StringConcatenation _builder = new StringConcatenation();
    {
      AbstractValue _defaultvalue = attr.getDefaultvalue();
      if ((_defaultvalue instanceof SingleValue)) {
        String _name = attr.getName();
        _builder.append(_name);
        _builder.append(" ");
        AbstractValue _defaultvalue_1 = attr.getDefaultvalue();
        Object _value = this._componentParamsGenHelpers.getValue(((SingleValue) _defaultvalue_1));
        _builder.append(_value);
        _builder.newLineIfNotEmpty();
      } else {
        AbstractValue _defaultvalue_2 = attr.getDefaultvalue();
        if ((_defaultvalue_2 instanceof ArrayValue)) {
          _builder.append("# ");
          String _name_1 = attr.getName();
          _builder.append(_name_1);
          _builder.append(" has an array value (defined by assigning each array element in a separate line)");
          _builder.newLineIfNotEmpty();
          {
            AbstractValue _defaultvalue_3 = attr.getDefaultvalue();
            EList<SingleValue> _values = ((ArrayValue) _defaultvalue_3).getValues();
            for(final SingleValue arrVal : _values) {
              String _name_2 = attr.getName();
              _builder.append(_name_2);
              _builder.append(" ");
              Object _value_1 = this._componentParamsGenHelpers.getValue(arrVal);
              _builder.append(_value_1);
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    return _builder;
  }
  
  protected CharSequence _compileIniAttribute(final AttributeRefinement attr) {
    StringConcatenation _builder = new StringConcatenation();
    {
      AbstractValue _value = attr.getValue();
      if ((_value instanceof SingleValue)) {
        String _name = attr.getAttribute().getName();
        _builder.append(_name);
        _builder.append(" ");
        AbstractValue _value_1 = attr.getValue();
        Object _value_2 = this._componentParamsGenHelpers.getValue(((SingleValue) _value_1));
        _builder.append(_value_2);
        _builder.newLineIfNotEmpty();
      } else {
        AbstractValue _value_3 = attr.getValue();
        if ((_value_3 instanceof ArrayValue)) {
          _builder.append("# ");
          String _name_1 = attr.getAttribute().getName();
          _builder.append(_name_1);
          _builder.append(" has an array value (defined by assigning each array element in a separate line)");
          _builder.newLineIfNotEmpty();
          {
            AbstractValue _value_4 = attr.getValue();
            EList<SingleValue> _values = ((ArrayValue) _value_4).getValues();
            for(final SingleValue arrVal : _values) {
              String _name_2 = attr.getAttribute().getName();
              _builder.append(_name_2);
              _builder.append(" ");
              Object _value_5 = this._componentParamsGenHelpers.getValue(arrVal);
              _builder.append(_value_5);
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    return _builder;
  }
  
  private String getFullyQualifiedName(final AbstractDocumentationElement par) {
    if (par instanceof ParameterDefinition) {
      return _getFullyQualifiedName((ParameterDefinition)par);
    } else if (par instanceof TriggerDefinition) {
      return _getFullyQualifiedName((TriggerDefinition)par);
    } else if (par instanceof ParameterSetDefinition) {
      return _getFullyQualifiedName((ParameterSetDefinition)par);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(par).toString());
    }
  }
  
  private String getFullyQualifiedVariableName(final AbstractDocumentationElement par) {
    if (par instanceof ParameterDefinition) {
      return _getFullyQualifiedVariableName((ParameterDefinition)par);
    } else if (par instanceof TriggerDefinition) {
      return _getFullyQualifiedVariableName((TriggerDefinition)par);
    } else if (par instanceof ParameterSetDefinition) {
      return _getFullyQualifiedVariableName((ParameterSetDefinition)par);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(par).toString());
    }
  }
  
  private String generateTriggerAttributeDefinitions(final AbstractDocumentationElement t) {
    if (t instanceof ExtendedTrigger) {
      return _generateTriggerAttributeDefinitions((ExtendedTrigger)t);
    } else if (t instanceof TriggerDefinition) {
      return _generateTriggerAttributeDefinitions((TriggerDefinition)t);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(t).toString());
    }
  }
  
  private String generateTriggerAttributeNames(final AbstractDocumentationElement t, final String prefix) {
    if (t instanceof ExtendedTrigger) {
      return _generateTriggerAttributeNames((ExtendedTrigger)t, prefix);
    } else if (t instanceof TriggerDefinition) {
      return _generateTriggerAttributeNames((TriggerDefinition)t, prefix);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(t, prefix).toString());
    }
  }
  
  public CharSequence compileIniAttribute(final AbstractDocumentationElement attr) {
    if (attr instanceof AttributeDefinition) {
      return _compileIniAttribute((AttributeDefinition)attr);
    } else if (attr instanceof AttributeRefinement) {
      return _compileIniAttribute((AttributeRefinement)attr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(attr).toString());
    }
  }
}
