/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.deployment;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.system.deployment.ComponentArtefact;
import org.eclipse.smartmdsd.ecore.system.deployment.Deployment;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentModel;
import org.eclipse.smartmdsd.ecore.system.deployment.LoginAccountSelection;
import org.eclipse.smartmdsd.ecore.system.deployment.NamingService;
import org.eclipse.smartmdsd.ecore.system.deployment.NetworkInterfaceSelection;
import org.eclipse.smartmdsd.ecore.system.deployment.TargetPlatformReference;
import org.eclipse.smartmdsd.ecore.system.deployment.UploadDirectory;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.NetworkInterface;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.system.BehaviorSystem;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class DeploymentGenerator2Impl
extends AbstractGenerator {
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;
    @Inject
    @Extension
    private BehaviorSystem _behaviorSystem;

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)resource.getAllContents()), DeploymentModel.class);
        for (DeploymentModel deployment : _filter) {
            String _plus_3;
            String _plus_1;
            fsa.generateFile("combine_ini_files.sh", "SRC_GEN_SYS_DEPLOY", this.combineIniFilesScript(deployment));
            Iterable _filter_1 = Iterables.filter((Iterable)deployment.getElements(), NamingService.class);
            for (NamingService namingService : _filter_1) {
                fsa.generateFile("ns_config.ini", "SRC_GEN_SYS_DEPLOY", this.nsConfig(namingService));
            }
            Iterable _filter_2 = Iterables.filter((Iterable)deployment.getElements(), ComponentArtefact.class);
            for (ComponentArtefact artefact : _filter_2) {
                String _name = artefact.getName();
                String _plus = String.valueOf(_name) + "_data";
                this.createDirectory(resource, _plus);
                String _name_1 = artefact.getName();
                _plus_1 = "predeploy-" + _name_1;
                String _plus_2 = String.valueOf(_plus_1) + ".sh";
                fsa.generateFile(_plus_2, "SRC_OUTPUT", this.preDeployScript(artefact));
                String _name_2 = artefact.getName();
                _plus_3 = "startstop-hooks-" + _name_2;
                String _plus_4 = String.valueOf(_plus_3) + ".sh";
                fsa.generateFile(_plus_4, "SRC_OUTPUT", this.startStopHooksScript(artefact));
            }
            Iterable _filter_3 = Iterables.filter((Iterable)deployment.getElements(), TargetPlatformReference.class);
            for (TargetPlatformReference target : _filter_3) {
                String _name = target.getName();
                String _plus = "deploy-" + _name;
                _plus_1 = String.valueOf(_plus) + ".sh";
                fsa.generateFile(_plus_1, "SRC_GEN_SYS_DEPLOY", this.deployDeviceScript(target));
                String _name_1 = target.getName();
                String _plus_2 = "start-" + _name_1;
                _plus_3 = String.valueOf(_plus_2) + ".sh";
                fsa.generateFile(_plus_3, "SRC_GEN_SYS_DEPLOY", this.startScript(target));
            }
            fsa.generateFile("deploy-all.sh", "SRC_GEN_SYS_DEPLOY", this.deployAllScript(deployment));
            fsa.generateFile("start-all.sh", "SRC_GEN_SYS_DEPLOY", this.startAllScript(deployment));
            fsa.generateFile("tiler.sh", "SRC_GEN_SYS_DEPLOY", this.tilerscript());
            fsa.generateFile("deploy-behavior-files.sh", "SRC_GEN_SYS_DEPLOY", this._behaviorSystem.compileBehaviorDeploymentFiles(deployment));
            fsa.generateFile("referenced-projects", "SRC_GEN_SYS_DEPLOY", this.compileReferencedProjects(deployment));
        }
    }

    public CharSequence compileReferencedProjects(DeploymentModel model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# This file is generated using the SmartMDSD Toolchain.");
        _builder.newLine();
        _builder.append("# Any changes will be overwritten next time the deployment project");
        _builder.newLine();
        _builder.append("# is deployed/run from within the SmartMDSD toolchain.");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it -> this.getType((ComponentArtefact)it);
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)model.getElements(), ComponentArtefact.class), (Functions.Function1)_function)), (Functions.Function1)_function_1);
        for (ComponentDefinition componentDef : _sortBy) {
            _builder.append("REFERENCED_PROJECT_");
            String _name = componentDef.getName();
            _builder.append(_name);
            _builder.append("=\"");
            String _location = this.getLocation(componentDef);
            _builder.append(_location);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String getLocation(ComponentDefinition component) {
        URI uri = component.eResource().getURI();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.segment(1));
        return project.getLocation().toString();
    }

    private void createDirectory(Resource resource, String directory) {
        try {
            boolean _not;
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(resource.getURI().segment(1));
            IFolder folder = project.getFolder("smartsoft/src/" + directory);
            boolean _exists = folder.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                folder.create(true, true, (IProgressMonitor)_nullProgressMonitor);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence nsConfig(NamingService ns) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[smartsoft]");
        _builder.newLine();
        _builder.newLine();
        _builder.append("[RemoteNS]");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# ip 127.0.0.1:20002");
        _builder.newLine();
        if (ns.getDeploy() != null && ns.getDeploy().getTo().getHost() != null) {
            _builder.append("# ip ");
            String _hostAddress = ns.getDeploy().getTo().getHost().getNetwork().getHostAddress();
            _builder.append(_hostAddress);
            _builder.append(":");
            int _portNr = ns.getPortNr();
            _builder.append((Object)_portNr);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence combineIniFilesScript(DeploymentModel model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/bin/bash");
        _builder.newLine();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This script collects the generated ini-file parts and combines them into single ini-files (one for each component artefact)");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# create subfolder combined-ini-files (if not yet created)");
        _builder.newLine();
        _builder.append("echo \"create subfolder src-gen/combined-ini-files\"");
        _builder.newLine();
        _builder.append("mkdir -p src-gen/combined-ini-files");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# clean-up old combined-ini-files before they are generated again");
        _builder.newLine();
        _builder.append("echo \"clean-up src-gen/combined-ini-files subfolder\"");
        _builder.newLine();
        _builder.append("rm src-gen/combined-ini-files/*.ini");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.filter((Iterable)model.getElements(), ComponentArtefact.class), (Functions.Function1)_function);
        for (ComponentArtefact artefact : _sortBy) {
            _builder.append("# create ini-file ");
            String _name = artefact.getName();
            _builder.append(_name);
            _builder.append(".ini");
            _builder.newLineIfNotEmpty();
            _builder.append("echo \"create ini-file ");
            String _name_1 = artefact.getName();
            _builder.append(_name_1);
            _builder.append(".ini\"");
            _builder.newLineIfNotEmpty();
            _builder.append("cp src-gen/system/");
            String _name_2 = artefact.getName();
            _builder.append(_name_2);
            _builder.append(".ini src-gen/combined-ini-files/");
            _builder.newLineIfNotEmpty();
            _builder.append("if [ -f src-gen/params/");
            String _name_3 = artefact.getName();
            _builder.append(_name_3);
            _builder.append(".ini ]; then");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("cat src-gen/params/");
            String _name_4 = artefact.getName();
            _builder.append(_name_4, "  ");
            _builder.append(".ini >> src-gen/combined-ini-files/");
            String _name_5 = artefact.getName();
            _builder.append(_name_5, "  ");
            _builder.append(".ini");
            _builder.newLineIfNotEmpty();
            _builder.append("fi");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence preDeployScript(ComponentArtefact artefact) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/bin/bash");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This script is run prior to deployment of component ");
        String _name = artefact.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("# The working directory of this script is the deployment project folder.");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.newLine();
        String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
        _builder.append(_copyrightWriteOnceHash);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# uncomment to enable predeploy script delivered by component");
        _builder.newLine();
        _builder.append("source $REFERENCED_PROJECT_");
        String _name_1 = this.getType(artefact).getName();
        _builder.append(_name_1);
        _builder.append("/smartsoft/src/predeploy.sh");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# Add SmartSoft libraries that shall be deployed to the target device where this");
        _builder.newLine();
        _builder.append("# component is to be deployed.");
        _builder.newLine();
        _builder.append("# These libraries will be searched in $SMART_ROOT/lib and then deployed");
        _builder.newLine();
        _builder.append("# Add one file per line.");
        _builder.newLine();
        _builder.append("#DEPLOY_LIBRARIES=\"$DEPLOY_LIBRARIES");
        _builder.newLine();
        _builder.append("#libSmartSickInterface.so");
        _builder.newLine();
        _builder.append("#\"");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# add custom code here. E.g. use this script to collect data-files and ");
        _builder.newLine();
        _builder.append("# copy them to src/<COMPONENT>_data, etc.");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence startStopHooksScript(ComponentArtefact artefact) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/bin/bash");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Start-Stop-Hooks for component ");
        String _name = artefact.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This script provides methods to call custom commands pre/post of");
        _builder.newLine();
        _builder.append("# starting/stoping the component during launch on the device.");
        _builder.newLine();
        _builder.append("# This script is being executed on the target device where this ");
        _builder.newLine();
        _builder.append("# component is running.");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.newLine();
        String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
        _builder.append(_copyrightWriteOnceHash);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("case \"$1\" in");
        _builder.newLine();
        _builder.newLine();
        _builder.append("pre-start)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# first, trigger hooks as delivered from component ...");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash startstop-hooks-component-");
        String _name_1 = this.getType(artefact).getName();
        _builder.append(_name_1, "\t");
        _builder.append(".sh pre-start");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# ...then call user/deployment specific hook:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Triggering pre-start hooks ...\"");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("post-start)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# first, trigger hooks as delivered from component ...");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash startstop-hooks-component-");
        String _name_2 = this.getType(artefact).getName();
        _builder.append(_name_2, "\t");
        _builder.append(".sh post-start");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# ...then call user/deployment specific hook:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Triggering post-start hooks ...\"");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("pre-stop)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# first, trigger hooks as delivered from component ...");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash startstop-hooks-component-");
        String _name_3 = this.getType(artefact).getName();
        _builder.append(_name_3, "\t");
        _builder.append(".sh pre-stop");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# ...then call user/deployment specific hook:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Triggering pre-stop hooks ...\"");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("post-stop)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# first, trigger hooks as delivered from component ...");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash startstop-hooks-component-");
        String _name_4 = this.getType(artefact).getName();
        _builder.append(_name_4, "\t");
        _builder.append(".sh post-stop");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# ...then call user/deployment specific hook:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Triggering post-stop hooks ...\"");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("*)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"ERROR in $0: no such hook '$1'. Usage: $0 pre-start|post-start|pre-stop|post-stop\"");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("esac");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private Iterable<ComponentArtefact> getComponentArtefacts(TargetPlatformReference target) {
        EObject _eContainer = target.eContainer();
        Functions.Function1 _function = it -> {
            Deployment _deploy = it.getDeploy();
            TargetPlatformReference _to = null;
            if (_deploy != null) {
                _to = _deploy.getTo();
            }
            return Objects.equal((Object)_to, (Object)target);
        };
        Functions.Function1 _function_1 = it -> it.getName();
        return IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((DeploymentModel)_eContainer).getElements(), ComponentArtefact.class), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    private boolean hasNamingService(TargetPlatformReference target) {
        NamingService namingService = this.getNamingService(target);
        if (namingService != null) {
            TargetPlatformReference _to;
            boolean _equals;
            boolean _tripleNotEquals;
            Deployment _deploy = namingService.getDeploy();
            boolean bl = _tripleNotEquals = _deploy != null;
            if (_tripleNotEquals && (_equals = Objects.equal((Object)(_to = namingService.getDeploy().getTo()), (Object)target))) {
                return true;
            }
        }
        return false;
    }

    private NamingService getNamingService(TargetPlatformReference target) {
        EObject parent = target.eContainer();
        if (parent instanceof DeploymentModel) {
            return (NamingService)IterableExtensions.head((Iterable)Iterables.filter((Iterable)((DeploymentModel)parent).getElements(), NamingService.class));
        }
        return null;
    }

    private String sshLoginPair(TargetPlatformReference target) {
        boolean _tripleNotEquals;
        NetworkInterfaceSelection _host = target.getHost();
        boolean bl = _tripleNotEquals = _host != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            LoginAccountSelection _login = target.getLogin();
            boolean bl2 = _tripleNotEquals_1 = _login != null;
            if (_tripleNotEquals_1) {
                String _name = target.getLogin().getName();
                String _plus = String.valueOf(_name) + "@";
                String _hostAddress = target.getHost().getNetwork().getHostAddress();
                return String.valueOf(_plus) + _hostAddress;
            }
            NetworkInterfaceSelection _host_1 = target.getHost();
            NetworkInterface _network = null;
            if (_host_1 != null) {
                _network = _host_1.getNetwork();
            }
            return _network.getHostAddress();
        }
        return "";
    }

    private ComponentDefinition getType(ComponentArtefact artefact) {
        return artefact.getComponent().getComponent();
    }

    public CharSequence deployDeviceScript(TargetPlatformReference target) {
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/bin/bash");
        _builder.newLine();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# run this script from the component's root folder to deploy the scenario to device.");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.newLine();
        _builder.append("TARGET_SSHUSER=");
        LoginAccountSelection _login = target.getLogin();
        boolean bl = _tripleNotEquals = _login != null;
        if (_tripleNotEquals) {
            String _name = target.getLogin().getName();
            _builder.append(_name);
        }
        _builder.newLineIfNotEmpty();
        _builder.append("TARGET_IP=");
        NetworkInterfaceSelection _host = target.getHost();
        boolean bl2 = _tripleNotEquals_1 = _host != null;
        if (_tripleNotEquals_1) {
            String _hostAddress = target.getHost().getNetwork().getHostAddress();
            _builder.append(_hostAddress);
        }
        _builder.newLineIfNotEmpty();
        _builder.append("TARGET_DIRECTORY=\"");
        UploadDirectory _directory = target.getDirectory();
        boolean bl3 = _tripleNotEquals_2 = _directory != null;
        if (_tripleNotEquals_2) {
            String _path = target.getDirectory().getPath();
            _builder.append(_path);
        }
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("DEPLOYMENT_DIRECTORY=");
        EObject _eContainer = target.eContainer();
        String _name_1 = ((DeploymentModel)_eContainer).getName();
        _builder.append(_name_1);
        _builder.append(".deployment/");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("echo \"#######################################################\"");
        _builder.newLine();
        _builder.append("echo \"## Deployment of Device ");
        String _name_2 = target.getPlatform().getName();
        _builder.append(_name_2);
        _builder.append(" / $TARGET_IP\"");
        _builder.newLineIfNotEmpty();
        _builder.append("echo \"#######################################################\"");
        _builder.newLine();
        _builder.append("echo \"Target SSH user:      $TARGET_SSHUSER\"");
        _builder.newLine();
        _builder.append("echo \"Target IP:            $TARGET_IP\"");
        _builder.newLine();
        _builder.append("echo \"Target directory:     $TARGET_DIRECTORY\"");
        _builder.newLine();
        _builder.append("echo \"Deployment directory: $DEPLOYMENT_DIRECTORY\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("echo \"Working directory of deployment script: \"`pwd`");
        _builder.newLine();
        _builder.newLine();
        _builder.append("echo Sourcing referenced projects");
        _builder.newLine();
        _builder.append("source src-gen/deployment/referenced-projects");
        _builder.newLine();
        _builder.newLine();
        _builder.append("DEPLOY_LIBRARIES_USER=\"\"");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy(this.getComponentArtefacts(target), (Functions.Function1)_function);
        for (ComponentArtefact artefact : _sortBy) {
            _builder.append("###############################");
            _builder.newLine();
            _builder.append("echo \"Sourcing pre-deployment script for ");
            String _name_3 = artefact.getName();
            _builder.append(_name_3);
            _builder.append("... (errors might be ignored)\"");
            _builder.newLineIfNotEmpty();
            _builder.append("DEPLOY_LIBRARIES=\"\"");
            _builder.newLine();
            _builder.append("DEPLOY_COMPONENT_FILES=\"\"");
            _builder.newLine();
            _builder.append("source src/predeploy-");
            String _name_4 = artefact.getName();
            _builder.append(_name_4);
            _builder.append(".sh 2>&1");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("for I in $DEPLOY_LIBRARIES; do");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if [ -e \"$SMART_ROOT_ACE/bin/$I\" ]; then");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("FILE=\"$SMART_ROOT_ACE/bin/$I\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("else");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("FILE=\"$SMART_ROOT_ACE/lib/$I\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("fi");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("DEPLOY_LIBRARIES_USER=\"$DEPLOY_LIBRARIES_USER $FILE\"");
            _builder.newLine();
            _builder.append("done");
            _builder.newLine();
            _builder.newLine();
            _builder.append("DEPLOY_COMPONENT_FILES_PATHS_");
            String _name_5 = this.getType(artefact).getName();
            _builder.append(_name_5);
            _builder.append("=\"\"");
            _builder.newLineIfNotEmpty();
            _builder.append("for I in $DEPLOY_COMPONENT_FILES; do");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if ls $REFERENCED_PROJECT_");
            String _name_6 = this.getType(artefact).getName();
            _builder.append(_name_6, "\t");
            _builder.append("/$I > /dev/null 2>&1; then");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("DEPLOY_COMPONENT_FILES_PATHS_");
            String _name_7 = this.getType(artefact).getName();
            _builder.append(_name_7, "\t\t");
            _builder.append("=\"$DEPLOY_COMPONENT_FILES_PATHS_");
            String _name_8 = this.getType(artefact).getName();
            _builder.append(_name_8, "\t\t");
            _builder.append(" $REFERENCED_PROJECT_");
            String _name_9 = this.getType(artefact).getName();
            _builder.append(_name_9, "\t\t");
            _builder.append("/$I\"");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("elif ls $I > /dev/null 2>&1; then");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("DEPLOY_COMPONENT_FILES_PATHS_");
            String _name_10 = this.getType(artefact).getName();
            _builder.append(_name_10, "\t\t");
            _builder.append("=\"$DEPLOY_COMPONENT_FILES_PATHS_");
            String _name_11 = this.getType(artefact).getName();
            _builder.append(_name_11, "\t\t");
            _builder.append(" $I\"");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("fi");
            _builder.newLine();
            _builder.append("done");
            _builder.newLine();
            _builder.newLine();
            _builder.append("#########################");
            _builder.newLine();
            _builder.append("## BEHAVIOR FILES");
            _builder.newLine();
            _builder.append("shopt -u | grep -q nullglob && changed=true && shopt -s nullglob");
            _builder.newLine();
            _builder.append("for entry in \"$REFERENCED_PROJECT_");
            String _name_12 = this.getType(artefact).getName();
            _builder.append(_name_12);
            _builder.append("\"/model/*.smartTcl");
            _builder.newLineIfNotEmpty();
            _builder.append("do");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("DEPLOY_COMPONENT_BEHAVIOR_MODEL_FILES_");
            String _name_13 = this.getType(artefact).getName();
            _builder.append(_name_13, "  ");
            _builder.append("=\"$DEPLOY_COMPONENT_TCL_MODEL_FILES_");
            String _name_14 = this.getType(artefact).getName();
            _builder.append(_name_14, "  ");
            _builder.append(" $entry\"");
            _builder.newLineIfNotEmpty();
            _builder.append("done");
            _builder.newLine();
            _builder.append("[ $changed ] && shopt -u nullglob; unset changed");
            _builder.newLine();
            _builder.newLine();
            _builder.append("echo \"$DEPLOY_COMPONENT_BEHAVIOR_MODEL_FILES_");
            String _name_15 = this.getType(artefact).getName();
            _builder.append(_name_15);
            _builder.append(" \"");
            _builder.newLineIfNotEmpty();
            _builder.append("#########################");
            _builder.newLine();
            _builder.newLine();
            _builder.append("echo");
            _builder.newLine();
            _builder.append("###############################");
            _builder.newLine();
            _builder.append(" ");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append("DEPL_FILES=\"");
        _builder.newLine();
        _builder.append("$SMART_ROOT_ACE/lib/libAceSmartSoftKernel.so.*");
        _builder.newLine();
        _builder.append("$SMART_ROOT_ACE/lib/libSmartProperty.so.*");
        _builder.newLine();
        _builder.append("src-gen/deployment/tiler.sh");
        _builder.newLine();
        _builder.append("src-gen/deployment/start-");
        String _name_16 = target.getName();
        _builder.append(_name_16);
        _builder.append(".sh");
        _builder.newLineIfNotEmpty();
        boolean _hasNamingService = this.hasNamingService(target);
        if (_hasNamingService) {
            _builder.append("$SMART_ROOT_ACE/bin/NamingService");
            _builder.newLine();
            _builder.append("src-gen/deployment/ns_config.ini");
            _builder.newLine();
        }
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy(this.getComponentArtefacts(target), (Functions.Function1)_function_1);
        for (ComponentArtefact artefact_1 : _sortBy_1) {
            _builder.append("src/");
            String _name_17 = artefact_1.getName();
            _builder.append(_name_17);
            _builder.append("_data");
            _builder.newLineIfNotEmpty();
            _builder.append("src/startstop-hooks-");
            String _name_18 = artefact_1.getName();
            _builder.append(_name_18);
            _builder.append(".sh");
            _builder.newLineIfNotEmpty();
            _builder.append("$SMART_ROOT_ACE/bin/");
            String _name_19 = this.getType(artefact_1).getName();
            _builder.append(_name_19);
            _builder.newLineIfNotEmpty();
            _builder.append("src-gen/combined-ini-files/");
            String _name_20 = artefact_1.getName();
            _builder.append(_name_20);
            _builder.append(".ini");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_2 = it -> {
                EObject _eContainer_1 = it.eContainer();
                return (CommObjectsRepository)_eContainer_1;
            };
            Functions.Function1 _function_3 = it -> it.getName();
            List _sortBy_2 = IterableExtensions.sortBy((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)ComponentDefinitionModelUtility.getAllCommObjects((ComponentDefinition)this.getType(artefact_1)), (Functions.Function1)_function_2)), (Functions.Function1)_function_3);
            for (CommObjectsRepository x : _sortBy_2) {
                _builder.append("$SMART_ROOT_ACE/lib/lib");
                String _name_21 = x.getName();
                _builder.append(_name_21);
                _builder.append(".so*");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("$DEPLOY_LIBRARIES_USER");
        _builder.newLine();
        _builder.append("\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("FILES_MISSING=false");
        _builder.newLine();
        _builder.append("for FILE in $DEPL_FILES; do");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if [ ! -e $FILE ]; then");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("echo \"Deployment: No such file or directory: $FILE\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("FILES_MISSING=true");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.newLine();
        _builder.append("if [ \"$FILES_MISSING\" = \"true\" ]; then");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"ERROR: FILES ARE MISSING FROM THE DEPLOYMENT (see above). Did you compile all components?\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("exit 1");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("if [ \"$1\" = \"local\" ]; then");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# local deployment");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mkdir -p $DEPLOYMENT_DIRECTORY");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rsync -l -r -v --progress --exclude \".svn\" $DEPL_FILES $DEPLOYMENT_DIRECTORY/");
        String _name_22 = target.getName();
        _builder.append(_name_22, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# remote deployment");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("SSH_TARGET=");
        String _sshLoginPair = this.sshLoginPair(target);
        _builder.append(_sshLoginPair, "\t");
        _builder.append(":$TARGET_DIRECTORY/$DEPLOYMENT_DIRECTORY");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("echo \"Deployment to $SSH_TARGET\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ssh ");
        String _sshLoginPair_1 = this.sshLoginPair(target);
        _builder.append(_sshLoginPair_1, "\t");
        _builder.append(" mkdir -p $TARGET_DIRECTORY/$DEPLOYMENT_DIRECTORY");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("TMPDIR=$(mktemp -d --suffix=.deployment) || exit 1");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Temporary directory: $TMPDIR\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mkdir $TMPDIR/behaviorFiles");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("trap \"rm -rf $TMPDIR\" EXIT");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# collect files in $TMPDIR");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#rsync -l -r -v --progress --exclude \".svn\" $DEPL_FILES $TMPDIR/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cp -rv $DEPL_FILES $TMPDIR 2>&1");
        _builder.newLine();
        Functions.Function1 _function_4 = it -> it.getName();
        List _sortBy_3 = IterableExtensions.sortBy(this.getComponentArtefacts(target), (Functions.Function1)_function_4);
        for (ComponentArtefact artefact_2 : _sortBy_3) {
            _builder.append("#rsync -l -r -v --progress --exclude \".svn\" $DEPLOY_COMPONENT_FILES_PATHS_");
            String _name_23 = this.getType(artefact_2).getName();
            _builder.append(_name_23);
            _builder.append(" $TMPDIR/");
            String _name_24 = artefact_2.getName();
            _builder.append(_name_24);
            _builder.append("_data/");
            _builder.newLineIfNotEmpty();
            _builder.append("if [ ! \"$DEPLOY_COMPONENT_FILES_PATHS_");
            String _name_25 = this.getType(artefact_2).getName();
            _builder.append(_name_25);
            _builder.append("\" = \"\" ]; then");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("cp -rv $DEPLOY_COMPONENT_FILES_PATHS_");
            String _name_26 = this.getType(artefact_2).getName();
            _builder.append(_name_26, "\t");
            _builder.append(" $TMPDIR/");
            String _name_27 = artefact_2.getName();
            _builder.append(_name_27, "\t");
            _builder.append("_data/ 2>&1");
            _builder.newLineIfNotEmpty();
            _builder.append("fi");
            _builder.newLine();
            _builder.newLine();
            _builder.append("if [ ! \"$DEPLOY_COMPONENT_BEHAVIOR_MODEL_FILES_");
            String _name_28 = this.getType(artefact_2).getName();
            _builder.append(_name_28);
            _builder.append("\" = \"\" ]; then");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("cp -rv $DEPLOY_COMPONENT_BEHAVIOR_MODEL_FILES_");
            String _name_29 = this.getType(artefact_2).getName();
            _builder.append(_name_29, "\t");
            _builder.append(" $TMPDIR/behaviorFiles/ 2>&1");
            _builder.newLineIfNotEmpty();
            _builder.append("fi");
            _builder.newLine();
            _builder.newLine();
            _builder.append("cp -v $REFERENCED_PROJECT_");
            String _name_30 = this.getType(artefact_2).getName();
            _builder.append(_name_30);
            _builder.append("/smartsoft/src/startstop-hooks.sh $TMPDIR/startstop-hooks-component-");
            String _name_31 = this.getType(artefact_2).getName();
            _builder.append(_name_31);
            _builder.append(".sh 2>/dev/null");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#collect and copy behavior related files");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Sourcing behavior files...\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("test -f src-gen/deployment/deploy-behavior-files.sh && source src-gen/deployment/deploy-behavior-files.sh");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# actually deploy:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rsync -z -l -r -v --progress --exclude \".svn\" -e ssh $TMPDIR/ $SSH_TARGET");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("if [ \"$?\" != \"0\" ]; then");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"ERROR: Files could not be deployed to remote host.\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#gdialog --title ERROR --msgbox \"Files could not be deployed host.\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("exit 1");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append("echo -e \"\\n\\nDeployment to device ");
        String _name_32 = target.getName();
        _builder.append(_name_32);
        _builder.append(" finished.\\n\\n\"");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence startScript(TargetPlatformReference target) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/bin/sh");
        _builder.newLine();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# start script for device ");
        String _name = target.getPlatform().getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("PID_XTERM=\"/var/tmp/start-");
        String _name_1 = target.getPlatform().getName();
        _builder.append(_name_1);
        _builder.append("-xterms.pid\"");
        _builder.newLineIfNotEmpty();
        _builder.append("PID_COMPONENT_NAMES=\"/var/tmp/start-");
        String _name_2 = target.getPlatform().getName();
        _builder.append(_name_2);
        _builder.append("-component-names.pid\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("SCRIPT_DIR=`pwd`");
        _builder.newLine();
        _builder.append("SCRIPT_NAME=start-");
        String _name_3 = target.getPlatform().getName();
        _builder.append(_name_3);
        _builder.append(".sh");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("export SMART_ROOT_DEPLOYMENT=$SCRIPT_DIR");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#######");
        _builder.newLine();
        _builder.append("## case");
        _builder.newLine();
        _builder.append("case \"$1\" in");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.newLine();
        _builder.append("#########################################################################################");
        _builder.newLine();
        _builder.append("## start");
        _builder.newLine();
        _builder.append("start)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("true > $PID_XTERM");
        _builder.newLine();
        _builder.append("true > $PID_COMPONENT_NAMES");
        _builder.newLine();
        _builder.newLine();
        _builder.append("echo \"Starting scenario...\"");
        _builder.newLine();
        _builder.append("date -R");
        _builder.newLine();
        _builder.newLine();
        NamingService _namingService = this.getNamingService(target);
        boolean bl = _tripleNotEquals = _namingService != null;
        if (_tripleNotEquals) {
            _builder.append("# CONFIGURE NAMING SERVICE");
            _builder.newLine();
            if (this.getNamingService(target).getDeploy() != null && this.getNamingService(target).getDeploy().getTo().getHost() != null) {
                _builder.append("\t");
                _builder.append("export SMART_NS_ADDR=");
                String _hostAddress = this.getNamingService(target).getDeploy().getTo().getHost().getNetwork().getHostAddress();
                _builder.append(_hostAddress, "\t");
                _builder.append(":");
                int _portNr = this.getNamingService(target).getPortNr();
                _builder.append((Object)_portNr, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        boolean _hasNamingService = this.hasNamingService(target);
        if (_hasNamingService) {
            _builder.append("echo \"Stopping Naming Service...\"");
            _builder.newLine();
            _builder.append("killall AceSmartSoftNamingService &");
            _builder.newLine();
            _builder.append("test -e SMART_NAMES && rm -f SMART_NAMES");
            _builder.newLine();
            _builder.append("sleep 1");
            _builder.newLine();
            _builder.append("echo Starting Naming Service...");
            _builder.newLine();
            _builder.append("rm -f AceSmartSoftNamingService.log");
            _builder.newLine();
            _builder.append("xterm -l -lf AceSmartSoftNamingService.log -title \"AceSmartSoftNamingService\" -hold -e \"export LD_LIBRARY_PATH=$SCRIPT_DIR:\\$LD_LIBRARY_PATH; ./NamingService/AceSmartSoftNamingService --ns-port ");
            int _portNr_1 = this.getNamingService(target).getPortNr();
            _builder.append((Object)_portNr_1);
            _builder.append(" --ns-dir ./ --ns-file SMART_NAMES --filename=ns_config.ini; echo; echo; echo 'Naming Service exited'; /bin/bash\" &");
            _builder.newLineIfNotEmpty();
            _builder.append("echo $! >> $PID_XTERM");
            _builder.newLine();
            _builder.append("echo AceSmartSoftNamingService >> $PID_COMPONENT_NAMES");
            _builder.newLine();
            _builder.append("sleep 1");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("## start components");
        _builder.newLine();
        NetworkInterfaceSelection _host = target.getHost();
        boolean bl2 = _tripleNotEquals_1 = _host != null;
        if (_tripleNotEquals_1) {
            _builder.append("export SMART_IP=");
            String _hostAddress_1 = target.getHost().getNetwork().getHostAddress();
            _builder.append(_hostAddress_1);
        }
        _builder.newLineIfNotEmpty();
        _builder.append("echo \"starting components...\"");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy(this.getComponentArtefacts(target), (Functions.Function1)_function);
        for (ComponentArtefact artefact : _sortBy) {
            _builder.append("# Component instance ");
            String _name_4 = artefact.getName();
            _builder.append(_name_4);
            _builder.newLineIfNotEmpty();
            _builder.append("echo");
            _builder.newLine();
            _builder.append("echo \"############################################\"");
            _builder.newLine();
            _builder.append("echo \"## Starting component instance ");
            String _name_5 = artefact.getName();
            _builder.append(_name_5);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            _builder.append("cd $SCRIPT_DIR");
            _builder.newLine();
            _builder.append("echo \"executing startstop-hooks-");
            String _name_6 = artefact.getName();
            _builder.append(_name_6);
            _builder.append(".sh (errors might be ignored)\"");
            _builder.newLineIfNotEmpty();
            _builder.append("bash startstop-hooks-");
            String _name_7 = artefact.getName();
            _builder.append(_name_7);
            _builder.append(".sh pre-start");
            _builder.newLineIfNotEmpty();
            _builder.append("cd $SCRIPT_DIR/");
            String _name_8 = artefact.getName();
            _builder.append(_name_8);
            _builder.append("_data");
            _builder.newLineIfNotEmpty();
            _builder.append("rm -f \"../");
            String _name_9 = artefact.getName();
            _builder.append(_name_9);
            _builder.append(".log\"");
            _builder.newLineIfNotEmpty();
            _builder.append("xterm -l -lf \"../");
            String _name_10 = artefact.getName();
            _builder.append(_name_10);
            _builder.append(".log\" -title \"");
            String _name_11 = artefact.getName();
            _builder.append(_name_11);
            _builder.append("@");
            String _name_12 = target.getPlatform().getName();
            _builder.append(_name_12);
            _builder.append(" Component\" -hold -e \"export LD_LIBRARY_PATH=$SCRIPT_DIR:\\$LD_LIBRARY_PATH; $SCRIPT_DIR/");
            String _name_13 = this.getType(artefact).getName();
            _builder.append(_name_13);
            _builder.append(" -filename=$SCRIPT_DIR/");
            String _name_14 = artefact.getName();
            _builder.append(_name_14);
            _builder.append(".ini; echo; echo; echo '");
            String _name_15 = artefact.getName();
            _builder.append(_name_15);
            _builder.append(" exited.'; echo; /bin/bash --login\" &");
            _builder.newLineIfNotEmpty();
            _builder.append("echo $! >> $PID_XTERM");
            _builder.newLine();
            _builder.append("echo ");
            String _name_16 = this.getType(artefact).getName();
            _builder.append(_name_16);
            _builder.append(" >> $PID_COMPONENT_NAMES");
            _builder.newLineIfNotEmpty();
            _builder.append("cd $SCRIPT_DIR");
            _builder.newLine();
            _builder.append("bash startstop-hooks-");
            String _name_17 = artefact.getName();
            _builder.append(_name_17);
            _builder.append(".sh post-start");
            _builder.newLineIfNotEmpty();
            _builder.append("echo -e \"\\n\\n\\n\"");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("cd $SCRIPT_DIR");
        _builder.newLine();
        _builder.newLine();
        _builder.append(";; ## start");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#########################################################################################");
        _builder.newLine();
        _builder.append("## stop");
        _builder.newLine();
        _builder.append("stop)");
        _builder.newLine();
        _builder.append("cd $SCRIPT_DIR");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy(this.getComponentArtefacts(target), (Functions.Function1)_function_1);
        for (ComponentArtefact artefact_1 : _sortBy_1) {
            _builder.append("bash startstop-hooks-");
            String _name_18 = artefact_1.getName();
            _builder.append(_name_18);
            _builder.append(".sh pre-stop");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("echo \"kill all components...\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("for I in `cat $PID_COMPONENT_NAMES`; do");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("echo $I");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("killall -2 $I");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.append("rm $PID_COMPONENT_NAMES");
        _builder.newLine();
        _builder.newLine();
        _builder.append("sleep 3");
        _builder.newLine();
        _builder.newLine();
        _builder.append("for I in `cat $PID_XTERM`; do");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("echo $I");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("kill -2 $I");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.append("rm $PID_XTERM");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        boolean _hasNamingService_1 = this.hasNamingService(target);
        if (_hasNamingService_1) {
            _builder.append("test -e SMART_NAMES && rm -f SMART_NAMES");
            _builder.newLine();
        }
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy(this.getComponentArtefacts(target), (Functions.Function1)_function_2);
        for (ComponentArtefact artefact_2 : _sortBy_2) {
            _builder.append("bash startstop-hooks-");
            String _name_19 = artefact_2.getName();
            _builder.append(_name_19);
            _builder.append(".sh post-stop");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append("# collect log files");
        _builder.newLine();
        _builder.append("ls -l *.log && (");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("pwd");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tar czvf ");
        String _name_20 = target.getPlatform().getName();
        _builder.append(_name_20, "\t");
        _builder.append("-logs-$(date +\"%Y%m%d%H%M\").tar.gz *.log");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("rm *.log");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.newLine();
        _builder.append(";; ## stop");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#########################################################################################");
        _builder.newLine();
        _builder.append("## menu");
        _builder.newLine();
        _builder.newLine();
        _builder.append("menu-start)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME start");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cd $SCRIPT_DIR");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME menu");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("menu-stop)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME stop");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cd $SCRIPT_DIR");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME menu");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("menu-tile)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash tiler.sh");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cd $SCRIPT_DIR");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME menu");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("menu)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#wmctrl -r :ACTIVE: -b add,above");
        _builder.newLine();
        _builder.append("ACTION=$(whiptail --title \"Scenario Control\" --menu \"Choose an option\" 12 35 4 \"menu-start\" \"Start Scenario\" \"menu-stop\" \"Stop Scenario\" \"menu-tile\" \"Arrange terminals\" \"quit\" \"Quit to console\" 3>&1 1>&2 2>&3)");
        _builder.newLine();
        _builder.append("#whiptail --title \"Scenario Control\" --menu \"Choose an option\" 10 30 3 \"menu-start\" \"Start Scenario\" \"menu-stop\" \"Stop Scenario\" \"quit\" \"Quit to console\" 2>/tmp/whip");
        _builder.newLine();
        _builder.append("#ACTION=`cat /tmp/whip`");
        _builder.newLine();
        _builder.newLine();
        _builder.append("cd $SCRIPT_DIR");
        _builder.newLine();
        _builder.append("bash $SCRIPT_NAME $ACTION");
        _builder.newLine();
        _builder.newLine();
        _builder.append(";; ## menu");
        _builder.newLine();
        _builder.newLine();
        _builder.append("quit)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME stop");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("#########################################################################################");
        _builder.newLine();
        _builder.append("## default");
        _builder.newLine();
        _builder.append("*)");
        _builder.newLine();
        _builder.append("echo \"No such parameter: $1\"");
        _builder.newLine();
        _builder.append("echo \"Usage: $SCRIPT_NAME {start|stop|menu-start|menu-stop|menu}\"");
        _builder.newLine();
        _builder.append("exit 1");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("esac");
        _builder.newLine();
        return _builder;
    }

    public CharSequence deployAllScript(DeploymentModel model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/bin/bash");
        _builder.newLine();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# run this script from the component's root folder to deploy the scenario to robot.");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.newLine();
        _builder.append("echo \"Working directory of deployment script: \"`pwd`");
        _builder.newLine();
        _builder.newLine();
        _builder.append("BASENAME=`pwd | xargs basename`");
        _builder.newLine();
        _builder.append("if [ \"$BASENAME\" != \"smartsoft\" ]; then");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Folder: $BASENAME vs Model: smartsoft did not match\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"###################################################################\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"ERROR: this script must be called from the project's smartsoft folder.\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"###################################################################\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("gdialog --title ERROR --msgbox \"ERROR: this script must be called from the component's root folder.\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("exit 1");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#gdialog --title \"Deployment\" --yesno \"Deploy scenario to remote host?\"");
        _builder.newLine();
        _builder.append("#if [ \"$?\" != \"0\" ]; then");
        _builder.newLine();
        _builder.append("#\tDEPL_MODE=\"local\"");
        _builder.newLine();
        _builder.append("#fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append("echo \"combine ini-files\"");
        _builder.newLine();
        _builder.append("bash src-gen/deployment/combine_ini_files.sh");
        _builder.newLine();
        _builder.newLine();
        _builder.append("DEVICES=\"");
        _builder.newLine();
        Iterable _filter = Iterables.filter((Iterable)model.getElements(), TargetPlatformReference.class);
        for (TargetPlatformReference target : _filter) {
            String _name = target.getPlatform().getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("exec 99> >(zenity --progress --auto-close --pulsate --no-cancel --width 300)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("for I in $DEVICES; do");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"#Deploying Device $I ...\" >&99");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#gdialog --title \"Deployment\" --yesno \"Device $I is about to be deployed.\\nContinue?\" || continue");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash src-gen/deployment/deploy-$I.sh ${DEPL_MODE}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if [ \"$?\" != \"0\" ]; then");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("zenity --error --text=\"Deployment to $I failed.\\nAborting Deployment.\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("exit 1");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.newLine();
        _builder.append("exec 99>&-");
        _builder.newLine();
        _builder.newLine();
        _builder.append("gdialog --title \"Deployment\" --yesno \"Deployment finished. Do you want to start it now?\"");
        _builder.newLine();
        _builder.append("if [ \"$?\" != \"0\" ]; then");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Scenario not started.\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Execute the startscript 'start-<DEVICENAME>.sh' on the remote device in order to execute the scenario.\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("exit 0");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append("if [ \"$DEPL_MODE\" = \"local\" ]; then");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for I in $DEVICES; do");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("cd ");
        String _name_1 = model.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append(".deployment/$I");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("xterm -title \"Scenario Control of Device $I\" -e \"pwd;bash start-$I.sh menu;echo;echo;echo;echo 'You can close this window now.'; echo; echo;bash --login\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("done");
        _builder.newLine();
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#gdialog --title \"Deployment\" --yesno \"remote start not yet implemented!!!!!!!!!!!!!!!!!!\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("xterm -title \"Global Scenario Control\" -e \"cd src-gen/deployment; pwd; bash start-all.sh menu;echo;echo;echo;echo 'You can close this window now.'; echo; echo;bash --login\"");
        _builder.newLine();
        _builder.append("fi");
        _builder.newLine();
        _builder.newLine();
        _builder.append("echo -e \"\\n\\nDeployment finished.\\n\\n\"");
        _builder.newLine();
        _builder.append("exit 0");
        _builder.newLine();
        return _builder;
    }

    public CharSequence startAllScript(DeploymentModel model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/bin/bash");
        _builder.newLine();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Script to start all components on all devices");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.newLine();
        _builder.append("PID_FILE=\"/var/tmp/start-all.pid\"");
        _builder.newLine();
        _builder.append("SCRIPT_DIR=`pwd`");
        _builder.newLine();
        _builder.append("SCRIPT_NAME=start-all.sh");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("case \"$1\" in");
        _builder.newLine();
        _builder.newLine();
        _builder.append("start)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("true > $PID_FILE");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Starting all devices ...\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        Iterable _filter = Iterables.filter((Iterable)model.getElements(), TargetPlatformReference.class);
        for (TargetPlatformReference target : _filter) {
            _builder.append("\t");
            _builder.append("echo \"Starting ");
            String _sshLoginPair = this.sshLoginPair(target);
            _builder.append(_sshLoginPair, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            if (target.getHost().getNetwork().getHostAddress().equals("localhost") || target.getHost().getNetwork().getHostAddress().equals("127.0.0.1")) {
                _builder.append("\t");
                _builder.append("xterm -fg red -title \"");
                String _sshLoginPair_1 = this.sshLoginPair(target);
                _builder.append(_sshLoginPair_1, "\t");
                _builder.append("\" -e 'echo;echo \"Starting local session ...\"; echo;echo;cd ");
                UploadDirectory _directory = target.getDirectory();
                String _path = null;
                if (_directory != null) {
                    _path = _directory.getPath();
                }
                _builder.append(_path, "\t");
                _builder.append("/");
                String _name = model.getName();
                _builder.append(_name, "\t");
                _builder.append(".deployment; pwd; bash --login -i -e start-");
                String _name_1 = target.getPlatform().getName();
                _builder.append(_name_1, "\t");
                _builder.append(".sh start' &");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("xterm -fg red -title \"SSH: ");
                String _sshLoginPair_2 = this.sshLoginPair(target);
                _builder.append(_sshLoginPair_2, "\t");
                _builder.append("\" -e 'echo;echo \"Starting remote SSH session at ");
                String _sshLoginPair_3 = this.sshLoginPair(target);
                _builder.append(_sshLoginPair_3, "\t");
                _builder.append(" ...\"; echo;echo;ssh -X ");
                String _sshLoginPair_4 = this.sshLoginPair(target);
                _builder.append(_sshLoginPair_4, "\t");
                _builder.append(" \"cd ");
                UploadDirectory _directory_1 = target.getDirectory();
                String _path_1 = null;
                if (_directory_1 != null) {
                    _path_1 = _directory_1.getPath();
                }
                _builder.append(_path_1, "\t");
                _builder.append("/");
                String _name_2 = model.getName();
                _builder.append(_name_2, "\t");
                _builder.append(".deployment; pwd; bash --login -i -e start-");
                String _name_3 = target.getPlatform().getName();
                _builder.append(_name_3, "\t");
                _builder.append(".sh start\"' &");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("echo $! >> $PID_FILE");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("stop)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Stopping all devices\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        Iterable _filter_1 = Iterables.filter((Iterable)model.getElements(), TargetPlatformReference.class);
        for (TargetPlatformReference target_1 : _filter_1) {
            _builder.append("\t");
            _builder.append("echo \"Stopping ");
            String _sshLoginPair_5 = this.sshLoginPair(target_1);
            _builder.append(_sshLoginPair_5, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            if (target_1.getHost().getNetwork().getHostAddress().equals("localhost") || target_1.getHost().getNetwork().getHostAddress().equals("127.0.0.1")) {
                _builder.append("\t");
                _builder.append("xterm -title \"stopping ");
                String _sshLoginPair_6 = this.sshLoginPair(target_1);
                _builder.append(_sshLoginPair_6, "\t");
                _builder.append("\" -e 'echo;echo \"Starting local session ...\"; echo;echo;cd ");
                UploadDirectory _directory_2 = target_1.getDirectory();
                String _path_2 = null;
                if (_directory_2 != null) {
                    _path_2 = _directory_2.getPath();
                }
                _builder.append(_path_2, "\t");
                _builder.append("/");
                String _name_4 = model.getName();
                _builder.append(_name_4, "\t");
                _builder.append(".deployment; pwd; bash --login -i -e start-");
                String _name_5 = target_1.getPlatform().getName();
                _builder.append(_name_5, "\t");
                _builder.append(".sh stop'");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("xterm -title \"stopping ");
                String _sshLoginPair_7 = this.sshLoginPair(target_1);
                _builder.append(_sshLoginPair_7, "\t");
                _builder.append("\" -e 'echo;echo \"Starting remote SSH session at ");
                String _sshLoginPair_8 = this.sshLoginPair(target_1);
                _builder.append(_sshLoginPair_8, "\t");
                _builder.append(" ...\"; echo;echo;ssh -X ");
                String _sshLoginPair_9 = this.sshLoginPair(target_1);
                _builder.append(_sshLoginPair_9, "\t");
                _builder.append(" \"cd ");
                UploadDirectory _directory_3 = target_1.getDirectory();
                String _path_3 = null;
                if (_directory_3 != null) {
                    _path_3 = _directory_3.getPath();
                }
                _builder.append(_path_3, "\t");
                _builder.append("/");
                String _name_6 = model.getName();
                _builder.append(_name_6, "\t");
                _builder.append(".deployment; pwd; bash --login -i -e start-");
                String _name_7 = target_1.getPlatform().getName();
                _builder.append(_name_7, "\t");
                _builder.append(".sh stop\"'");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("echo $! >> $PID_FILE");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("## just to make sure:");
        _builder.newLine();
        _builder.append("sleep 2");
        _builder.newLine();
        _builder.append("cut -d '\"' -f2 $PID_FILE |");
        _builder.newLine();
        _builder.append("while read number");
        _builder.newLine();
        _builder.append("do");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo $number");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("kill -9 $number");
        _builder.newLine();
        _builder.append("done < $PID_FILE");
        _builder.newLine();
        _builder.append("rm $PID_FILE");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("menu-start)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME start");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cd $SCRIPT_DIR");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME menu");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("menu-stop)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME stop");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cd $SCRIPT_DIR");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME menu");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("menu-tile)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash tiler.sh");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cd $SCRIPT_DIR");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME menu");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("menu)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ACTION=$(whiptail --title \"Scenario Control\" --menu \"Choose an option\" 12 40 4 \"menu-start\" \"Start Scenario\" \"menu-stop\" \"Stop Scenario\" \"menu-tile\" \"Arrange terminals\" \"quit\" \"Quit to console\" 3>&1 1>&2 2>&3)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cd $SCRIPT_DIR");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME $ACTION");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("quit)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("bash $SCRIPT_NAME stop");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("*)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"No such parameter: $1\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("echo \"Usage: $SCRIPT_NAME {start|stop|menu-start|menu-stop|menu}\"");
        _builder.newLine();
        _builder.append(";;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("esac");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence tilerscript() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/bin/bash");
        _builder.newLine();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# Parts in this script are taken from: https://github.com/otubo/misc/commit/3bbf0c9ad93b72e802d5591f2364ccb9d457bbc2#diff-0b590c8bfa296cd726e4d93945f0e24d");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#get the desktop parameters");
        _builder.newLine();
        _builder.append("HEIGHT=`xwininfo -root | grep 'Height:' | awk '{print $2}'`");
        _builder.newLine();
        _builder.append("WIDTH=`xwininfo -root | grep 'Width:' | awk '{print $2}'`");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#xterm parameters");
        _builder.newLine();
        _builder.append("TERM_HEIGHT=316");
        _builder.newLine();
        _builder.append("TERM_WIDTH=484");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#get the window parameters");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("#get the current desktop");
        _builder.newLine();
        _builder.append("CURR_DESK=` wmctrl -d | grep '* DG:'| awk '{print $1}'`");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#get the total number of windows.");
        _builder.newLine();
        _builder.append("#NOTE: we are not directly using grep to get the windows from the current desktop as it may serve up some false positives");
        _builder.newLine();
        _builder.append("COMPONENT_WINDOWS=`wmctrl -lx |grep Component| wc -l`");
        _builder.newLine();
        _builder.append("SSH_WINDOWS=`wmctrl -lx |grep SSH| wc -l`");
        _builder.newLine();
        _builder.append("GLOBAL_SCENARIO_WINDOWS=`wmctrl -lx |grep 'Global Scenario Control'| wc -l`");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#counter");
        _builder.newLine();
        _builder.append("i=1");
        _builder.newLine();
        _builder.append("#Assume that there are no Global Scenario Controls in the current desktop");
        _builder.newLine();
        _builder.append("GLOBAL_SCENARIO_IN_DESK=0");
        _builder.newLine();
        _builder.append("while  [ $i  -le  $GLOBAL_SCENARIO_WINDOWS ] ; do");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("CURR_LINE=`wmctrl -lx | grep 'Global Scenario Control'|head -n $i | tail -n 1`");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("WIN_DESK=`echo $CURR_LINE | awk '{print $2}'|sort`");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if  [ $WIN_DESK  -eq  $CURR_DESK ] ; then");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#save the various window properties as supplied by wmctrl .");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("GLOBAL_SCENARIO_XID[$GLOBAL_SCENARIO_IN_DESK]=`echo $CURR_LINE | awk '{print $1}'`");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#see if the window is \"IsViewable\" or \"IsUnMapped\" i.e minimized");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("MAP_STATE=`xwininfo -id ${GLOBAL_SCENARIO_XID[$GLOBAL_SCENARIO_IN_DESK]} | grep \"Map State:\" | awk '{print $3}'`");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#we don't  want the minimized windows to be considered while allocating the space");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if [ \"$MAP_STATE\"  ==  \"IsViewable\" ]; then");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("GLOBAL_SCENARIO_IN_DESK=$((GLOBAL_SCENARIO_IN_DESK+1))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("GLOBAL_SCENARIO_XID[$GLOBAL_SCENARIO_IN_DESK]=0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fi\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("i=$((i+1))");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#counter");
        _builder.newLine();
        _builder.append("i=1");
        _builder.newLine();
        _builder.append("#Assume that there are no SSH windows in the current desktop");
        _builder.newLine();
        _builder.append("SSH_IN_DESK=0");
        _builder.newLine();
        _builder.append("while  [ $i  -le  $SSH_WINDOWS ] ; do");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("CURR_LINE=`wmctrl -lx | grep SSH|head -n $i | tail -n 1`");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("WIN_DESK=`echo $CURR_LINE | awk '{print $2}'|sort`");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if  [ $WIN_DESK  -eq  $CURR_DESK ] ; then");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#save the various window properties as supplied by wmctrl .");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("SSH_XID[$SSH_IN_DESK]=`echo $CURR_LINE | awk '{print $1}'`");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("SSH_NAME[$SSH_IN_DESK]=`echo $CURR_LINE | awk '{print substr($0, index($0,$5))}'`");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#see if the window is \"IsViewable\" or \"IsUnMapped\" i.e minimized");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("MAP_STATE=`xwininfo -id ${SSH_XID[$SSH_IN_DESK]} | grep \"Map State:\" | awk '{print $3}'`");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#we don't  want the minimized windows to be considered while allocating the space");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if [ \"$MAP_STATE\"  ==  \"IsViewable\" ]; then");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("SSH_IN_DESK=$((SSH_IN_DESK+1))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("SSH_XID[$SSH_IN_DESK]=0");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("SSH_NAME[$SSH_IN_DESK]=\"\"\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fi\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("i=$((i+1))");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#sort SSH");
        _builder.newLine();
        _builder.append("readarray -t SSH_NAME < <(for a in \"${SSH_NAME[@]}\"; do echo \"$a\"; done | sort)");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#counter");
        _builder.newLine();
        _builder.append("i=1");
        _builder.newLine();
        _builder.append("#Assume that there are no windows in the current desktop");
        _builder.newLine();
        _builder.append("WINDOWS_IN_DESK=0");
        _builder.newLine();
        _builder.append("while  [ $i  -le  $COMPONENT_WINDOWS ] ; do");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("CURR_LINE=`wmctrl -lx | grep Component|head -n $i | tail -n 1`");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("WIN_DESK=`echo $CURR_LINE | awk '{print $2}'|sort`");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if  [ $WIN_DESK  -eq  $CURR_DESK ] ; then");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#save the various window properties as supplied by wmctrl .");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("WIN_XID[$WINDOWS_IN_DESK]=`echo $CURR_LINE | awk '{print $1}'`");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("WIN_NAME[$WINDOWS_IN_DESK]=`echo $CURR_LINE | awk '{print substr($0, index($0,$5))}'`");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#see if the window is \"IsViewable\" or \"IsUnMapped\" i.e minimized");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("MAP_STATE=`xwininfo -id ${WIN_XID[$WINDOWS_IN_DESK]} | grep \"Map State:\" | awk '{print $3}'`");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#we don't  want the minimized windows to be considered while allocating the space");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if [ \"$MAP_STATE\"  ==  \"IsViewable\" ]; then");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("WINDOWS_IN_DESK=$((WINDOWS_IN_DESK+1))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("WIN_XID[$WINDOWS_IN_DESK]=0");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("WIN_NAME[$WINDOWS_IN_DESK]=\"\"\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fi\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("i=$((i+1))");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#sort components");
        _builder.newLine();
        _builder.append("readarray -t WIN_NAME < <(for a in \"${WIN_NAME[@]}\"; do echo \"$a\"; done | sort)");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("X_POS=0");
        _builder.newLine();
        _builder.append("Y_POS=0");
        _builder.newLine();
        _builder.append("DESK=$CURR_DESK");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#Gloabal Scenario Control");
        _builder.newLine();
        _builder.append("i=0");
        _builder.newLine();
        _builder.append("while [ $i -lt $GLOBAL_SCENARIO_IN_DESK ] ; do");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if [ $((WIDTH+25)) -le $((X_POS+TERM_WIDTH)) ] ; then");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#next row");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if [ $Y_POS -eq 0 ] ; then");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Y_POS=$((Y_POS+TERM_HEIGHT+53))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Y_POS=$((Y_POS+TERM_HEIGHT+30))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("X_POS=0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if [ $((Y_POS+TERM_HEIGHT)) -ge $((HEIGHT+5)) ] ; then");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#next Desktop");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("DESK=$(((DESK+1)%4))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("X_POS=0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Y_POS=0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wmctrl  -i  -r ${GLOBAL_SCENARIO_XID[$i]}  -b remove,maximized_vert,maximized_horz");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wmctrl  -i  -r ${GLOBAL_SCENARIO_XID[$i]} -e \"0,$X_POS,$Y_POS,$TERM_WIDTH,$TERM_HEIGHT\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wmctrl  -i  -r ${GLOBAL_SCENARIO_XID[$i]} -t \"$DESK\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("X_POS=$((X_POS+TERM_WIDTH))");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("i=$((i+1))");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#SSH");
        _builder.newLine();
        _builder.append("i=0");
        _builder.newLine();
        _builder.append("while [ $i -lt $SSH_IN_DESK ] ; do");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if [ $((WIDTH+25)) -le $((X_POS+TERM_WIDTH)) ] ; then");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#next row");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if [ $Y_POS -eq 0 ] ; then");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Y_POS=$((Y_POS+TERM_HEIGHT+53))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Y_POS=$((Y_POS+TERM_HEIGHT+30))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("X_POS=0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if [ $((Y_POS+TERM_HEIGHT)) -ge $((HEIGHT+5)) ] ; then");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#next Desktop");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("DESK=$(((DESK+1)%4))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("X_POS=0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Y_POS=0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wmctrl    -r ${SSH_NAME[$i]}  -b remove,maximized_vert,maximized_horz");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wmctrl    -r ${SSH_NAME[$i]} -e \"0,$X_POS,$Y_POS,$TERM_WIDTH,$TERM_HEIGHT\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wmctrl    -r ${SSH_NAME[$i]} -t \"$DESK\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("X_POS=$((X_POS+TERM_WIDTH))");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("i=$((i+1))");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#components");
        _builder.newLine();
        _builder.append("i=0");
        _builder.newLine();
        _builder.append("while [ $i -lt $WINDOWS_IN_DESK ] ; do");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if [ $((WIDTH+25)) -le $((X_POS+TERM_WIDTH)) ] ; then");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#next row");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if [ $Y_POS -eq 0 ] ; then");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Y_POS=$((Y_POS+TERM_HEIGHT+53))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Y_POS=$((Y_POS+TERM_HEIGHT+30))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("X_POS=0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if [ $((Y_POS+TERM_HEIGHT)) -ge $((HEIGHT+5)) ] ; then");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#next Desktop");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("DESK=$(((DESK+1)%4))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("X_POS=0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Y_POS=0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fi");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wmctrl    -r ${WIN_NAME[$i]}  -b remove,maximized_vert,maximized_horz");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wmctrl    -r ${WIN_NAME[$i]} -e \"0,$X_POS,$Y_POS,$TERM_WIDTH,$TERM_HEIGHT\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wmctrl    -r ${WIN_NAME[$i]} -t \"$DESK\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("X_POS=$((X_POS+TERM_WIDTH))");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("i=$((i+1))");
        _builder.newLine();
        _builder.append("done");
        _builder.newLine();
        return _builder;
    }
}

